/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import jeus.ejb.BeanContainer;
import jeus.ejb.BeanContext;
import jeus.ejb.bean.context.EntityContextImpl;
import jeus.ejb.bean.objectbase.TimerImpl;
import jeus.ejb.container.TimerContainer;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB2;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;

public class TimerServiceImpl
implements TimerService {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    private TimerContainer timerContainer = TimerContainer.currentTimerContainer();
    private BeanContext ejbContext;
    private boolean isEntity;
    private Object primaryKey;
    private boolean isEnableDurable;
    private String moduleName;
    private String beanName;

    public TimerServiceImpl(BeanContext ejbContext, DurableTimerServiceType durableSetting) {
        this.ejbContext = ejbContext;
        if (ejbContext instanceof EntityContextImpl) {
            this.isEntity = true;
        }
        if (durableSetting != null) {
            this.isEnableDurable = durableSetting.isEnableDurableTimers();
        }
        BeanContainer container = ejbContext.getContainer();
        this.moduleName = container.getModuleName();
        this.beanName = container.getBeanName();
        if (logger.isLoggable(JeusMessage_EJB2._2401_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2401_LEVEL, "TimerServiceImpl", "<init>", JeusMessage_EJB2._2401, new Object[]{this.moduleName, this.beanName, this.isEnableDurable ? "" : "none "});
        }
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        Long timerId;
        if (logger.isLoggable(JeusMessage_EJB2._2402_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2402_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2402, new Object[]{String.valueOf(duration), info});
        }
        this.ejbContext.checkOperationsAllowed(1200);
        if (duration < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2403_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2403_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2403, (Object)String.valueOf(duration));
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2403, (Object)String.valueOf(duration)));
        }
        try {
            timerId = this.timerContainer.createTimer(this.moduleName, this.beanName, this.getPrimaryKey(), duration, 0L, info, this.isEnableDurable);
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB2._2405_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2405_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2405, (Throwable)e);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2405), (Exception)((Object)e));
        }
        if (logger.isLoggable(JeusMessage_EJB2._2406_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2406_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2406, new Object[]{String.valueOf(duration), info});
        }
        return new TimerImpl(timerId, this.timerContainer);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        Long timerId;
        if (logger.isLoggable(JeusMessage_EJB2._2407_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2407_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2407, new Object[]{String.valueOf(initialDuration), String.valueOf(intervalDuration), info});
        }
        this.ejbContext.checkOperationsAllowed(1200);
        if (initialDuration < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2408_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2408_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2408, (Object)String.valueOf(initialDuration));
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2408, (Object)String.valueOf(initialDuration)));
        }
        if (intervalDuration < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2409_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2409_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2409, (Object)String.valueOf(intervalDuration));
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2409, (Object)String.valueOf(intervalDuration)));
        }
        try {
            timerId = this.timerContainer.createTimer(this.moduleName, this.beanName, this.getPrimaryKey(), initialDuration, intervalDuration, info, this.isEnableDurable);
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB2._2411_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2411_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2411, (Throwable)e);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2411), (Exception)((Object)e));
        }
        if (logger.isLoggable(JeusMessage_EJB2._2412_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2412_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2412, new Object[]{String.valueOf(initialDuration), String.valueOf(intervalDuration), info});
        }
        return new TimerImpl(timerId, this.timerContainer);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (logger.isLoggable(JeusMessage_EJB2._2413_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2413_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2413, new Object[]{expiration, info});
        }
        this.ejbContext.checkOperationsAllowed(1200);
        if (expiration == null || expiration.getTime() < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2414_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2414_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2414, (Object)expiration);
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2414, (Object)expiration));
        }
        try {
            Long timerId = this.timerContainer.createTimer(this.moduleName, this.beanName, this.getPrimaryKey(), expiration, 0L, info, this.isEnableDurable, true, null);
            return new TimerImpl(timerId, this.timerContainer);
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB2._2417_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2417_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2417, (Throwable)e);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2417), (Exception)((Object)e));
        }
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        Long timerId;
        if (logger.isLoggable(JeusMessage_EJB2._2418_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2418_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2418, new Object[]{initialExpiration, String.valueOf(intervalDuration), info});
        }
        this.ejbContext.checkOperationsAllowed(1200);
        if (initialExpiration == null || initialExpiration.getTime() < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2419_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2419_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2419, (Object)initialExpiration);
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2419, (Object)initialExpiration));
        }
        if (intervalDuration < 0L) {
            if (logger.isLoggable(JeusMessage_EJB2._2420_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2420_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2420, (Object)intervalDuration);
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2420, (Object)intervalDuration));
        }
        try {
            timerId = this.timerContainer.createTimer(this.moduleName, this.beanName, this.getPrimaryKey(), initialExpiration, intervalDuration, info, this.isEnableDurable, true, null);
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB2._2422_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2422_LEVEL, "TimerServiceImpl", "createTimer", JeusMessage_EJB2._2422, (Throwable)e);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2422), (Exception)((Object)e));
        }
        return new TimerImpl(timerId, this.timerContainer);
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        Collection timerIds;
        this.ejbContext.checkOperationsAllowed(1200);
        try {
            timerIds = this.timerContainer.getTimerIds(this.moduleName, this.beanName, this.getPrimaryKey());
        }
        catch (NoSuchObjectLocalException fe) {
            if (logger.isLoggable(JeusMessage_EJB2._2425_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2425_LEVEL, "TimerServiceImpl", "getTimers", JeusMessage_EJB2._2425, new Object[]{this.beanName, this.moduleName}, (Throwable)fe);
            }
            throw fe;
        }
        HashSet<TimerImpl> timers = new HashSet<TimerImpl>();
        for (Long next : timerIds) {
            timers.add(new TimerImpl(next, this.timerContainer));
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPrimaryKey() {
        if (!this.isEntity) {
            if (logger.isLoggable(JeusMessage_EJB2._2428_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2428_LEVEL, "TimerServiceImpl", "getPrimaryKey", JeusMessage_EJB2._2428, new Object[]{this.beanName, this.moduleName});
            }
            return null;
        }
        if (this.primaryKey == null) {
            TimerServiceImpl timerServiceImpl = this;
            synchronized (timerServiceImpl) {
                if (this.primaryKey == null) {
                    this.primaryKey = ((EntityContextImpl)this.ejbContext).getPrimaryKey();
                }
            }
        }
        if (logger.isLoggable(JeusMessage_EJB2._2429_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2429_LEVEL, "TimerServiceImpl", "getPrimaryKey", JeusMessage_EJB2._2429, new Object[]{this.primaryKey, this.beanName, this.moduleName});
        }
        return this.primaryKey;
    }
}

