/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.ejb.EJBException;
import jeus.ejb.baseimpl.RemoteInvocationManager;
import jeus.ejb.bean.rmi.RMISkeleton;
import jeus.ejb.container.AbstractContainer;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.rmi.spec.ServerInterceptor;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.container.ejb.EJBSecurity;
import jeus.security.util.LoginUtil;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.ServerContextSenderReceiver;
import jeus.transaction.ThreadContexts;
import jeus.transaction.client.TMContextCarrier;
import jeus.util.ByteUtil;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.trace.GID;
import jeus.util.trace.GIDException;
import jeus.workarea.WorkAreaServiceHelper;

public class EJBServerInterceptor
implements ServerInterceptor {
    private AbstractContainer container;
    private final RemoteInvocationManager invocationManager;
    private static final String IVM_TICKET = "IVM_TICKET";
    private static final String LOGIN = "LOGON";
    private static final String READTX_TYPE = "READTX_TYPE";

    public EJBServerInterceptor(AbstractContainer container) {
        this.container = container;
        this.invocationManager = container.getRemoteInvocationManager();
    }

    public void intercept(DataInput din, InterceptorContextProvider invoker) throws Exception {
        ThreadContexts.initNextTimeout();
        Map context = invoker.getContext();
        this.invocationManager.beforeInvoke();
        context.put(IVM_TICKET, true);
        try {
            byte clientPlatformVersion = din.readByte();
            int length = din.readInt();
            if (length > 0) {
                byte[] ctx = new byte[length];
                din.readFully(ctx, 0, length);
                try {
                    EJBSecurity.loginEJBSubject(ctx);
                }
                catch (SecurityException ex) {
                    throw new RemoteException("The subject is not allowed to login this system");
                }
                catch (ServiceException ex) {
                    throw new RemoteException("Internal exception during checking security", ex);
                }
                context.put(LOGIN, LOGIN);
            } else {
                context.remove(LOGIN);
            }
            int returnTxCtx = ContextSenderReceiver.readTMCtx(din);
            context.put(READTX_TYPE, new Integer(returnTxCtx));
            byte[] lenBytes = new byte[4];
            din.readFully(lenBytes);
            int gidLen = ByteUtil.convertToInt((byte[])lenBytes);
            if (gidLen > 0) {
                byte[] gidBytes = new byte[gidLen];
                din.readFully(gidBytes);
                GID.setCurrentGID(gidBytes);
            }
        }
        catch (RuntimeException t) {
            if (!(t instanceof EJBException) && RMISkeleton.logger.isLoggable(JeusMessage_EJB12._9004_LEVEL)) {
                RMISkeleton.logger.log(JeusMessage_EJB12._9004_LEVEL, JeusMessage_EJB12._9004, (Throwable)t);
            }
            throw t;
        }
    }

    public void afterIntercept(DataOutput dout, InterceptorContextProvider invoker) throws IOException {
        Map context = invoker.getContext();
        Integer returnTxCtx = (Integer)context.get(READTX_TYPE);
        if (returnTxCtx != null) {
            if (returnTxCtx == 2) {
                ServerContextSenderReceiver.checkRegistration();
            } else if (returnTxCtx == 1) {
                dout.write(ContextSenderReceiver.getPropagationContext());
            }
        }
        byte[] gidBytes = GID.getCurrentGIDBytes();
        byte[] lenBytes = new byte[4];
        int length = 0;
        if (GID.useGID) {
            length = gidBytes.length;
            ByteUtil.putInt((byte[])lenBytes, (int)0, (int)length);
        }
        dout.write(lenBytes);
        if (length > 0) {
            dout.write(gidBytes);
        }
    }

    public void exceptionOccurred(Throwable ex, InterceptorContextProvider interceptedServerInvoker) throws Throwable {
        Map context;
        Integer readTxType;
        if (GID.useGID) {
            ex = new GIDException(ex, GID.getCurrentGIDBytes());
        }
        if ((readTxType = (Integer)(context = interceptedServerInvoker.getContext()).get(READTX_TYPE)) != null && readTxType == 1) {
            ex = new TMContextCarrier(ex, ContextSenderReceiver.getPropagationContext());
        }
        throw ex;
    }

    public void handleFinally(InterceptorContextProvider invoker) {
        Map context = invoker.getContext();
        if (context.get(LOGIN) != null) {
            try {
                LoginUtil.logoutWithRuntimeException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (context.get(IVM_TICKET) != null) {
            this.invocationManager.afterInvoke();
        }
        WorkAreaServiceHelper.clearUserWorkArea();
        GID.setCurrentGID((GID)null);
    }
}

