/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.InvocationHandlerUtil;
import jeus.ejb.util.MethodUtils;

public class RemoteBusinessObjectClientHandler
extends RemoteInvokerClient
implements InvocationHandler {
    private static final long serialVersionUID = 60L;
    private final String ejbId;
    private final String sessionId;
    private final String interfaceName;
    private final boolean isRmiRemote;
    private volatile int hashCode = 0;
    private transient ConcurrentMap<Method, String> signatureCache;
    private transient InvocationHandler localCallHandler;
    private transient Class interfaceClass;

    public RemoteBusinessObjectClientHandler(String ejbId, String sessionId, Class interfaze, RemoteInvoker invoker) {
        super(invoker);
        this.ejbId = ejbId;
        this.sessionId = sessionId;
        this.interfaceName = interfaze.getName();
        this.isRmiRemote = Remote.class.isAssignableFrom(interfaze);
    }

    public void setLocalCallHandler(Class interfaze, InvocationHandler localCallHandler) {
        assert (interfaze != null && localCallHandler != null);
        this.interfaceClass = interfaze;
        this.localCallHandler = localCallHandler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName().charAt(0)) {
                case 'e': {
                    return this.isIdentical(proxy, args[0]);
                }
                case 'h': {
                    return this.hashCode();
                }
            }
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        try {
            if (this.localCallHandler != null) {
                return this.localCallHandler.invoke(this.interfaceClass, method, args);
            }
            String signature = this.getSignature(method);
            RemoteInvocationImpl invocation = new RemoteInvocationImpl();
            invocation.setInterface(this.interfaceName);
            invocation.setSignature(signature);
            invocation.setArgs(args);
            return super.invoke(invocation);
        }
        catch (Exception ex2) {
            RemoteException ex2;
            if (ex2 instanceof ServerException) {
                ServerException e = (ServerException)ex2;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex2 = (RemoteException)e.detail;
                }
            }
            if (ex2 instanceof NoSuchObjectException) {
                if (!this.isRmiRemote) {
                    throw new NoSuchEJBException(((Throwable)ex2).getMessage(), (Exception)ex2);
                }
                throw ex2;
            }
            if (ex2 instanceof RemoteException) {
                if (!this.isRmiRemote) {
                    throw new EJBException(((Throwable)ex2).getMessage(), (Exception)ex2);
                }
                throw ex2;
            }
            throw ex2;
        }
    }

    private String getSignature(Method method) {
        String sig;
        if (this.signatureCache == null) {
            this.signatureCache = new ConcurrentHashMap<Method, String>();
        }
        if ((sig = (String)this.signatureCache.get(method)) == null) {
            sig = MethodUtils.getSignature(method);
            this.signatureCache.put(method, sig);
        }
        return sig;
    }

    private boolean isIdentical(Object proxy, Object arg) {
        if (proxy == arg) {
            return true;
        }
        if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
            return false;
        }
        InvocationHandler other = Proxy.getInvocationHandler(arg);
        if (!(other instanceof RemoteBusinessObjectClientHandler)) {
            return false;
        }
        RemoteBusinessObjectClientHandler that = (RemoteBusinessObjectClientHandler)other;
        return this.ejbId.equals(that.ejbId) && this.sessionId.equals(that.sessionId) && this.interfaceName.equals(that.interfaceName);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.ejbId.hashCode();
            this.hashCode = result = 29 * result + this.sessionId.hashCode();
        }
        return this.hashCode;
    }
}

