/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.io.OutputStream;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.compiler.EJBCodeGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.EJBCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;

public class EJBPkeyGenerator
extends EJBCodeGenerator {
    private String beanClassName;
    private String beanWithPkeyClassName;
    private String beanPackageName;

    public EJBPkeyGenerator(String moduleName, FileArchive jarArchive, FileArchive tempArchive, ArchiveArrayClassLoader loader, EJBCompiler compiler) throws EJBSourceGeneratorException {
        super(jarArchive, tempArchive, moduleName, loader, compiler);
    }

    public void generateBeanClass(OutputStream out, CMEntityBeanPair desc) throws EJBSourceGeneratorException, IOException {
        if (logger.isLoggable(JeusMessage_EJB11._7066_LEVEL)) {
            logger.log(JeusMessage_EJB11._7066_LEVEL, JeusMessage_EJB11._7066, (Object)(this.beanPackageName + "." + this.beanWithPkeyClassName));
        }
        CodeWriter codewriter = new CodeWriter(out);
        codewriter.write("package " + this.beanPackageName + ";");
        codewriter.write("");
        boolean isCMP20 = desc.getCMPVersion() == 2;
        codewriter.write("public" + (isCMP20 ? " abstract class " : " class ") + this.beanWithPkeyClassName + " extends " + this.beanClassName);
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("public " + this.beanWithPkeyClassName + "(){");
        codewriter.write("\tsuper();");
        codewriter.write("}");
        if (isCMP20) {
            codewriter.write("public abstract int getJwcpkey();");
            codewriter.write("public abstract void setJwcpkey(int jwcpkey);");
        } else {
            codewriter.write("public int jwcpkey;");
        }
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(CMEntityBeanPair desc, boolean fastDeploy) throws EJBSourceGeneratorException {
        try {
            this.beanPackageName = desc.getBeanPackageName();
            this.beanClassName = desc.getBeanClassName();
            this.beanWithPkeyClassName = this.beanClassName + "_Pkey";
            if (!fastDeploy) {
                OutputStream beanClassWithPkey = null;
                try {
                    beanClassWithPkey = this.makeFileOf(this.beanPackageName + "." + this.beanWithPkeyClassName);
                    this.generateBeanClass(beanClassWithPkey, desc);
                    beanClassWithPkey.flush();
                }
                finally {
                    if (beanClassWithPkey != null) {
                        beanClassWithPkey.close();
                    }
                }
                String beanWithPkeyFileName = this.tempArchive.getArchiveUri() + fs + this.beanPackageName.replace('.', fsc) + fs + this.beanWithPkeyClassName + ".java";
                this.compile_generatedFiles(1, new String[]{beanWithPkeyFileName}, new String[]{this.beanPackageName + "." + this.beanWithPkeyClassName}, true);
                this.loader.addToClassList(this.beanPackageName + "." + this.beanWithPkeyClassName);
            }
            desc.setBeanImplClassName(this.beanPackageName + "." + this.beanWithPkeyClassName);
            desc.addCMPField("jwcpkey");
            desc.setPrimaryKeyField("jwcpkey");
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7017, ex);
        }
    }
}

