/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.compiler.BeanInfo;
import jeus.ejb.compiler.EJBCodeGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.HomeInfo;
import jeus.ejb.compiler.ObjectInfo;
import jeus.ejb.compiler.RMICompiler;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.util.EJBCompiler;
import jeus.ejb.util.IIOPHomeGenerator;
import jeus.ejb.util.IIOPObjectGenerator;
import jeus.ejb.util.WrapperGenerator;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.JeusException;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusRMIProperties;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;

public class EJBSourceGenerator
extends EJBCodeGenerator {
    private BeanPair deployD;
    private String moduleDomain;
    private String beanNameInDescriptor;
    private BeanInfo beanInfo = new BeanInfo();
    private ObjectInfo objectInfo = new ObjectInfo();
    private HomeInfo homeInfo = new HomeInfo();
    private int methodID;
    private int hashValue;
    public EJBSQLGenerator sqlGen;
    private CMEntityBeanPair beanPair;
    private BeanSchema bSchema;

    public EJBSourceGenerator(FileArchive jarArchive, FileArchive tempArchive, String moduleName, ArchiveArrayClassLoader loader, EJBCompiler compiler) throws EJBSourceGeneratorException {
        super(jarArchive, tempArchive, moduleName, loader, compiler);
    }

    public EJBSourceGenerator(BeanSchema bSchema, EJBSQLGenerator sqlGen, FileArchive jarArchive, FileArchive tempArchive, String moduleName, ArchiveArrayClassLoader loader, EJBCompiler compiler) throws EJBSourceGeneratorException {
        this(jarArchive, tempArchive, moduleName, loader, compiler);
        this.beanPair = bSchema.beanPair;
        this.bSchema = bSchema;
        this.sqlGen = sqlGen;
    }

    private void generate_RMIfiles(String[] implementedHomeInterfaces) throws EJBSourceGeneratorException, JeusException {
        if (logger.isLoggable(JeusMessage_EJB11._7054_LEVEL)) {
            logger.log(JeusMessage_EJB11._7054_LEVEL, JeusMessage_EJB11._7054);
        }
        try {
            RMICompiler rmic = new RMICompiler((AbstractArchive)this.tempArchive, this.loader, this.compiler, this.deployD.useJeusRmi());
            rmic.compileEJB(implementedHomeInterfaces, this.homeInfo.getFullImplClassName(), this.objectInfo.getFullClassName(), this.objectInfo.getFullImplClassName(), this.deployD, this.getKeyClassName(), this.beanInfo.getBeanType());
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7018, ex);
        }
    }

    private void generate_LocalStubs() throws EJBSourceGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB11._7056_LEVEL)) {
            logger.log(JeusMessage_EJB11._7056_LEVEL, JeusMessage_EJB11._7056, (Object[])new String[]{this.homeInfo.getLocalFullImplClassName(), this.objectInfo.getLocalFullImplClassName()});
        }
        try {
            this.hashValue = this.moduleDomain.substring(1).hashCode() + this.beanNameInDescriptor.hashCode();
            this.generateLocalCode();
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7019, ex);
        }
    }

    private String getKeyClassName() throws EJBSourceGeneratorException {
        try {
            if (this.beanInfo.isClusteredDescriptor(this.deployD)) {
                if (this.beanInfo.isEntity) {
                    Method[] methods = this.homeInfo.classObject.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("findByPrimaryKey")) continue;
                        return StringUtil.getTypeDeclaration(methods[i].getParameterTypes()[0]);
                    }
                    throw new EJBSourceGeneratorException(JeusMessage_EJB11._7020);
                }
                if (!this.beanInfo.isStatelessSession) {
                    return "_jeusSessionID";
                }
            }
            return null;
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7021, ex);
        }
    }

    private void generate_IIOPfiles() throws EJBSourceGeneratorException, JeusException {
        if (logger.isLoggable(JeusMessage_EJB11._7055_LEVEL)) {
            logger.log(JeusMessage_EJB11._7055_LEVEL, JeusMessage_EJB11._7055);
        }
        try {
            IIOPObjectGenerator iiopObjectGen = new IIOPObjectGenerator(this.tempArchive.getArchiveUri(), this.objectInfo.classPackageName, this.objectInfo.implClassName, this.objectInfo.className, this.loader);
            iiopObjectGen.generate();
            IIOPHomeGenerator iiopHomeGen = new IIOPHomeGenerator(this.tempArchive.getArchiveUri(), this.homeInfo.classPackageName, this.homeInfo.implClassName, this.homeInfo.className, this.loader);
            iiopHomeGen.generate();
            String directoryPath = this.tempArchive.getArchiveUri() + File.separator;
            String iiopHomeClassName = ((WrapperGenerator)iiopHomeGen).generateClassName();
            String iiopHomeFullClassName = this.homeInfo.classPackageName + "." + iiopHomeClassName;
            String iiopObjectClassName = ((WrapperGenerator)iiopObjectGen).generateClassName();
            String iiopObjectFullClassName = this.objectInfo.classPackageName + "." + iiopObjectClassName;
            String[] classesToBeLoaded = new String[]{iiopHomeFullClassName, iiopObjectFullClassName};
            this.compile_generatedFiles(3, new String[]{directoryPath + iiopObjectFullClassName.replace('.', File.separatorChar) + ".java", directoryPath + iiopHomeFullClassName.replace('.', File.separatorChar) + ".java"}, classesToBeLoaded, false);
            this.deployD.setIIOPEJBHomeImplClassName(iiopHomeFullClassName);
            this.deployD.setIIOPEJBObjectImplClassName(iiopObjectFullClassName);
        }
        catch (Throwable e) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7022, e);
        }
    }

    public boolean hasOffendingPrefix(String p) {
        return p.startsWith("java.") || p.equals("java") || p.startsWith("com.sun.") || p.equals("com.sun") || p.startsWith("net.jini.") || p.equals("net.jini") || p.startsWith("jini.") || p.equals("jini") || p.startsWith("javax.") || p.equals("javax");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(String moduleDomain, BeanPair deployD, boolean fastDeploy, Map transactionInfo) throws EJBSourceGeneratorException {
        block19: {
            try {
                this.deployD = deployD;
                boolean hasInterface = false;
                if (deployD.getEJBHomeClassName() != null || deployD.getEJBLocalHomeClassName() != null) {
                    hasInterface = true;
                    this.homeInfo.setHomePackageName(deployD);
                    this.objectInfo.setObjectPackageName(deployD);
                }
                if (fastDeploy) {
                    if (hasInterface) {
                        deployD.setEJBHomeImplClassName(this.homeInfo.getFullImplClassNameAtFastDeploy(deployD, moduleDomain));
                        deployD.setEJBObjectImplClassName(this.objectInfo.getFullImplClassNameAtFastDeploy(deployD, moduleDomain));
                        if (deployD.getEJBLocalHomeClassName() != null) {
                            deployD.setEJBLocalHomeImplClassName(this.homeInfo.getLocalFullImplClassNameAtFastDeploy(deployD, moduleDomain));
                            deployD.setEJBLocalObjectImplClassName(this.objectInfo.getLocalFullImplClassNameAtFastDeploy(deployD, moduleDomain));
                        }
                        deployD.setIIOPEJBObjectImplClassName(deployD.getEJBObjectImplClassName() + "_IIOP");
                        deployD.setIIOPEJBHomeImplClassName(deployD.getEJBHomeImplClassName() + "_IIOP");
                    }
                    return;
                }
                this.moduleDomain = moduleDomain;
                this.beanNameInDescriptor = deployD.getBeanName();
                this.beanInfo.setSecurityPolicyID(deployD.getSecurityPolicyID());
                this.beanInfo.setEjbName(this.beanNameInDescriptor);
                this.beanInfo.setTransactionInfo(transactionInfo);
                this.beanInfo.setUnspecifiedTransactionType(deployD.getUnspecifiedTransactionType());
                deployD.setUnspecifiedTransactionAttr(deployD.getUnspecifiedTransactionIntType());
                this.beanInfo.initEJBBeanInfo(this);
                if (hasInterface) {
                    this.homeInfo.initEJBHomeInfo(this);
                    this.objectInfo.initEJBObjectInfo(this);
                }
                this.beanInfo.postInitBeanInfo(deployD);
                this.methodID = 0;
                if (!hasInterface) break block19;
                OutputStream outEJBObject = null;
                try {
                    outEJBObject = this.makeFileOf(this.objectInfo.getFullImplClassName());
                    this.objectInfo.generateInterfaceClass(outEJBObject);
                    outEJBObject.flush();
                }
                finally {
                    if (outEJBObject != null) {
                        outEJBObject.close();
                    }
                }
                OutputStream outEJBHome = null;
                String[] implementedHomeInterfaces = null;
                try {
                    outEJBHome = this.makeFileOf(this.homeInfo.getFullImplClassName());
                    implementedHomeInterfaces = this.homeInfo.generateInterfaceClass(outEJBHome);
                    outEJBHome.flush();
                }
                finally {
                    if (outEJBHome != null) {
                        outEJBHome.close();
                    }
                }
                ArrayList<String> sourceFileList = new ArrayList<String>();
                ArrayList<String> classFileList = new ArrayList<String>();
                sourceFileList.add(this.tempArchive.getArchiveUri() + fs + this.objectInfo.getFullImplClassName().replace('.', fsc) + ".java");
                sourceFileList.add(this.tempArchive.getArchiveUri() + fs + this.homeInfo.getFullImplClassName().replace('.', fsc) + ".java");
                classFileList.add(this.objectInfo.getFullImplClassName());
                classFileList.add(this.homeInfo.getFullImplClassName());
                this.compile_generatedFiles(4, sourceFileList.toArray(new String[sourceFileList.size()]), classFileList.toArray(new String[classFileList.size()]), false);
                if (deployD.getExportIIOP()) {
                    this.generate_IIOPfiles();
                }
                if (!(this.homeInfo.classObject == null || deployD.useJeusRmi() && JeusRMIProperties.IGNORE_STUB_CALSS)) {
                    this.generate_RMIfiles(implementedHomeInterfaces);
                }
                if (this.homeInfo.localClassObject != null) {
                    this.generate_LocalStubs();
                }
                deployD.setEJBHomeImplClassName(this.homeInfo.getFullImplClassName());
                deployD.setEJBObjectImplClassName(this.objectInfo.getFullImplClassName());
                if (deployD.getEJBLocalHomeClassName() != null) {
                    deployD.setEJBLocalHomeImplClassName(this.homeInfo.getLocalFullImplClassName());
                    deployD.setEJBLocalObjectImplClassName(this.objectInfo.getLocalFullImplClassName());
                }
            }
            catch (Throwable ex) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7023, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCMPBaseClass(boolean fastDeploy) throws EJBSourceGeneratorException {
        this.beanInfo.initBaseBeanInfo(this, this.beanPair);
        try {
            if (!fastDeploy) {
                OutputStream outEJBBaseImpl = null;
                try {
                    outEJBBaseImpl = this.makeFileOf(this.beanInfo.getFullBaseImplClassName());
                    this.beanInfo.writeCMPBaseImpl(outEJBBaseImpl, this.bSchema);
                    outEJBBaseImpl.flush();
                }
                finally {
                    if (outEJBBaseImpl != null) {
                        outEJBBaseImpl.close();
                    }
                }
                String baseImplFileName = this.tempArchive.getArchiveUri() + fs + this.beanInfo.getFullBaseImplClassName().replace('.', fsc) + ".java";
                this.compile_generatedFiles(5, new String[]{baseImplFileName}, new String[]{this.beanInfo.getFullBaseImplClassName()}, false);
            }
            this.beanPair.setBeanImplClassName(this.beanInfo.getFullBaseImplClassName());
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7024, ex);
        }
    }

    BeanPair getDescriptor() {
        return this.deployD;
    }

    String getModuleDomain() {
        return this.moduleDomain;
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public int getMethodID() {
        return this.methodID++;
    }

    public String getBeanNameInDescriptor() {
        return this.beanNameInDescriptor;
    }

    String getObjectImplClassName() {
        return this.objectInfo.implClassName;
    }

    Class getHomeClassObject() {
        return this.homeInfo.classObject;
    }

    Class getHomeLocalClassObject() {
        return this.homeInfo.localClassObject;
    }

    String getModuleName() {
        return this.moduleName;
    }

    public HomeInfo getHomeInfo() {
        return this.homeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateLocalCode() throws EJBSourceGeneratorException {
        try {
            if (this.deployD instanceof CMEntityBeanPair) {
                this.beanInfo.enableInstantQL = ((CMEntityBeanPair)this.deployD).isEnableInstantQL();
            }
            OutputStream outEJBObject = null;
            try {
                outEJBObject = this.makeFileOf(this.objectInfo.getLocalFullImplClassName());
                this.objectInfo.generateLocalInterfaceClass(outEJBObject, false);
                outEJBObject.flush();
            }
            finally {
                if (outEJBObject != null) {
                    outEJBObject.close();
                }
            }
            OutputStream outEJBHome = null;
            try {
                outEJBHome = this.makeFileOf(this.homeInfo.getLocalFullImplClassName());
                this.homeInfo.generateLocalInterfaceClass(outEJBHome, true);
                outEJBHome.flush();
            }
            finally {
                if (outEJBHome != null) {
                    outEJBHome.close();
                }
            }
            String ejbLocalObjectImplFileName = this.tempArchive.getArchiveUri() + fs + this.objectInfo.getLocalFullImplClassName().replace('.', fsc) + ".java";
            String ejbLocalHomeImplFileName = this.tempArchive.getArchiveUri() + fs + this.homeInfo.getLocalFullImplClassName().replace('.', fsc) + ".java";
            String[] classesToBeLoaded = new String[]{this.homeInfo.getLocalFullImplClassName(), this.objectInfo.getLocalFullImplClassName()};
            this.compile_generatedFiles(6, new String[]{ejbLocalObjectImplFileName, ejbLocalHomeImplFileName}, classesToBeLoaded, false);
        }
        catch (Throwable ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7025, ex);
        }
    }

    int getHashValue() {
        return this.hashValue;
    }
}

