/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EntityBean;
import javax.ejb.Handle;
import javax.ejb.SessionBean;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.InterfaceInfo;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.MethodConvertor;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.BeanPair;

public class HomeInfo
extends InterfaceInfo {
    String[] resources = new String[]{"getEJBMetaDataRsc", "getHomeHandleRsc"};
    String[] resourceMethods = new String[]{"getEJBMetaData", "getHomeHandle"};
    String[] resourceMethodParamClasses = new String[]{"", ""};

    void initEJBHomeInfo(EJBSourceGenerator generator) throws EJBSourceGeneratorException {
        this.generator = generator;
        this.beanInfo = generator.getBeanInfo();
        ClassLoader loader = generator.getClassLoader();
        BeanPair deployD = generator.getDescriptor();
        String moduleDomain = generator.getModuleDomain();
        if (deployD.getEJBHomeClassName() != null) {
            try {
                this.classObject = loader.loadClass(deployD.getEJBHomeClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7026, (Throwable)ex);
            }
            if (!EJBHome.class.isAssignableFrom(this.classObject)) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7027);
            }
        }
        if (deployD.getEJBLocalHomeClassName() != null) {
            try {
                this.localClassObject = loader.loadClass(deployD.getEJBLocalHomeClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7028, (Throwable)ex);
            }
            if (!EJBLocalHome.class.isAssignableFrom(this.localClassObject)) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7029);
            }
        }
        if (SessionBean.class.isAssignableFrom(this.beanInfo.beanClassObject)) {
            this.baseClassName = "EJBHomeImpl";
        } else if (EntityBean.class.isAssignableFrom(this.beanInfo.beanClassObject)) {
            this.baseClassName = "EJBHomeImpl";
            this.beanInfo.isEntity = true;
        }
        this.localBaseClassName = "jeus.ejb.bean.objectbase.EJBLocalHomeImpl";
        if (this.baseClassName == null) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7030);
        }
        this.implClassName = this.getImplClassName(deployD, moduleDomain);
        deployD.setIIOPEJBHomeImplClassName(this.implClassName + "_IIOP");
        if (this.classObject != null) {
            this.className = StringUtil.cutPackagePart((String)this.classObject.getName());
            this.classMethods = this.getApplicationMethods(true, false);
        }
        if (this.localClassObject != null) {
            this.localClassName = StringUtil.cutPackagePart((String)this.localClassObject.getName());
            this.localImplClassName = this.getLocalImplClassName(deployD, moduleDomain);
            this.localClassMethods = this.getApplicationMethods(true, true);
        }
        this.postInitialize();
    }

    protected String getLocalImplClassPostfix() {
        return "LocalHomeImpl";
    }

    protected String getImplClassPostfix() {
        return "HomeImpl";
    }

    void setHomePackageName(BeanPair deployD) throws EJBSourceGeneratorException {
        String homeClassName;
        int index;
        String localHomeClassName = deployD.getEJBLocalHomeClassName();
        if (localHomeClassName != null) {
            index = localHomeClassName.lastIndexOf(46);
            if (index == -1) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7003);
            }
            this.localClassPackageName = localHomeClassName.substring(0, index);
        }
        if ((homeClassName = deployD.getEJBHomeClassName()) != null) {
            index = homeClassName.lastIndexOf(46);
            if (index == -1) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7003);
            }
            this.classPackageName = homeClassName.substring(0, index);
        } else {
            this.classPackageName = this.localClassPackageName;
        }
    }

    protected void writeResourceCodes(CodeWriter codewriter) throws IOException {
        this.writeResourceAccessor(codewriter, this.resources);
        this.writeResourceInitialization(codewriter, this.resources, this.resourceMethods, this.resourceMethodParamClasses, false, this.className == null);
    }

    protected void writeInterfaceMethods(CodeWriter codewriter) throws IOException {
        try {
            if (this.classObject != null) {
                this.generateUserDefinedMethods(codewriter, this.classMethods, false);
                this.generateRemoveHandleMethod(codewriter);
                this.generateRemovePkeyMethod(codewriter, false);
            }
            if (this.localClassObject != null) {
                this.generateUserDefinedMethods(codewriter, this.localClassMethods, true);
                this.generateRemovePkeyMethod(codewriter, true);
            }
            if (this.beanInfo.isStatefulCluster) {
                this.generateFindByInstanceKey(codewriter);
            }
        }
        catch (NoSuchMethodException e) {
            throw new EJBSourceGeneratorException("The method does not exists : " + e.getMessage(), (Throwable)e);
        }
    }

    protected String[] writeImplementedInterfaceSignature(CodeWriter codewriter) throws IOException {
        Vector<String> implementedInterfaces = new Vector<String>();
        if (this.classObject != null) {
            implementedInterfaces.add(this.classPackageName + "." + this.className);
            if (this.beanInfo.isStatefulCluster) {
                implementedInterfaces.add(this.className);
            }
        } else if (this.beanInfo.isStatefulCluster) {
            implementedInterfaces.add(this.className);
        }
        for (int i = 0; i < implementedInterfaces.size(); ++i) {
            if (i == 0) {
                codewriter.write(" implements ");
            } else {
                codewriter.write(", ");
            }
            codewriter.cwrite((String)implementedInterfaces.get(i));
        }
        return implementedInterfaces.toArray(new String[0]);
    }

    private void generateUserDefinedMethods(CodeWriter codewriter, Method[] methods, boolean isLocal) throws IOException, NoSuchMethodException {
        for (int i = 0; i < methods.length; ++i) {
            Method classMethod;
            int methodID = this.generator.getMethodID();
            if (methods[i].getName().startsWith("create")) {
                String userDefinedName = methods[i].getName().substring(6);
                classMethod = methods[i];
                if (!this.CheckMappedInterfaceMethod("ejbCreate" + userDefinedName, classMethod, false)) {
                    throw new EJBSourceGeneratorException(JeusMessage_EJB11._7031, methods[i].getName());
                }
                if (this.beanInfo.isUseAccessControl()) {
                    this.writeMethodFieldDeclaration(codewriter, "ejbCreate" + methodID, this.beanInfo.beanClassObject.getMethod("ejbCreate", classMethod.getParameterTypes()));
                }
                if (this.beanInfo.isEntity) {
                    if (!this.CheckMappedInterfaceMethod("ejbPostCreate" + userDefinedName, classMethod, false)) {
                        throw new EJBSourceGeneratorException(JeusMessage_EJB11._7032, methods[i].getName());
                    }
                    if (this.beanInfo.isUseAccessControl()) {
                        this.writeMethodFieldDeclaration(codewriter, "ejbPostCreate" + methodID, this.beanInfo.beanClassObject.getMethod("ejbPostCreate", classMethod.getParameterTypes()));
                    }
                }
                this.generateInterfaceMethod(codewriter, methods[i], 1, isLocal, true, methodID);
                continue;
            }
            if (methods[i].getName().startsWith("find")) {
                Method classMethod2 = methods[i];
                String findMethodName = "ejbFind" + methods[i].getName().substring(4);
                if (this.beanInfo.isBeanManaged) {
                    if (!this.CheckMappedInterfaceMethod(findMethodName, classMethod2, false)) {
                        throw new EJBSourceGeneratorException(JeusMessage_EJB11._7067, methods[i].getName());
                    }
                    if (this.beanInfo.isUseAccessControl()) {
                        this.writeMethodFieldDeclaration(codewriter, findMethodName + methodID, this.beanInfo.beanClassObject.getMethod(findMethodName, classMethod2.getParameterTypes()));
                    }
                }
                this.generateInterfaceMethod(codewriter, methods[i], 2, isLocal, true, methodID);
                continue;
            }
            if (this.beanInfo.isEntity) {
                String homeMethodName = methods[i].getName();
                homeMethodName = "ejbHome" + StringUtil.getUpperLeadString((String)homeMethodName);
                if (!this.CheckMappedInterfaceMethod(homeMethodName, classMethod = methods[i], false)) {
                    throw new EJBSourceGeneratorException(JeusMessage_EJB11._7068, methods[i].getName());
                }
                if (this.beanInfo.isUseAccessControl()) {
                    this.writeMethodFieldDeclaration(codewriter, homeMethodName + methodID, this.beanInfo.beanClassObject.getMethod(homeMethodName, classMethod.getParameterTypes()));
                }
                this.generateInterfaceMethod(codewriter, methods[i], 3, isLocal, true, methodID);
                continue;
            }
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7069, methods[i].getName());
        }
    }

    protected void writeWorkingBody(CodeWriter codewriter, int methodType, Method m, boolean isLocalIntf, Class[] params, Class[] exceptions, int methodID) throws IOException {
        codewriter.write("try {");
        codewriter.TabIn();
        if (methodType == 1 || methodType == 3 || this.beanInfo.isBeanManaged) {
            codewriter.write(this.generator.getObjectImplClassName() + " ejbObject;");
            codewriter.write("try {");
            codewriter.write("\tejbObject = (" + this.generator.getObjectImplClassName() + ") container.getEJBObjectInstance();");
            codewriter.write("} catch(RemoteException e) {");
            codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",e);");
            codewriter.write("\tthrow e;");
            codewriter.write("}");
        } else {
            codewriter.write(this.generator.getObjectImplClassName() + " ejbObject = null;");
        }
        codewriter.write("");
        if (methodType == 1) {
            codewriter.write("this.container.createMethodCalled();");
        }
        codewriter.write("");
        if (!this.beanInfo.isStatelessSession) {
            codewriter.write("RemoteRequest request = new RemoteRequest();");
            codewriter.write("request.ejbObject = ejbObject;");
            codewriter.write("request.methodType = " + methodType + ";");
            if (this.beanInfo.isEntity) {
                if (this.beanInfo.isConManaged && methodType == 2) {
                    String methodDecl = MethodConvertor.getMethodDeclaration(m);
                    codewriter.write("request.method = \"" + methodDecl + "\";");
                    if (this.beanInfo.getIncludeUpdate(m) && !m.getName().equals("findByPrimaryKey")) {
                        codewriter.write("request.isIncludeUpdates = true;");
                    }
                }
                codewriter.write("request.txAttr = " + this.beanInfo.getTxAttribute(m, isLocalIntf ? 3 : 2) + ";");
            }
            codewriter.write("");
            this.writeInitializingReturnValue(methodType, codewriter, m);
            codewriter.write("try {");
            codewriter.TabIn();
            codewriter.write("this.container.preInvokeHome(request);");
            if (methodType != 2 || this.beanInfo.isBeanManaged) {
                if (this.beanInfo.isEntity) {
                    codewriter.write(this.beanInfo.beanClassName + " ejbBean = (" + this.beanInfo.beanClassName + ") request.ejbContext.ejbBean;");
                } else {
                    codewriter.write(this.beanInfo.beanClassName + " ejbBean = (" + this.beanInfo.beanClassName + ") ejbObject.getContext().ejbBean;");
                }
            } else {
                codewriter.write(this.beanInfo.beanClassName + " ejbBean = null;");
            }
            this.writeSecurityChecking(codewriter, isLocalIntf, m, null, methodID, this.beanInfo.isUseAccessControl());
            switch (methodType) {
                case 1: {
                    int i;
                    String name = m.getName().substring(6);
                    if (this.beanInfo.isUseAccessControl()) {
                        if (this.beanInfo.isEntity && !this.beanInfo.isConManaged) {
                            codewriter.cwrite("\tjava.lang.Object primaryKey = ");
                        }
                        codewriter.write("EJBSecurity.runEJBBusinessCode(ejbBean, methodejbCreate" + methodID + "Obj, args);");
                    } else {
                        if (this.beanInfo.isEntity && !this.beanInfo.isConManaged) {
                            codewriter.cwrite("\tjava.lang.Object primaryKey = ");
                        }
                        codewriter.cwrite("\tejbBean.ejbCreate" + name + "(");
                        for (i = 0; i < params.length; ++i) {
                            if (i != 0) {
                                codewriter.cwrite(", ");
                            }
                            codewriter.cwrite("arg" + i);
                        }
                        codewriter.write(");");
                    }
                    if (!this.beanInfo.isEntity) break;
                    if (!this.beanInfo.isConManaged) {
                        codewriter.write("\t((BMEntityContainer)this.container).registerEJBBean(request, primaryKey);");
                    } else {
                        codewriter.write("\t((CMEntityContainer)this.container).registerEJBBean(request);");
                    }
                    if (this.beanInfo.isUseAccessControl()) {
                        codewriter.write("EJBSecurity.runEJBBusinessCode(ejbBean, methodejbPostCreate" + methodID + "Obj, args);");
                    } else {
                        codewriter.cwrite("\tejbBean.ejbPostCreate" + name + "(");
                        for (i = 0; i < params.length; ++i) {
                            if (i != 0) {
                                codewriter.cwrite(", ");
                            }
                            codewriter.cwrite("arg" + i);
                        }
                        codewriter.write(");");
                    }
                    if (!this.beanInfo.isConManaged || !this.beanInfo.isDelayDatabaseInsertUntil().equals("ejbPostCreate")) break;
                    codewriter.write("\t((CMEntityContainer)this.container).registerEJBBean(ejbObject, request.tx);");
                    break;
                }
                case 2: {
                    String name = m.getName().substring(4);
                    if (!this.beanInfo.isConManaged) {
                        codewriter.cwrite("\tjava.lang.Object pKeys = ");
                        if (this.beanInfo.isUseAccessControl()) {
                            codewriter.write("EJBSecurity.runEJBBusinessCode(ejbBean, methodejbFind" + name + methodID + "Obj, args);");
                        } else {
                            codewriter.cwrite("\tejbBean.ejbFind" + name + "( ");
                            for (int i = 0; i < params.length; ++i) {
                                if (i != 0) {
                                    codewriter.cwrite(", ");
                                }
                                codewriter.cwrite("arg" + i);
                            }
                            codewriter.write(");");
                        }
                        codewriter.write("\treturnValue = (" + m.getReturnType().getName() + ")((BMEntityContainer)this.container).getEJBObjectsOf(request, pKeys, isLocal," + isLocalIntf + ");");
                        break;
                    }
                    codewriter.write("\tjava.lang.Object[] findargs = new Object[" + params.length + "];");
                    for (int i = 0; i < params.length; ++i) {
                        if (!params[i].isPrimitive()) {
                            codewriter.write("\tfindargs[" + i + "] = arg" + i + ";");
                            continue;
                        }
                        String wrapper = this.getWrapperClassName(params[i]);
                        codewriter.write("\tfindargs[" + i + "] = new " + wrapper + "(arg" + i + ");");
                    }
                    codewriter.write("\treturnValue = (" + m.getReturnType().getName() + ")((CMEntityContainer)this.container).findEntities(request, findargs, isLocal," + isLocalIntf + ");");
                    break;
                }
                case 3: {
                    String homeMethodName = m.getName();
                    homeMethodName = "ejbHome" + homeMethodName.substring(0, 1).toUpperCase() + homeMethodName.substring(1);
                    if (this.beanInfo.isUseAccessControl()) {
                        this.writeTypeConversion(codewriter, m.getReturnType(), "method" + homeMethodName + methodID + "Obj");
                        break;
                    }
                    if (m.getReturnType() != Void.TYPE) {
                        codewriter.cwrite("\treturnValue = ");
                    }
                    codewriter.cwrite("\tejbBean." + homeMethodName + "(");
                    for (int i = 0; i < params.length; ++i) {
                        if (i != 0) {
                            codewriter.cwrite(", ");
                        }
                        codewriter.cwrite("arg" + i);
                    }
                    codewriter.write(");");
                }
            }
            codewriter.write("} catch(Throwable ex) {");
            codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",ex);");
            codewriter.write("\trequest.exception = ex;");
            codewriter.write("} finally {");
            codewriter.write("\tthis.container.postInvokeHome(request);");
            codewriter.write("}");
            this.writeRecoveringEnvironment(codewriter, m, true);
            this.writeExceptionHandler(codewriter, exceptions);
        } else {
            this.writeRecoveringEnvironment(codewriter, m, false);
        }
        switch (methodType) {
            case 1: {
                if (isLocalIntf) {
                    codewriter.write("return (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")ejbObject.getEJBLocalObjectImpl();");
                    break;
                }
                codewriter.write("try {");
                codewriter.TabIn();
                codewriter.write("if(isLocal)");
                codewriter.write("\treturn (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")ejbObject;");
                codewriter.write("else if(container.exportIIOP && container.isIIOP())");
                codewriter.write("\treturn (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")ejbObject.getIIOPStub();");
                codewriter.write("else");
                codewriter.write("\treturn (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")ejbObject.getRMIStub();");
                codewriter.TabOut();
                codewriter.write("} catch (ContainerException nsoe) {");
                codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7070_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7070) + "\", nsoe);");
                codewriter.write("\tthrow new java.rmi.RemoteException(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7070) + "\", nsoe);");
                codewriter.write("}");
                break;
            }
            case 2: {
                codewriter.write("return (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")returnValue;");
                break;
            }
            case 3: {
                if (m.getReturnType() == Void.TYPE) break;
                codewriter.write("return (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")returnValue;");
            }
        }
        codewriter.TabOut();
        codewriter.write("} finally {");
        codewriter.write("}");
    }

    private void writeInitializingReturnValue(int methodType, CodeWriter codewriter, Method m) throws IOException {
        if (this.beanInfo.isEntity && methodType == 2) {
            codewriter.write(m.getReturnType().getName() + " returnValue = null;");
            codewriter.write("");
        } else if (methodType == 3) {
            this.writeInitializingReturnValueForNormalMethod(m, codewriter);
        }
        codewriter.write("");
    }

    protected void writeExceptionHandlerPerClass(CodeWriter codewriter) throws IOException {
        codewriter.write("if(request.exception instanceof RemoteException) {");
        codewriter.write("\tthrow (RemoteException)request.exception; ");
        codewriter.write("}");
    }

    private void generateRemoveHandleMethod(CodeWriter codewriter) throws EJBSourceGeneratorException, IOException {
        Method m;
        Class[] arg = new Class[]{Handle.class};
        try {
            m = EJBHome.class.getDeclaredMethod("remove", arg);
        }
        catch (NoSuchMethodException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7071);
        }
        int methodID = this.generator.getMethodID();
        this.writeResourceFieldDeclaration(codewriter, methodID, false, m, true);
        codewriter.write("public final void remove(Handle handle) throws RemoteException, RemoveException");
        codewriter.write("{");
        codewriter.TabIn();
        if (!this.beanInfo.isStatelessSession) {
            this.writeSettingEnvironment(codewriter, false, m);
            codewriter.write("RemoteRequest request = new RemoteRequest();");
            codewriter.write("request.methodType = 4;");
            if (this.beanInfo.isEntity) {
                codewriter.write("request.txAttr = " + this.beanInfo.getTxAttribute(m, 2) + ";");
            }
            codewriter.write("try {");
            codewriter.TabIn();
            if (this.beanInfo.isEntity) {
                codewriter.write("if(handle instanceof jeus.ejb.bean.objectbase.RMIHandleImpl)");
                codewriter.write("\tcontainer.removeWithPrimaryKey((Object)((jeus.ejb.bean.objectbase.RMIHandleImpl)handle).pkey, request, method" + methodID + "Rsc, new Object[] {handle});");
                codewriter.write("else");
                codewriter.write("\tcontainer.removeWithPrimaryKey((Object)((jeus.ejb.bean.objectbase.IIOPHandleImpl)handle).pkey, request, method" + methodID + "Rsc, new Object[] {handle});");
            } else {
                codewriter.write("container.removeWithInstanceKey(handle, request, method" + methodID + "Rsc);");
            }
            codewriter.write("} finally {");
            codewriter.TabIn();
            this.writeRecoveringEnvironment(codewriter, m, false);
            codewriter.TabOut();
            codewriter.write("}");
        }
        codewriter.TabOut();
        codewriter.write("}");
    }

    private void generateRemovePkeyMethod(CodeWriter codewriter, boolean isLocalIntf) throws EJBSourceGeneratorException, IOException {
        Method m;
        Class[] arg = new Class[]{Object.class};
        try {
            m = isLocalIntf ? EJBLocalHome.class.getDeclaredMethod("remove", arg) : EJBHome.class.getDeclaredMethod("remove", arg);
        }
        catch (NoSuchMethodException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7072);
        }
        int methodID = this.generator.getMethodID();
        this.writeResourceFieldDeclaration(codewriter, methodID, isLocalIntf, m, true);
        codewriter.write("public final void " + (isLocalIntf ? "__" : "") + "remove(Object primaryKey) throws RemoveException, RemoteException");
        codewriter.write("{");
        codewriter.TabIn();
        if (!this.beanInfo.isEntity) {
            this.writeSuspendChecking(codewriter, isLocalIntf, this.beanInfo.isClusteredDescriptor(this.generator.getDescriptor()));
            codewriter.write("");
            codewriter.write("throw new RemoveException(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7073) + "\");");
        } else {
            this.writeSettingEnvironment(codewriter, isLocalIntf, m);
            codewriter.write("RemoteRequest request = new RemoteRequest();");
            codewriter.write("request.methodType = 4;");
            codewriter.write("request.txAttr = " + this.beanInfo.getTxAttribute(m, isLocalIntf ? 3 : 2) + ";");
            codewriter.write("try {");
            codewriter.write("\tcontainer.removeWithPrimaryKey(primaryKey, request, method" + methodID + "Rsc, new Object[] {primaryKey} );");
            codewriter.write("} finally {");
            codewriter.TabIn();
            this.writeRecoveringEnvironment(codewriter, m, false);
            codewriter.TabOut();
            codewriter.write("}");
        }
        codewriter.TabOut();
        codewriter.write("}");
    }

    private void generateFindByInstanceKey(CodeWriter codewriter) throws EJBSourceGeneratorException, IOException {
        codewriter.write("public final EJBObject findByInstanceKey(long sesID) throws RemoteException");
        codewriter.write("{");
        codewriter.TabIn();
        this.writeSuspendChecking(codewriter, false, this.beanInfo.isClusteredDescriptor(this.generator.getDescriptor()));
        codewriter.write("");
        codewriter.write("return ((StatefulSessionContainer)container).findByInstanceKey(sesID);");
        codewriter.TabOut();
        codewriter.write("}");
    }

    boolean isDefaultLocalHome(int intType) {
        return this.localClassName != null && (this.localClassPackageName + "." + this.localClassName).equals("jeus.ejb.bean.objectbase.DefaultLocalHome") && (intType == 1 || intType == 3);
    }

    protected int getGenerationType(boolean isLocalIntf) {
        return isLocalIntf ? 3 : 2;
    }

    protected String getGenerationInterface(boolean isLocalIntf) {
        return isLocalIntf ? "LocalHome" : "Home";
    }
}

