/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.connector;

import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import jeus.ejb.baseimpl.MessageDrivenContextImpl;
import jeus.ejb.connector.EJBMessageEndpointFactory;
import jeus.ejb.connector.InflowMessageResource;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.ejbserver.ActiveManager;
import jeus.ejb.interceptor.UserInterceptorManager;
import jeus.security.base.Subject;
import jeus.security.container.ejb.EJBSecurity;
import jeus.util.ExecutionContext;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;

public class EJBMessageEndpoint
implements MessageEndpoint {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.connector.message");
    private final MessageDrivenContextImpl beanContext;
    private final EJBMessageEndpointFactory factory;
    private final MessageDrivenContainer container;
    private XAResource resource;
    private Transaction inflowTx;
    private boolean isSucceeded;
    private Method callingMethod;

    EJBMessageEndpoint(MessageDrivenContextImpl context, MessageDrivenContainer container, EJBMessageEndpointFactory factory) {
        this.beanContext = context;
        this.factory = factory;
        this.container = container;
    }

    void setResource(XAResource xaresource) {
        if (xaresource != null) {
            this.resource = new InflowMessageResource(xaresource);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object onMessage(Method method, Object[] args) throws Exception {
        Object returnValue = null;
        if (this.container.isSuspended()) {
            throw new EJBException("the container is undeployed");
        }
        Subject runAsName = this.container.getRunAsSubject();
        ExecutionContext.push(this.container.getExecutionContext());
        try {
            ActiveManager activeManager = ActiveManager.currentActiveManager();
            if (activeManager != null) {
                activeManager.getTicket();
            }
            if (runAsName != null) {
                EJBSecurity.setEJBRunAsIdentity(runAsName);
            }
            this.container.messageCount.increase();
            UserInterceptorManager interceptor = this.container.getUserInterceptorManager();
            returnValue = interceptor.invoke(this.beanContext, method, args);
            this.isSucceeded = true;
            return returnValue;
        }
        catch (Exception t) {
            Throwable cause = null;
            if (this.ofInvocationException(method, t)) {
                cause = t;
            } else {
                cause = new EJBException(t.getMessage());
                cause.initCause(t);
            }
            this.container.leaveUserLog(cause);
            this.isSucceeded = false;
            throw cause;
        }
        catch (Throwable t) {
            Throwable cause = null;
            if (this.ofInvocationException(method, t)) {
                cause = (Exception)t;
            } else {
                cause = new EJBException(t.getMessage());
                cause.initCause(t);
            }
            this.container.leaveUserLog(cause);
            this.isSucceeded = false;
            throw cause;
        }
        finally {
            try {
                if (runAsName != null) {
                    EJBSecurity.clearEJBRunAsIdentity();
                }
            }
            catch (Exception e) {
                this.isSucceeded = false;
                throw new EJBException(e);
            }
            finally {
                ExecutionContext.pop();
                ActiveManager activeManager = ActiveManager.currentActiveManager();
                if (activeManager != null) {
                    activeManager.returnTicket();
                }
            }
        }
    }

    private boolean ofInvocationException(Method method, Throwable exception) {
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            String name = exception.getClass().getName();
            if (!name.equals(exceptions[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void beforeDelivery(Method method) throws EJBException {
        try {
            this.inflowTx = this.container.beforeDelivery(this.resource, method);
            this.callingMethod = method;
        }
        catch (ContainerException ex) {
            if (logger.isLoggable(JeusMessage_EJB11._7178_LEVEL)) {
                logger.log(JeusMessage_EJB11._7178_LEVEL, JeusMessage_EJB11._7178, (Throwable)((Object)ex));
            }
            throw new EJBException((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelivery() {
        try {
            this.container.afterDelivery(this.resource, this.callingMethod, this.isSucceeded, this.inflowTx);
        }
        finally {
            this.callingMethod = null;
            this.inflowTx = null;
            this.isSucceeded = false;
        }
    }

    public void release() {
        this.resource = null;
        this.factory.release(this);
    }
}

