/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.connector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import jeus.ejb.connector.EJBMessageEndpoint;
import jeus.ejb.connector.MessageEndpointHandler;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.InstantRecycler;
import jeus.ejb.container.InstantRecyclerControlable;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMService;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB12;

public class EJBMessageEndpointFactory
implements MessageEndpointFactory,
InstantRecyclerControlable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.connector.message");
    public static final String MESSAGE_ENDPOINT = "javax.resource.spi.endpoint.MessageEndpoint";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String BEFORE_DELIVERY = "beforeDelivery";
    public static final String AFTER_DELIVERY = "afterDelivery";
    public static final String RELEASE = "release";
    public static final String HASHCODE = "hashCode";
    public static final String EQUALS = "equals";
    public static final String TO_STRING = "toString";
    private Class[] interfaces;
    private MessageDrivenContainer container;
    private MessageDrivenBeanInfo desc;
    private InstantRecycler beanPool;

    public EJBMessageEndpointFactory(MessageDrivenContainer con, MessageDrivenBeanInfo beanInfo) throws ContainerException {
        block2: {
            this.container = con;
            this.desc = beanInfo;
            this.beanPool = new InstantRecycler(beanInfo.getEJBBeanPoolSize(), beanInfo.getEJBBeanPoolMax(), beanInfo.getEJBBeanResizingPeriod(), this);
            try {
                this.interfaces = new Class[]{Class.forName(MESSAGE_ENDPOINT), beanInfo.getListenerInterface()};
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_EJB11._7179_LEVEL)) break block2;
                logger.log(JeusMessage_EJB11._7179_LEVEL, JeusMessage_EJB11._7179, (Throwable)e);
            }
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaresource) throws UnavailableException {
        try {
            EJBMessageEndpoint epj = (EJBMessageEndpoint)this.beanPool.getObject();
            epj.setResource(xaresource);
            MessageEndpointHandler handler = new MessageEndpointHandler(epj);
            MessageEndpoint ep = (MessageEndpoint)Proxy.newProxyInstance(this.container.getClassLoader(), this.interfaces, (InvocationHandler)handler);
            if (logger.isLoggable(JeusMessage_EJB12._9013_LEVEL)) {
                logger.log(JeusMessage_EJB12._9013_LEVEL, JeusMessage_EJB12._9013, new Object[]{ep.hashCode(), Thread.currentThread()});
            }
            return ep;
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_EJB11._7180_LEVEL)) {
                logger.log(JeusMessage_EJB11._7180_LEVEL, JeusMessage_EJB11._7180, (Throwable)ex);
            }
            throw new UnavailableException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7180));
        }
    }

    public void release(EJBMessageEndpoint endpoint) {
        block2: {
            try {
                this.beanPool.putObject(endpoint);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_EJB11._7177_LEVEL)) break block2;
                logger.log(JeusMessage_EJB11._7177_LEVEL, JeusMessage_EJB11._7177, (Throwable)ex);
            }
        }
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof EJBMessageEndpointFactory)) {
            return false;
        }
        EJBMessageEndpointFactory fac = (EJBMessageEndpointFactory)another;
        return fac.desc.getModuleName().equals(this.desc.getModuleName());
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.container.isTransactedMethod(method);
    }

    public Object createPoolElement() throws ContainerException {
        return new EJBMessageEndpoint(this.container.createEJBBean(), this.container, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingObjectAtCleared(Object obj) {
        Object gtid = this.beforeShrink();
        try {
            this.beforeRemove(obj);
        }
        finally {
            this.afterShrink(gtid);
        }
    }

    public Object beforeShrink() {
        return TMService.suspendCurrentTransaction();
    }

    public void afterShrink(Object shrinkState) {
        TMService.resumeCurrentTransaction((GTID)shrinkState);
    }

    public void beforeRemove(Object obj) {
    }

    public Exception throwException(Throwable ex) {
        return null;
    }

    public int getInstanceSize() {
        return this.beanPool.size();
    }

    public int getAvailableInstanceSize() {
        return this.beanPool.available();
    }
}

