/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.security.jacc.EJBMethodPermission;
import javax.transaction.Transaction;
import jeus.container.resource.ResourceRefHelper;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.EJBStatus;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.bean.RemoteRequest;
import jeus.ejb.bean.context.EJBContextImpl;
import jeus.ejb.bean.objectbase.EJBHomeImpl;
import jeus.ejb.bean.objectbase.EJBLocalHomeImpl;
import jeus.ejb.bean.objectbase.EJBLocalObjectImpl;
import jeus.ejb.bean.objectbase.EJBObjectImpl;
import jeus.ejb.bean.objectbase.IIOPEJBMetaDataImpl;
import jeus.ejb.bean.objectbase.IIOPHomeHandleImpl;
import jeus.ejb.bean.objectbase.RMIEJBMetaDataImpl;
import jeus.ejb.bean.objectbase.RMIHomeHandleImpl;
import jeus.ejb.bean.objectbase.TimerImpl;
import jeus.ejb.compiler.BeanInfo;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.ConcurrentAccessException;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.ejbserver.containerinfo.ContainerInfo;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.PropertyLinkRef;
import jeus.jndi.objectfactory.CosNamingResource;
import jeus.jndi.objectfactory.CosNamingResourceFactory;
import jeus.security.base.Subject;
import jeus.security.resource.PrincipalImpl;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB3;
import jeus.util.message.JeusMessage_EJB4;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.ResAuthType;
import jeus.xml.binding.j2ee.ResSharingScopeType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.RunAsType;
import jeus.xml.binding.j2ee.SecurityIdentityType;
import jeus.xml.binding.j2ee.SessionBeanType;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;
import jeus.xml.binding.jeusDD.ExportIiopType;
import org.omg.PortableServer.POA;

public abstract class Container
extends AbstractContainer {
    protected BeanPair deployD;
    protected ClusteringType clusterDesc;
    protected Class ejbHomeImplClass;
    protected Class ejbLocalHomeImplClass;
    protected Class ejbObjectImplClass;
    protected Class ejbLocalObjectImplClass;
    protected Class ejbHomeClass;
    protected Class ejbLocalHomeClass;
    protected Class ejbObjectClass;
    protected Class ejbLocalObjectClass;
    Method removeMethod;
    public Method methodEjbPassivateObj;
    protected Method methodEjbActivateObj;
    protected EJBHomeImpl ejbHomeImpl;
    protected EJBHomeImpl ejbLocalizedHomeImpl;
    protected EJBLocalHomeImpl ejbLocalHomeImpl;
    protected RMIHomeHandleImpl homeHandleImpl_rmi;
    protected IIOPHomeHandleImpl homeHandleImpl_iiop;
    protected RMIEJBMetaDataImpl ejbMetaDataImpl_rmi;
    protected IIOPEJBMetaDataImpl ejbMetaDataImpl_iiop;
    public String envRoot;
    private boolean isEnvRootUsed;
    public String appName;
    private HashMap environmentMap = new HashMap();
    public boolean isBeanManagedTx;
    protected Map transactionInfo;
    protected int ejbTimeoutTxType;
    private boolean exported;
    private boolean localExported;
    private boolean iiopExported;

    Container(EntityBeanInfo beanInfo, Map transactionInfo, ArchiveArrayClassLoader loader, String securityDomain) throws ContainerException {
        super(beanInfo, loader, securityDomain);
        this.deployD = beanInfo.getBeanPair();
        this.transactionInfo = transactionInfo;
        this.environmentMap.put("jeus.app.name", this.appName);
        this.environmentMap.put("jeus.logger", logger);
        this.environmentMap.put("jeus.contextloader", loader);
        this.registerSecurities();
        if (logger.isLoggable(JeusMessage_EJB4._3060_LEVEL)) {
            logger.log(JeusMessage_EJB4._3060_LEVEL, JeusMessage_EJB4._3060, (Object)this.deployD.toConfigString());
        }
    }

    protected final void initEJBBeanInfo(Map transactionInfo) throws ContainerException {
        try {
            String beanClassName = this.deployD.getFullEJBBeanClassName();
            this.beanClass = this.loader.loadClass(beanClassName);
            if (this.isUseAccessControl) {
                this.removeMethod = this.beanClass.getMethod("ejbRemove", EJBServerUtils.null_classes);
                this.methodEjbActivateObj = this.beanClass.getMethod("ejbActivate", EJBServerUtils.null_classes);
                this.methodEjbPassivateObj = this.beanClass.getMethod("ejbPassivate", EJBServerUtils.null_classes);
            }
            if (TimedObject.class.isAssignableFrom(this.beanClass)) {
                this.ejbTimeoutMethod = this.beanClass.getMethod("ejbTimeout", Timer.class);
                if (transactionInfo != null) {
                    this.ejbTimeoutTxType = BeanInfo.getTxAttributeWithTxInfo(this.ejbTimeoutMethod, 4, transactionInfo, TransactionInfo.getTransactionType(this.deployD.getUnspecifiedTransactionType()), 0);
                    if (!this.isBeanManagedTx && this.ejbTimeoutTxType != 3 && this.ejbTimeoutTxType != 0) {
                        if (logger.isLoggable(JeusMessage_EJB3._2863_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2863_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2863, (Object)TransactionInfo.state[this.ejbTimeoutTxType]);
                        }
                        throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB3._2863, (Object)TransactionInfo.state[this.ejbTimeoutTxType]));
                    }
                    if (logger.isLoggable(JeusMessage_EJB3._2864_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2864_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2864, (Object)TransactionInfo.state[this.ejbTimeoutTxType]);
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_EJB3._2865_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2865_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2865);
                    }
                    this.ejbTimeoutTxType = 0;
                }
                if (logger.isLoggable(JeusMessage_EJB3._2866_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2866_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2866);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ContainerException(JeusMessage_EJB3._2868, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ContainerException(JeusMessage_EJB3._2869, (Throwable)ex);
        }
    }

    protected final void registerEnviroments() throws ContainerException {
        try {
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.localbindings", "true");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            InitialContext ctx = new InitialContext(envs);
            this.envRoot = "_" + this.moduleName + "/_" + this.beanName;
            this.environmentMap.put("jeus.jndi.enc.prefix", this.envRoot);
            List envList = this.deployD.getEnvs();
            List ejbRefList = this.deployD.getEJBRefs();
            List ejbLocalRefList = this.deployD.getEJBLocalRefs();
            List resourceRefList = this.deployD.getResourceRefs();
            List resourceEnvRefList = this.deployD.getResourceEnvRefs();
            List serviceRefPairList = this.deployD.getServiceRefPairs();
            List messageDestinationRefList = this.deployD.getMessageDestinationRefs();
            for (EnvEntryType envEntry : envList) {
                this.bindEnvEntry(envEntry, ctx);
            }
            for (EnvEntryType envEntry : ejbRefList) {
                this.bindEjbRef((EjbRefType)envEntry, ctx);
            }
            for (EnvEntryType envEntry : ejbLocalRefList) {
                this.bindEjbLocalRef((EjbLocalRefType)envEntry, ctx);
            }
            for (EnvEntryType envEntry : resourceRefList) {
                this.bindResourceRef((ResourceRefType)envEntry, ctx);
            }
            for (EnvEntryType envEntry : resourceEnvRefList) {
                this.bindResourceEnvRef((ResourceEnvRefType)envEntry, ctx);
            }
            for (EnvEntryType envEntry : messageDestinationRefList) {
                this.bindMessageDestinationRef((MessageDestinationRefType)envEntry, ctx);
            }
            EWSProvider provider = EWSProvider.getProvider();
            if (provider != null && provider.bindServiceRefs(ctx, this.envRoot, serviceRefPairList, this.loader)) {
                System.out.println("###################### Container#registerEnviroments");
                this.isEnvRootUsed = true;
                this.isWebserviceConsumer = true;
            }
            if (this.isBeanManagedTx) {
                this.isEnvRootUsed = true;
                ctx.rebind(this.envRoot + "/UserTransaction", (Object)TxHelper.getUserTransaction());
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2942, ex);
        }
    }

    private void bindResourceEnvRef(ResourceEnvRefType envEntry, InitialContext ctx) throws EJBDescriptorValidationException, NamingException {
        String ref = envEntry.getResourceEnvRefName().getValue();
        String jndiName = this.deployD.getJndiName(envEntry);
        if (logger.isLoggable(JeusMessage_EJB3._2943_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2943_LEVEL, "Container", "bindResourceEnvRef", JeusMessage_EJB3._2943, new Object[]{ref, jndiName});
        }
        this.isEnvRootUsed = true;
        ctx.rebind(this.envRoot + "/" + ref, (Object)new LinkRef(jndiName));
        if (logger.isLoggable(JeusMessage_EJB3._2944_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2944_LEVEL, "Container", "bindResourceEnvRef", JeusMessage_EJB3._2944, new Object[]{ref, jndiName});
        }
    }

    private void bindMessageDestinationRef(MessageDestinationRefType envEntry, InitialContext ctx) throws EJBDescriptorValidationException, NamingException {
        String ref = envEntry.getMessageDestinationRefName().getValue();
        String jndiName = this.deployD.getJndiName(envEntry);
        if (logger.isLoggable(JeusMessage_EJB3._2945_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2945_LEVEL, "Container", "bindMessageDestinationRef", JeusMessage_EJB3._2945, new Object[]{ref, jndiName});
        }
        this.isEnvRootUsed = true;
        ctx.rebind(this.envRoot + "/" + ref, (Object)new LinkRef(jndiName));
        if (logger.isLoggable(JeusMessage_EJB3._2946_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2946_LEVEL, "Container", "bindMessageDestinationRef", JeusMessage_EJB3._2946, new Object[]{ref, jndiName});
        }
    }

    private void bindResourceRef(ResourceRefType envEntry, InitialContext ctx) throws EJBDescriptorValidationException, NamingException {
        String resourceRefName = envEntry.getResRefName().getValue();
        String context = this.envRoot + "/" + resourceRefName;
        String jndiName = this.deployD.getJndiName(envEntry);
        if (logger.isLoggable(JeusMessage_EJB3._2947_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2947_LEVEL, "Container", "bindResourceRef", JeusMessage_EJB3._2947, new Object[]{resourceRefName, jndiName});
        }
        if (resourceRefName.startsWith("url/")) {
            try {
                URL url = new URL(jndiName);
                ctx.rebind(context, (Object)url);
            }
            catch (MalformedURLException ex) {
                ctx.rebind(context, (Object)new LinkRef(jndiName));
            }
        } else {
            ResSharingScopeType sharingType = envEntry.getResSharingScope();
            boolean shareable = true;
            if (sharingType != null) {
                shareable = !"Unshareable".equals(sharingType.getValue());
            }
            ResAuthType resAuthType = envEntry.getResAuth();
            Resource.AuthenticationType authType = ResourceRefHelper.DEFAULT_AUTH_TYPE;
            if (resAuthType != null) {
                authType = "Application".equals(resAuthType.getValue()) ? Resource.AuthenticationType.APPLICATION : Resource.AuthenticationType.CONTAINER;
            }
            PropertyLinkRef linkRef = ResourceRefHelper.createPropertyLinkRef(jndiName, shareable, authType);
            ctx.rebind(context, (Object)linkRef);
        }
        if (logger.isLoggable(JeusMessage_EJB3._2948_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2948_LEVEL, "Container", "bindResourceRef", JeusMessage_EJB3._2948, new Object[]{resourceRefName, jndiName});
        }
        if (envEntry.getResAuth() == null) {
            if (logger.isLoggable(JeusMessage_EJB3._2949_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2949_LEVEL, "Container", "bindResourceRef", JeusMessage_EJB3._2949);
            }
            throw new JeusRuntimeException("you must set resource-ref in ejb-jar.xml");
        }
        if (envEntry.getResAuth().getValue().equalsIgnoreCase("Application")) {
            if (logger.isLoggable(JeusMessage_EJB3._2950_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2950_LEVEL, "Container", "bindResourceRef", JeusMessage_EJB3._2950);
            }
            Context leafContext = (Context)ctx.lookup(context.substring(0, context.lastIndexOf(47)));
            leafContext.addToEnvironment("_resauth", "_resauth");
        } else if (logger.isLoggable(JeusMessage_EJB3._2951_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2951_LEVEL, "Container", "bindResourceRef", JeusMessage_EJB3._2951);
        }
    }

    private void bindEjbRef(EjbRefType ejbRefType, InitialContext ctx) throws NamingException, EJBDescriptorValidationException {
        String ref = ejbRefType.getEjbRefName().getValue();
        String jndiName = this.deployD.getJndiName(ejbRefType);
        if (logger.isLoggable(JeusMessage_EJB3._2952_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2952_LEVEL, "Container", "bindEjbRef", JeusMessage_EJB3._2952, new Object[]{ref, jndiName});
        }
        this.isEnvRootUsed = true;
        ctx.rebind(this.envRoot + "/" + ref, (Object)new LinkRef(jndiName));
        if (logger.isLoggable(JeusMessage_EJB3._2953_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2953_LEVEL, "Container", "bindEjbRef", JeusMessage_EJB3._2953, new Object[]{ref, jndiName});
        }
    }

    private void bindEjbLocalRef(EjbLocalRefType ejbRefType, InitialContext ctx) throws NamingException, EJBDescriptorValidationException {
        String ref = ejbRefType.getEjbRefName().getValue();
        String jndiName = this.deployD.getJndiName(ejbRefType);
        if (logger.isLoggable(JeusMessage_EJB3._2954_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2954_LEVEL, "Container", "bindEjbLocalRef", JeusMessage_EJB3._2954, new Object[]{ref, jndiName});
        }
        this.isEnvRootUsed = true;
        ctx.rebind(this.envRoot + "/" + ref, (Object)new LinkRef(jndiName));
        if (logger.isLoggable(JeusMessage_EJB3._2955_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2955_LEVEL, "Container", "bindEjbLocalRef", JeusMessage_EJB3._2955, new Object[]{ref, jndiName});
        }
    }

    private void bindEnvEntry(EnvEntryType envEntry, Context ctx) throws NamingException {
        Object value;
        String name = envEntry.getEnvEntryName().getValue();
        String type = envEntry.getEnvEntryType().getValue();
        String envValue = envEntry.getEnvEntryValue().getValue().trim();
        if (type.equals("int") || type.equals("Integer") || type.equals("java.lang.Integer")) {
            value = Integer.valueOf(envValue);
        } else if (type.equals("long") || type.equals("Long") || type.equals("java.lang.Long")) {
            value = Long.valueOf(envValue);
        } else if (type.equals("float") || type.equals("Float") || type.equals("java.lang.Float")) {
            value = Float.valueOf(envValue);
        } else if (type.equals("boolean") || type.equals("Boolean") || type.equals("java.lang.Boolean")) {
            value = Boolean.valueOf(envValue);
        } else if (type.equals("double") || type.equals("Double") || type.equals("java.lang.Double")) {
            value = Double.valueOf(envValue);
        } else if (type.equals("byte") || type.equals("Byte") || type.equals("java.lang.Byte")) {
            value = Byte.valueOf(envValue);
        } else if (type.equals("short") || type.equals("Short") || type.equals("java.lang.Short")) {
            value = Short.valueOf(envValue);
        } else if (type.equals("char") || type.equals("Char") || type.equals("java.lang.Character")) {
            char[] carray = envValue.toCharArray();
            value = new Character(carray[0]);
        } else {
            value = envValue;
        }
        if (logger.isLoggable(JeusMessage_EJB3._2956_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2956_LEVEL, "Container", "bindEnvEntry", JeusMessage_EJB3._2956, new Object[]{type, name});
        }
        this.isEnvRootUsed = true;
        String bindName = this.envRoot + "/" + name;
        ctx.rebind(bindName, value);
        if (logger.isLoggable(JeusMessage_EJB3._2957_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2957_LEVEL, "Container", "bindEnvEntry", JeusMessage_EJB3._2957, new Object[]{value, bindName});
        }
    }

    protected final void unregisterEnvironments() {
        block5: {
            InitialContext ctx;
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.localbindings", "true");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            try {
                ctx = new InitialContext(envs);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return;
            }
            try {
                if (this.isEnvRootUsed) {
                    ctx.destroySubcontext(this.envRoot);
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB3._2966_LEVEL)) break block5;
                logger.logp(JeusMessage_EJB3._2966_LEVEL, "Container", "unregisterEnvironments", JeusMessage_EJB3._2966, ex);
            }
        }
    }

    protected final void registerSecurities() throws ContainerException {
        try {
            String principal = this.deployD.getRunAsName();
            if (principal != null) {
                PrincipalImpl p = new PrincipalImpl(principal);
                this.runAsSubject = new Subject(this.securityDomainName, p);
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2970, ex);
        }
    }

    public String getRunAsRole(Object ejbJarBean) {
        RoleNameType roleNameType;
        RunAsType runAsType;
        SecurityIdentityType indentityType;
        EntityBeanType beanType;
        String roleName = null;
        if (ejbJarBean instanceof EntityBeanType) {
            beanType = (EntityBeanType)ejbJarBean;
            indentityType = beanType.getSecurityIdentity();
        } else if (ejbJarBean instanceof SessionBeanType) {
            beanType = (SessionBeanType)ejbJarBean;
            indentityType = beanType.getSecurityIdentity();
        } else if (ejbJarBean instanceof MessageDrivenBeanType) {
            beanType = (MessageDrivenBeanType)ejbJarBean;
            indentityType = beanType.getSecurityIdentity();
        } else {
            return roleName;
        }
        if (indentityType != null && (runAsType = indentityType.getRunAs()) != null && (roleNameType = runAsType.getRoleName()) != null) {
            roleName = roleNameType.getValue();
        }
        return roleName;
    }

    protected final void registerEJBHome() throws ContainerException {
        InitialDirContext ctx;
        Hashtable<String, String> envs;
        String clusterExportName = null;
        if (this.deployD.getEJBHomeClassName() == null && this.deployD.getEJBLocalHomeClassName() == null) {
            return;
        }
        try {
            envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            if (this.singleVMOnly) {
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.localcontextbindings", "false");
                envs.put("jeus.jndi.replicate.context", "true");
            }
            ctx = new InitialDirContext(envs);
            if (this.exportName != null) {
                ExportIiopType iiopType;
                String context = this.exportName;
                if (this.deployD.getEJBHomeClassName() != null && this.ejbHomeImpl != null && this.isClustered) {
                    if (logger.isLoggable(JeusMessage_EJB3._2974_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2974_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2974);
                    }
                    clusterExportName = this.exportName;
                    String engineName = this.engine.getPureEngineName();
                    this.exportName = "__jeus_cl" + Container.getHashCode(VirtualDNS.LOCAL_VIRTUALNAME + "_" + JeusPort.JeusBase + "_" + engineName) + "_" + clusterExportName + "_$addr$_" + EJBServerUtils.getJndiUrl() + ":" + JeusPort.JeusBase;
                }
                if (this.exportIIOP) {
                    Context iiopContext = CosNamingResourceFactory.getCNCtx();
                    int index = context.indexOf("/");
                    String fullName = context;
                    while (index > 0) {
                        try {
                            iiopContext = iiopContext.createSubcontext(context.substring(0, index));
                        }
                        catch (NameAlreadyBoundException e) {
                            iiopContext = (Context)iiopContext.lookup(context.substring(0, index));
                        }
                        context = context.substring(index + 1);
                        index = context.indexOf("/");
                    }
                    iiopContext.rebind(context, (Object)this.ejbHomeImpl.getIIOPStub());
                    this.iiopExported = true;
                    if (this.deployD.getExportIiopType().isOnlyIiop().booleanValue()) {
                        Container.bindAgedObject(ctx, this.exportName, new CosNamingResource(CosNamingResourceFactory.urlServer, fullName));
                        this.exported = true;
                        if (logger.isLoggable(JeusMessage_EJB3._2982_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2982_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2982);
                        }
                    }
                }
                if ((iiopType = this.deployD.getExportIiopType()) == null || !iiopType.isOnlyIiop().booleanValue()) {
                    Object bindObject;
                    if (this.isLocalInvocationOptimized) {
                        bindObject = Container.getStubObject(this.ejbLocalizedHomeImpl, this.ejbHomeClass);
                        if (logger.isLoggable(JeusMessage_EJB3._2984_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2984_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2984, (Object)this.exportName);
                        }
                    } else {
                        bindObject = Container.getStubObject(this.ejbHomeImpl.getRMIStub(), this.ejbHomeClass);
                        if (logger.isLoggable(JeusMessage_EJB3._2986_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2986_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2986, (Object)this.exportName);
                        }
                    }
                    Container.bindAgedObject(ctx, this.exportName, bindObject);
                    this.exported = true;
                }
            }
            if (this.localExportName != null && this.ejbLocalHomeImpl != null) {
                envs = new Hashtable();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.localcontextbindings", "false");
                envs.put("jeus.jndi.replicate.context", "true");
                InitialContext ctx1 = new InitialContext(envs);
                ctx1.bind(this.localExportName, (Object)this.ejbLocalHomeImpl);
                this.localExported = true;
                if (logger.isLoggable(JeusMessage_EJB3._2989_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2989_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2989, (Object)this.localExportName);
                }
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2990, this.exportName, ex);
        }
        try {
            this.homeHandleImpl_rmi = new RMIHomeHandleImpl(this.ejbLocalizedHomeImpl, this.exportName);
            if (this.exportIIOP) {
                this.homeHandleImpl_iiop = new IIOPHomeHandleImpl(this.ejbHomeImpl.getIIOPStub(), this.ejbHomeClass.getName(), this.exportName);
            }
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB3._2995, e);
        }
        try {
            if (this.deployD.getEJBHomeClassName() != null && this.ejbHomeImpl != null && this.isClustered) {
                envs = new Hashtable();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                envs.put("jeus.jndi.jns.clusterbindings", "true");
                ctx = new InitialDirContext(envs);
                ctx.rebind(clusterExportName, (Object)new DynamicLinkRef("EJBLinkRef", this.exportName));
                if (logger.isLoggable(JeusMessage_EJB3._2997_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2997_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2997, (Object)clusterExportName);
                }
            }
        }
        catch (Throwable ex1) {
            throw new ContainerException(JeusMessage_EJB3._2998, ex1);
        }
    }

    public final void start() throws ContainerException {
        if (!this.status.compareAndSet(EJBStatus.DEPLOYED, EJBStatus.STARTING)) {
            throw new ContainerException("EJBContainer is not deployed state.");
        }
        ExecutionContext.push(this.environmentMap);
        try {
            this.preStartService();
            this.startService();
        }
        catch (Throwable ex) {
            this.status.set(EJBStatus.START_FAILED);
            if (logger.isLoggable(JeusMessage_EJB11._8002_LEVEL)) {
                logger.log(JeusMessage_EJB11._8002_LEVEL, JeusMessage_EJB11._8002, (Object)this.beanName);
                logger.log(JeusMessage_EJB11._8003_LEVEL, JeusMessage_EJB11._8003, ex);
            }
            if (ex instanceof ContainerException) {
                throw (ContainerException)((Object)ex);
            }
            throw new ContainerException(ex.getMessage(), ex);
        }
        finally {
            ExecutionContext.pop();
        }
        this.status.set(EJBStatus.RUNNING);
    }

    public EJBHomeImpl getEJBHome() {
        if (this.isLocalInvocationOptimized) {
            return this.ejbLocalizedHomeImpl;
        }
        return this.ejbHomeImpl;
    }

    public EJBLocalHomeImpl getEJBLocalHome() {
        if (this.localExportName == null || this.ejbLocalHomeImpl == null) {
            return null;
        }
        return this.ejbLocalHomeImpl;
    }

    public EJBMetaData getEJBMetaData() {
        if (this.exportIIOP && Container.isIIOP()) {
            return this.ejbMetaDataImpl_iiop;
        }
        return this.ejbMetaDataImpl_rmi;
    }

    public HomeHandle getHomeHandle() {
        if (this.exportIIOP && Container.isIIOP()) {
            return this.homeHandleImpl_iiop;
        }
        return this.homeHandleImpl_rmi;
    }

    public void removeWithPrimaryKey(Object pkey, RemoteRequest request, EJBMethodPermission perm, Object[] args) throws RemoteException, RemoveException {
    }

    public void removeWithInstanceKey(Handle handle, RemoteRequest request, EJBMethodPermission perm) throws RemoteException, RemoveException {
    }

    protected void getContainerInfo(ContainerInfo conInfo) {
        conInfo.setContainerName(this.ejbId);
        conInfo.setIsRunning(!this.isRunning());
        conInfo.setEJBDescriptor(this.deployD);
    }

    protected void stopService() {
        block5: {
            try {
                if (this.ejbHomeImpl != null) {
                    this.ejbHomeImpl.unexport();
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB11._7181_LEVEL)) break block5;
                logger.log(JeusMessage_EJB11._7181_LEVEL, JeusMessage_EJB11._7181, ex);
            }
        }
        try {
            super.stopService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy() {
        block32: {
            block31: {
                Hashtable<String, String> env;
                block30: {
                    if (logger.isLoggable(JeusMessage_EJB4._3017_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3017_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3017);
                    }
                    try {
                        this.destoryTimers();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    try {
                        this.unregisterEnvironments();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (this.exportName != null) {
                            if (this.iiopExported) {
                                InitialContext iiopContext = CosNamingResourceFactory.getCNCtx();
                                iiopContext.unbind(this.exportName);
                                if (logger.isLoggable(JeusMessage_EJB3._2982_LEVEL)) {
                                    logger.logp(JeusMessage_EJB3._2982_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2982);
                                }
                            }
                            env = new Hashtable<String, String>();
                            if (this.singleVMOnly) {
                                env.put("jeus.jndi.jns.localbindings", "true");
                            }
                            if (this.exported) {
                                new InitialContext(env).unbind(this.exportName);
                            }
                            if (logger.isLoggable(JeusMessage_EJB4._3019_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3019_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3019, (Object)this.exportName);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_EJB4._3020_LEVEL)) break block30;
                        logger.logp(JeusMessage_EJB4._3020_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3020, (Object)this.exportName, ex);
                    }
                }
                try {
                    if (this.localExported) {
                        env = new Hashtable();
                        env.put("jeus.jndi.jns.localbindings", "true");
                        new InitialContext(env).unbind(this.localExportName);
                        if (logger.isLoggable(JeusMessage_EJB4._3022_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3022_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3022, (Object)this.localExportName);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3023_LEVEL)) break block31;
                    logger.logp(JeusMessage_EJB4._3023_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3023, (Object)this.localExportName, ex);
                }
            }
            try {
                if (this.ejbLocalizedHomeImpl != null) {
                    this.ejbLocalizedHomeImpl.unexport();
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB11._7181_LEVEL)) break block32;
                logger.log(JeusMessage_EJB11._7181_LEVEL, JeusMessage_EJB11._7181, ex);
            }
        }
        if (this.ejbPOA != null) {
            try {
                String poaName = this.moduleName + "_" + this.beanName;
                EJBORBManager.removeEJBCSIDescriptor(poaName);
                ((POA)this.ejbPOA).destroy(false, false);
                if (logger.isLoggable(JeusMessage_EJB4._3025_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3025_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3025);
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_EJB4._3026_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3026_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3026, ex);
                }
            }
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3027_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3027_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3027);
        }
    }

    public synchronized EJBLocalObjectImpl getEJBLocalObjectStub() {
        try {
            return (EJBLocalObjectImpl)this.ejbLocalObjectImplClass.newInstance();
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(JeusMessage_EJB4._3036, t);
        }
    }

    public abstract void preInvoke(RemoteRequest var1) throws Throwable, ConcurrentAccessException;

    public abstract void postInvoke(RemoteRequest var1);

    public abstract void preInvokeHome(RemoteRequest var1) throws Throwable;

    public abstract void postInvokeHome(RemoteRequest var1) throws RemoteException;

    public abstract void removeEJBBean(RemoteRequest var1) throws RemoveException, ContainerException;

    public abstract EJBContextImpl connectContext(EJBObjectImpl var1, Transaction var2) throws Throwable;

    public abstract EJBObjectImpl getEJBObjectInstance() throws RemoteException;

    public abstract void beforeCompletion(EJBObject var1, Transaction var2, boolean var3);

    public abstract void afterCompletion(EJBObject var1, Transaction var2, boolean var3);

    public abstract void flush(EJBObject var1, Transaction var2);

    protected void initializeMetaData(Class pkeyClass, boolean isSessionBean, boolean isStatelessSessionBean) throws RemoteException {
        this.ejbMetaDataImpl_rmi = new RMIEJBMetaDataImpl(this.ejbHomeImpl, this.ejbHomeClass, this.ejbObjectClass, pkeyClass, this.exportName, EJBServerUtils.getJndiUrl() + ":" + JeusPort.JeusBase, isSessionBean, isStatelessSessionBean);
        if (this.exportIIOP) {
            this.ejbMetaDataImpl_iiop = new IIOPEJBMetaDataImpl(this.ejbHomeImpl, this.exportName, this.ejbHomeClass, this.ejbObjectClass, pkeyClass, isSessionBean, isStatelessSessionBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeEJBTimeout(TimerState timerState, TimerContainer timerContainer) throws Throwable {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3053_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3053_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3053);
        }
        boolean redeliver = false;
        RemoteRequest request = new RemoteRequest();
        request.methodType = 0;
        request.method = "ejbTimeout(javax.ejb.Timer)";
        request.txAttr = this.ejbTimeoutTxType;
        ExecutionContext.push(this.environmentMap);
        try {
            this.initInvokeTimer(request, timerState);
            this.preInvoke(request);
            Object[] args = new Object[]{new TimerImpl(timerState.getTimerId(), timerContainer)};
            this.timeoutMethodInvoke(request, args);
            if (!this.isBeanManagedTx && this.ejbTimeoutTxType != 0 && txManager.getTransaction().getStatus() == 1) {
                if (timerLogger.isLoggable(JeusMessage_EJB4._3055_LEVEL)) {
                    timerLogger.logp(JeusMessage_EJB4._3055_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3055);
                }
                redeliver = true;
            }
            timerContainer.setLastExpiration(timerState, redeliver);
            this.postInvokeTimer(request);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB4._3056_LEVEL)) {
                timerLogger.logp(JeusMessage_EJB4._3056_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3056, t);
            }
            redeliver = true;
            request.exception = t;
        }
        finally {
            this.postInvoke(request);
            ExecutionContext.pop();
        }
        if (timerLogger.isLoggable(JeusMessage_EJB4._3057_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3057_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3057, (Object)(redeliver ? "" : "not "));
        }
        return redeliver;
    }

    protected void postInvokeTimer(RemoteRequest request) throws Exception {
    }

    protected abstract void initInvokeTimer(RemoteRequest var1, TimerState var2) throws Throwable;

    protected abstract void timeoutMethodInvoke(RemoteRequest var1, Object[] var2) throws Throwable;

    public void createMethodCalled() {
        this.createCount.increase();
    }

    public DurableTimerServiceType getDurableTimerSetting() {
        return this.deployD.getDurableTimerSetting();
    }

    public Map getContextMap() {
        return this.environmentMap;
    }

    public void afterEJBTransaction(boolean committed) {
        if (committed) {
            this.committedCount.increase();
        } else {
            this.rolledbackCount.increase();
        }
    }

    public void txTimeOut(EJBObject ejbObj, Transaction tx, int status) {
        this.timeoutRolledbackCount.increase();
    }

    public BeanPair getBeanPair() {
        return this.deployD;
    }

    public boolean isBeanManagedTx() {
        return this.isBeanManagedTx;
    }

    public Object invoke(InvocationRequest request) throws Exception {
        throw new RuntimeException("not supported");
    }

    public EJBObjectBase getEJBObjectHandler(Object key) {
        throw new RuntimeException("not supported");
    }

    public BusinessObjectHandler getBusinessObjectHandler(Object key) {
        throw new RuntimeException("not supported");
    }

    public EJBLocalObjectBase getEJBLocalObjectHandler(Object key) {
        throw new RuntimeException("not supported");
    }
}

