/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import jeus.ejb.bean.context.EntityContextImpl;
import jeus.ejb.bean.objectbase.EJBEntityObjectImpl;
import jeus.ejb.container.EntityContainer;
import jeus.ejb.container.InstantRecycler;
import jeus.ejb.container.SessionManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB4;

public class EntityCache
extends SessionManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.container.cache");
    private EJBEntityObjectImpl ejbObj;
    private InstantRecycler beanPool;
    private EntityContainer con;

    public EntityCache(int degree, EJBEntityObjectImpl obj, InstantRecycler pool, EntityContainer container) {
        super(degree);
        this.ejbObj = obj;
        this.beanPool = pool;
        this.con = container;
    }

    public void setEJBObject(EJBEntityObjectImpl ejbObj) {
        this.ejbObj = ejbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContextImpl remove(Object identity) {
        if (logger.isLoggable(JeusMessage_EJB4._3152_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3152_LEVEL, "EntityCache", "remove", JeusMessage_EJB4._3152, identity);
        }
        int index = EntityContextImpl.getHashCode(identity) % this.degree;
        Object object = this.syncs[index % 128];
        synchronized (object) {
            SessionManager.Element curr = this.lists[index];
            SessionManager.Element prev = null;
            while (curr != null) {
                if (curr.object.isSame(identity)) {
                    if (prev != null) {
                        prev.next = curr.next;
                    } else {
                        this.lists[index] = curr.next;
                    }
                    EntityCache entityCache = this;
                    synchronized (entityCache) {
                        --this.size;
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3153_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3153_LEVEL, "EntityCache", "remove", JeusMessage_EJB4._3153);
                    }
                    return (EntityContextImpl)curr.object;
                }
                prev = curr;
                curr = curr.next;
            }
        }
        if (logger.isLoggable(JeusMessage_EJB4._3154_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3154_LEVEL, "EntityCache", "remove", JeusMessage_EJB4._3154);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Object identity) {
        int index = EntityContextImpl.getHashCode(identity) % this.degree;
        Object object = this.syncs[index % 100];
        synchronized (object) {
            SessionManager.Element curr = this.lists[index];
            while (curr != null) {
                if (curr.object.isSame(identity)) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rearrangeCache() {
        Object object;
        if (logger.isLoggable(JeusMessage_EJB4._3155_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3155_LEVEL, "EntityCache", "rearrangeCache", JeusMessage_EJB4._3155);
        }
        int startIdx = this.idx;
        int targetNum = this.size - this.degree;
        if (targetNum <= 0) {
            return;
        }
        int removed = 0;
        do {
            object = this.syncs[this.idx % 100];
            synchronized (object) {
                if (this.lists[this.idx] != null) {
                    SessionManager.Element curr = this.lists[this.idx];
                    do {
                        SessionManager.Element prev = curr;
                        curr = curr.next;
                        prev.next = null;
                        this.clearEJBBean((EntityContextImpl)prev.object);
                        ++removed;
                    } while (curr != null);
                    this.lists[this.idx] = null;
                }
            }
            this.idx = (this.idx + 1) % this.degree;
        } while (targetNum > removed && startIdx != this.idx);
        object = this;
        synchronized (object) {
            this.size -= removed;
        }
        if (logger.isLoggable(JeusMessage_EJB4._3156_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3156_LEVEL, "EntityCache", "rearrangeCache", JeusMessage_EJB4._3156);
        }
    }

    private void clearEJBBean(EntityContextImpl ejbCon) {
        block4: {
            try {
                if (logger.isLoggable(JeusMessage_EJB4._3157_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3157_LEVEL, "EntityCache", "clearEJBBean", JeusMessage_EJB4._3157, (Object)ejbCon);
                }
                ejbCon.setEJBObject(this.ejbObj);
                this.ejbObj.setContext(ejbCon);
                this.ejbObj.setPrimaryKey(ejbCon.getIdentity());
                this.con.callEjbPassivate(ejbCon);
                ejbCon.setEJBObject(null);
                this.beanPool.putObject(ejbCon);
                if (logger.isLoggable(JeusMessage_EJB4._3158_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3158_LEVEL, "EntityCache", "clearEJBBean", JeusMessage_EJB4._3158);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB4._3159_LEVEL)) break block4;
                logger.logp(JeusMessage_EJB4._3159_LEVEL, "EntityCache", "clearEJBBean", JeusMessage_EJB4._3159, (Object)ejbCon, t);
            }
        }
    }
}

