/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import jeus.ejb.baseimpl.EJBStatefulSessionObjectBase;
import jeus.ejb.baseimpl.EJBStatelessSessionObjectBase;
import jeus.ejb.baseimpl.RemoteExporter;
import jeus.ejb.bean.objectbase.EJBEntityObjectImpl;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.container.AbstractContainer;
import jeus.rmi.http.HttpClientSocketFactory;
import jeus.rmi.spec.server.RMISocketFactory;
import jeus.rmi.spec.server.UnicastRemoteObject;

public class RMIExporter
implements RemoteExporter {
    private AbstractContainer container;
    private boolean useJeusRmi;

    public RMIExporter(AbstractContainer container) {
        this.container = container;
    }

    public void setUseJeusRmi(boolean useJeusRmi) {
        this.useJeusRmi = useJeusRmi;
    }

    public int getExportPort() {
        return this.container.exportPort;
    }

    public boolean isHttpInvocation() {
        return this.container.isHttpInvocation;
    }

    public boolean useJeusRmi() {
        return this.useJeusRmi;
    }

    public boolean isClustered() {
        return this.container.isClustered;
    }

    public String getHttpContext() {
        return this.container.httpContext;
    }

    public int getHttpPort() {
        return this.container.httpPort;
    }

    public Remote export(Remote obj) throws RemoteException {
        Remote stub;
        int exportPort = this.getExportPort();
        boolean isHttpInvocation = this.isHttpInvocation();
        if (!this.useJeusRmi()) {
            if (isHttpInvocation) {
                HttpClientSocketFactory csf = new HttpClientSocketFactory(this.getHttpContext(), this.getHttpPort());
                stub = java.rmi.server.UnicastRemoteObject.exportObject(obj, exportPort, csf, java.rmi.server.RMISocketFactory.getDefaultSocketFactory());
            } else {
                stub = java.rmi.server.UnicastRemoteObject.exportObject(obj, exportPort);
            }
        } else {
            boolean isClustered = this.isClustered();
            int clusterType = -1;
            if (obj instanceof EJBHome || obj instanceof BusinessHome) {
                clusterType = 0;
            } else if (obj instanceof EJBStatelessSessionObjectBase) {
                clusterType = 1;
            } else if (obj instanceof EJBStatefulSessionObjectBase) {
                clusterType = 2;
            } else if (obj instanceof EJBEntityObjectImpl) {
                clusterType = 3;
            } else assert (false) : "should be never reached";
            if (isHttpInvocation) {
                HttpClientSocketFactory csf = new HttpClientSocketFactory(this.getHttpContext(), this.getHttpPort());
                stub = !isClustered ? UnicastRemoteObject.exportObject(obj, exportPort, csf, RMISocketFactory.getDefaultSocketFactory()) : UnicastRemoteObject.exportObject(obj, exportPort, csf, RMISocketFactory.getDefaultSocketFactory(), clusterType);
            } else {
                stub = !isClustered ? UnicastRemoteObject.exportObject(obj, exportPort) : UnicastRemoteObject.exportObject(obj, exportPort, clusterType);
            }
        }
        return stub;
    }

    public void unexport(Remote obj, boolean force) throws NoSuchObjectException {
        if (this.useJeusRmi) {
            UnicastRemoteObject.unexportObject(obj, force);
        } else {
            java.rmi.server.UnicastRemoteObject.unexportObject(obj, force);
        }
    }
}

