/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import jeus.ejb.EJBLoggers;
import jeus.ejb.baseimpl.RemoteInvocationManager;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.ejbserver.ActiveManager;
import jeus.ejb.util.LeftTime;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class RemoteInvocationManagerImpl
implements RemoteInvocationManager {
    private static final JeusLogger rmiLogger = EJBLoggers.getLogger("jeus.ejb.rmi");
    private static final JeusLogger containerLogger = EJBLoggers.getLogger("jeus.ejb.container");
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition ticketCondition = this.lock.newCondition();
    private final Condition emptyCondition = this.lock.newCondition();
    private final AbstractContainer container;
    private final String ejbId;
    private final int maxTicket;
    private int count;
    private static final long TICKET_MAX_WAIT_TIME = 600000L;

    public RemoteInvocationManagerImpl(AbstractContainer container, int max) {
        this.container = container;
        this.maxTicket = max <= 0 ? 0 : max;
        this.ejbId = container.getEJBId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeInvoke() throws Exception {
        Thread currentThread = Thread.currentThread();
        if (rmiLogger.isLoggable(Level.FINEST)) {
            rmiLogger.log(Level.FINEST, "[{0}][{1}] beforeInvoke", new Object[]{this.ejbId, currentThread});
        }
        this.lock.lockInterruptibly();
        try {
            ActiveManager activeManager;
            if (!this.container.isRunning()) {
                if (rmiLogger.isLoggable(JeusMessage_EJB12._9200_LEVEL)) {
                    rmiLogger.log(JeusMessage_EJB12._9200_LEVEL, JeusMessage_EJB12._9200, new Object[]{this.ejbId, currentThread});
                }
                throw new NoSuchObjectException("EJB object is not ready");
            }
            if (this.maxTicket > 0) {
                while (this.count >= this.maxTicket) {
                    if (rmiLogger.isLoggable(JeusMessage_EJB12._9201_LEVEL)) {
                        rmiLogger.log(JeusMessage_EJB12._9201_LEVEL, JeusMessage_EJB12._9201, new Object[]{this.ejbId, currentThread});
                    }
                    if (this.ticketCondition.await(600000L, TimeUnit.MILLISECONDS)) continue;
                    if (rmiLogger.isLoggable(JeusMessage_EJB12._9202_LEVEL)) {
                        rmiLogger.log(JeusMessage_EJB12._9202_LEVEL, JeusMessage_EJB12._9202, new Object[]{this.ejbId, currentThread});
                    }
                    throw new RemoteException("timeout - could not acquire thread ticket");
                }
            }
            if ((activeManager = ActiveManager.currentActiveManager()) != null) {
                activeManager.getTicket();
            }
            ++this.count;
            if (rmiLogger.isLoggable(Level.FINEST)) {
                rmiLogger.log(Level.FINEST, "[{0}][{1}] beforeInvoke count={2}", new Object[]{this.ejbId, currentThread, this.count});
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvoke() {
        Thread currentThread = Thread.currentThread();
        if (rmiLogger.isLoggable(Level.FINEST)) {
            rmiLogger.log(Level.FINEST, "[{0}][{1}] afterInvoke", new Object[]{this.ejbId, currentThread});
        }
        this.lock.lock();
        try {
            try {
                ActiveManager activeManager = ActiveManager.currentActiveManager();
                if (activeManager != null) {
                    activeManager.returnTicket();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            --this.count;
            assert (this.count >= 0);
            if (rmiLogger.isLoggable(Level.FINEST)) {
                rmiLogger.log(Level.FINEST, "[{0}][{1}] afterInvoke count={2}", new Object[]{this.ejbId, currentThread, this.count});
            }
            this.ticketCondition.signal();
            if (this.count == 0) {
                if (rmiLogger.isLoggable(Level.FINEST)) {
                    rmiLogger.log(Level.FINEST, "[{0}][{1}] afterInvoke notify waiters", new Object[]{this.ejbId, currentThread});
                }
                this.emptyCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmpty(long timeoutMillis) throws InterruptedException {
        LeftTime leftTime = new LeftTime(timeoutMillis);
        if (this.lock.tryLock(leftTime.leftTime(), TimeUnit.MILLISECONDS)) {
            if (containerLogger.isLoggable(Level.FINEST)) {
                containerLogger.log(Level.FINEST, "RemoveInvocationManager#waitUntilEmpty - locked");
            }
            try {
                leftTime.check();
                if (this.count > 0) {
                    if (containerLogger.isLoggable(Level.FINEST)) {
                        containerLogger.log(Level.FINEST, "RemoveInvocationManager#waitUntilEmpty - wait for on-going ones");
                    }
                    if (!this.emptyCondition.await(leftTime.leftTime(), TimeUnit.MILLISECONDS)) {
                        if (containerLogger.isLoggable(Level.FINEST)) {
                            containerLogger.log(Level.FINEST, "RemoveInvocationManager#waitUntilEmpty - condition wait timed out");
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (containerLogger.isLoggable(Level.FINEST)) {
            containerLogger.log(Level.FINEST, "RemoveInvocationManager#waitUntilEmpty - lock timed out");
        }
        return false;
    }

    public int getMaxTicket() {
        return this.maxTicket;
    }

    public int getActiveCount() {
        return this.count;
    }
}

