/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transaction;
import jeus.container.namingenv.InjectionException;
import jeus.ejb.BeanContainer;
import jeus.ejb.BeanState;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBStatus;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBHomeBase;
import jeus.ejb.baseimpl.EJBLocalHomeBase;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.bean.objectbase.TimerImpl;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.ejb.container3.EJBEnvironment;
import jeus.ejb.ejbserver.containerinfo.ContainerInfo;
import jeus.ejb.interceptor.CallbackException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.interceptor.InvocationType;
import jeus.ejb.interceptor.UserInterceptorManager;
import jeus.ejb.metadata.BeanInfo;
import jeus.security.base.Subject;
import jeus.security.resource.PrincipalImpl;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.ReflectionUtils;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB3;
import jeus.util.message.JeusMessage_EJB4;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;

public abstract class BaseBeanContainer
extends AbstractContainer
implements BeanContainer {
    protected static ThreadLocal<Stack<Invocation>> invocationStack = new ThreadLocal();
    protected final ExecutionContext executionContext = new ExecutionContext();
    protected EJBEnvironment beanEnvironment;
    protected TransactionAttributeType ejbTimeoutTxType;
    protected final Map<InvocationType, Interceptor[]> interceptorTable = new HashMap<InvocationType, Interceptor[]>();
    protected UserInterceptorManager userInterceptorManager;

    public static Invocation getCurrentInvocation() {
        Stack<Invocation> stack = invocationStack.get();
        if (stack == null) {
            return null;
        }
        return stack.peek();
    }

    protected static void pushInvocation(Invocation invocation) {
        Stack<Invocation> stack = invocationStack.get();
        if (stack == null) {
            stack = new Stack();
            invocationStack.set(stack);
        }
        stack.push(invocation);
    }

    protected static void popInvocation() {
        Stack<Invocation> stack = invocationStack.get();
        if (stack == null) {
            throw new RuntimeException("there is no invocation to pop");
        }
        stack.pop();
    }

    protected BaseBeanContainer(BeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws EJBDeploymentException {
        super(beanInfo, loader, securityDomain);
        String envRoot = "_" + this.moduleName + "/" + this.beanName;
        this.executionContext.put("jeus.app.name", this.appName);
        this.executionContext.put("jeus.logger", logger);
        this.executionContext.put("jeus.jndi.enc.prefix", envRoot);
        this.executionContext.put("jeus.contextloader", loader);
        this.executionContext.put("jeus.container.execution-module", beanInfo.getModuleInfo().getModule());
        this.beanEnvironment = new EJBEnvironment(this, envRoot);
        this.registerSecurities();
        this.isClustered = beanInfo.isClustered();
        this.beanClass = beanInfo.getBeanClass();
        this.initEJBTimerService();
        this.userInterceptorManager = new UserInterceptorManager(this);
    }

    protected void postConstruct() throws EJBDeploymentException {
        this.beanEnvironment.init();
    }

    public final synchronized void start() throws ContainerException {
        if (!this.status.compareAndSet(EJBStatus.DEPLOYED, EJBStatus.STARTING)) {
            throw new ContainerException("EJBContainer is not deployed state.");
        }
        ExecutionContext.push(this.executionContext);
        try {
            this.beanEnvironment.registerEntries();
            this.preStartService();
            this.startService();
        }
        catch (Throwable ex) {
            this.status.set(EJBStatus.START_FAILED);
            if (logger.isLoggable(JeusMessage_EJB11._8002_LEVEL)) {
                logger.log(JeusMessage_EJB11._8002_LEVEL, JeusMessage_EJB11._8002, (Object)this.beanName);
                logger.log(JeusMessage_EJB11._8003_LEVEL, JeusMessage_EJB11._8003, ex);
            }
            if (ex instanceof ContainerException) {
                throw (ContainerException)((Object)ex);
            }
            throw new ContainerException(ex.getMessage(), ex);
        }
        finally {
            ExecutionContext.pop();
        }
        this.status.set(EJBStatus.RUNNING);
    }

    protected void initEJBTimerService() throws EJBDeploymentException {
        this.ejbTimeoutMethod = this.beanInfo.getTimeoutMethod();
        if (TimedObject.class.isAssignableFrom(this.beanClass)) {
            try {
                Method method = this.beanClass.getMethod("ejbTimeout", Timer.class);
                if (this.ejbTimeoutMethod != null && !method.equals(this.ejbTimeoutMethod)) {
                    throw new EJBDeploymentException("timeout method(given by annotation/descriptor) should be ejbTimeout(Timer)");
                }
                this.ejbTimeoutMethod = method;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.ejbTimeoutMethod == null) {
            return;
        }
        if (!this.ejbTimeoutMethod.isAccessible()) {
            ReflectionUtils.setAccessible(this.ejbTimeoutMethod, true);
        }
        if (this.beanInfo.isContainerManagedTx()) {
            this.ejbTimeoutTxType = this.beanInfo.getTxAttrTable().get(this.ejbTimeoutMethod, null);
            switch (this.ejbTimeoutTxType) {
                case REQUIRES_NEW: 
                case REQUIRED: 
                case SUPPORTS: 
                case NOT_SUPPORTED: 
                case NEVER: {
                    break;
                }
                default: {
                    if (logger.isLoggable(JeusMessage_EJB3._2863_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2863_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2863, (Object)this.ejbTimeoutTxType);
                    }
                    throw new EJBDeploymentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB3._2863, (Object)this.ejbTimeoutTxType));
                }
            }
        }
        if (logger.isLoggable(JeusMessage_EJB3._2864_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2864_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2864, (Object)this.ejbTimeoutTxType);
        }
        if (logger.isLoggable(JeusMessage_EJB3._2866_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2866_LEVEL, "Container", "initEJBBeanInfo", JeusMessage_EJB3._2866);
        }
    }

    public UserInterceptorManager getUserInterceptorManager() {
        return this.userInterceptorManager;
    }

    private void registerSecurities() {
        String principal = this.beanInfo.getJeusDDRunAsName();
        if (principal != null) {
            PrincipalImpl p = new PrincipalImpl(principal);
            this.runAsSubject = new Subject(this.securityDomainName, p);
        }
    }

    public boolean isBeanManagedTx() {
        return this.beanInfo.isBeanManagedTx();
    }

    public EJBHomeBase getEJBHome() {
        return null;
    }

    public EJBLocalHomeBase getEJBLocalHome() {
        return null;
    }

    protected void getContainerInfo(ContainerInfo conInfo) {
        conInfo.setContainerName(this.ejbId);
        conInfo.setIsRunning(this.isRunning());
    }

    protected void undeploy() {
        if (logger.isLoggable(JeusMessage_EJB4._3017_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3017_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3017);
        }
        try {
            this.destoryTimers();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this.beanEnvironment.unregisterEntries();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3027_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3027_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3027);
        }
    }

    public void afterBegin(EJBContextImpl ctx, Transaction tx) {
    }

    public void beforeCompletion(EJBContextImpl ejbContext, Transaction tx, boolean throwException) {
    }

    public void afterCompletion(EJBContextImpl ejbContext, Transaction tx, boolean committed) {
    }

    public void flush(EJBContextImpl ejbContext, Transaction tx) {
    }

    public void txTimeOut(EJBContextImpl ejbContext, Transaction tx, int status) {
        this.timeoutRolledbackCount.increase();
    }

    public void afterEJBTransaction(boolean committed) {
        if (committed) {
            this.committedCount.increase();
        } else {
            this.rolledbackCount.increase();
        }
    }

    public boolean invokeEJBTimeout(TimerState timerState, TimerContainer timerContainer) throws Throwable {
        boolean redeliver;
        if (timerLogger.isLoggable(JeusMessage_EJB4._3053_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3053_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3053);
        }
        Object[] args = new Object[]{new TimerImpl(timerState.getTimerId(), timerContainer)};
        InvocationRequest inv = InvocationRequest.create(InvocationType.TIMEOUT_METHOD, null, this.ejbTimeoutMethod, args);
        inv.setContext("timerState", timerState);
        try {
            Object result = this.invoke(inv);
            assert (result instanceof Boolean);
            redeliver = (Boolean)result;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB4._3056_LEVEL)) {
                timerLogger.logp(JeusMessage_EJB4._3056_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3056, t);
            }
            redeliver = true;
        }
        if (timerLogger.isLoggable(JeusMessage_EJB4._3057_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3057_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3057, (Object)(redeliver ? "" : "not "));
        }
        return redeliver;
    }

    public void createMethodCalled() {
        this.createCount.increase();
    }

    public DurableTimerServiceType getDurableTimerSetting() {
        return this.beanInfo.getDurableTimerSetting();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    protected void invokeCallback(CallbackType type, EJBContextImpl context) throws CallbackException {
        this.userInterceptorManager.invokeCallback(type, context);
    }

    public EJBObjectBase getEJBObjectHandler(Object key) {
        return null;
    }

    public EJBLocalObjectBase getEJBLocalObjectHandler(Object key) {
        return null;
    }

    public BusinessObjectHandler getBusinessObjectHandler(Object key) {
        return null;
    }

    public String toString() {
        return "EJBContainer:ejbId=" + this.ejbId + ",beanName=" + this.beanName + ",beanClass=" + this.beanClass.getName();
    }

    /*
     * Loose catch block
     */
    public Object invoke(InvocationRequest request) throws Exception {
        this.startAccess();
        try {
            this.requestCount.increase();
            Invocation invocation = new Invocation(request);
            Interceptor[] interceptors = this.interceptorTable.get((Object)request.getType());
            invocation.initInterceptors(interceptors);
            BaseBeanContainer.pushInvocation(invocation);
            try {
                Object result;
                Object object = result = invocation.invokeNext();
                return object;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                BaseBeanContainer.popInvocation();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.endAccess();
        }
    }

    protected void pushExecutionContext(EJBContextImpl context) {
        ExecutionContext.push(this.executionContext);
        BaseBeanContainer.pushEJBContext(context);
    }

    protected void popExecutionContext() {
        BaseBeanContainer.popEJBContext();
        ExecutionContext.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newBeanInstance(EJBContextImpl beanContext) throws IllegalAccessException, InstantiationException, InjectionException {
        beanContext.setStatus(BeanState.DEP_INJECTION);
        this.pushExecutionContext(beanContext);
        try {
            Object bean = this.beanClass.newInstance();
            if (logger.isLoggable(JeusMessage_EJB11._8004_LEVEL)) {
                logger.log(JeusMessage_EJB11._8004_LEVEL, JeusMessage_EJB11._8004, bean);
            }
            beanContext.setBean(bean);
            Object[] interceptors = this.userInterceptorManager.createInterceptorInstances();
            beanContext.setInterceptorInstances(interceptors);
            this.beanEnvironment.resolveInjections(beanContext);
        }
        finally {
            this.popExecutionContext();
            beanContext.setStatus(BeanState.NONE);
        }
    }
}

