/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import jeus.ejb.baseimpl.EJBIfObject;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.interceptor.Invocation;
import jeus.webservices.spi.EWSProvider;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;

public class ExceptionMapper {
    public static Exception mapSystemException(Invocation invocation, Exception ex) {
        assert (ex instanceof RemoteException || ex instanceof RuntimeException);
        Object ifObject = invocation.getCaller();
        EWSProvider provider = EWSProvider.getProvider();
        EJBIfObjectType type = provider != null && provider.isServiceEndpoint(ifObject) ? EJBIfObjectType.SERVICE_ENDPOINT : ((EJBIfObject)ifObject)._getIfObjectType();
        switch (type) {
            case EJBOBJECT: 
            case SERVICE_ENDPOINT: {
                ex = ExceptionMapper.mapToRemoteException(ex);
                if (AbstractContainer.isIIOP()) {
                    if (ex instanceof NoSuchObjectException) {
                        return new OBJECT_NOT_EXIST(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (ex instanceof AccessException) {
                        return new NO_PERMISSION(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (ex instanceof MarshalException) {
                        return new MARSHAL(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (ex instanceof TransactionRolledbackException) {
                        return new TRANSACTION_ROLLEDBACK(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (ex instanceof TransactionRequiredException) {
                        return new TRANSACTION_REQUIRED(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (ex instanceof InvalidTransactionException) {
                        return new INVALID_TRANSACTION(9998, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                return ex;
            }
            case EJBLOCALOBJECT: {
                return ExceptionMapper.mapToLocalException(ex);
            }
            case BUSINESSOBJECT: {
                Class interfaze = invocation.getInvokedInterface();
                boolean isRemote = Remote.class.isAssignableFrom(interfaze);
                if (isRemote) {
                    return ExceptionMapper.mapToRemoteException(ex);
                }
                if (ex instanceof TransactionRequiredLocalException) {
                    EJBTransactionRequiredException newex = new EJBTransactionRequiredException();
                    newex.initCause(ex);
                    return newex;
                }
                if (ex instanceof TransactionRolledbackLocalException) {
                    EJBTransactionRolledbackException newex = new EJBTransactionRolledbackException();
                    newex.initCause(ex);
                    return newex;
                }
                if (ex instanceof RemoteException) {
                    return new EJBException(ex);
                }
                return ex;
            }
        }
        return ex;
    }

    public static RemoteException mapToRemoteException(Exception ex) {
        if (ex instanceof RemoteException) {
            return (RemoteException)ex;
        }
        if (ex instanceof NoSuchEJBException) {
            NoSuchObjectException newex = new NoSuchObjectException(ex.getMessage());
            newex.detail = ex;
            return newex;
        }
        if (ex instanceof EJBAccessException) {
            return new AccessException(ex.getMessage(), ex);
        }
        if (ex instanceof TransactionRequiredLocalException) {
            TransactionRequiredException newex = new TransactionRequiredException(ex.getMessage());
            newex.detail = ex;
            return newex;
        }
        if (ex instanceof TransactionRolledbackLocalException) {
            TransactionRolledbackException newex = new TransactionRolledbackException(ex.getMessage());
            newex.detail = ex;
            return newex;
        }
        if (ex instanceof ConcurrentAccessException) {
            return new RemoteException(ex.getMessage());
        }
        return new RemoteException(ex.getMessage(), ex);
    }

    public static EJBException mapToLocalException(Exception ex) {
        if (ex instanceof NoSuchEJBException) {
            return new NoSuchObjectLocalException(ex.getMessage());
        }
        if (ex instanceof EJBAccessException) {
            return new AccessLocalException(ex.getMessage(), ex);
        }
        if (ex instanceof ConcurrentAccessException) {
            return new EJBException(ex.getMessage());
        }
        if (ex instanceof NoSuchObjectException) {
            NoSuchObjectException ex1 = (NoSuchObjectException)ex;
            if (ex1.detail instanceof Exception) {
                return new NoSuchObjectLocalException("", (Exception)ex1.detail);
            }
            return new NoSuchObjectLocalException("", (Exception)ex1);
        }
        if (ex instanceof EJBException) {
            return (EJBException)((Object)ex);
        }
        return new EJBException(ex.getMessage(), ex);
    }
}

