/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import jeus.ejb.baseimpl.MessageDrivenContextImpl;
import jeus.ejb.container.MDServerSessionImpl;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.server.enginecontainer.InvocationManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB6;

public class MDBInterceptor
implements Interceptor {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");
    private MessageDrivenContainer container;

    public MDBInterceptor(MessageDrivenContainer container) {
        this.container = container;
    }

    public String getName() {
        return "MDB Interceptor";
    }

    public Object invoke(Invocation invocation) throws Exception {
        MDServerSessionImpl caller = (MDServerSessionImpl)invocation.getCaller();
        assert (caller != null);
        MessageDrivenContextImpl context = caller.getEjbContext();
        invocation.setEJBContext(context);
        this.container.pushExecutionContext(context);
        try {
            this.preInvoke();
            invocation.invokeNext();
        }
        catch (Throwable ex) {
            this.container.leaveUserLog(ex);
        }
        this.postInvoke();
        this.container.popExecutionContext();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke() {
        if (logger.isLoggable(JeusMessage_EJB6._4018_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4018_LEVEL, "MessageDrivenContainer", "preInvoke", JeusMessage_EJB6._4018);
        }
        InvocationManager.preInvoke(true);
    }

    public void postInvoke() {
        if (logger.isLoggable(JeusMessage_EJB6._4023_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4023_LEVEL, "MessageDrivenContainer", "postInvoke", JeusMessage_EJB6._4023);
        }
        InvocationManager.postInvoke();
    }
}

