/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttributeType;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import jeus.connector.ManagedResourceAdapter;
import jeus.container.namingenv.EnvironmentAnnotationProcessor;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.namingenv.ResourceRef;
import jeus.ejb.BeanState;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBEngine;
import jeus.ejb.EJBStatus;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.MessageDrivenContextImpl;
import jeus.ejb.connector.EJBMessageEndpointFactory;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.InstantRecyclerControlable;
import jeus.ejb.container.MDServerSessionImpl;
import jeus.ejb.container.MDServerSessionPoolImpl;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.container3.EJB3SynchronizationImpl;
import jeus.ejb.container3.MDBInterceptor;
import jeus.ejb.container3.MDBTimerInterceptor;
import jeus.ejb.container3.MDBTxInterceptor;
import jeus.ejb.container3.MessageListenerWrapper;
import jeus.ejb.container3.RedeliverTimerInterceptor;
import jeus.ejb.container3.SecurityInterceptor;
import jeus.ejb.ejbserver.containerinfo.MessageDrivenContainerInfo;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.InvocationType;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.jms.client.facility.factory.JeusConnectionFactory;
import jeus.jms.wrapper.XAQueueConnectionFactoryWrapper;
import jeus.jms.wrapper.XATopicConnectionFactoryWrapper;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.server.enginecontainer.InvocationManager;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.GTID;
import jeus.transaction.TMService;
import jeus.util.ExecutionContext;
import jeus.util.JeusRuntimeException;
import jeus.util.PooledExecutorFactory;
import jeus.util.UserLogger;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB5;
import jeus.util.message.JeusMessage_EJB6;

public class MessageDrivenContainer
extends BaseBeanContainer
implements InstantRecyclerControlable {
    protected MessageDrivenBeanInfo beanInfo;
    protected boolean isMessageDrivenBeanImpl;
    private Connection connection;
    protected MDServerSessionPoolImpl ejbMDBeanPool;
    private boolean isQueue;
    private ConnectionConsumer conConsumer = null;
    private static final int RESOURCE_TYPE_XA_QCF = 5;
    private static final int RESOURCE_TYPE_XA_TCF = 6;
    private HashMap<Method, ListenerMethodInfo> listenerMethodInfo;
    private boolean isJMSMessageListener;
    private boolean isJMSMessageListenerImpl;
    private Method onMessageMethod;
    private TransactionAttributeType txAttr;
    private EJBMessageEndpointFactory factory;
    private ResourceAdapter adapter;
    private ActivationSpec spec;
    public CountStatisticImpl messageCount = new CountStatisticImpl("messages", "MessageCount", "message", "the number of messages received");
    protected final HashSet<Transaction> txList = new HashSet();
    private ThreadPoolExecutor threadPool;
    private boolean isXa;

    public MessageDrivenContainer(MessageDrivenBeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws ContainerException, EJBDeploymentException {
        super(beanInfo, loader, securityDomain);
        this.beanInfo = beanInfo;
        this.initMessageListenerInfo();
        if (MessageDrivenBean.class.isAssignableFrom(this.beanClass)) {
            this.isMessageDrivenBeanImpl = true;
            try {
                Method setContext = this.beanClass.getMethod("setMessageDrivenContext", MessageDrivenContext.class);
                NamingEnvironment beanClassNamingEnv = beanInfo.getBeanNamingEnvironment();
                if (beanClassNamingEnv.getInjectionInfo(setContext) == null) {
                    String name = EnvironmentAnnotationProcessor.getDefaultEntryName(setContext);
                    ResourceRef entry = new ResourceRef(name, MessageDrivenContext.class);
                    InjectionInfo injection = new InjectionInfo(name, setContext);
                    beanClassNamingEnv.addEntry(this.beanClass, entry);
                    beanClassNamingEnv.addInjectionInfo(injection);
                }
                Method ejbRemove = this.beanClass.getMethod("ejbRemove", null);
                beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.PRE_DESTROY, ejbRemove);
            }
            catch (NoSuchMethodException ex) {
                throw new EJBDeploymentException(ex);
            }
        }
        try {
            Method ejbCreate = this.beanClass.getMethod("ejbCreate", null);
            beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.POST_CONSTRUCT, ejbCreate);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    public EJB createMBean(ObjectName parent) throws InstanceAlreadyExistsException {
        EJB mo = (EJB)jeus.management.j2ee.MessageDrivenBean.createMBean(this.beanName, parent, this);
        this.setBeanModel(mo);
        return mo;
    }

    private void initMessageListenerInfo() throws EJBDeploymentException {
        Class messageListenerInterface = this.beanInfo.getListenerInterface();
        if (MessageListener.class.isAssignableFrom(messageListenerInterface)) {
            this.isJMSMessageListener = true;
            if (MessageListener.class.isAssignableFrom(this.beanClass)) {
                this.isJMSMessageListenerImpl = true;
            }
            try {
                this.onMessageMethod = this.beanClass.getMethod("onMessage", Message.class);
                this.txAttr = this.beanInfo.getTxAttrTable().get(this.onMessageMethod, null);
            }
            catch (NoSuchMethodException ex) {
                throw new EJBDeploymentException("MDB class " + this.beanClass + " should have onMessage(Message) method");
            }
        }
        Method[] methods = messageListenerInterface.getMethods();
        this.listenerMethodInfo = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            ListenerMethodInfo info = new ListenerMethodInfo();
            if (this.beanInfo.isContainerManagedTx()) {
                info.setTxAttr(this.beanInfo.getTxAttrTable().get(methods[i], null));
            }
            this.listenerMethodInfo.put(methods[i], info);
        }
        if (logger.isLoggable(JeusMessage_EJB5._3959_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3959_LEVEL, "MessageDrivenContainer", "initMessageListenerInfo", JeusMessage_EJB5._3959);
        }
    }

    public final TransactionAttributeType getTxAttr() {
        return this.txAttr;
    }

    protected void startService() throws ContainerException {
        super.startService();
        this.initInterceptors();
        try {
            if (this.beanInfo.useResourceAdapter()) {
                this.activateEndpoint();
            } else {
                this.initializeConnection();
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB5._3961, this.beanInfo.getBeanName(), ex);
        }
        this.initDurableTimers(this.loader);
    }

    private void activateEndpoint() throws ContainerException {
        try {
            String resourceAdapterName = this.beanInfo.getCorrespondResourceAdapter();
            this.adapter = ResourceAdapterModule.getResourceAdapter(resourceAdapterName);
            String messagingType = this.beanInfo.getListenerInterface().getName();
            Class specClass = ((ManagedResourceAdapter)this.adapter).getActivationSpecClass(messagingType);
            if (specClass == null) {
                throw new ContainerException("Resource adapter " + resourceAdapterName + " does not support message listener " + messagingType);
            }
            this.spec = (ActivationSpec)specClass.newInstance();
            for (String propertyName : this.beanInfo.getActivationConfigPropertyKeys()) {
                this.setActivationSpecProperty(specClass, propertyName, this.beanInfo.getActivationConfigProperty(propertyName));
            }
            this.factory = new EJBMessageEndpointFactory(this, this.beanInfo);
            this.adapter.endpointActivation((MessageEndpointFactory)this.factory, this.spec);
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB5._3967, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB5._3968_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3968_LEVEL, "MessageDrivenContainer", "activateEndpoint", JeusMessage_EJB5._3968);
        }
    }

    private void setActivationSpecProperty(Class specClass, String propertyName, Object value) throws ContainerException {
        try {
            Method setMethod = this.getSetMethod(specClass, propertyName);
            setMethod.invoke((Object)this.spec, value);
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB5._3965, propertyName);
        }
    }

    private Method getSetMethod(Class specClass, String propertyName) throws NoSuchMethodException {
        return specClass.getMethod("set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), String.class);
    }

    private void initializeConnection() throws NamingException, JMSException, ContainerException {
        String initialCtxFactory = this.beanInfo.getInitialContextFactory();
        boolean isJEUSJndiContext = false;
        if (initialCtxFactory.equals("jeus.jndi.JNSContextFactory") || initialCtxFactory.equals("jeus.jndi.JEUSContextFactory")) {
            isJEUSJndiContext = true;
        }
        InitialContext ctx = this.getInitialContext(this.beanInfo);
        String cfJndiName = this.beanInfo.getConnectionFactoryName();
        String jndiName = this.beanInfo.getDestination();
        String destinationType = this.beanInfo.getDestinationType();
        Destination dest = (Destination)ctx.lookup(jndiName);
        this.isQueue = dest instanceof Queue;
        if (this.isQueue) {
            if (logger.isLoggable(JeusMessage_EJB5._3972_LEVEL)) {
                logger.logp(JeusMessage_EJB5._3972_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3972, (Object)jndiName);
            }
            if (cfJndiName == null) {
                cfJndiName = "QueueConnectionFactory";
            }
            QueueConnectionFactory qf = (QueueConnectionFactory)ctx.lookup(cfJndiName);
            Object factory = !isJEUSJndiContext && qf instanceof XAQueueConnectionFactory ? new XAQueueConnectionFactoryWrapper(qf, cfJndiName, false, 5, this.beanInfo.getVendor()) : qf;
            if (this.isTxRequired() && factory instanceof XAQueueConnectionFactory) {
                this.connection = ((XAQueueConnectionFactory)factory).createXAQueueConnection();
                this.isXa = true;
            } else {
                if (this.isTxRequired() && factory instanceof JeusConnectionFactory) {
                    throw new ContainerException("If the transaction attribute of MDB is required, the JEUS JMS connection factory should be a XA connection factory");
                }
                this.connection = factory.createQueueConnection();
            }
            this.createServerSessionPool();
            this.conConsumer = ((QueueConnection)this.connection).createConnectionConsumer((Queue)dest, this.beanInfo.getMessageSelector(), (ServerSessionPool)this.ejbMDBeanPool, this.beanInfo.getMaxMessage());
            if (logger.isLoggable(JeusMessage_EJB5._3976_LEVEL)) {
                logger.logp(JeusMessage_EJB5._3976_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3976);
            }
        } else {
            if (logger.isLoggable(JeusMessage_EJB5._3977_LEVEL)) {
                logger.logp(JeusMessage_EJB5._3977_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3977, (Object)jndiName);
            }
            if (cfJndiName == null) {
                cfJndiName = "TopicConnectionFactory";
            }
            TopicConnectionFactory tf = (TopicConnectionFactory)ctx.lookup(cfJndiName);
            Object factory = !isJEUSJndiContext && tf instanceof XATopicConnectionFactory ? new XATopicConnectionFactoryWrapper(tf, cfJndiName, false, 6, this.beanInfo.getVendor()) : tf;
            if (this.isTxRequired() && factory instanceof XATopicConnectionFactory) {
                this.connection = ((XATopicConnectionFactory)factory).createXATopicConnection();
                this.isXa = true;
            } else {
                if (this.isTxRequired() && factory instanceof JeusConnectionFactory) {
                    throw new ContainerException("If the transaction attribute of MDB is required, the JEUS JMS connection factory should be a XA connection factory");
                }
                this.connection = factory.createTopicConnection();
            }
            if (this.beanInfo.isDurable()) {
                this.connection.setClientID(this.beanInfo.getClientId());
            }
            this.createServerSessionPool();
            if (!this.beanInfo.isDurable()) {
                this.conConsumer = ((TopicConnection)this.connection).createConnectionConsumer((Topic)dest, this.beanInfo.getMessageSelector(), (ServerSessionPool)this.ejbMDBeanPool, this.beanInfo.getMaxMessage());
                if (logger.isLoggable(JeusMessage_EJB5._3981_LEVEL)) {
                    logger.logp(JeusMessage_EJB5._3981_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3981);
                }
            } else {
                this.conConsumer = this.connection.createDurableConnectionConsumer((Topic)dest, this.beanInfo.getSubscriptionName(), this.beanInfo.getMessageSelector(), (ServerSessionPool)this.ejbMDBeanPool, this.beanInfo.getMaxMessage());
                if (logger.isLoggable(JeusMessage_EJB5._3983_LEVEL)) {
                    logger.logp(JeusMessage_EJB5._3983_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3983);
                }
            }
        }
        this.connection.start();
        if (logger.isLoggable(JeusMessage_EJB5._3985_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3985_LEVEL, "MessageDrivenContainer", "initializeConnection", JeusMessage_EJB5._3985);
        }
    }

    private boolean isTxRequired() {
        return this.txAttr == TransactionAttributeType.REQUIRED;
    }

    private InitialContext getInitialContext(MessageDrivenBeanInfo dd) throws NamingException {
        String initialCtxFactory = dd.getInitialContextFactory();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialCtxFactory);
        if (dd.getProviderURL() != null) {
            env.put("java.naming.provider.url", dd.getProviderURL());
        }
        return new InitialContext(env);
    }

    private void createServerSessionPool() throws ContainerException {
        int ejbBeanPoolSize = this.beanInfo.getEJBBeanPoolSize();
        this.ejbMDBeanPool = new MDServerSessionPoolImpl(0, this.beanInfo.getEJBBeanPoolMax(), this.beanInfo.getEJBBeanResizingPeriod(), this);
        this.threadPool = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)("MDB-" + this.ejbId), (int)this.beanInfo.getThreadPoolMax());
        for (int i = 0; i < ejbBeanPoolSize; ++i) {
            this.ejbMDBeanPool.initializeObject(this.createServerSession());
        }
    }

    ServerSession createServerSession() throws ContainerException {
        MessageDrivenContextImpl ejbCon = this.createEJBBean();
        try {
            Object session = this.isXa ? (this.isQueue ? ((XAQueueConnection)this.connection).createXAQueueSession() : ((XATopicConnection)this.connection).createXATopicSession()) : (this.isQueue ? ((QueueConnection)this.connection).createQueueSession(false, this.beanInfo.getAckMode()) : ((TopicConnection)this.connection).createTopicSession(false, this.beanInfo.getAckMode()));
            return new MDServerSessionImpl((Session)session, this.ejbMDBeanPool, ejbCon, this, this.beanInfo.isUseAccessControl());
        }
        catch (JMSException ex) {
            throw new ContainerException(JeusMessage_EJB5._3994, (Throwable)ex);
        }
        catch (NoSuchMethodException e) {
            throw new ContainerException(JeusMessage_EJB5._3995, (Throwable)e);
        }
    }

    public MessageDrivenContextImpl createEJBBean() throws ContainerException {
        MessageDrivenContextImpl context;
        boolean contextPushed = false;
        GTID id = TMService.suspendCurrentTransaction();
        try {
            context = new MessageDrivenContextImpl(this);
            logger.info("Created a bean context instance " + context);
            this.newBeanInstance(context);
            if (this.isJMSMessageListener) {
                MessageListenerWrapper msgListener = new MessageListenerWrapper(this, context);
                context.setMessageListenerInstance(msgListener);
            }
            this.pushExecutionContext(context);
            contextPushed = true;
            this.invokeCallback(CallbackType.POST_CONSTRUCT, context);
            this.createCount.increase();
            context.setStatus(BeanState.READY);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new ContainerException(JeusMessage_EJB6._4004, ex);
        }
        finally {
            if (contextPushed) {
                this.popExecutionContext();
            }
            TMService.resumeCurrentTransaction(id);
        }
        return context;
    }

    protected void stopService() {
        block12: {
            try {
                if (this.beanInfo.useResourceAdapter()) {
                    if (logger.isLoggable(JeusMessage_EJB6._4008_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4008_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4008);
                    }
                    this.adapter.endpointDeactivation((MessageEndpointFactory)this.factory, this.spec);
                    if (logger.isLoggable(JeusMessage_EJB6._4009_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4009_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4009);
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_EJB6._4010_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4010_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4010);
                    }
                    if (this.conConsumer != null) {
                        this.conConsumer.close();
                    }
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    if (logger.isLoggable(JeusMessage_EJB6._4011_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4011_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4011);
                    }
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB6._4012_LEVEL)) break block12;
                logger.logp(JeusMessage_EJB6._4012_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4012, ex);
            }
        }
        try {
            super.stopService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    protected void undeploy() {
        if (logger.isLoggable(JeusMessage_EJB6._4007_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4007_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4007);
        }
        if (this.ejbMDBeanPool != null) {
            this.ejbMDBeanPool.clear();
        }
        try {
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.undeploy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB6._4017_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4017_LEVEL, "MessageDrivenContainer", "undeploy", JeusMessage_EJB6._4017);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preInvokeTx(Transaction currentTx, EJBObjectBase ejbObj) throws RemoteException {
        if (!this.isBeanManagedTx() && currentTx != null && currentTx != TMService.nullTransaction) {
            HashSet<Transaction> hashSet = this.txList;
            synchronized (hashSet) {
                if (!this.txList.contains(currentTx)) {
                    try {
                        EJB3SynchronizationImpl sync = new EJB3SynchronizationImpl(this, null, currentTx);
                        currentTx.registerSynchronization((Synchronization)sync);
                        this.txList.add(currentTx);
                    }
                    catch (Throwable e) {
                        throw new ContainerException(JeusMessage_EJB6._4021, e);
                    }
                    if (logger.isLoggable(JeusMessage_EJB6._4022_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4022_LEVEL, "MessageDrivenContainer", "preInvokeTx", JeusMessage_EJB6._4022);
                    }
                }
            }
        }
    }

    public void leaveUserLog(Throwable ex) {
        if (ex != null && this.engine.isUserLoggingOn()) {
            try {
                UserLogger.notifyEvent(this.engine.getName() + " " + this.ejbId, ex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(long timeStamp) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB6._4027_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4027_LEVEL, "MessageDrivenContainer", "passivator", JeusMessage_EJB6._4027);
        }
        try {
            ExecutionContext.push(this.getExecutionContext());
            if (this.ejbMDBeanPool != null) {
                this.ejbMDBeanPool.tryShrink();
            }
        }
        finally {
            ExecutionContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContainerInfo(MessageDrivenContainerInfo conInfo) {
        super.getContainerInfo(conInfo);
        Object object = this.statSync;
        synchronized (object) {
            conInfo.setRequest(this.numRequest);
        }
        if (!this.beanInfo.useResourceAdapter()) {
            conInfo.setPooledEJBBean(this.ejbMDBeanPool.size());
            conInfo.setActiveEJBBean(this.ejbMDBeanPool.size() - this.ejbMDBeanPool.available());
        } else {
            conInfo.setPooledEJBBean(this.factory.getInstanceSize());
            conInfo.setActiveEJBBean(this.factory.getInstanceSize() - this.factory.getAvailableInstanceSize());
        }
        conInfo.setPooledConnect(conInfo.getPooledEJBBean());
        conInfo.setActiveConnect(conInfo.getActiveEJBBean());
        conInfo.setPooledThread(conInfo.getPooledEJBBean());
        conInfo.setActiveThread(conInfo.getActiveEJBBean());
    }

    public void beforeStatistic() {
        if (this.getStatus() != EJBStatus.RUNNING) {
            return;
        }
        if (logger.isLoggable(JeusMessage_EJB6._4029_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4029_LEVEL, "MessageDrivenContainer", "beforeStatistic", JeusMessage_EJB6._4029);
        }
        try {
            if (!this.beanInfo.useResourceAdapter()) {
                this.totalEJBBeanCount.set((long)this.ejbMDBeanPool.size());
                this.activeEJBBeanCount.set((long)(this.ejbMDBeanPool.size() - this.ejbMDBeanPool.available()));
            } else {
                this.totalEJBBeanCount.set((long)this.factory.getInstanceSize());
                this.activeEJBBeanCount.set((long)(this.factory.getInstanceSize() - this.factory.getAvailableInstanceSize()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction beforeDelivery(XAResource resource, Method method) throws ContainerException {
        Transaction inflowTx;
        if (logger.isLoggable(JeusMessage_EJB6._4038_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4038_LEVEL, "MessageDrivenContainer", "beforeDelivery", JeusMessage_EJB6._4038);
        }
        if (!EJBEngine.isRunning()) {
            throw new ContainerException(JeusMessage_EJB6._4039);
        }
        try {
            inflowTx = txManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
        TransactionAttributeType txAttr = this.getTxAttrForMethod(method);
        try {
            if (logger.isLoggable(JeusMessage_EJB6._4040_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4040_LEVEL, "MessageDrivenContainer", "beforeDelivery", JeusMessage_EJB6._4040, (Object)txAttr.toString());
            }
            switch (txAttr) {
                case NOT_SUPPORTED: {
                    if (inflowTx != null) {
                        if (logger.isLoggable(JeusMessage_EJB6._4041_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4041_LEVEL, "MessageDrivenContainer", "beforeDelivery", JeusMessage_EJB6._4041);
                        }
                        inflowTx = txManager.suspend();
                    }
                    break;
                }
                case REQUIRED: {
                    if (inflowTx == null) {
                        if (logger.isLoggable(JeusMessage_EJB6._4042_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4042_LEVEL, "MessageDrivenContainer", "beforeDelivery", JeusMessage_EJB6._4042);
                        }
                        txManager.begin();
                        if (resource != null) {
                            txManager.getTransaction().enlistResource(resource);
                        }
                    } else if (logger.isLoggable(JeusMessage_EJB6._4043_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4043_LEVEL, "MessageDrivenContainer", "beforeDelivery", JeusMessage_EJB6._4043);
                    }
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB6._4044, txAttr.toString());
                }
            }
        }
        catch (Exception e) {
            this.afterDelivery(resource, method, false, inflowTx, false);
            throw new EJBException(e);
        }
        Object e = this.statSync;
        synchronized (e) {
            ++this.numRequest;
            this.requestCount.increase();
        }
        boolean isPush = false;
        try {
            this.preInvokeTx(inflowTx, null);
            InvocationManager.preInvoke(true);
            ExecutionContext.push(this.executionContext);
            isPush = true;
            return inflowTx;
        }
        catch (Throwable e2) {
            this.afterDelivery(resource, method, false, inflowTx, isPush);
            throw new ContainerException(JeusMessage_EJB6._4045, e2);
        }
    }

    public boolean isTransactedMethod(Method method) {
        ListenerMethodInfo info = this.listenerMethodInfo.get(method);
        if (info == null) {
            return false;
        }
        return info.isTransactedMethod();
    }

    public TransactionAttributeType getTxAttrForMethod(Method method) {
        ListenerMethodInfo info = this.listenerMethodInfo.get(method);
        if (info == null) {
            throw new JeusRuntimeException(JeusMessage_EJB6._4076, (Object)method.getName());
        }
        return info.getTxAttr();
    }

    public Object createPoolElement() throws ContainerException {
        return this.createServerSession();
    }

    public void handleIncomingObjectAtCleared(Object obj) {
        Object id = this.beforeShrink();
        this.beforeRemove(obj);
        this.afterShrink(id);
    }

    public Object beforeShrink() {
        return TMService.suspendCurrentTransaction();
    }

    public void afterShrink(Object shrinkState) {
        TMService.resumeCurrentTransaction((GTID)shrinkState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeRemove(Object obj) {
        MDServerSessionImpl svrSession = (MDServerSessionImpl)obj;
        try {
            MessageDrivenContextImpl context = svrSession.getEjbContext();
            this.pushExecutionContext(context);
            Object bean = context.getBean();
            this.invokeCallback(CallbackType.PRE_DESTROY, context);
            context.setStatus(BeanState.NOT_READY);
            this.removeCount.increase();
            logger.info("Removed the bean instance " + bean);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.popExecutionContext();
        }
    }

    public Exception throwException(Throwable ex) {
        return null;
    }

    public void afterDelivery(XAResource resource, Method method, boolean isSucceeded, Transaction inflowTx) {
        this.afterDelivery(resource, method, isSucceeded, inflowTx, true);
    }

    public void afterDelivery(XAResource resource, Method method, boolean isSucceeded, Transaction inflowTx, boolean isPush) {
        block23: {
            if (logger.isLoggable(JeusMessage_EJB6._4078_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4078_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4078);
            }
            if (isPush) {
                ExecutionContext.pop();
                InvocationManager.postInvoke();
            }
            TransactionAttributeType txAttr = this.getTxAttrForMethod(method);
            try {
                switch (txAttr) {
                    case NOT_SUPPORTED: {
                        if (inflowTx != null) {
                            txManager.resume(inflowTx);
                        }
                        break;
                    }
                    case REQUIRED: {
                        Transaction tx;
                        try {
                            tx = txManager.getTransaction();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                        if (inflowTx == null) {
                            if (!isSucceeded || tx.getStatus() == 1) {
                                if (resource != null) {
                                    tx.delistResource(resource, 0x20000000);
                                }
                                tx.rollback();
                                if (logger.isLoggable(JeusMessage_EJB6._4080_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4080_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4080);
                                }
                            } else {
                                if (resource != null) {
                                    tx.delistResource(resource, 0x4000000);
                                }
                                tx.commit();
                                if (logger.isLoggable(JeusMessage_EJB6._4082_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4082_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4082);
                                }
                            }
                        } else if (!isSucceeded || tx.getStatus() == 1) {
                            if (logger.isLoggable(JeusMessage_EJB6._4083_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4083_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4083);
                            }
                            tx.setRollbackOnly();
                        }
                        break;
                    }
                    default: {
                        if (logger.isLoggable(JeusMessage_EJB6._4084_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4084_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4084, (Object)String.valueOf(txAttr));
                        }
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB6._4085_LEVEL)) break block23;
                logger.logp(JeusMessage_EJB6._4085_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4085, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB6._4086_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4086_LEVEL, "MessageDrivenContainer", "afterDelivery", JeusMessage_EJB6._4086);
        }
    }

    private boolean resumeInflowTx(Transaction inflowTx) {
        if (inflowTx != null && this.txAttr == TransactionAttributeType.NOT_SUPPORTED) {
            try {
                txManager.resume(inflowTx);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void execute(MDServerSessionImpl mdServerSession) throws InterruptedException {
        this.threadPool.execute((Runnable)mdServerSession);
    }

    public void setBeanModel(EJB mo) {
        super.setBeanModel(mo);
        mo.setStatistic((StatisticImpl)this.messageCount);
        mo.setStatistic((StatisticImpl)this.totalEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.activeEJBBeanCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(EJBContextImpl ejbContext, Transaction tx, boolean committed) {
        this.afterEJBTransaction(committed);
        HashSet<Transaction> hashSet = this.txList;
        synchronized (hashSet) {
            this.txList.remove(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void txTimeOut(EJBContextImpl ejbContext, Transaction tx, int status) {
        super.txTimeOut(ejbContext, tx, status);
        HashSet<Transaction> hashSet = this.txList;
        synchronized (hashSet) {
            this.txList.remove(tx);
        }
    }

    public float getActiveThreadRatio() {
        int total = this.threadPool.getPoolSize();
        return (float)this.threadPool.getActiveCount() / (float)total;
    }

    protected void initInterceptors() throws ContainerException {
        ArrayList<Interceptor> itxList = new ArrayList<Interceptor>();
        itxList.add(new MDBInterceptor(this));
        SecurityInterceptor securityItx = new SecurityInterceptor(this);
        itxList.add(securityItx);
        MDBTxInterceptor txItx = new MDBTxInterceptor(this, this.getTxAttr());
        itxList.add(txItx);
        this.interceptorTable.put(InvocationType.ONMESSAGE_METHOD, itxList.toArray(new Interceptor[itxList.size()]));
        if (this.isTimedObject()) {
            ArrayList<Interceptor> timeoutInterceptors = new ArrayList<Interceptor>();
            timeoutInterceptors.add(new MDBTimerInterceptor(this));
            timeoutInterceptors.add(securityItx);
            timeoutInterceptors.add(new MDBTxInterceptor(this, this.ejbTimeoutTxType));
            timeoutInterceptors.add(new RedeliverTimerInterceptor(this));
            this.interceptorTable.put(InvocationType.TIMEOUT_METHOD, timeoutInterceptors.toArray(new Interceptor[timeoutInterceptors.size()]));
        }
        if (logger.isLoggable(JeusMessage_EJB12._9024_LEVEL)) {
            logger.log(JeusMessage_EJB12._9024_LEVEL, JeusMessage_EJB12._9024, (Object)this.beanName);
        }
    }

    protected boolean isJMSMessageListenerImpl() {
        return this.isJMSMessageListenerImpl;
    }

    protected Method getOnMessageMethod() {
        return this.onMessageMethod;
    }

    private class ListenerMethodInfo {
        private TransactionAttributeType txAttr;

        private ListenerMethodInfo() {
        }

        public TransactionAttributeType getTxAttr() {
            return this.txAttr;
        }

        public void setTxAttr(TransactionAttributeType txAttr) {
            this.txAttr = txAttr;
        }

        public boolean isTransactedMethod() {
            return this.txAttr == TransactionAttributeType.REQUIRED;
        }
    }
}

