/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.security.jacc.EJBMethodPermission;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.interceptor.InvocationType;
import jeus.ejb.metadata.BeanInfo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.container.ejb.EJBSecurity;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB6;

public class SecurityInterceptor
implements Interceptor {
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)SecurityInterceptor.class.getName());
    protected BaseBeanContainer container;
    private BeanInfo beanInfo;
    private String beanName;
    private String securityDomain;
    private Subject runAsPrincipal;
    private boolean usePermissionCache = true;
    private final ConcurrentMap<Method, EJBMethodPermissionList> permissionsCache = new ConcurrentHashMap<Method, EJBMethodPermissionList>();

    public SecurityInterceptor(BaseBeanContainer container) {
        this.container = container;
        this.beanInfo = container.getBeanInfo();
        this.beanName = this.beanInfo.getBeanName();
        this.securityDomain = container.getSecurityDomain();
        this.runAsPrincipal = container.getRunAsSubject();
    }

    public String getName() {
        return "SecurityInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation inv) throws Exception {
        boolean isSetEJBSecurityContext = false;
        boolean isSetRunAsIdentity = false;
        try {
            if (inv.getType() == InvocationType.BUSINESS_METHOD) {
                if (logger.isLoggable(JeusMessage_EJB6._4246_LEVEL)) {
                    Principal p = EJBSecurity.getCurrentEJBPrincipal();
                    if (p != null) {
                        logger.logp(JeusMessage_EJB6._4246_LEVEL, "SessionContainer", "preInvoke", JeusMessage_EJB6._4246, (Object)p.getName());
                    } else {
                        logger.logp(JeusMessage_EJB6._4247_LEVEL, "SessionContainer", "preInvoke", JeusMessage_EJB6._4247);
                    }
                }
                try {
                    EJBSecurity.setEJBSecurityContext(this.beanInfo.getSecurityPolicyID(), inv.getInstance(), inv.getParameters(), null);
                    isSetEJBSecurityContext = true;
                }
                catch (Exception ex) {
                    logger.log(JeusMessage_EJB12._9027_LEVEL, JeusMessage_EJB12._9027, (Throwable)ex);
                    throw new EJBException("internal error during setEJBSecurityContext - " + ex.getMessage());
                }
                this.checkPermission(inv);
            }
            try {
                if (this.runAsPrincipal != null) {
                    EJBSecurity.setEJBRunAsIdentity(this.runAsPrincipal);
                    isSetRunAsIdentity = true;
                }
            }
            catch (Exception ex) {
                logger.log(JeusMessage_EJB12._9027_LEVEL, JeusMessage_EJB12._9027, (Throwable)ex);
                throw new EJBAccessException("internal error during setEJBRunAsIdentity - " + ex.getMessage());
            }
            Object object = inv.invokeNext();
            return object;
        }
        finally {
            if (isSetRunAsIdentity) {
                try {
                    EJBSecurity.clearEJBRunAsIdentity();
                }
                catch (Throwable ex) {
                    logger.log(JeusMessage_EJB12._9027_LEVEL, JeusMessage_EJB12._9027, ex);
                }
            }
            if (isSetEJBSecurityContext) {
                try {
                    EJBSecurity.clearEJBSecurityContext();
                }
                catch (Throwable ex) {
                    logger.log(JeusMessage_EJB12._9027_LEVEL, JeusMessage_EJB12._9027, ex);
                }
            }
        }
    }

    private void checkPermission(Invocation inv) {
        EJBMethodPermission methodPermission;
        MethodInterfaceType mit = inv.getMethodInterfaceType();
        String methodIntf = null;
        if (mit != null) {
            methodIntf = mit.name();
        }
        Method beanMethod = inv.getMethod();
        if (this.usePermissionCache) {
            EJBMethodPermissionList permissionList = (EJBMethodPermissionList)this.permissionsCache.get(beanMethod);
            if (permissionList == null) {
                permissionList = new EJBMethodPermissionList();
                this.permissionsCache.putIfAbsent(beanMethod, permissionList);
            }
            if ((methodPermission = permissionList.get(mit)) == null) {
                methodPermission = new EJBMethodPermission(this.beanName, methodIntf, beanMethod);
                permissionList.put(mit, methodPermission);
            }
        } else {
            methodPermission = new EJBMethodPermission(this.beanName, methodIntf, beanMethod);
        }
        try {
            EJBSecurity.checkEJBMethodPermission(methodPermission);
        }
        catch (SecurityException ex) {
            throw new EJBAccessException(ex.getMessage());
        }
        catch (ServiceException ex) {
            logger.log(JeusMessage_EJB12._9027_LEVEL, JeusMessage_EJB12._9027, (Throwable)ex);
            throw new EJBException("internal error during checkEJBMethodPermission", (Exception)ex);
        }
    }

    private static class EJBMethodPermissionList {
        private EJBMethodPermission home;
        private EJBMethodPermission localHome;
        private EJBMethodPermission remote;
        private EJBMethodPermission local;
        private EJBMethodPermission serviceEndpoint;

        private EJBMethodPermissionList() {
        }

        synchronized void put(MethodInterfaceType type, EJBMethodPermission permission) {
            switch (type) {
                case Home: {
                    this.home = permission;
                    break;
                }
                case LocalHome: {
                    this.localHome = permission;
                    break;
                }
                case Remote: {
                    this.remote = permission;
                    break;
                }
                case Local: {
                    this.local = permission;
                    break;
                }
                case ServiceEndpoint: {
                    this.serviceEndpoint = permission;
                }
            }
        }

        EJBMethodPermission get(MethodInterfaceType type) {
            switch (type) {
                case Home: {
                    return this.home;
                }
                case LocalHome: {
                    return this.localHome;
                }
                case Remote: {
                    return this.remote;
                }
                case Local: {
                    return this.local;
                }
                case ServiceEndpoint: {
                    return this.serviceEndpoint;
                }
            }
            return null;
        }
    }
}

