/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import jeus.container.namingenv.EnvironmentAnnotationProcessor;
import jeus.container.namingenv.InjectionException;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.namingenv.ResourceRef;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.baseimpl.BusinessHomeImpl;
import jeus.ejb.baseimpl.BusinessInterfaceInfo;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.client.RemoteBusinessHomeClientHandler;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.ConfigurationException;
import jeus.ejb.container3.SessionEntityContainer;
import jeus.ejb.container3.SessionIfObjectPool;
import jeus.ejb.interceptor.CallbackException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.util.InstancePool;
import jeus.ejb.util.MethodUtils;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB3;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusNetPropertyValues;

public abstract class SessionContainer
extends SessionEntityContainer {
    protected SessionBeanInfo beanInfo;
    protected boolean isSessionBeanImpl;
    protected BusinessHomeImpl remoteBusinessHome;
    protected BusinessHomeImpl localBusinessHome;
    protected Map<Class, BusinessInterfaceInfo> interfaceInfoTable = new HashMap<Class, BusinessInterfaceInfo>();
    protected Map<Class, BusinessInterfaceInfo> proxyInterfaceInfoTable = new HashMap<Class, BusinessInterfaceInfo>();
    private Map<String, Method> beanMethodTable = new HashMap<String, Method>();
    private Map<Method, Method> interface2beanMethodTable = new HashMap<Method, Method>();
    protected InstancePool<SessionContextImpl> beanContextPool;
    protected SessionIfObjectPool ejbSessionObjectPool;
    protected SessionIfObjectPool ejbLocalSessionObjectPool;
    protected SessionIfObjectPool bizObjectPool;
    RangeStatisticImpl methodReadyCount = new RangeStatisticImpl("MethodReadyCount", "bean", "the number of beans in the method-ready state");

    protected SessionContainer(SessionBeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws EJBDeploymentException, ContainerException {
        super(beanInfo, loader, securityDomain);
        this.beanInfo = beanInfo;
        try {
            if (SessionBean.class.isAssignableFrom(this.beanClass)) {
                this.isSessionBeanImpl = true;
                Method setContext = this.beanClass.getMethod("setSessionContext", SessionContext.class);
                NamingEnvironment beanClassNamingEnv = beanInfo.getBeanNamingEnvironment();
                if (beanClassNamingEnv.getInjectionInfo(setContext) == null) {
                    String name = EnvironmentAnnotationProcessor.getDefaultEntryName(setContext);
                    ResourceRef entry = new ResourceRef(name, SessionContext.class);
                    InjectionInfo injection = new InjectionInfo(name, setContext);
                    beanClassNamingEnv.addEntry(this.beanClass, entry);
                    beanClassNamingEnv.addInjectionInfo(injection);
                }
                Method ejbRemove = this.beanClass.getMethod("ejbRemove", null);
                Method ejbActivate = this.beanClass.getMethod("ejbActivate", null);
                Method ejbPassivate = this.beanClass.getMethod("ejbPassivate", null);
                beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.PRE_DESTROY, ejbRemove);
                beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.POST_ACTIVATE, ejbActivate);
                beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.PRE_PASSIVATE, ejbPassivate);
            }
            this.initializeBusinessViewJndiNames();
            this.initializeBusinessInterfaceInfo();
        }
        catch (NoSuchMethodException e) {
            throw new EJBDeploymentException(e);
        }
    }

    private void initializeBusinessInterfaceInfo() throws EJBDeploymentException {
        Class[] localBusinessIntfs = this.beanInfo.getLocalBusinessInterfaces();
        if (this.beanInfo.hasLocalBusinessView()) {
            for (Class intf : localBusinessIntfs) {
                Class<?> proxy = Proxy.getProxyClass(this.loader, intf);
                BusinessInterfaceInfo bizIntfInfo = new BusinessInterfaceInfo(intf, false, proxy);
                this.interfaceInfoTable.put(intf, bizIntfInfo);
                this.proxyInterfaceInfoTable.put(proxy, bizIntfInfo);
                for (Method m : intf.getMethods()) {
                    try {
                        Method beanMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
                        String sig = MethodUtils.getSignature(beanMethod);
                        this.beanMethodTable.put(sig, beanMethod);
                        this.interface2beanMethodTable.put(m, beanMethod);
                    }
                    catch (NoSuchMethodException e) {
                        throw new EJBDeploymentException("EJB class " + this.beanClass.getName() + " don't implement the method " + m);
                    }
                }
            }
        }
        Class[] remoteBusinessIntfs = this.beanInfo.getRemoteBusinessInterfaces();
        if (this.beanInfo.hasRemoteBusinessView()) {
            for (Class intf : remoteBusinessIntfs) {
                Class<?> proxy = Proxy.getProxyClass(this.loader, intf);
                BusinessInterfaceInfo bizIntfInfo = new BusinessInterfaceInfo(intf, true, proxy);
                this.interfaceInfoTable.put(intf, bizIntfInfo);
                this.proxyInterfaceInfoTable.put(proxy, bizIntfInfo);
                for (Method m : intf.getMethods()) {
                    try {
                        Method beanMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
                        String sig = MethodUtils.getSignature(beanMethod);
                        this.beanMethodTable.put(sig, beanMethod);
                        this.interface2beanMethodTable.put(m, beanMethod);
                    }
                    catch (NoSuchMethodException e) {
                        throw new EJBDeploymentException("EJB class " + this.beanClass.getName() + " don't implement the method " + m);
                    }
                }
            }
        }
    }

    public BusinessInterfaceInfo getBusinessInterfaceInfo(Class interfaze) {
        return this.interfaceInfoTable.get(interfaze);
    }

    public BusinessInterfaceInfo getBusinessInterfaceInfoForProxy(Object proxy) {
        return this.proxyInterfaceInfoTable.get(proxy.getClass());
    }

    public Method getBeanMethodWithSignature(String signature) {
        return this.beanMethodTable.get(signature);
    }

    public Method getBeanMethodWithInterfaceMethod(Method businessInterfaceMethod) {
        return this.interface2beanMethodTable.get(businessInterfaceMethod);
    }

    protected void startService() throws ContainerException {
        super.startService();
        this.initInterceptors();
        this.initializePool();
        this.initializeBusinessHome();
        this.registerEJBHome();
    }

    protected void initInterceptors() throws ContainerException {
    }

    private void initializeBusinessViewJndiNames() throws ConfigurationException {
        String jndiName;
        if (this.beanInfo.hasRemoteBusinessView()) {
            jndiName = EJBServerUtils.getRemoteViewJndiName(this.beanInfo);
            if (jndiName == null) {
                throw new ConfigurationException("Could not determine the remote JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
            }
            this.beanInfo.setRemoteBusinessBaseJndiName(jndiName);
        }
        if (this.beanInfo.hasLocalBusinessView()) {
            jndiName = EJBServerUtils.getLocalViewJndiName(this.beanInfo);
            if (jndiName == null) {
                throw new ConfigurationException("Could not determine the local JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
            }
            this.beanInfo.setLocalBusinessBaseJndiName(jndiName);
        }
    }

    protected void initializeBusinessHome() throws ContainerException {
        try {
            String homeJndiName;
            String baseJndiName;
            InitialContext ctx;
            Hashtable<String, String> envs;
            if (this.beanInfo.hasLocalBusinessView()) {
                Class[] localBusiness;
                envs = new Hashtable<String, String>();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.localcontextbindings", "false");
                envs.put("jeus.jndi.replicate.context", "true");
                ctx = new InitialContext(envs);
                baseJndiName = this.beanInfo.getLocalBusinessBaseJndiName();
                homeJndiName = baseJndiName + "#_local_biz_home";
                this.localBusinessHome = new BusinessHomeImpl(this, false, homeJndiName);
                if (logger.isLoggable(JeusMessage_EJB12._9028_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9028_LEVEL, JeusMessage_EJB12._9028, (Object)this.beanInfo.getBeanName());
                }
                ctx.bind(homeJndiName, (Object)this.localBusinessHome);
                if (logger.isLoggable(JeusMessage_EJB12._9029_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9029_LEVEL, JeusMessage_EJB12._9029, (Object)homeJndiName);
                }
                for (Class bizInterface : localBusiness = this.beanInfo.getLocalBusinessInterfaces()) {
                    String interfaceName = bizInterface.getName();
                    String bizJndiName = this.beanInfo.getLocalBusinessJndiName(interfaceName);
                    Reference reference = this.localBusinessHome.getReference(interfaceName);
                    ctx.bind(bizJndiName, (Object)reference);
                    if (!logger.isLoggable(JeusMessage_EJB12._9030_LEVEL)) continue;
                    logger.log(JeusMessage_EJB12._9030_LEVEL, JeusMessage_EJB12._9030, new Object[]{interfaceName, bizJndiName});
                }
                if (this.beanInfo.hasSingleLocalBusinessView()) {
                    ctx.bind(baseJndiName, (Object)this.localBusinessHome.getReference(localBusiness[0].getName()));
                    if (logger.isLoggable(JeusMessage_EJB12._9031_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9031_LEVEL, JeusMessage_EJB12._9031, new Object[]{this.beanInfo.getBeanName(), baseJndiName});
                    }
                }
                ctx.close();
            }
            if (this.beanInfo.hasRemoteBusinessView()) {
                Class[] remoteBusiness;
                envs = new Hashtable();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                if (this.singleVMOnly) {
                    envs.put("jeus.jndi.jns.localbindings", "true");
                    envs.put("jeus.jndi.jns.localcontextbindings", "false");
                    envs.put("jeus.jndi.replicate.context", "true");
                }
                ctx = new InitialDirContext(envs);
                baseJndiName = this.beanInfo.getRemoteBusinessBaseJndiName();
                homeJndiName = baseJndiName + "#_remote_biz_home";
                this.remoteBusinessHome = new BusinessHomeImpl(this, true, homeJndiName);
                RemoteBusinessHomeClientHandler remoteHomeClientHandler = (RemoteBusinessHomeClientHandler)this.remoteBusinessHome.export();
                if (this.isLocalInvocationOptimized) {
                    remoteHomeClientHandler.setLocalStub(this.remoteBusinessHome);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9032_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9032_LEVEL, JeusMessage_EJB12._9032, (Object)this.beanInfo.getBeanName());
                }
                String actualHomeJndiName = this.getActualJndiName(homeJndiName);
                SessionContainer.bindAgedObject((DirContext)((Object)ctx), actualHomeJndiName, remoteHomeClientHandler);
                if (this.isClustered) {
                    ctx.rebind(homeJndiName, (Object)new DynamicLinkRef("EJBLinkRef", actualHomeJndiName));
                }
                if (logger.isLoggable(JeusMessage_EJB12._9033_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9033_LEVEL, JeusMessage_EJB12._9033, (Object)homeJndiName);
                }
                for (Class bizInterface : remoteBusiness = this.beanInfo.getRemoteBusinessInterfaces()) {
                    String interfaceName = bizInterface.getName();
                    String bizJndiName = this.beanInfo.getRemoteBusinessJndiName(interfaceName);
                    Reference reference = this.remoteBusinessHome.getReference(interfaceName);
                    String actualBizJndiName = this.getActualJndiName(bizJndiName);
                    String actualRepresentativeJndiName = this.getActualJndiName(baseJndiName);
                    SessionContainer.bindAgedObject((DirContext)((Object)ctx), actualBizJndiName, reference);
                    if (logger.isLoggable(JeusMessage_EJB12._9030_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9030_LEVEL, JeusMessage_EJB12._9030, new Object[]{interfaceName, bizJndiName});
                    }
                    if (this.beanInfo.hasSingleRemoteBusinessView()) {
                        SessionContainer.bindAgedObject((DirContext)((Object)ctx), actualRepresentativeJndiName, this.remoteBusinessHome.getReference(remoteBusiness[0].getName()));
                    }
                    if (logger.isLoggable(JeusMessage_EJB12._9034_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9034_LEVEL, JeusMessage_EJB12._9034, new Object[]{this.beanInfo.getBeanName(), baseJndiName});
                    }
                    if (!this.isClustered) continue;
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("jeus.jndi.jns.forcedbindings", "true");
                    env.put("jeus.jndi.jns.clusterbindings", "true");
                    ctx = new InitialDirContext(env);
                    ctx.rebind(bizJndiName, (Object)new DynamicLinkRef("EJBLinkRef", actualBizJndiName));
                    if (logger.isLoggable(JeusMessage_EJB3._2997_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2997_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2997, (Object)bizJndiName);
                    }
                    if (!this.beanInfo.hasSingleRemoteBusinessView()) continue;
                    ctx.rebind(baseJndiName, (Object)new DynamicLinkRef("EJBLinkRef", actualRepresentativeJndiName));
                    if (!logger.isLoggable(JeusMessage_EJB3._2997_LEVEL)) continue;
                    logger.logp(JeusMessage_EJB3._2997_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2997, (Object)baseJndiName);
                }
                ctx.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ContainerException("", (Throwable)ex);
        }
    }

    private String getActualJndiName(String jndiName) {
        if (!this.isClustered) {
            return jndiName;
        }
        return "__jeus_cl" + SessionContainer.getHashCode(VirtualDNS.LOCAL_VIRTUALNAME + "_" + JeusPort.JeusBase + "_" + this.engine.getPureEngineName()) + "_" + jndiName + "_$addr$_" + (JeusEJBProperties.USE_IP_FOR_DYNAMIC_REF ? JeusNetPropertyValues.LOCAL_HOSTADDRESS : JeusNetPropertyValues.LOCAL_HOSTNAME) + ":" + JeusPort.JeusBase;
    }

    protected abstract SessionContextImpl getSessionContext(EJBSessionIfObject var1) throws NoSuchEJBException, ConcurrentAccessException;

    protected abstract void putSessionContext(SessionContextImpl var1);

    protected void initializePool() throws ContainerException {
    }

    protected SessionContextImpl newBeanContext() throws IllegalAccessException, InstantiationException, InjectionException {
        SessionContextImpl beanContext = new SessionContextImpl(this, this.beanInfo.isStateless(), this.beanInfo.isStatefulClustered());
        if (logger.isLoggable(JeusMessage_EJB12._9035_LEVEL)) {
            logger.log(JeusMessage_EJB12._9035_LEVEL, JeusMessage_EJB12._9035, (Object)beanContext.toString());
        }
        this.createExtendedEMs(beanContext);
        this.newBeanInstance(beanContext);
        return beanContext;
    }

    protected void createExtendedEMs(SessionContextImpl beanContext) {
    }

    protected void destroyExtendedEMs(SessionContextImpl beanContext) {
    }

    protected void internalRemoveObject(SessionContextImpl context) throws Exception {
    }

    protected void removeBean(SessionContextImpl context) throws EJBException {
        Object bean = context.getBean();
        this.pushExecutionContext(context);
        try {
            this.invokeCallback(CallbackType.PRE_DESTROY, context);
            this.removeCount.increase();
        }
        catch (CallbackException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EJBException) {
                throw (EJBException)cause;
            }
            throw new EJBException((Exception)cause);
        }
        finally {
            this.popExecutionContext();
            this.destroyExtendedEMs(context);
            context.reset();
        }
        if (logger.isLoggable(JeusMessage_EJB12._9036_LEVEL)) {
            logger.log(JeusMessage_EJB12._9036_LEVEL, JeusMessage_EJB12._9036, bean);
        }
    }

    protected void discardObject(SessionContextImpl context) {
        this.discardBean(context);
    }

    protected void discardBean(SessionContextImpl context) {
        Object bean = context.getBean();
        this.destroyExtendedEMs(context);
        context.reset();
        this.methodReadyCount.decrease();
        if (logger.isLoggable(JeusMessage_EJB12._9037_LEVEL)) {
            logger.log(JeusMessage_EJB12._9037_LEVEL, JeusMessage_EJB12._9037, bean);
        }
    }

    protected void stopService() {
        try {
            if (this.remoteBusinessHome != null) {
                this.remoteBusinessHome.unexport();
                if (logger.isLoggable(JeusMessage_EJB12._9039_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9039_LEVEL, JeusMessage_EJB12._9039, (Object)this.ejbId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.stopService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void undeploy() {
        block35: {
            String bizJndiName;
            String interfaceName;
            String homeJndiName;
            InitialContext ctx;
            Hashtable<String, String> envs;
            block34: {
                try {
                    Class[] remoteBusiness;
                    if (this.remoteBusinessHome == null) break block34;
                    envs = new Hashtable<String, String>();
                    envs.put("jeus.jndi.jns.forcedbindings", "true");
                    if (this.singleVMOnly) {
                        envs.put("jeus.jndi.jns.localbindings", "true");
                    }
                    ctx = new InitialContext(envs);
                    homeJndiName = this.remoteBusinessHome.getJndiName();
                    try {
                        ctx.unbind(this.getActualJndiName(homeJndiName));
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                    for (Class bizInterface : remoteBusiness = this.beanInfo.getRemoteBusinessInterfaces()) {
                        interfaceName = bizInterface.getName();
                        bizJndiName = this.beanInfo.getRemoteBusinessJndiName(interfaceName);
                        try {
                            ctx.unbind(this.getActualJndiName(bizJndiName));
                        }
                        catch (NamingException e) {
                            e.printStackTrace();
                        }
                        if (!logger.isLoggable(JeusMessage_EJB12._9038_LEVEL)) continue;
                        logger.log(JeusMessage_EJB12._9038_LEVEL, JeusMessage_EJB12._9038, (Object)interfaceName);
                    }
                    if (this.beanInfo.hasSingleRemoteBusinessView()) {
                        String representiveBizJndiName = this.beanInfo.getRemoteBusinessBaseJndiName();
                        try {
                            ctx.unbind(this.getActualJndiName(representiveBizJndiName));
                        }
                        catch (NamingException e) {
                            e.printStackTrace();
                        }
                        if (logger.isLoggable(JeusMessage_EJB12._9038_LEVEL)) {
                            logger.log(JeusMessage_EJB12._9038_LEVEL, JeusMessage_EJB12._9038, (Object)representiveBizJndiName);
                        }
                    }
                    ctx.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                if (this.localBusinessHome == null) break block35;
                envs = new Hashtable();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                envs.put("jeus.jndi.jns.localbindings", "true");
                ctx = new InitialContext(envs);
                homeJndiName = this.localBusinessHome.getJndiName();
                try {
                    ctx.unbind(homeJndiName);
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
                if (logger.isLoggable(JeusMessage_EJB12._9040_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9040_LEVEL, JeusMessage_EJB12._9040);
                }
                Class[] localBusiness = this.beanInfo.getLocalBusinessInterfaces();
                for (Class bizInterface : localBusiness) {
                    interfaceName = bizInterface.getName();
                    bizJndiName = this.beanInfo.getLocalBusinessJndiName(interfaceName);
                    try {
                        ctx.unbind(bizJndiName);
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                    if (!logger.isLoggable(JeusMessage_EJB12._9038_LEVEL)) continue;
                    logger.log(JeusMessage_EJB12._9038_LEVEL, JeusMessage_EJB12._9038, (Object)interfaceName);
                }
                if (this.beanInfo.hasSingleLocalBusinessView()) {
                    try {
                        ctx.unbind(this.beanInfo.getLocalBusinessBaseJndiName());
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                }
                ctx.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (this.ejbSessionObjectPool != null) {
                this.ejbSessionObjectPool.clear();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            if (this.ejbLocalSessionObjectPool == null) {
                // empty if block
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            if (this.bizObjectPool != null) {
                this.bizObjectPool.clear();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            super.undeploy();
            return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setBeanModel(EJB mo) {
        super.setBeanModel(mo);
        mo.setStatistic((StatisticImpl)this.methodReadyCount);
    }

    public EJBObjectBase getEJBObjectHandler(Object key) {
        assert (key instanceof String);
        if (this.ejbSessionObjectPool != null) {
            return (EJBObjectBase)this.ejbSessionObjectPool.getOrCreate((String)key);
        }
        return null;
    }

    public EJBLocalObjectBase getEJBLocalObjectHandler(Object key) {
        assert (key instanceof String);
        if (this.ejbLocalSessionObjectPool != null) {
            return (EJBLocalObjectBase)this.ejbLocalSessionObjectPool.getOrCreate((String)key);
        }
        return null;
    }

    public BusinessObjectHandler getBusinessObjectHandler(Object key) {
        assert (key instanceof String);
        if (this.bizObjectPool != null) {
            return (BusinessObjectHandler)this.bizObjectPool.getOrCreate((String)key);
        }
        return null;
    }

    public abstract boolean isStateful();
}

