/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import com.sun.corba.ee.spi.extension.ZeroPortPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.directory.InitialDirContext;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.baseimpl.EJBHomeBase;
import jeus.ejb.baseimpl.EJBIfObject;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.baseimpl.EJBLocalHomeBase;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.bean.objectbase.IIOPEJBMetaDataImpl;
import jeus.ejb.bean.objectbase.IIOPHome;
import jeus.ejb.bean.objectbase.IIOPHomeHandleImpl;
import jeus.ejb.bean.objectbase.RMIEJBMetaDataImpl;
import jeus.ejb.bean.objectbase.RMIHomeHandleImpl;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.InterfaceContainer;
import jeus.ejb.container.OTSPolicyImpl;
import jeus.ejb.container.RMIExporter;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.container3.ConfigurationException;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.metadata.BeanInfo;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.objectfactory.CosNamingResource;
import jeus.jndi.objectfactory.CosNamingResourceFactory;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB3;
import jeus.util.message.JeusMessage_EJB4;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.ExportIiopType;
import jeus.xml.binding.jeusDD.SecurityInteropElementType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;

public abstract class SessionEntityContainer
extends BaseBeanContainer {
    protected Class ejbHomeClass;
    protected Class ejbLocalHomeClass;
    protected Class ejbObjectClass;
    protected Class ejbLocalObjectClass;
    protected Class ejbHomeImplClass;
    protected Class ejbLocalHomeImplClass;
    protected Class ejbObjectImplClass;
    protected Class ejbLocalObjectImplClass;
    protected EJBHomeBase ejbHomeImpl;
    protected EJBLocalHomeBase ejbLocalHomeImpl;
    protected RMIHomeHandleImpl homeHandleImpl_rmi;
    protected IIOPHomeHandleImpl homeHandleImpl_iiop;
    protected RMIEJBMetaDataImpl ejbMetaDataImpl_rmi;
    protected IIOPEJBMetaDataImpl ejbMetaDataImpl_iiop;
    protected ClusteringType clusterDesc;

    protected SessionEntityContainer(BeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws EJBDeploymentException, ContainerException {
        super(beanInfo, loader, securityDomain);
        try {
            this.initializeEjbHomeJndiNames();
            if (beanInfo.hasRemoteView()) {
                this.exportPort = beanInfo.getExportPort();
                this.isHttpInvocation = beanInfo.isInvocationWithHttp();
                if (this.isHttpInvocation) {
                    this.httpContext = beanInfo.getHttpURL();
                    this.httpPort = beanInfo.getHttpPort();
                }
                this.exportIIOP = beanInfo.getExportIIOP();
                if (this.exportIIOP) {
                    String poaName = this.moduleName + "_" + this.beanName;
                    ArrayList<OTSPolicyImpl> policyList = new ArrayList<OTSPolicyImpl>();
                    SecurityInteropType ejbcsiDescriptor = beanInfo.getEJBCSIDescriptor();
                    if (ejbcsiDescriptor != null) {
                        InterfaceContainer.setSecurityPolicy(ejbcsiDescriptor, poaName, policyList, this.runAsSubject);
                    }
                    policyList.add(new OTSPolicyImpl());
                    this.initPOA(poaName, policyList.toArray(new Policy[0]));
                }
                this.rmiExporter = new RMIExporter(this);
                this.rmiExporter.setUseJeusRmi(beanInfo.useJeusRmi());
            }
            this.singleVMOnly = beanInfo.isSingleVMOnly();
            this.clusterDesc = beanInfo.getClusterDesc();
        }
        catch (EJBDeploymentException ex) {
            throw ex;
        }
        catch (ContainerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2852, ex);
        }
    }

    public static void checkZeroPortPolicy(SecurityInteropType ejbcsiDescriptor, List policyList) {
        ejbcsiDescriptor.strip();
        if (ejbcsiDescriptor.getIntegrityConfidentiality() == SecurityInteropElementType.REQUIRES) {
            policyList.add(ZeroPortPolicy.getPolicy());
        }
    }

    private void initializeEjbHomeJndiNames() throws ConfigurationException {
        String jndiName;
        if (this.beanInfo.hasRemoteEjbHome()) {
            jndiName = EJBServerUtils.getRemoteViewJndiName(this.beanInfo);
            if (jndiName == null) {
                throw new ConfigurationException("Could not determine the remote JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
            }
            this.beanInfo.setRemoteEjbHomeJndiName(jndiName);
        }
        if (this.beanInfo.hasLocalEjbHome()) {
            jndiName = EJBServerUtils.getLocalViewJndiName(this.beanInfo);
            if (jndiName == null) {
                throw new ConfigurationException("Could not determine the local JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
            }
            this.beanInfo.setLocalEjbHomeJndiName(jndiName);
        }
    }

    private void initPOA(String poaName, Policy[] tpolicy) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB3._2853_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2853_LEVEL, "Container", "initPOA", JeusMessage_EJB3._2853);
        }
        try {
            POA rootPOA = EJBORBManager.getRootPOA();
            this.ejbPOA = rootPOA.create_POA(poaName, null, tpolicy);
            ((POA)this.ejbPOA).the_POAManager().activate();
        }
        catch (Exception ex) {
            throw new ContainerException("Error in initializing ORB", (Throwable)ex);
        }
    }

    protected void startService() throws ContainerException {
        super.startService();
        this.initEJBHomeInfo();
        this.initEJBObjectInfo();
    }

    protected final void initEJBHomeInfo() throws ContainerException {
        String ejbHomeClassName = this.beanInfo.getEJBHomeClassName();
        String ejbHomeImplClassName = this.beanInfo.getEJBHomeImplClassName();
        Class<?> ejbHomeImplIIOPClass = null;
        if (ejbHomeImplClassName != null) {
            try {
                this.ejbHomeImplClass = this.loader.loadClass(ejbHomeImplClassName);
                if (this.exportIIOP) {
                    ejbHomeImplIIOPClass = this.loader.loadClass(this.beanInfo.getIIOPEJBHomeImplClassName());
                    this.ejbObjectImplIIOPClass = this.loader.loadClass(this.beanInfo.getIIOPEJBObjectImplClassName());
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2874, (Throwable)ex);
            }
            if (ejbHomeClassName != null) {
                try {
                    this.ejbHomeClass = this.loader.loadClass(ejbHomeClassName);
                }
                catch (ClassNotFoundException ex) {
                    throw new ContainerException(JeusMessage_EJB3._2877, (Throwable)ex);
                }
                try {
                    this.ejbHomeImpl = (EJBHomeBase)this.ejbHomeImplClass.newInstance();
                    this.ejbHomeImpl._setContainer(this);
                    if (this.beanInfo.getExportIiopType() == null || !this.beanInfo.getExportIiopType().isOnlyIiop().booleanValue()) {
                        this.ejbHomeImpl.export();
                        if (this.isHttpInvocation) {
                            if (logger.isLoggable(JeusMessage_EJB3._2881_LEVEL)) {
                                logger.logp(JeusMessage_EJB3._2881_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2881);
                            }
                        } else if (logger.isLoggable(JeusMessage_EJB3._2883_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2883_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2883);
                        }
                    }
                    if (this.exportIIOP) {
                        Constructor<?> constructor = ejbHomeImplIIOPClass.getConstructor(this.ejbHomeImplClass);
                        IIOPHome ejbHomeImplIIOPImpl = (IIOPHome)constructor.newInstance(this.ejbHomeImpl);
                        ejbHomeImplIIOPImpl.export();
                        this.ejbHomeImpl.setIIOPHomeImpl(ejbHomeImplIIOPImpl);
                        if (logger.isLoggable(JeusMessage_EJB11._7187_LEVEL)) {
                            logger.logp(JeusMessage_EJB11._7187_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB11._7187);
                        }
                    }
                }
                catch (Exception e) {
                    throw new ContainerException(JeusMessage_EJB3._2884, (Throwable)e);
                }
            }
        }
        String localHomeClassName = this.beanInfo.getEJBLocalHomeClassName();
        String localHomeImplClassName = this.beanInfo.getEJBLocalHomeImplClassName();
        if (localHomeImplClassName != null) {
            try {
                this.ejbLocalHomeImplClass = this.loader.loadClass(localHomeImplClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2891, (Throwable)ex);
            }
            try {
                this.ejbLocalHomeClass = this.loader.loadClass(localHomeClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2894, (Throwable)ex);
            }
            try {
                this.ejbLocalHomeImpl = (EJBLocalHomeBase)this.ejbLocalHomeImplClass.newInstance();
                this.ejbLocalHomeImpl._setContainer(this);
            }
            catch (Exception e) {
                throw new ContainerException(JeusMessage_EJB3._2897, (Throwable)e);
            }
        }
    }

    protected final void initEJBObjectInfo() throws ContainerException {
        String ejbLocalObjectImplClassName;
        String ejbObjectImplClassName = this.beanInfo.getEJBObjectImplClassName();
        try {
            if (ejbObjectImplClassName != null) {
                this.ejbObjectImplClass = this.loader.loadClass(ejbObjectImplClassName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ContainerException(JeusMessage_EJB3._2906, (Throwable)ex);
        }
        String ejbObjectClassName = this.beanInfo.getEJBObjectClassName();
        if (ejbObjectClassName != null) {
            try {
                this.ejbObjectClass = this.loader.loadClass(ejbObjectClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2909, (Throwable)ex);
            }
        }
        if ((ejbLocalObjectImplClassName = this.beanInfo.getEJBLocalObjectImplClassName()) != null) {
            try {
                this.ejbLocalObjectImplClass = this.loader.loadClass(ejbLocalObjectImplClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2912, (Throwable)ex);
            }
            String ejbLocalObjectClassName = this.beanInfo.getEJBLocalObjectClassName();
            try {
                this.ejbLocalObjectClass = this.loader.loadClass(ejbLocalObjectClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2915, (Throwable)ex);
            }
        }
    }

    protected final void registerEJBHome() throws ContainerException {
        String clusterExportName = null;
        if (!this.beanInfo.hasRemoteEjbHome() && !this.beanInfo.hasLocalEjbHome()) {
            return;
        }
        try {
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            if (this.singleVMOnly) {
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.localcontextbindings", "false");
                envs.put("jeus.jndi.replicate.context", "true");
            }
            InitialDirContext ctx = new InitialDirContext(envs);
            if (this.beanInfo.hasRemoteEjbHome() && this.ejbHomeImpl != null) {
                ExportIiopType iiopType;
                String context = this.exportName = this.beanInfo.getRemoteEjbHomeJndiName();
                if (this.isClustered) {
                    if (logger.isLoggable(JeusMessage_EJB3._2974_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2974_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2974);
                    }
                    clusterExportName = this.exportName;
                    String engineName = this.engine.getPureEngineName();
                    this.exportName = "__jeus_cl" + SessionEntityContainer.getHashCode(VirtualDNS.LOCAL_VIRTUALNAME + "_" + JeusPort.JeusBase + "_" + engineName) + "_" + clusterExportName + "_$addr$_" + (JeusEJBProperties.USE_IP_FOR_DYNAMIC_REF ? JeusNetPropertyValues.LOCAL_HOSTADDRESS : JeusNetPropertyValues.LOCAL_HOSTNAME) + ":" + JeusPort.JeusBase;
                }
                if (this.exportIIOP) {
                    Context iiopContext = CosNamingResourceFactory.getCNCtx();
                    int index = context.indexOf("/");
                    String fullName = context;
                    while (index > 0) {
                        try {
                            iiopContext = iiopContext.createSubcontext(context.substring(0, index));
                        }
                        catch (NameAlreadyBoundException e) {
                            iiopContext = (Context)iiopContext.lookup(context.substring(0, index));
                        }
                        context = context.substring(index + 1);
                        index = context.indexOf("/");
                    }
                    EJBHome stub = this.ejbHomeImpl.getIIOPStub();
                    iiopContext.rebind(context, (Object)stub);
                    if (this.beanInfo.getExportIiopType().isOnlyIiop().booleanValue()) {
                        ctx.rebind(this.exportName, (Object)new CosNamingResource(CosNamingResourceFactory.urlServer, fullName));
                        if (logger.isLoggable(JeusMessage_EJB3._2982_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2982_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2982);
                        }
                    }
                }
                if ((iiopType = this.beanInfo.getExportIiopType()) == null || !iiopType.isOnlyIiop().booleanValue()) {
                    Object stub = SessionEntityContainer.getStubObject(this.isLocalInvocationOptimized ? this.ejbHomeImpl : this.ejbHomeImpl.getRMIStub(), this.ejbHomeClass);
                    SessionEntityContainer.bindAgedObject(ctx, this.exportName, stub);
                    if (logger.isLoggable(JeusMessage_EJB3._2986_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2986_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2986, (Object)this.exportName);
                    }
                }
                try {
                    if (this.isClustered) {
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        env.put("jeus.jndi.jns.forcedbindings", "true");
                        env.put("jeus.jndi.jns.clusterbindings", "true");
                        ctx = new InitialDirContext(env);
                        ctx.rebind(clusterExportName, (Object)new DynamicLinkRef("EJBLinkRef", this.exportName));
                        if (logger.isLoggable(JeusMessage_EJB3._2997_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2997_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2997, (Object)clusterExportName);
                        }
                    }
                }
                catch (Throwable ex1) {
                    throw new ContainerException(JeusMessage_EJB3._2998, ex1);
                }
            }
            if (this.beanInfo.hasLocalEjbHome() && this.ejbLocalHomeImpl != null) {
                String jndiName = this.beanInfo.getLocalEjbHomeJndiName();
                envs = new Hashtable();
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.localcontextbindings", "false");
                envs.put("jeus.jndi.replicate.context", "true");
                InitialContext ctx1 = new InitialContext(envs);
                ctx1.bind(jndiName, (Object)this.ejbLocalHomeImpl);
                this.localExportName = jndiName;
                if (logger.isLoggable(JeusMessage_EJB3._2989_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2989_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2989, (Object)jndiName);
                }
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2990, "", ex);
        }
        try {
            this.homeHandleImpl_rmi = new RMIHomeHandleImpl(this.ejbHomeImpl, this.exportName);
            if (this.exportIIOP) {
                this.homeHandleImpl_iiop = new IIOPHomeHandleImpl(this.ejbHomeImpl.getIIOPStub(), this.ejbHomeClass.getName(), this.exportName);
            }
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB3._2995, e);
        }
    }

    protected void initializeMetaData(Class pkeyClass, boolean isSessionBean, boolean isStatelessSessionBean) throws RemoteException {
        if (this.ejbHomeImpl != null) {
            this.ejbMetaDataImpl_rmi = new RMIEJBMetaDataImpl(this.ejbHomeImpl, this.ejbHomeClass, this.ejbObjectClass, pkeyClass, this.exportName, EJBServerUtils.getJndiUrl() + ":" + JeusPort.JeusBase, isSessionBean, isStatelessSessionBean);
            if (this.exportIIOP) {
                this.ejbMetaDataImpl_iiop = new IIOPEJBMetaDataImpl(this.ejbHomeImpl, this.exportName, this.ejbHomeClass, this.ejbObjectClass, pkeyClass, isSessionBean, isStatelessSessionBean);
            }
        }
    }

    public synchronized EJBLocalObjectBase getEJBLocalObjectStub() {
        try {
            EJBLocalObjectBase local = (EJBLocalObjectBase)this.ejbLocalObjectImplClass.newInstance();
            return local;
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(JeusMessage_EJB4._3036, t);
        }
    }

    public EJBHomeBase getEJBHome() {
        return this.ejbHomeImpl;
    }

    public EJBLocalHomeBase getEJBLocalHome() {
        if (!this.beanInfo.hasLocalEjbHome() || this.ejbLocalHomeImpl == null) {
            return null;
        }
        return this.ejbLocalHomeImpl;
    }

    public EJBMetaData getEJBMetaData() {
        if (this.exportIIOP && SessionEntityContainer.isIIOP()) {
            return this.ejbMetaDataImpl_iiop;
        }
        return this.ejbMetaDataImpl_rmi;
    }

    public HomeHandle getHomeHandle() {
        if (this.exportIIOP && SessionEntityContainer.isIIOP()) {
            return this.homeHandleImpl_iiop;
        }
        return this.homeHandleImpl_rmi;
    }

    protected void stopService() {
        block5: {
            try {
                if (this.ejbHomeImpl != null) {
                    this.ejbHomeImpl._unexport();
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB11._7181_LEVEL)) break block5;
                logger.log(JeusMessage_EJB11._7181_LEVEL, JeusMessage_EJB11._7181, ex);
            }
        }
        try {
            super.stopService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy() {
        block24: {
            InitialContext ctx;
            Hashtable<String, String> env;
            block23: {
                try {
                    if (this.exportName != null) {
                        if (this.exportIIOP) {
                            InitialContext iiopContext = CosNamingResourceFactory.getCNCtx();
                            iiopContext.unbind(this.exportName);
                            if (logger.isLoggable(JeusMessage_EJB3._2982_LEVEL)) {
                                logger.logp(JeusMessage_EJB3._2982_LEVEL, "Container", "registerEJBHome", JeusMessage_EJB3._2982);
                            }
                        }
                        env = new Hashtable<String, String>();
                        if (this.singleVMOnly) {
                            env.put("jeus.jndi.jns.localbindings", "true");
                        }
                        ctx = new InitialContext(env);
                        ctx.unbind(this.exportName);
                        ctx.close();
                        if (logger.isLoggable(JeusMessage_EJB4._3019_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3019_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3019, (Object)this.exportName);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3020_LEVEL)) break block23;
                    logger.logp(JeusMessage_EJB4._3020_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3020, (Object)this.exportName, ex);
                }
            }
            try {
                if (this.localExportName != null && this.ejbLocalHomeImpl != null) {
                    env = new Hashtable();
                    env.put("jeus.jndi.jns.localbindings", "true");
                    ctx = new InitialContext(env);
                    ctx.unbind(this.localExportName);
                    if (logger.isLoggable(JeusMessage_EJB4._3022_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3022_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3022, (Object)this.localExportName);
                    }
                    ctx.close();
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB4._3023_LEVEL)) break block24;
                logger.logp(JeusMessage_EJB4._3023_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3023, (Object)this.localExportName, ex);
            }
        }
        try {
            if (this.ejbLocalHomeImpl != null) {
                this.ejbLocalHomeImpl._unexport();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this.ejbPOA != null) {
            try {
                String poaName = this.moduleName + "_" + this.beanName;
                EJBORBManager.removeEJBCSIDescriptor(poaName);
                ((POA)this.ejbPOA).destroy(false, false);
                if (logger.isLoggable(JeusMessage_EJB4._3025_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3025_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3025);
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_EJB4._3026_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3026_LEVEL, "Container", "undeploy", JeusMessage_EJB4._3026, ex);
                }
            }
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public abstract EJBIfObject createObject(EJBIfObjectType var1, Method var2, Object[] var3) throws Exception;

    public abstract void removeObject(EJBIfObject var1) throws Exception;

    public abstract void removeObjectWithHandle(Handle var1) throws Exception;
}

