/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.TransactionAssociationManager;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.container3.TransactionInterceptor;
import jeus.ejb.container3.WrappedException;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.metadata.TxAttrTable;
import jeus.transaction.TMException;
import jeus.transaction.TMService;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_EJB6;

public abstract class SessionTxInterceptor
extends TransactionInterceptor {
    protected final TxAttrTable txAttrTable;
    protected final TransactionAssociationManager associatedTransactionManager;
    protected boolean isStateful;

    public SessionTxInterceptor(BaseBeanContainer container) {
        this.container = container;
        this.beanInfo = container.getBeanInfo();
        this.isBeanManagedTx = this.beanInfo.isBeanManagedTx();
        this.txAttrTable = this.beanInfo.getTxAttrTable();
        this.associatedTransactionManager = container.getAssociatedTransactionManager();
        this.isStateful = ((SessionBeanInfo)this.beanInfo).isStateful();
    }

    public Object invoke(Invocation invocation) throws Exception {
        TransactionInterceptor.TxContext txContext = new TransactionInterceptor.TxContext(this);
        SessionContextImpl ejbContext = (SessionContextImpl)invocation.getEJBContext();
        txContext.ejbContext = ejbContext;
        this.preCheckRemoveTx(txContext, invocation);
        Method method = invocation.getMethod();
        if (!this.isBeanManagedTx) {
            txContext.txAttr = this.txAttrTable.get(method, invocation.getMethodInterfaceType());
        }
        this.preTxFilter(txContext);
        this.handleBeforeCallingServices(txContext);
        Object result = null;
        try {
            result = invocation.invokeNext();
        }
        catch (Throwable ex) {
            txContext.exception = ex;
        }
        if (invocation.isRemoveMethod && (txContext.exception == null || !((SessionBeanInfo)this.beanInfo).retainIfException(method))) {
            ejbContext.setToBeRemoved(true);
        }
        this.postHandleTx(txContext);
        boolean rollback = txContext.exception != null ? this.postInvokeTx(txContext) : false;
        this.postTxFilter(txContext, rollback);
        if (txContext.exception != null) {
            if (txContext.exception instanceof Exception) {
                throw (Exception)txContext.exception;
            }
            throw new WrappedException(txContext.exception);
        }
        return result;
    }

    protected void handleBeforeCallingServices(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (!this.isBeanManagedTx && txContext.tx != TMService.nullTransaction) {
            this.associatedTransactionManager.associateTransaction(txContext.tx);
        }
    }

    protected void preTxFilter(TransactionInterceptor.TxContext txContext) throws RemoteException {
        if (logger.isLoggable(JeusMessage_EJB6._4207_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4207_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4207);
        }
        try {
            try {
                txContext.callerTx = this.txManager.getTransaction();
            }
            catch (Throwable ex) {
                throw new ContainerException(JeusMessage_EJB6._4210, ex);
            }
            if (this.isBeanManagedTx) {
                this.preTxFilterBeanManaged(txContext);
            } else {
                if (logger.isLoggable(JeusMessage_EJB6._4211_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4211_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4211);
                }
                if (logger.isLoggable(JeusMessage_EJB6._4212_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4212_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4212, (Object)txContext.txAttr.name());
                }
                switch (txContext.txAttr) {
                    case NOT_SUPPORTED: {
                        if (txContext.callerTx != null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4213_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4213_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4213);
                            }
                            this.txManager.suspend();
                        } else if (logger.isLoggable(JeusMessage_EJB6._4214_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4214_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4214);
                        }
                        this.preTxFilterNotSupported(txContext);
                        break;
                    }
                    case REQUIRED: {
                        if (txContext.callerTx == null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4215_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4215_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4215);
                            }
                            this.txManager.begin();
                            txContext.tx = this.txManager.getTransaction();
                        } else {
                            if (logger.isLoggable(JeusMessage_EJB6._4216_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4216_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4216);
                            }
                            txContext.tx = txContext.callerTx;
                        }
                        this.preTxFilterRequired(txContext);
                        break;
                    }
                    case SUPPORTS: {
                        if (txContext.callerTx != null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4217_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4217_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4217);
                            }
                            txContext.tx = txContext.callerTx;
                        } else if (logger.isLoggable(JeusMessage_EJB6._4218_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4218_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4218);
                        }
                        this.preTxFilterSuports(txContext);
                        break;
                    }
                    case REQUIRES_NEW: {
                        if (txContext.callerTx != null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4219_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4219_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4219);
                            }
                            txContext.callerTx = this.txManager.suspend();
                        }
                        if (logger.isLoggable(JeusMessage_EJB6._4220_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4220_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4220);
                        }
                        this.txManager.begin();
                        txContext.tx = this.txManager.getTransaction();
                        this.preTxFilterRequiresNew(txContext);
                        break;
                    }
                    case MANDATORY: {
                        if (txContext.callerTx == null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4221_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4221_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4221);
                            }
                            throw new TransactionRequiredLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4221));
                        }
                        if (logger.isLoggable(JeusMessage_EJB6._4222_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4222_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4222);
                        }
                        txContext.tx = txContext.callerTx;
                        this.preTxFilterMandatory(txContext);
                        break;
                    }
                    case NEVER: {
                        if (txContext.callerTx != null) {
                            if (logger.isLoggable(JeusMessage_EJB6._4223_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4223_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4223);
                            }
                            throw new ContainerException(JeusMessage_EJB6._4223);
                        }
                        this.preTxFilterNever(txContext);
                        break;
                    }
                }
            }
            if (txContext.tx == null) {
                txContext.tx = TMService.nullTransaction;
            }
        }
        catch (TransactionRequiredLocalException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            if (logger.isLoggable(JeusMessage_EJB6._4225_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4225_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4225, (Throwable)ex);
            }
            throw ex;
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB6._4226, e);
        }
        if (logger.isLoggable(JeusMessage_EJB6._4227_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4227_LEVEL, "SessionContainer", "preTxFilter", JeusMessage_EJB6._4227);
        }
    }

    protected abstract void preCheckRemoveTx(TransactionInterceptor.TxContext var1, Invocation var2) throws RemoveException;

    protected abstract void preTxFilterBeanManaged(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterNever(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterMandatory(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterRequiresNew(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterSuports(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterRequired(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void preTxFilterNotSupported(TransactionInterceptor.TxContext var1) throws ContainerException;

    protected abstract void postHandleTx(TransactionInterceptor.TxContext var1) throws SystemException, TMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean postInvokeTx(TransactionInterceptor.TxContext request) throws RemoteException {
        if (logger.isLoggable(JeusMessage_EJB6._4251_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4251_LEVEL, "SessionContainer", "postInvokeTx", JeusMessage_EJB6._4251);
        }
        try {
            Throwable exception = request.exception;
            if (this.isSystemException(exception)) {
                try {
                    if (this.isBeanManagedTx) {
                        this.processExceptionInNullTx(exception, request);
                        boolean bl = true;
                        return bl;
                    }
                    if (request.tx == null) {
                        if (logger.isLoggable(JeusMessage_EJB6._4253_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4253_LEVEL, "SessionContainer", "postInvokeTx", JeusMessage_EJB6._4253);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (request.tx == TMService.nullTransaction) {
                        if (logger.isLoggable(JeusMessage_EJB6._4254_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4254_LEVEL, "SessionContainer", "postInvokeTx", JeusMessage_EJB6._4254);
                        }
                        this.processExceptionInNullTx(exception, request);
                        boolean bl = false;
                        return bl;
                    }
                    if (request.tx.equals(request.callerTx)) {
                        if (logger.isLoggable(JeusMessage_EJB6._4255_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4255_LEVEL, "SessionContainer", "postInvokeTx", JeusMessage_EJB6._4255);
                        }
                        this.processExceptionInClientTx(exception, request);
                        boolean bl = true;
                        return bl;
                    }
                    if (logger.isLoggable(JeusMessage_EJB6._4256_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4256_LEVEL, "SessionContainer", "postInvokeTx", JeusMessage_EJB6._4256);
                    }
                    this.processExceptionInNullTx(exception, request);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.discardObject(request);
                }
            }
            if (!this.isBeanManagedTx) return this.beanInfo.getModuleInfo().getAppExceptionRollbackRequired(exception);
            if (!this.isStateful) return true;
            if (this.beanInfo.getModuleInfo().getAppExceptionRollbackRequired(exception)) return true;
            return false;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB6._4257, ex);
        }
    }

    private boolean isSystemException(Throwable exception) {
        if (exception instanceof RuntimeException || exception instanceof RemoteException || exception instanceof Error) {
            return !this.beanInfo.getModuleInfo().isAppException(exception);
        }
        return false;
    }

    protected abstract void discardObject(TransactionInterceptor.TxContext var1);

    private void processExceptionInClientTx(Throwable exception, TransactionInterceptor.TxContext request) {
        request.exception = new TransactionRolledbackLocalException("Exception thrown from bean " + exception.toString());
        request.exception.initCause(exception);
    }

    private void processExceptionInNullTx(Throwable exception, TransactionInterceptor.TxContext request) {
        if (exception instanceof EJBException) {
            request.exception = exception;
        } else {
            request.exception = new EJBException("Exception thrown from bean " + exception.toString());
            request.exception.initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postTxFilter(TransactionInterceptor.TxContext txContext, boolean rollbackForException) throws RemoteException {
        block65: {
            if (logger.isLoggable(JeusMessage_EJB6._4261_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4261_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4261);
            }
            try {
                Throwable exception = txContext.exception;
                if (exception != null) {
                    if (this.isBeanManagedTx) {
                        try {
                            Transaction tx;
                            if (logger.isLoggable(JeusMessage_EJB6._4262_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4262_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4262);
                            }
                            if ((tx = this.txManager.getTransaction()) != null) {
                                if (rollbackForException) {
                                    tx.rollback();
                                }
                                if (logger.isLoggable(JeusMessage_EJB6._4264_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4264_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4264);
                                }
                            }
                            break block65;
                        }
                        finally {
                            if (txContext.callerTx != null) {
                                TMService.associateTransactionContext(txContext.callerTx);
                                if (logger.isLoggable(JeusMessage_EJB6._4266_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4266_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4266);
                                }
                            }
                        }
                    }
                    if (logger.isLoggable(JeusMessage_EJB6._4267_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4267_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4267);
                    }
                    if (txContext.tx == null) {
                        if (logger.isLoggable(JeusMessage_EJB6._4268_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4268_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4268);
                        }
                        break block65;
                    }
                    if (txContext.tx == TMService.nullTransaction) {
                        if (logger.isLoggable(JeusMessage_EJB6._4269_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4269_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4269);
                        }
                        if (txContext.callerTx != null) {
                            TMService.associateTransactionContext(txContext.callerTx);
                            if (logger.isLoggable(JeusMessage_EJB6._4271_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4271_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4271);
                            }
                        }
                        break block65;
                    }
                    if (txContext.tx.equals(txContext.callerTx)) {
                        if (logger.isLoggable(JeusMessage_EJB6._4272_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4272_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4272);
                        }
                        if (rollbackForException) {
                            txContext.tx.setRollbackOnly();
                            if (logger.isLoggable(JeusMessage_EJB6._4274_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4274_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4274);
                            }
                        }
                        break block65;
                    }
                    try {
                        if (logger.isLoggable(JeusMessage_EJB6._4275_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4275_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4275);
                        }
                        if (rollbackForException) {
                            txContext.tx.rollback();
                            if (logger.isLoggable(JeusMessage_EJB6._4277_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4277_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4277);
                            }
                        } else if (txContext.tx.getStatus() == 1) {
                            txContext.tx.rollback();
                            if (logger.isLoggable(JeusMessage_EJB6._4279_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4279_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4279);
                            }
                        } else {
                            txContext.tx.commit();
                            if (logger.isLoggable(JeusMessage_EJB6._4281_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4281_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4281);
                            }
                        }
                        break block65;
                    }
                    finally {
                        if (txContext.callerTx != null) {
                            TMService.associateTransactionContext(txContext.callerTx);
                            if (logger.isLoggable(JeusMessage_EJB6._4283_LEVEL)) {
                                logger.logp(JeusMessage_EJB6._4283_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4283);
                            }
                        }
                    }
                }
                if (this.isBeanManagedTx) {
                    if (logger.isLoggable(JeusMessage_EJB6._4284_LEVEL)) {
                        logger.logp(JeusMessage_EJB6._4284_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4284);
                    }
                    if (txContext.callerTx != null) {
                        TMService.associateTransactionContext(txContext.callerTx);
                        if (logger.isLoggable(JeusMessage_EJB6._4286_LEVEL)) {
                            logger.logp(JeusMessage_EJB6._4286_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4286);
                        }
                    }
                    break block65;
                }
                if (logger.isLoggable(JeusMessage_EJB6._4287_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4287_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4287);
                }
                if (logger.isLoggable(JeusMessage_EJB6._4288_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4288_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4288, (Object)txContext.txAttr.name());
                }
                switch (txContext.txAttr) {
                    case NOT_SUPPORTED: {
                        if (txContext.callerTx == null) break;
                        TMService.associateTransactionContext(txContext.callerTx);
                        if (!logger.isLoggable(JeusMessage_EJB6._4290_LEVEL)) break;
                        logger.logp(JeusMessage_EJB6._4290_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4290);
                        break;
                    }
                    case REQUIRED: {
                        if (txContext.callerTx != null) break;
                        if (txContext.tx.getStatus() == 1) {
                            txContext.tx.rollback();
                            if (!logger.isLoggable(JeusMessage_EJB6._4292_LEVEL)) break;
                            logger.logp(JeusMessage_EJB6._4292_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4292);
                            break;
                        }
                        txContext.tx.commit();
                        if (!logger.isLoggable(JeusMessage_EJB6._4294_LEVEL)) break;
                        logger.logp(JeusMessage_EJB6._4294_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4294);
                        break;
                    }
                    case SUPPORTS: {
                        break;
                    }
                    case REQUIRES_NEW: {
                        try {
                            if (txContext.tx.getStatus() == 1) {
                                txContext.tx.rollback();
                                if (logger.isLoggable(JeusMessage_EJB6._4296_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4296_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4296);
                                }
                            } else {
                                txContext.tx.commit();
                                if (logger.isLoggable(JeusMessage_EJB6._4298_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4298_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4298);
                                }
                            }
                            break;
                        }
                        finally {
                            if (txContext.callerTx != null) {
                                TMService.associateTransactionContext(txContext.callerTx);
                                if (logger.isLoggable(JeusMessage_EJB6._4300_LEVEL)) {
                                    logger.logp(JeusMessage_EJB6._4300_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4300);
                                }
                            }
                        }
                    }
                    case MANDATORY: {
                        break;
                    }
                    case NEVER: {
                        break;
                    }
                }
            }
            catch (RollbackException ex) {
                throw new EJBException("transaction is rolled back", (Exception)((Object)ex));
            }
            catch (IllegalStateException ex) {
                throw new EJBException("the target object is not associated with any transaction", (Exception)ex);
            }
            catch (Exception ex) {
                throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4302), ex);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB6._4303_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4303_LEVEL, "SessionContainer", "postTxFilter", JeusMessage_EJB6._4303);
        }
    }
}

