/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import javax.ejb.Handle;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import javax.ejb.SessionSynchronization;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import jeus.container.namingenv.PersistenceContextRef;
import jeus.descriptor.sessionmanager.DistributedSessionManagerDescriptor;
import jeus.ejb.BeanState;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBEngine;
import jeus.ejb.EJBStatus;
import jeus.ejb.ReplicationMode;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBIfObject;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.baseimpl.EJBSessionObjectBase;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.bean.objectbase.IIOPHandleImpl;
import jeus.ejb.bean.objectbase.IIOPObject;
import jeus.ejb.bean.objectbase.RMIHandleImpl;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.ejb.container3.SecurityInterceptor;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.container3.SessionIfObjectPool;
import jeus.ejb.container3.SessionInterceptor;
import jeus.ejb.container3.StatefulTxInterceptor;
import jeus.ejb.interceptor.CallbackException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.InvocationType;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.session.EJBSession;
import jeus.ejb.session.EJBSessionConfig;
import jeus.ejb.session.EJBSessionFactory;
import jeus.ejb.util.InstancePoolHandler;
import jeus.ejb.util.SimpleInstancePool;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.StatefulSessionBean;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.persistence.container.PersistenceUnit;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.sessionmanager.LifeCycle;
import jeus.sessionmanager.SessionActivationListener;
import jeus.sessionmanager.SessionListener;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.SessionManagerFactory;
import jeus.sessionmanager.distributed.DistributedJkRouter;
import jeus.sessionmanager.session.ObjectSession;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SecureSessionIdGenerator;
import jeus.transaction.GTID;
import jeus.transaction.TMService;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB6;
import jeus.util.message.JeusMessage_EJB7;
import jeus.util.properties.JeusEJBProperties;

public class StatefulSessionContainer
extends SessionContainer
implements SessionListener,
SessionActivationListener {
    private static final String DEFAULT_SESSION_MANAGER_SCOPE = "ejb-" + SecureSessionIdGenerator.generateId();
    private SessionManager sessionManager;
    protected ExecutionContext executionContextForSessionManager = new ExecutionContext();
    private boolean isSessionSync = false;
    private boolean poolingBeans = false;
    private long passivationTimeout;
    private int evictionTOInt;

    public StatefulSessionContainer(SessionBeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws EJBDeploymentException, ContainerException {
        super(beanInfo, loader, securityDomain);
        this.executionContextForSessionManager.put("jeus.ejb.container", this);
        try {
            Method[] methods;
            for (Method m : methods = this.beanClass.getMethods()) {
                if (!m.getName().startsWith("ejbCreate")) continue;
                String createName = "create" + m.getName().substring(9);
                beanInfo.addInitMethod(createName, m);
            }
            if (SessionSynchronization.class.isAssignableFrom(this.beanClass)) {
                if (logger.isLoggable(JeusMessage_EJB7._4559_LEVEL)) {
                    logger.log(JeusMessage_EJB7._4559_LEVEL, JeusMessage_EJB7._4559, (Object)"true");
                }
                this.isSessionSync = true;
            } else {
                if (logger.isLoggable(JeusMessage_EJB7._4559_LEVEL)) {
                    logger.log(JeusMessage_EJB7._4559_LEVEL, JeusMessage_EJB7._4559, (Object)"false");
                }
                this.isSessionSync = false;
            }
            this.readPoolingInfo();
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB6._4401, ex);
        }
    }

    public EJB createMBean(ObjectName parent) throws InstanceAlreadyExistsException {
        EJB mo = (EJB)StatefulSessionBean.createMBean(this.beanName, parent, this);
        this.setBeanModel(mo);
        return mo;
    }

    protected void startService() throws ContainerException {
        super.startService();
        try {
            this.initializeMetaData(null, true, false);
            this.initializeSessionManager();
        }
        catch (ContainerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB6._4401, ex);
        }
    }

    protected void initInterceptors() throws ContainerException {
        ArrayList<Interceptor> itxList = new ArrayList<Interceptor>();
        try {
            itxList.add(new SessionInterceptor(this));
            SecurityInterceptor securityItx = new SecurityInterceptor(this);
            itxList.add(securityItx);
            StatefulTxInterceptor txItx = new StatefulTxInterceptor(this);
            itxList.add(txItx);
            if (this.userInterceptorManager != null) {
                itxList.add(this.userInterceptorManager);
            }
        }
        catch (Exception ex) {
            throw new ContainerException(ex.getMessage(), (Throwable)ex);
        }
        this.interceptorTable.put(InvocationType.BUSINESS_METHOD, itxList.toArray(new Interceptor[itxList.size()]));
    }

    protected void initializePool() throws ContainerException {
        super.initializePool();
        if (this.poolingBeans) {
            this.beanContextPool = new SimpleInstancePool();
            int initSize = this.beanInfo.getEJBBeanPoolSize();
            int spareSize = this.beanInfo.getEJBBeanPoolSize();
            int maxSpare = this.beanInfo.getEJBBeanPoolMax();
            int maxSize = Integer.MAX_VALUE;
            this.beanContextPool.initialize(SessionContextImpl.class, initSize, spareSize, maxSpare, maxSize, new BeanInstancePoolHandler());
        }
        if (this.ejbObjectImplClass != null) {
            this.ejbSessionObjectPool = new SessionIfObjectPool(this, true, this.ejbObjectImplClass);
        }
        if (this.ejbLocalObjectImplClass != null) {
            this.ejbLocalSessionObjectPool = new SessionIfObjectPool(this, true, this.ejbLocalObjectImplClass);
        }
        if (this.beanInfo.hasBusinessView()) {
            this.bizObjectPool = new SessionIfObjectPool(this, true, BusinessObjectHandler.class);
        }
    }

    private void initializeSessionManager() throws ContainerException {
        DistributedSessionManagerDescriptor managerConfig = this.engine.getSessionManagerDescriptor();
        if (logger.isLoggable(JeusMessage_EJB6._4404_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4404_LEVEL, "StatefulSessionContainer", "initializeFileDB", JeusMessage_EJB6._4404);
        }
        EJBSessionFactory sessionFac = new EJBSessionFactory();
        DistributedJkRouter router = new DistributedJkRouter();
        EJBSessionConfig sessionConfig = new EJBSessionConfig(router);
        managerConfig.printDescriptor();
        boolean lightVersion = EJBEngine.isLightVersion();
        this.sessionManager = SessionManagerFactory.createSessionManager(DEFAULT_SESSION_MANAGER_SCOPE, sessionFac, sessionConfig, managerConfig, lightVersion ? 4 : 3);
        try {
            ((LifeCycle)((Object)this.sessionManager)).start();
        }
        catch (Throwable t) {
            throw new ContainerException("Internal error during starting session manager", t);
        }
        if (logger.isLoggable(JeusMessage_EJB6._4407_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4407_LEVEL, "StatefulSessionContainer", "initializeFileDB", JeusMessage_EJB6._4407);
        }
    }

    private void readPoolingInfo() {
        long evictionTOInSec;
        long evictionTimeout = 0L;
        if (this.beanInfo.getDisconnectTimeout() != null) {
            evictionTimeout = this.beanInfo.getDisconnectTimeout();
            if (logger.isLoggable(JeusMessage_EJB12._9041_LEVEL)) {
                logger.log(JeusMessage_EJB12._9041_LEVEL, JeusMessage_EJB12._9041, (Object)evictionTimeout);
            }
            if (evictionTimeout <= 0L) {
                evictionTimeout = -1L;
            }
        } else if (JeusEJBProperties.EJB_STATEFUL_DISCONNECT_TIMEOUT != null) {
            evictionTimeout = JeusEJBProperties.EJB_STATEFUL_DISCONNECT_TIMEOUT;
            if (logger.isLoggable(JeusMessage_EJB12._9042_LEVEL)) {
                logger.log(JeusMessage_EJB12._9042_LEVEL, JeusMessage_EJB12._9042, (Object)evictionTimeout);
            }
            if (evictionTimeout <= 0L) {
                evictionTimeout = -1L;
            }
        } else if (JeusEJBProperties.EJB_DISCONNECT_TIMEOUT != null) {
            evictionTimeout = JeusEJBProperties.EJB_DISCONNECT_TIMEOUT;
            if (logger.isLoggable(JeusMessage_EJB12._9043_LEVEL)) {
                logger.log(JeusMessage_EJB12._9043_LEVEL, JeusMessage_EJB12._9043, (Object)evictionTimeout);
            }
            if (evictionTimeout <= 0L) {
                evictionTimeout = -1L;
            }
        } else if (logger.isLoggable(JeusMessage_EJB12._9044_LEVEL)) {
            logger.log(JeusMessage_EJB12._9044_LEVEL, JeusMessage_EJB12._9044);
        }
        this.evictionTOInt = evictionTimeout == -1L ? -1 : (int)((evictionTOInSec = evictionTimeout / 1000L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : evictionTOInSec);
        this.passivationTimeout = 0L;
        if (this.beanInfo.getPassivationTimeout() != null) {
            this.passivationTimeout = this.beanInfo.getPassivationTimeout();
            if (logger.isLoggable(JeusMessage_EJB12._9045_LEVEL)) {
                logger.log(JeusMessage_EJB12._9045_LEVEL, JeusMessage_EJB12._9045, (Object)this.passivationTimeout);
            }
            if (this.passivationTimeout <= 0L) {
                this.passivationTimeout = -1L;
            }
        } else if (JeusEJBProperties.EJB_STATEFUL_PASSIVATE_TIMEOUT != null) {
            this.passivationTimeout = JeusEJBProperties.EJB_STATEFUL_PASSIVATE_TIMEOUT;
            if (logger.isLoggable(JeusMessage_EJB12._9046_LEVEL)) {
                logger.log(JeusMessage_EJB12._9046_LEVEL, JeusMessage_EJB12._9046, (Object)this.passivationTimeout);
            }
            if (this.passivationTimeout <= 0L) {
                this.passivationTimeout = -1L;
            }
        } else if (JeusEJBProperties.EJB_PASSIVATE_TIMEOUT != null) {
            this.passivationTimeout = JeusEJBProperties.EJB_PASSIVATE_TIMEOUT;
            if (logger.isLoggable(JeusMessage_EJB12._9047_LEVEL)) {
                logger.log(JeusMessage_EJB12._9047_LEVEL, JeusMessage_EJB12._9047, (Object)this.passivationTimeout);
            }
            if (this.passivationTimeout <= 0L) {
                this.passivationTimeout = -1L;
            }
        } else if (logger.isLoggable(JeusMessage_EJB12._9048_LEVEL)) {
            logger.log(JeusMessage_EJB12._9048_LEVEL, JeusMessage_EJB12._9048);
        }
        this.poolingBeans = this.beanInfo.isPoolingBeans();
    }

    /*
     * Loose catch block
     */
    public EJBIfObject createObject(EJBIfObjectType type, Method createMethod, Object[] args) throws Exception {
        this.startAccess();
        try {
            GTID id = TMService.suspendCurrentTransaction();
            try {
                Object ejbObject;
                EJBSession objSession = this.createBean();
                String sessionID = objSession.getId();
                SessionContextImpl context = (SessionContextImpl)objSession.getObject();
                switch (type) {
                    case EJBOBJECT: {
                        ejbObject = this.ejbSessionObjectPool.create(sessionID);
                        if (!this.exportIIOP) break;
                        Constructor constructor = this.ejbObjectImplIIOPClass.getConstructor(this.ejbObjectImplClass);
                        IIOPObject ejbObjectImplIIOPImpl = (IIOPObject)constructor.newInstance(ejbObject);
                        ((EJBObjectBase)ejbObject).setIIOPObjectImpl(ejbObjectImplIIOPImpl);
                        break;
                    }
                    case EJBLOCALOBJECT: {
                        ejbObject = this.ejbLocalSessionObjectPool.create(sessionID);
                        break;
                    }
                    case BUSINESSOBJECT: {
                        ejbObject = this.bizObjectPool.create(sessionID);
                        break;
                    }
                    default: {
                        throw new Exception("Not implemented for " + type.name());
                    }
                }
                context.setEJBSessionIfObject((EJBSessionIfObject)ejbObject);
                if (type == EJBIfObjectType.EJBOBJECT || type == EJBIfObjectType.EJBLOCALOBJECT) {
                    Method initMethod = this.beanInfo.getInitMethod(createMethod.getName(), createMethod.getParameterTypes());
                    if (initMethod == null) {
                        throw new EJBException("there is no init/ejbCreate method for the " + createMethod);
                    }
                    context.setStatus(BeanState.POST_CONSTRUCT);
                    this.pushExecutionContext(context);
                    try {
                        initMethod.invoke(context.getBean(), args);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        throw t instanceof Error ? new Exception(t) : (Exception)t;
                    }
                    finally {
                        this.popExecutionContext();
                        context.setStatus(BeanState.NONE);
                    }
                    if (logger.isLoggable(JeusMessage_EJB12._9049_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9049_LEVEL, JeusMessage_EJB12._9049, (Object)initMethod);
                    }
                }
                context.setStatus(BeanState.READY);
                Object t = ejbObject;
                return t;
            }
            catch (Exception ex) {
                logger.log(JeusMessage_EJB12._9050_LEVEL, JeusMessage_EJB12._9050, (Throwable)ex);
                throw ex;
            }
            finally {
                TMService.resumeCurrentTransaction(id);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.endAccess();
        }
    }

    public void removeObject(EJBIfObject object) throws Exception {
        if (logger.isLoggable(JeusMessage_EJB6._4456_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4456_LEVEL, "StatefulSessionContainer", "removeWithInstanceKey", JeusMessage_EJB6._4456);
        }
        this.startAccess();
        try {
            EJBSessionIfObject ejbObject = (EJBSessionIfObject)object;
            SessionContextImpl context = this.getSessionContext(ejbObject);
            if (context.getTx() != null) {
                throw new RemoveException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4501));
            }
            this.internalRemoveObject(context);
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_EJB6._4466_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4466_LEVEL, "StatefulSessionContainer", "removeEJBBean", JeusMessage_EJB6._4466, (Throwable)ex);
            }
            throw ex;
        }
        finally {
            this.endAccess();
        }
        if (logger.isLoggable(JeusMessage_EJB6._4457_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4457_LEVEL, "StatefulSessionContainer", "removeWithInstanceKey", JeusMessage_EJB6._4457);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemoveObject(SessionContextImpl context) throws Exception {
        BusinessObjectHandler bizObject;
        EJBLocalObjectBase ejbLocalObject;
        String sessionID;
        block16: {
            sessionID = context.getSessionID();
            EJBObjectBase ejbObject = context.getEJBObjectHandler();
            ejbLocalObject = context.getEJBLocalObjectHandler();
            bizObject = context.getBusinessObjectHandler();
            try {
                if (context.getTx() != null) {
                    context.setToBeRemoved(true);
                } else {
                    ExecutionContext.push(this.executionContextForSessionManager);
                    ObjectSession ejbSession = null;
                    try {
                        ejbSession = (ObjectSession)this.sessionManager.getSession(sessionID);
                    }
                    finally {
                        if (ejbSession != null) {
                            ejbSession.endAccess();
                            this.sessionManager.destroy(ejbSession);
                        }
                        ExecutionContext.pop();
                    }
                }
                Object var9_8 = null;
                if (this.ejbSessionObjectPool == null) break block16;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (this.ejbSessionObjectPool != null) {
                    this.ejbSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbObject));
                }
                if (this.ejbLocalSessionObjectPool != null) {
                    this.ejbLocalSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbLocalObject));
                }
                if (this.bizObjectPool != null) {
                    this.bizObjectPool.remove(bizObject);
                }
                if (logger.isLoggable(JeusMessage_EJB6._4468_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4468_LEVEL, "StatefulSessionContainer", "removeEJBBean", JeusMessage_EJB6._4468, (Object)sessionID);
                }
                throw throwable;
            }
            this.ejbSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbObject));
        }
        if (this.ejbLocalSessionObjectPool != null) {
            this.ejbLocalSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbLocalObject));
        }
        if (this.bizObjectPool != null) {
            this.bizObjectPool.remove(bizObject);
        }
        if (logger.isLoggable(JeusMessage_EJB6._4468_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4468_LEVEL, "StatefulSessionContainer", "removeEJBBean", JeusMessage_EJB6._4468, (Object)sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardObject(SessionContextImpl context) {
        String sessionID = context.getSessionID();
        EJBObjectBase ejbObject = context.getEJBObjectHandler();
        EJBLocalObjectBase ejbLocalObject = context.getEJBLocalObjectHandler();
        BusinessObjectHandler bizObject = context.getBusinessObjectHandler();
        try {
            ExecutionContext.push(this.executionContextForSessionManager);
            try {
                EJBSession ejbSession = (EJBSession)this.sessionManager.getSession(sessionID);
                if (ejbSession != null) {
                    ejbSession.setExceptionalRemove(true);
                    this.sessionManager.destroy(ejbSession);
                }
            }
            finally {
                ExecutionContext.pop();
            }
        }
        finally {
            if (this.ejbSessionObjectPool != null) {
                this.ejbSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbObject));
            }
            if (this.ejbLocalSessionObjectPool != null) {
                this.ejbLocalSessionObjectPool.remove((EJBSessionIfObject)((Object)ejbLocalObject));
            }
            if (this.bizObjectPool != null) {
                this.bizObjectPool.remove(bizObject);
            }
        }
        logger.info("Discarded the interface objects associated the stateful bean " + sessionID);
    }

    protected void undeploy() {
        if (logger.isLoggable(JeusMessage_EJB6._4421_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4421_LEVEL, "StatefulSessionContainer", "undeploy", JeusMessage_EJB6._4421);
        }
        if (logger.isLoggable(JeusMessage_EJB6._4422_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4422_LEVEL, "StatefulSessionContainer", "undeploy", JeusMessage_EJB6._4422);
        }
        try {
            if (this.beanContextPool != null) {
                this.beanContextPool.clear(true);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB6._4425_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4425_LEVEL, "StatefulSessionContainer", "undeploy", JeusMessage_EJB6._4425, (Object)this.ejbId);
        }
        try {
            SessionManagerFactory.destroySessionManager(DEFAULT_SESSION_MANAGER_SCOPE);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB6._4426_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4426_LEVEL, "StatefulSessionContainer", "undeploy", JeusMessage_EJB6._4426);
        }
    }

    public boolean isStateful() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBSession createBean() throws ContainerException {
        SessionContextImpl context = null;
        EJBSession ejbSession = null;
        try {
            if (this.poolingBeans) {
                context = (SessionContextImpl)this.beanContextPool.fetch();
                if (context == null) {
                    throw new EJBException("Could not fetch bean instance - pool is full or destroyed");
                }
            } else {
                context = this.newBeanContext();
            }
            ExecutionContext.push(this.executionContextForSessionManager);
            try {
                ejbSession = (EJBSession)this.sessionManager.createSession(context);
                ejbSession.setMaxInactiveInterval(this.evictionTOInt);
                ejbSession.setPassivateTO(this.passivationTimeout);
                ejbSession.setNeedUpdate(true);
                try {
                    this.callUpdateSession(this.beanInfo.getReplicationModeOfBean(), ejbSession);
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_EJB12._9051_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9051_LEVEL, JeusMessage_EJB12._9051, (Object)this.getBeanName());
                    }
                }
            }
            finally {
                ExecutionContext.pop();
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB6._4241, ex);
        }
        return ejbSession;
    }

    private void callUpdateSession(ReplicationMode modeValue, ObjectSession objSession) throws Exception {
        if (modeValue != ReplicationMode.NONE && this.beanInfo.isClustered()) {
            boolean sync = false;
            if (modeValue == ReplicationMode.SYNC || modeValue == null) {
                sync = true;
            } else if (modeValue == ReplicationMode.ASYNC) {
                sync = false;
            }
            this.sessionManager.updateSession(objSession, sync);
        }
    }

    protected void createExtendedEMs(SessionContextImpl sc) {
        Collection<PersistenceContextRef> refs = this.beanEnvironment.getNamingEnvManager().getNamingEnvironment().getPersistenceContextReferences();
        for (PersistenceContextRef ref : refs) {
            SessionContextImpl invokingSC;
            if (ref.getType() != PersistenceContextType.EXTENDED) continue;
            PersistenceUnit pu = ref.getPersistenceUnit();
            EntityManager pc = null;
            AtomicInteger refCount = null;
            EJBContextImpl invokingContext = StatefulSessionContainer.getCurrentEJBContext();
            if (invokingContext != null && invokingContext instanceof SessionContextImpl && (invokingSC = (SessionContextImpl)invokingContext).isStateful()) {
                pc = invokingSC.getExtendedPersistenceContext(pu);
                refCount = invokingSC.getExtendedPersistenceContextRefCount(pc);
            }
            if (pc == null) {
                pc = pu.createEntityManager(ref.getProperties());
                refCount = new AtomicInteger();
            }
            sc.addExtendedPersistenceContext(pu, pc);
            refCount.incrementAndGet();
            sc.addExtendedPersistenceContextRefCount(pc, refCount);
        }
    }

    public void associatesExtendedEMsWithTx(SessionContextImpl beanContext) throws EJBException {
        Transaction tx;
        try {
            tx = txManager.getTransaction();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(ex);
        }
        if (tx == null) {
            return;
        }
        if (!beanContext.hasExtendedPC()) {
            return;
        }
        Map<PersistenceUnit, EntityManager> map = beanContext.getExtendedPersistenceContextMap();
        for (PersistenceUnit pu : map.keySet()) {
            EntityManager pc = pu.getTxAssociatedPersistenceContext();
            EntityManager eem = map.get(pu);
            if (pc == null) {
                pu.associatePersistenceContextWithTx(eem, PersistenceContextType.EXTENDED);
                continue;
            }
            if (pc == eem) continue;
            throw new EJBException("There is different persistence context bound to the transaction");
        }
    }

    protected void destroyExtendedEMs(SessionContextImpl beanContext) {
        Collection<EntityManager> pcs = beanContext.getExtendedPersistenceContexts();
        if (pcs != null) {
            for (EntityManager pc : pcs) {
                AtomicInteger refCount = beanContext.getExtendedPersistenceContextRefCount(pc);
                int count = refCount.decrementAndGet();
                if (count != 0) continue;
                try {
                    if (logger.isLoggable(JeusMessage_EJB12._9052_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9052_LEVEL, JeusMessage_EJB12._9052, (Object)pc);
                    }
                    pc.close();
                }
                catch (Throwable ex) {
                    logger.log(JeusMessage_EJB12._9053_LEVEL, JeusMessage_EJB12._9053, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized SessionContextImpl getSessionContext(EJBSessionIfObject ifobject) throws NoSuchEJBException, ConcurrentAccessException {
        String sessionID = ifobject._getSessionID();
        ObjectSession objSession = null;
        ExecutionContext.push(this.executionContextForSessionManager);
        try {
            objSession = (ObjectSession)this.sessionManager.getSession(sessionID);
        }
        finally {
            ExecutionContext.pop();
        }
        if (objSession == null || !objSession.validate()) {
            throw new NoSuchEJBException("No such EJB, it may be removed due to timeout.");
        }
        SessionContextImpl context = (SessionContextImpl)objSession.getObject();
        objSession.access();
        if (objSession.getConcurrentAccessCount() > 1) {
            objSession.endAccess();
            throw new ConcurrentAccessException("concurrent access of same stateful session bean method is not allowed");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void executeSessionReplication(String sessionId, Method thisMethod) {
        block7: {
            ExecutionContext.push(this.executionContextForSessionManager);
            ObjectSession objSession = null;
            try {
                objSession = (ObjectSession)this.sessionManager.getSession(sessionId);
                Object var5_4 = null;
                if (objSession == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_5 = null;
                    if (objSession != null) {
                        objSession.endAccess();
                        objSession.setNeedUpdate(true);
                        try {
                            ReplicationMode modeValue = (ReplicationMode)this.beanInfo.getReplicationModeOfMethods().getValue(thisMethod);
                            this.callUpdateSession(modeValue, objSession);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(JeusMessage_EJB12._9054_LEVEL)) break block8;
                            logger.log(JeusMessage_EJB12._9054_LEVEL, JeusMessage_EJB12._9054, new Object[]{thisMethod.getName(), this.getBeanName()});
                        }
                    }
                }
                ExecutionContext.pop();
                throw throwable;
            }
            objSession.endAccess();
            objSession.setNeedUpdate(true);
            try {
                ReplicationMode modeValue = (ReplicationMode)this.beanInfo.getReplicationModeOfMethods().getValue(thisMethod);
                this.callUpdateSession(modeValue, objSession);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_EJB12._9054_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9054_LEVEL, JeusMessage_EJB12._9054, new Object[]{thisMethod.getName(), this.getBeanName()});
                }
            }
        }
        ExecutionContext.pop();
    }

    protected synchronized void putSessionContext(SessionContextImpl context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBSessionIfObject findByInstanceKey(EJBIfObjectType type, String sessionID) {
        try {
            Object ejbObject;
            SessionContextImpl context;
            String newSessionID;
            block18: {
                ObjectSession objSession = null;
                ExecutionContext.push(this.executionContextForSessionManager);
                try {
                    objSession = (ObjectSession)this.sessionManager.getSession(sessionID);
                }
                finally {
                    ExecutionContext.pop();
                }
                if (objSession == null) {
                    throw new EJBException("There is no such session [sessionID=" + sessionID + "]");
                }
                if (!objSession.validate()) {
                    throw new EJBException("Retrieved session is invalid(maybe timed out) [sessionID=" + sessionID + "]");
                }
                newSessionID = objSession.getId();
                context = (SessionContextImpl)objSession.getObject();
                if (context == null) {
                    throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4449, (Object)sessionID));
                }
                context.setSessionID(newSessionID);
                objSession.setNeedUpdate(true);
                try {
                    this.callUpdateSession(this.beanInfo.getReplicationModeOfBean(), objSession);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_EJB12._9055_LEVEL)) break block18;
                    logger.log(JeusMessage_EJB12._9055_LEVEL, JeusMessage_EJB12._9055, (Object)this.getBeanName());
                }
            }
            switch (type) {
                case EJBOBJECT: {
                    ejbObject = this.ejbSessionObjectPool.getOrCreate(newSessionID);
                    break;
                }
                case BUSINESSOBJECT: {
                    ejbObject = this.bizObjectPool.getOrCreate(newSessionID);
                    break;
                }
                default: {
                    throw new Exception("Not implemented for " + type.name());
                }
            }
            context.setEJBSessionIfObject((EJBSessionIfObject)ejbObject);
            return ejbObject;
        }
        catch (EJBException e) {
            if (logger.isLoggable(JeusMessage_EJB6._4451_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4451_LEVEL, "StatefulSessionContainer", "findByInstanceKey", JeusMessage_EJB6._4451, (Object)String.valueOf(sessionID), (Throwable)e);
            }
            throw e;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB6._4452_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4452_LEVEL, "StatefulSessionContainer", "findByInstanceKey", JeusMessage_EJB6._4452, (Object)String.valueOf(sessionID), t);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4452, (Object)sessionID));
        }
    }

    public void removeObjectWithHandle(Handle handle) throws Exception {
        EJBSessionObjectBase ejbObj;
        if (logger.isLoggable(JeusMessage_EJB6._4453_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4453_LEVEL, "StatefulSessionContainer", "removeWithInstanceKey", JeusMessage_EJB6._4453, (Object)handle);
        }
        String sessionID = handle instanceof RMIHandleImpl ? ((RMIHandleImpl)handle).sessionID : ((IIOPHandleImpl)handle).sessionID;
        if (logger.isLoggable(JeusMessage_EJB6._4454_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4454_LEVEL, "StatefulSessionContainer", "removeWithInstanceKey", JeusMessage_EJB6._4454, (Object)sessionID);
        }
        if ((ejbObj = (EJBSessionObjectBase)this.ejbSessionObjectPool.get(sessionID)) == null) {
            throw new NoSuchObjectException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4455, (Object)sessionID));
        }
        this.removeObject(ejbObj);
    }

    public void passivate(long timeStamp) throws ContainerException {
        this.sessionManager.scavenge(timeStamp);
    }

    public boolean isSessionSync() {
        return this.isSessionSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterBegin(EJBContextImpl ctx, Transaction tx) {
        SessionContextImpl context = (SessionContextImpl)ctx;
        if (this.isSessionSync()) {
            Object bean = context.getBean();
            BeanState prevStatus = context.getStatus();
            context.setStatus(BeanState.AFTER_BEGIN);
            this.pushExecutionContext(context);
            Exception exception = null;
            try {
                ((SessionSynchronization)bean).afterBegin();
                if (logger.isLoggable(JeusMessage_EJB7._4535_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4535_LEVEL, "StatefulSessionContainer", "preInvokeTx", JeusMessage_EJB7._4535);
                }
            }
            catch (Exception ex) {
                exception = ex;
            }
            finally {
                this.popExecutionContext();
                context.setStatus(prevStatus);
            }
            if (exception != null) {
                this.discardObject(context);
            }
        }
    }

    public void beforeCompletion(EJBContextImpl ctx, Transaction tx, boolean throwException) {
        block16: {
            SessionContextImpl context = (SessionContextImpl)ctx;
            if (this.isSessionSync() && !context.isToBeRemoved()) {
                if (logger.isLoggable(JeusMessage_EJB7._4541_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4541_LEVEL, "StatefulSessionContainer", "beforeCompletion", JeusMessage_EJB7._4541);
                }
                try {
                    Object bean = context.getBean();
                    BeanState prevStatus = context.getStatus();
                    context.setStatus(BeanState.BEFORE_COMPLETION);
                    this.pushExecutionContext(context);
                    try {
                        ((SessionSynchronization)bean).beforeCompletion();
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(JeusMessage_EJB7._4544_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4544_LEVEL, "StatefulSessionContainer", "beforeCompletion", JeusMessage_EJB7._4544, t);
                        }
                        try {
                            if (tx != TMService.nullTransaction) {
                                if (logger.isLoggable(JeusMessage_EJB7._4545_LEVEL)) {
                                    logger.logp(JeusMessage_EJB7._4545_LEVEL, "StatefulSessionContainer", "beforeCompletion", JeusMessage_EJB7._4545);
                                }
                                tx.setRollbackOnly();
                            }
                        }
                        catch (Throwable t1) {
                            // empty catch block
                        }
                        throw t;
                    }
                    finally {
                        this.popExecutionContext();
                        context.setStatus(prevStatus);
                    }
                    if (logger.isLoggable(JeusMessage_EJB7._4546_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4546_LEVEL, "StatefulSessionContainer", "beforeCompletion", JeusMessage_EJB7._4546);
                    }
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_EJB7._4547_LEVEL)) break block16;
                    logger.log(JeusMessage_EJB7._4547_LEVEL, JeusMessage_EJB7._4547, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void afterCompletion(EJBContextImpl ctx, Transaction tx, boolean committed) {
        block25: {
            context = (SessionContextImpl)ctx;
            if (StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4548_LEVEL)) {
                StatefulSessionContainer.logger.logp(JeusMessage_EJB7._4548_LEVEL, "StatefulSessionContainer", "afterCompletion", JeusMessage_EJB7._4548);
            }
            try {
                var5_5 = context;
                synchronized (var5_5) {
                    context.setTx(null);
                }
                if (context.isToBeRemoved()) {
                    ExecutionContext.push(this.executionContextForSessionManager);
                    try {
                        ejbSession = (ObjectSession)this.sessionManager.getSession(context.getSessionID());
                        if (ejbSession == null) ** GOTO lbl51
                        this.sessionManager.destroy(ejbSession);
                    }
                    catch (EJBException ex) {
                        StatefulSessionContainer.logger.log(JeusMessage_EJB12._9056_LEVEL, JeusMessage_EJB12._9056, (Throwable)ex);
                    }
                    finally {
                        ExecutionContext.pop();
                    }
                } else if (this.isSessionSync()) {
                    if (StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4549_LEVEL)) {
                        StatefulSessionContainer.logger.logp(JeusMessage_EJB7._4549_LEVEL, "StatefulSessionContainer", "afterCompletion", JeusMessage_EJB7._4549);
                    }
                    bean = context.getBean();
                    prevStatus = context.getStatus();
                    context.setStatus(BeanState.AFTER_COMPLETION);
                    this.pushExecutionContext(context);
                    throwable = null;
                    try {
                        ((SessionSynchronization)bean).afterCompletion(committed);
                        if (StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4553_LEVEL)) {
                            StatefulSessionContainer.logger.logp(JeusMessage_EJB7._4553_LEVEL, "StatefulSessionContainer", "afterCompletion", JeusMessage_EJB7._4553);
                        }
                    }
                    catch (Throwable t) {
                        if (StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4551_LEVEL)) {
                            StatefulSessionContainer.logger.logp(JeusMessage_EJB7._4551_LEVEL, "StatefulSessionContainer", "afterCompletion", JeusMessage_EJB7._4551, t);
                        }
                        throwable = t;
                    }
                    finally {
                        this.popExecutionContext();
                        context.setStatus(prevStatus);
                    }
                    if (throwable != null) {
                        this.discardObject(context);
                    }
                }
lbl51:
                // 8 sources

                if (!context.isToBeRemoved() && this.isClustered && committed && StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4554_LEVEL)) {
                    StatefulSessionContainer.logger.logp(JeusMessage_EJB7._4554_LEVEL, "StatefulSessionContainer", "afterCompletion", JeusMessage_EJB7._4554);
                }
            }
            catch (Throwable ex) {
                if (!StatefulSessionContainer.logger.isLoggable(JeusMessage_EJB7._4555_LEVEL)) break block25;
                StatefulSessionContainer.logger.log(JeusMessage_EJB7._4555_LEVEL, JeusMessage_EJB7._4555, ex);
            }
        }
    }

    public boolean invokeEJBTimeout(TimerState timerState, TimerContainer timerContainer) throws Throwable {
        throw new RuntimeException();
    }

    public void notifySessionCreation(Session param) {
        EJBSession ejbSession = (EJBSession)param;
        SessionContextImpl context = (SessionContextImpl)ejbSession.getObject();
        assert (context != null);
        context.setSessionID(ejbSession.getId());
        this.pushExecutionContext(context);
        try {
            this.invokeCallback(CallbackType.POST_CONSTRUCT, context);
            this.createCount.increase();
            this.methodReadyCount.increase();
            if (logger.isLoggable(JeusMessage_EJB12._9057_LEVEL)) {
                logger.log(JeusMessage_EJB12._9057_LEVEL, JeusMessage_EJB12._9057);
            }
        }
        catch (CallbackException ex) {
            throw new EJBException("problem occurred during the bean creation", (Exception)((Object)ex));
        }
        finally {
            this.popExecutionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionDestruction(Session param) {
        EJBSession ejbSession = (EJBSession)param;
        SessionContextImpl context = (SessionContextImpl)ejbSession.getObject();
        if (context == null) {
            if (logger.isLoggable(JeusMessage_EJB12._9058_LEVEL)) {
                logger.log(JeusMessage_EJB12._9058_LEVEL, JeusMessage_EJB12._9058, (Object)param.getId());
            }
            return;
        }
        try {
            if (ejbSession.isExceptionalRemove()) {
                this.discardBean(context);
            } else {
                this.removeBean(context);
            }
        }
        finally {
            ejbSession.setExceptionalRemove(false);
            if (this.poolingBeans) {
                this.beanContextPool.putback(context);
                logger.info("Putbacked the context instance " + context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionActivation(Session param) {
        EJBSession ejbSession = (EJBSession)param;
        SessionContextImpl context = (SessionContextImpl)ejbSession.getObject();
        assert (context != null);
        try {
            context.setContainer(this);
            GTID id = TMService.suspendCurrentTransaction();
            try {
                this.pushExecutionContext(context);
                try {
                    this.invokeCallback(CallbackType.POST_ACTIVATE, context);
                    this.passivatedBeanCount.decrease();
                }
                finally {
                    this.popExecutionContext();
                }
                context.setStatus(BeanState.READY);
            }
            finally {
                TMService.resumeCurrentTransaction(id);
            }
        }
        catch (CallbackException ex) {
            if (context != null) {
                this.discardObject(context);
            }
            throw new EJBException("exception occurred while calling POST ACTIVATE method", (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionPassivation(Session param) {
        block11: {
            EJBSession ejbSession = (EJBSession)param;
            SessionContextImpl context = (SessionContextImpl)ejbSession.getObject();
            assert (context != null);
            try {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.logp(Level.WARNING, "StatefulSessionContainer", "passivateEJB", JeusMessage_EJB6._4495);
                }
                this.pushExecutionContext(context);
                try {
                    this.invokeCallback(CallbackType.PRE_PASSIVATE, context);
                    this.passivatedBeanCount.increase();
                    this.methodReadyCount.decrease();
                    this.autoRemovedEJBObjectCount.increase();
                }
                finally {
                    this.popExecutionContext();
                }
                if (logger.isLoggable(JeusMessage_EJB6._4496_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4496_LEVEL, "StatefulSessionContainer", "passivateEJB", JeusMessage_EJB6._4496);
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_EJB6._4497_LEVEL)) {
                    logger.logp(JeusMessage_EJB6._4497_LEVEL, "StatefulSessionContainer", "passivateEJB", JeusMessage_EJB6._4497, ex);
                }
                this.discardObject(context);
                if (!logger.isLoggable(JeusMessage_EJB6._4493_LEVEL)) break block11;
                logger.logp(JeusMessage_EJB6._4493_LEVEL, "StatefulSessionContainer", "passivator", JeusMessage_EJB6._4493, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB6._4498_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4498_LEVEL, "StatefulSessionContainer", "passivateEJB", JeusMessage_EJB6._4498);
        }
    }

    protected void initEJBTimerService() {
    }

    public void setBeanModel(EJB mo) {
        super.setBeanModel(mo);
        mo.setStatistic((StatisticImpl)this.passivatedBeanCount);
        mo.setStatistic((StatisticImpl)this.autoRemovedEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.totalEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.activeEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.totalEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.activeEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.totalThreadCount);
        mo.setStatistic((StatisticImpl)this.activeThreadCount);
    }

    public void beforeStatistic() {
        if (logger.isLoggable(JeusMessage_EJB7._4500_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4500_LEVEL, "StatefulSessionContainer", "beforeStatistic", JeusMessage_EJB7._4500);
        }
        if (this.getStatus() != EJBStatus.RUNNING) {
            return;
        }
        int ejbObjectCount = 0;
        if (this.ejbSessionObjectPool != null) {
            ejbObjectCount += this.ejbSessionObjectPool.getActiveSize();
        }
        if (this.ejbLocalSessionObjectPool != null) {
            ejbObjectCount += this.ejbLocalSessionObjectPool.getActiveSize();
        }
        if (this.bizObjectPool != null) {
            ejbObjectCount += this.bizObjectPool.getActiveSize();
        }
        if (this.poolingBeans) {
            this.totalEJBBeanCount.set((long)(ejbObjectCount + this.beanContextPool.available()));
        } else {
            this.totalEJBBeanCount.set((long)ejbObjectCount);
        }
        long active = (long)ejbObjectCount - this.passivatedBeanCount.getCurrent();
        this.activeEJBBeanCount.set(active > 0L ? active : 0L);
        int ejbObjectTotalCount = 0;
        if (this.ejbSessionObjectPool != null) {
            ejbObjectTotalCount += this.ejbSessionObjectPool.getPoolSize();
        }
        if (this.ejbLocalSessionObjectPool != null) {
            ejbObjectTotalCount += this.ejbLocalSessionObjectPool.getPoolSize();
        }
        if (this.bizObjectPool != null) {
            ejbObjectTotalCount += this.bizObjectPool.getPoolSize();
        }
        this.totalEJBObjectCount.set((long)ejbObjectTotalCount);
        this.activeEJBObjectCount.set((long)ejbObjectCount);
        this.totalThreadCount.set((long)this.beanInfo.getThreadPoolMax());
        this.activeThreadCount.set((long)this.getActiveThreadNum());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanInstancePoolHandler
    implements InstancePoolHandler<SessionContextImpl> {
        private BeanInstancePoolHandler() {
        }

        @Override
        public SessionContextImpl createInstance() throws Exception {
            return StatefulSessionContainer.this.newBeanContext();
        }

        @Override
        public void afterCreateInstance(SessionContextImpl object) throws Exception {
        }

        @Override
        public Object beforeRemoveInstances() {
            return null;
        }

        @Override
        public void beforeRemoveInstance(SessionContextImpl object) {
        }

        @Override
        public void afterRemoveInstances(Object userData) {
        }
    }
}

