/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import javax.ejb.RemoveException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.EJB3SynchronizationImpl;
import jeus.ejb.container3.SessionTxInterceptor;
import jeus.ejb.container3.StatefulSessionContainer;
import jeus.ejb.container3.TransactionInterceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.transaction.TMException;
import jeus.transaction.TMService;
import jeus.util.message.JeusMessage_EJB6;
import jeus.util.message.JeusMessage_EJB7;

public class StatefulTxInterceptor
extends SessionTxInterceptor {
    protected StatefulSessionContainer container;

    public StatefulTxInterceptor(StatefulSessionContainer container) {
        super(container);
        this.container = container;
    }

    protected Transaction prevTx(TransactionInterceptor.TxContext txContext) {
        return txContext.ejbContext.getTx();
    }

    protected void setPrevTx(TransactionInterceptor.TxContext txContext, Transaction tx) {
        txContext.ejbContext.setTx(tx);
    }

    protected void preCheckRemoveTx(TransactionInterceptor.TxContext txContext, Invocation invocation) throws RemoveException {
    }

    protected void preTxFilterBeanManaged(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB7._4503_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4503_LEVEL, "StatefulSessionContainer", "preTxFilterBeanManaged", JeusMessage_EJB7._4503);
        }
        try {
            if (txContext.callerTx != null) {
                txContext.callerTx = this.txManager.suspend();
                if (logger.isLoggable(JeusMessage_EJB7._4505_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4505_LEVEL, "StatefulSessionContainer", "preTxFilterBeanManaged", JeusMessage_EJB7._4505);
                }
            } else if (logger.isLoggable(JeusMessage_EJB7._4506_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4506_LEVEL, "StatefulSessionContainer", "preTxFilterBeanManaged", JeusMessage_EJB7._4506);
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB7._4507, ex);
        }
        Transaction prevTx = this.prevTx(txContext);
        if (prevTx != null) {
            TMService.associateTransactionContext(prevTx);
            txContext.tx = prevTx;
            if (logger.isLoggable(JeusMessage_EJB7._4509_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4509_LEVEL, "StatefulSessionContainer", "preTxFilterBeanManaged", JeusMessage_EJB7._4509);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB7._4510_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4510_LEVEL, "StatefulSessionContainer", "preTxFilterBeanManaged", JeusMessage_EJB7._4510);
        }
    }

    protected void preTxFilterNever(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null) {
            throw new ContainerException(JeusMessage_EJB7._4512);
        }
    }

    protected void preTxFilterMandatory(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null && !this.prevTx(txContext).equals(txContext.callerTx)) {
            throw new ContainerException(JeusMessage_EJB7._4515);
        }
    }

    protected void preTxFilterRequiresNew(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null) {
            throw new ContainerException(JeusMessage_EJB7._4518);
        }
    }

    protected void preTxFilterSuports(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null && !this.prevTx(txContext).equals(txContext.callerTx)) {
            throw new ContainerException(JeusMessage_EJB7._4521);
        }
    }

    protected void preTxFilterRequired(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null && !this.prevTx(txContext).equals(txContext.callerTx)) {
            throw new ContainerException(JeusMessage_EJB7._4524);
        }
    }

    protected void preTxFilterNotSupported(TransactionInterceptor.TxContext txContext) throws ContainerException {
        if (this.prevTx(txContext) != null) {
            throw new ContainerException(JeusMessage_EJB7._4527);
        }
    }

    protected void handleBeforeCallingServices(TransactionInterceptor.TxContext txContext) throws ContainerException {
        super.handleBeforeCallingServices(txContext);
        if (!this.isBeanManagedTx && this.prevTx(txContext) == null && txContext.tx != TMService.nullTransaction) {
            if (logger.isLoggable(JeusMessage_EJB6._4430_LEVEL)) {
                logger.logp(JeusMessage_EJB6._4430_LEVEL, "StatefulSessionContainer", "prepareProcessingRequest", JeusMessage_EJB6._4430);
            }
            this.setPrevTx(txContext, txContext.tx);
            this.preInvokeTx(txContext);
        }
        if (txContext.tx != TMService.nullTransaction) {
            this.container.associatesExtendedEMsWithTx((SessionContextImpl)txContext.ejbContext);
        }
    }

    private void preInvokeTx(TransactionInterceptor.TxContext request) throws ContainerException {
        EJB3SynchronizationImpl sync;
        if (logger.isLoggable(JeusMessage_EJB7._4529_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4529_LEVEL, "StatefulSessionContainer", "preInvokeTx", JeusMessage_EJB7._4529);
        }
        try {
            sync = new EJB3SynchronizationImpl(this.container, request.ejbContext, request.tx);
            request.tx.registerSynchronization((Synchronization)sync);
            if (logger.isLoggable(JeusMessage_EJB7._4531_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4531_LEVEL, "StatefulSessionContainer", "preInvokeTx", JeusMessage_EJB7._4531);
            }
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB7._4532, e);
        }
        if (this.container.isSessionSync()) {
            sync.afterBegin();
        }
        if (logger.isLoggable(JeusMessage_EJB7._4539_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4539_LEVEL, "StatefulSessionContainer", "preInvokeTx", JeusMessage_EJB7._4539);
        }
    }

    protected void postHandleTx(TransactionInterceptor.TxContext txContext) throws SystemException, TMException {
        if (this.isBeanManagedTx) {
            if (logger.isLoggable(JeusMessage_EJB7._4540_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4540_LEVEL, "StatefulSessionContainer", "postHandleTx", JeusMessage_EJB7._4540);
            }
            Transaction tx = this.txManager.getTransaction();
            this.setPrevTx(txContext, tx);
            txContext.tx = tx;
        }
    }

    protected void discardObject(TransactionInterceptor.TxContext txContext) {
        this.container.discardObject((SessionContextImpl)txContext.ejbContext);
    }
}

