/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.ejbserver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.ejb.EJBEngine;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.enginecontainer.InvocationManager;
import jeus.server.enginecontainer.InvocationStack;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.SmtpHandler;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB7;
import jeus.util.message.JeusMessage_EJB8;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SmtpHandlerType;
import jeus.xml.binding.jeusDD.SmtpSenderType;

public class ActiveManager
extends Thread {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.ejbserver.activeManager");
    private static final int InitCap = 200;
    private static final int MaxCap = 1000;
    private long CheckInterval;
    private final Ticket[] freelist = new Ticket[1000];
    private int available;
    private Hashtable workinglist = new Hashtable(1000);
    private ThreadLocal ticket = new ThreadLocal();
    private long currentTime;
    private int numBlockedThread;
    private int maxBlockedThread;
    private long maxIdleTime;
    private boolean running = true;
    private final Object sync = new Object();

    public static ActiveManager currentActiveManager() {
        EJBEngine engine = EJBEngine.getDefaultEngine();
        if (engine != null) {
            return engine.getActiveManager();
        }
        return null;
    }

    public ActiveManager(int maxBlockedThread, long maxIdleTime, long checkInterval, SmtpSenderType emailDesc) throws Exception {
        super("jeus.ejb.ejbserver.ActiveManager");
        long checkThreadhold;
        this.maxBlockedThread = maxBlockedThread;
        if (checkInterval <= 0L) {
            checkInterval = 300000L;
        }
        if (checkInterval > (checkThreadhold = (long)((double)maxIdleTime * 0.5))) {
            checkInterval = checkThreadhold;
        }
        this.CheckInterval = checkInterval;
        if (maxBlockedThread == -1) {
            return;
        }
        this.maxIdleTime = maxIdleTime;
        this.available = 200;
        for (int i = 0; i < 200; ++i) {
            this.freelist[i] = new Ticket();
        }
        if (emailDesc != null) {
            SmtpHandler handler = new SmtpHandler();
            SmtpHandlerType handlerType = this.convertSmtpHandlerType(emailDesc);
            JeusLoggerConfiguration.setSmtpHandler(handlerType, (Handler)handler, (JeusFormatter)new SimpleFormatter());
            logger.setSmtpHandler((Handler)handler);
            logger.log(JeusMessage_EJB8._5052_LEVEL, JeusMessage_EJB8._5052);
        }
        this.setDaemon(true);
    }

    private SmtpHandlerType convertSmtpHandlerType(SmtpSenderType emailDesc) throws JAXBException {
        SmtpHandlerType handlerType = new ObjectFactory().createSmtpHandlerType();
        handlerType.setBccAddress(emailDesc.getBccAddress());
        handlerType.setCcAddress(emailDesc.getCcAddress());
        handlerType.setFromAddress(emailDesc.getFromAddress());
        handlerType.setLevel(LoggingLevelType.valueOf((String)Level.FINEST.getName()));
        handlerType.setName("smtp sender");
        handlerType.setSmtpHostAddress(emailDesc.getSmtpHostAddress());
        handlerType.setToAddress(emailDesc.getToAddress());
        return handlerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTicket() {
        if (this.maxBlockedThread == -1) {
            return;
        }
        Ticket[] ticketArray = this.freelist;
        synchronized (this.freelist) {
            Ticket tk;
            if (this.available == 0) {
                tk = new Ticket();
            } else {
                tk = this.freelist[this.available - 1];
                --this.available;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            tk.time = System.currentTimeMillis();
            InvocationStack myStack = InvocationManager.getCurrentStack();
            this.workinglist.put(tk, myStack);
            this.ticket.set(tk);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void returnTicket() {
        if (this.maxBlockedThread == -1) {
            return;
        }
        Ticket tk = (Ticket)this.ticket.get();
        if (tk == null) return;
        if (this.workinglist.remove(tk) == null) {
            --this.numBlockedThread;
        }
        Ticket[] ticketArray = this.freelist;
        synchronized (this.freelist) {
            if (this.available >= 1000) return;
            this.freelist[this.available] = tk;
            ++this.available;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.maxBlockedThread == -1) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            this.sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (this.maxBlockedThread == -1) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    Object object = this.sync;
                    // MONITORENTER : object
                    if (!this.running) {
                        // MONITOREXIT : object
                        return;
                    }
                    this.sync.wait(this.CheckInterval);
                    if (!this.running) {
                        // MONITOREXIT : object
                        return;
                    }
                    // MONITOREXIT : object
                    this.currentTime = System.currentTimeMillis();
                    Enumeration e = this.workinglist.keys();
                    while (e.hasMoreElements()) {
                        InvocationStack myStack;
                        Ticket tk = (Ticket)e.nextElement();
                        if (this.currentTime - tk.time <= this.maxIdleTime || (myStack = (InvocationStack)this.workinglist.remove(tk)) == null) continue;
                        ++this.numBlockedThread;
                        Ticket[] ticketArray = this.freelist;
                        // MONITORENTER : this.freelist
                        if (this.available < 1000) {
                            this.freelist[this.available] = tk;
                            ++this.available;
                        }
                        // MONITOREXIT : ticketArray
                        myStack.shutdownAll();
                    }
                    if (this.numBlockedThread < this.maxBlockedThread) continue;
                    this.restart();
                }
            }
            catch (Throwable t) {
                logger.logp(JeusMessage_EJB7._4901_LEVEL, "ActiveManager", "run", JeusMessage_EJB7._4901, t);
                continue;
            }
            break;
        }
    }

    private void restart() throws EJBServerException {
        String engineName = EJBEngine.getDefaultEngine().getName();
        try {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7084, (Object)engineName);
            if (logger.isLoggable(JeusMessage_EJB7._4902_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4902_LEVEL, "ActiveManager", "restart", JeusMessage_EJB7._4902, (Object)engineName);
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.sendEmailNotification(Level.SEVERE, msg);
            }
        }
        catch (Throwable e) {
            logger.logp(JeusMessage_EJB7._4903_LEVEL, "ActiveManager", "restart", JeusMessage_EJB7._4903, e);
        }
        try {
            EngineContainer.restart(engineName);
        }
        catch (Throwable t) {
            logger.logp(JeusMessage_EJB7._4904_LEVEL, "ActiveManager", "restart", JeusMessage_EJB7._4904, (Object)engineName, t);
            throw new EJBServerException(JeusMessage_EJB7._4904, engineName, t);
        }
    }

    public int getMaxBlockedThread() {
        return this.maxBlockedThread;
    }

    public float getBlockedThreadRatio() {
        return (float)this.numBlockedThread / (float)this.maxBlockedThread;
    }

    public int getNumBlockedThread() {
        return this.numBlockedThread;
    }

    public static class Ticket {
        public long time;
    }
}

