/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import jeus.deploy.archivist.FileArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassGenerator {
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp = File.separator.equals("/") ? new String(":") : new String(";");
    protected FileArchive archive;
    protected ClassLoader loader;
    private static int classNameLimit = 40;

    protected ClassGenerator(FileArchive archive, ClassLoader loader) {
        this.archive = archive;
        this.loader = loader;
    }

    public static String checkImplName(String name) {
        char head;
        if (name.length() > classNameLimit) {
            name = name.substring(name.length() - classNameLimit);
        }
        if (!Character.isJavaIdentifierStart(head = name.charAt(0))) {
            name = "a" + name;
        }
        return name;
    }

    public OutputStream makeFileOf(String className) throws IOException {
        return new BufferedOutputStream(this.archive.addEntry(className.replace('.', fsc) + ".java"), 4096);
    }

    public Vector<Class> computeUniqueCatchList(Class[] exceptions) {
        Vector<Class> uniqueList = new Vector<Class>();
        uniqueList.addElement(RuntimeException.class);
        block0: for (int i = 0; i < exceptions.length; ++i) {
            Class decl = exceptions[i];
            if (decl.isAssignableFrom(Exception.class)) {
                uniqueList.clear();
                uniqueList.addElement(decl);
                break;
            }
            if (!Exception.class.isAssignableFrom(decl)) continue;
            int j = 0;
            while (j < uniqueList.size()) {
                Class def = uniqueList.elementAt(j);
                if (def.isAssignableFrom(decl)) continue block0;
                if (decl.isAssignableFrom(def)) {
                    uniqueList.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            uniqueList.addElement(decl);
        }
        return uniqueList;
    }
}

