/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.SessionType;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.EJBRMIGenerator;
import jeus.ejb.generator.HomeImplGenerator;
import jeus.ejb.generator.ObjectImplGenerator;
import jeus.ejb.generator.SessionEJBHomeImplGenerator;
import jeus.ejb.generator.SessionEJBLocalHomeImplGenerator;
import jeus.ejb.generator.SessionEJBLocalObjectImplGenerator;
import jeus.ejb.generator.SessionEJBObjectImplGenerator;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.util.EJBCompiler;
import jeus.ejb.util.IIOPHomeGenerator;
import jeus.ejb.util.IIOPObjectGenerator;
import jeus.ejb.util.WrapperGenerator;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.codegen.CodeUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.xml.binding.jeusDD.ClusteringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBCodeBuilder {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)EJBCodeBuilder.class.getName());
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp = File.separator.equals("/") ? ":" : ";";
    FileArchive archive;
    ArchiveArrayClassLoader loader;
    private EJBCompiler compiler;

    public EJBCodeBuilder(FileArchive archive, ArchiveArrayClassLoader loader, EJBCompiler compiler) {
        this.archive = archive;
        this.loader = loader;
        this.compiler = compiler;
    }

    public void compile_generatedFiles(int type, String[] sources, String[] classes, boolean force) throws CodeGenerationException {
        try {
            this.compiler.addCompile(type, sources, classes, force);
        }
        catch (Throwable t) {
            throw new CodeGenerationException("Compiling the source files FAILED", t);
        }
    }

    public void compile_generatedFiles(int type, List<String> classes) throws CodeGenerationException {
        this.compile_generatedFiles(type, classes.toArray(new String[0]));
    }

    public void compile_generatedFiles(int type, String[] classes) throws CodeGenerationException {
        String[] sources = this.getSourceFiles(classes);
        this.compile_generatedFiles(type, sources, classes, false);
    }

    private String[] getSourceFiles(String[] classes) {
        String[] args = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            args[i] = this.archive.getArchiveUri() + fs + classes[i].replace('.', fsc) + ".java";
        }
        return args;
    }

    public OutputStream makeFileOf(String className) throws IOException {
        return new BufferedOutputStream(this.archive.addEntry(className.replace('.', fsc) + ".java"), 4096);
    }

    public void generateSessionCodes(SessionBeanInfo beanInfo, boolean fastDeploy) throws CodeGenerationException {
        try {
            Vector<String> generateds = new Vector<String>();
            this.generateEJBObjectImpl(beanInfo, generateds, fastDeploy);
            if (generateds.size() > 0) {
                this.compile_generatedFiles(4, generateds);
            }
            generateds.clear();
            this.generate_RMI(beanInfo, generateds, fastDeploy);
            if (generateds.size() > 0) {
                this.compile_generatedFiles(7, generateds);
            }
        }
        catch (CodeGenerationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private void generateEJBObjectImpl(SessionBeanInfo beanInfo, List<String> generateds, boolean fastDeploy) throws CodeGenerationException {
        String objectImpl;
        ObjectImplGenerator objectImplGenerator;
        String homeImpl;
        HomeImplGenerator homeImplGenerator;
        if (beanInfo.getEJBHomeClassName() != null) {
            try {
                homeImplGenerator = new SessionEJBHomeImplGenerator(this.archive, (ClassLoader)this.loader, beanInfo);
                if (logger.isLoggable(JeusMessage_EJB12._9059_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9059_LEVEL, JeusMessage_EJB12._9059, (Object)beanInfo.getBeanName());
                }
                if (!fastDeploy) {
                    homeImplGenerator.generate();
                }
                homeImpl = homeImplGenerator.getFullImplClassName();
                beanInfo.setEJBHomeImplClassName(homeImpl);
                if (!fastDeploy) {
                    generateds.add(homeImpl);
                }
                if (beanInfo.getEJBObjectClassName() == null) {
                    throw new CodeGenerationException("remote component (EJBObject) is not specified");
                }
                objectImplGenerator = new SessionEJBObjectImplGenerator(this.archive, (ClassLoader)this.loader, beanInfo);
                if (logger.isLoggable(JeusMessage_EJB12._9060_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9060_LEVEL, JeusMessage_EJB12._9060, (Object)beanInfo.getBeanName());
                }
                if (!fastDeploy) {
                    objectImplGenerator.generate();
                }
                objectImpl = objectImplGenerator.getFullImplClassName();
                beanInfo.setEJBObjectImplClassName(objectImpl);
                if (!fastDeploy) {
                    generateds.add(objectImpl);
                }
            }
            catch (IOException ex) {
                throw new CodeGenerationException(ex);
            }
        }
        if (beanInfo.getEJBLocalHomeClassName() != null) {
            try {
                homeImplGenerator = new SessionEJBLocalHomeImplGenerator(this.archive, (ClassLoader)this.loader, beanInfo);
                if (logger.isLoggable(JeusMessage_EJB12._9061_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9061_LEVEL, JeusMessage_EJB12._9061, (Object)beanInfo.getBeanName());
                }
                if (!fastDeploy) {
                    homeImplGenerator.generate();
                }
                homeImpl = homeImplGenerator.getFullImplClassName();
                beanInfo.setEJBLocalHomeImplClassName(homeImpl);
                if (!fastDeploy) {
                    generateds.add(homeImpl);
                }
                if (beanInfo.getEJBLocalObjectClassName() == null) {
                    throw new CodeGenerationException("local component (EJBLocalObject) is not specified");
                }
                objectImplGenerator = new SessionEJBLocalObjectImplGenerator(this.archive, (ClassLoader)this.loader, beanInfo);
                if (logger.isLoggable(JeusMessage_EJB12._9062_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9062_LEVEL, JeusMessage_EJB12._9062, (Object)beanInfo.getBeanName());
                }
                if (!fastDeploy) {
                    objectImplGenerator.generate();
                }
                objectImpl = objectImplGenerator.getFullImplClassName();
                beanInfo.setEJBLocalObjectImplClassName(objectImpl);
                if (!fastDeploy) {
                    generateds.add(objectImpl);
                }
            }
            catch (IOException ex) {
                throw new CodeGenerationException(ex);
            }
        }
    }

    private void generate_RMI(SessionBeanInfo beanInfo, List<String> generateds, boolean fastDeploy) throws CodeGenerationException {
        ClusteringType clusterType = beanInfo.getClusterDesc();
        SessionType sessionType = beanInfo.getSessionType();
        try {
            if (beanInfo.getEJBHomeImplClassName() != null) {
                String ejbHomeClassName = beanInfo.getEJBHomeClassName();
                String implClass = beanInfo.getEJBHomeImplClassName();
                EJBRMIGenerator rmiGenerator = new EJBRMIGenerator(this.archive, this.loader, implClass, beanInfo.getHomeImplStubInterfaces(), beanInfo.isClustered(), beanInfo.getHomeIdempotentMethods(), true, sessionType, beanInfo.useJeusRmi());
                if (!fastDeploy) {
                    rmiGenerator.generate();
                    generateds.add(rmiGenerator.getStubClassName());
                    if (!beanInfo.useJeusRmi()) {
                        generateds.add(rmiGenerator.getSkelClassName());
                    }
                    if (beanInfo.getExportIIOP()) {
                        String packageName = CodeUtil.getPackageName(implClass);
                        String className = CodeUtil.getSimpleClassName(implClass);
                        IIOPHomeGenerator iiopObjectGen = new IIOPHomeGenerator(this.archive.getArchiveUri(), packageName, className, CodeUtil.getSimpleClassName(ejbHomeClassName), this.loader);
                        String fullClassName = this.generateIIOPImpl(iiopObjectGen, packageName);
                        beanInfo.setIIOPEJBHomeImplClassName(fullClassName);
                    }
                }
                String ejbObjectClassName = beanInfo.getEJBObjectClassName();
                implClass = beanInfo.getEJBObjectImplClassName();
                rmiGenerator = new EJBRMIGenerator(this.archive, this.loader, implClass, new String[]{ejbObjectClassName}, beanInfo.isClustered(), beanInfo.getRemoteIdempotentMethods(), false, sessionType, beanInfo.useJeusRmi());
                if (!fastDeploy) {
                    rmiGenerator.generate();
                    generateds.add(rmiGenerator.getStubClassName());
                    if (!beanInfo.useJeusRmi()) {
                        generateds.add(rmiGenerator.getSkelClassName());
                    }
                    if (beanInfo.getExportIIOP()) {
                        String packageName = CodeUtil.getPackageName(implClass);
                        String className = CodeUtil.getSimpleClassName(implClass);
                        IIOPObjectGenerator iiopObjectGen = new IIOPObjectGenerator(this.archive.getArchiveUri(), packageName, className, CodeUtil.getSimpleClassName(ejbObjectClassName), this.loader);
                        String fullClassName = this.generateIIOPImpl(iiopObjectGen, packageName);
                        beanInfo.setIIOPEJBObjectImplClassName(fullClassName);
                    }
                }
            }
        }
        catch (CodeGenerationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private String generateIIOPImpl(WrapperGenerator iiopObjectGen, String packageName) throws CodeGenerationException {
        iiopObjectGen.generate();
        String directoryPath = this.archive.getArchiveUri() + File.separator;
        String s = iiopObjectGen.generateClassName();
        String fullClassName = packageName + "." + s;
        this.compile_generatedFiles(3, new String[]{directoryPath + fullClassName.replace('.', File.separatorChar) + ".java"}, new String[]{fullClassName}, false);
        return fullClassName;
    }
}

