/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.UserInterceptorManager;
import jeus.ejb.metadata.InterceptorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvocationChain {
    UserInterceptorManager manager;
    Map<InterceptorInfo, Integer> indexMap;
    List<Method> interceptMethods = new ArrayList<Method>();
    List<Integer> interceptorIndices = new ArrayList<Integer>();

    public InvocationChain(UserInterceptorManager manager) {
        this.manager = manager;
        this.indexMap = manager.interceptorIndexMap;
    }

    void addBeanAroundInvokes(InterceptorInfo interceptor) {
        if (interceptor == null || !interceptor.hasAroundInvokeMethods()) {
            return;
        }
        for (Method m : interceptor.getOrderedAroundInvokeMethods()) {
            this.interceptorIndices.add(-1);
            this.interceptMethods.add(m);
        }
    }

    void addBeanCallbacks(CallbackType type, InterceptorInfo interceptor) {
        if (interceptor == null || !interceptor.hasCallbackMethods(type)) {
            return;
        }
        for (Method m : interceptor.getOrderedCallbackMethods(type)) {
            this.interceptorIndices.add(-1);
            this.interceptMethods.add(m);
        }
    }

    void addAllAroundInvokes(List<InterceptorInfo> interceptors) {
        if (interceptors == null) {
            return;
        }
        for (InterceptorInfo i : interceptors) {
            if (!i.hasAroundInvokeMethods()) continue;
            int index = this.indexMap.get(i);
            for (Method m : i.getOrderedAroundInvokeMethods()) {
                this.interceptorIndices.add(index);
                this.interceptMethods.add(m);
            }
        }
    }

    void addAllCallbacks(CallbackType type, List<InterceptorInfo> interceptors) {
        if (interceptors == null) {
            return;
        }
        for (InterceptorInfo itc : interceptors) {
            if (!itc.hasCallbackMethods(type)) continue;
            int index = this.indexMap.get(itc);
            for (Method m : itc.getOrderedCallbackMethods(type)) {
                this.interceptorIndices.add(index);
                this.interceptMethods.add(m);
            }
        }
    }

    public int getInterceptorIndex(int position) {
        return this.interceptorIndices.get(position);
    }

    public Method getMethod(int position) {
        return this.interceptMethods.get(position);
    }

    public int size() {
        return this.interceptorIndices.size();
    }
}

