/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.List;
import jeus.ejb.interop.csi.SecurityMechanismSelector;

public class CSIIORToSocketInfo
implements IORToSocketInfo {
    public List getSocketInfo(IOR ior, List previous) {
        try {
            ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
            SecurityMechanismSelector selector = new SecurityMechanismSelector();
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            SocketInfo socketInfo = selector.getSSLPort(ior);
            if (socketInfo == null) {
                String type = "IIOP_CLEAR_TEXT";
                int port = primary.getPort();
                SocketInfo primarySocketInfo = CSIIORToSocketInfo.createSocketInfo(type, host, port);
                result.add(primarySocketInfo);
            } else {
                result.add(socketInfo);
            }
            return result;
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException(ex.getMessage());
            rte.initCause(ex);
            throw rte;
        }
    }

    public static SocketInfo createSocketInfo(final String type, final String host, final int port) {
        return new SocketInfo(){

            public String getType() {
                return type;
            }

            public String getHost() {
                return host;
            }

            public int getPort() {
                return port;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof SocketInfo)) {
                    return false;
                }
                SocketInfo other = (SocketInfo)o;
                if (other.getPort() != port) {
                    return false;
                }
                if (!other.getHost().equals(host)) {
                    return false;
                }
                return other.getType().equals(type);
            }

            public String toString() {
                return "SocketInfo[" + type + " " + host + " " + port + "]";
            }
        };
    }
}

