/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import java.io.IOException;
import java.security.Principal;
import jeus.ejb.interop.csi.CSIException;
import jeus.util.message.JeusMessage_EJB11;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUPExportName
implements Principal {
    private static ObjectIdentifier GSSUP_MECH_OID = null;
    private String username = "";
    private String scope = "";
    private byte[] gssExportedName;

    public GSSUPExportName(String username, String scope) throws Exception {
        this.username = username;
        this.scope = scope;
        String scopedName = GSSUPExportName.addEscape(username);
        if (!scope.equals("")) {
            scopedName = scopedName + "@" + GSSUPExportName.addEscape(scope);
        }
        byte[] expname_utf8 = scopedName.getBytes("UTF8");
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(GSSUP_MECH_OID);
        byte[] oidDER = dos.toByteArray();
        int tokensize = 4 + oidDER.length + 4 + expname_utf8.length;
        this.gssExportedName = new byte[tokensize];
        int pos = 0;
        this.gssExportedName[0] = 4;
        this.gssExportedName[1] = 1;
        this.gssExportedName[2] = (byte)(oidDER.length & 0xFF00);
        this.gssExportedName[3] = (byte)(oidDER.length & 0xFF);
        pos = 4;
        System.arraycopy(oidDER, 0, this.gssExportedName, pos, oidDER.length);
        pos += oidDER.length;
        int namelen = expname_utf8.length;
        this.gssExportedName[pos++] = (byte)(namelen & 0xFF0000);
        this.gssExportedName[pos++] = (byte)(namelen & 0xFF00);
        this.gssExportedName[pos++] = (byte)(namelen & 0xFF00);
        this.gssExportedName[pos++] = (byte)(namelen & 0xFF);
        System.arraycopy(expname_utf8, 0, this.gssExportedName, pos, namelen);
    }

    /*
     * Unable to fully structure code
     */
    public static String addEscape(String str) {
        block1: {
            from_idx = 0;
            idx = 0;
            do lbl-1000:
            // 3 sources

            {
                block2: {
                    if ((idx = str.indexOf(92, from_idx)) == -1) break block2;
                    str = str.substring(0, idx) + "\\" + str.substring(idx);
                    from_idx = idx + 2;
                    if (str.length() > from_idx) ** GOTO lbl-1000
                    return str;
                }
                idx = str.indexOf(64, from_idx);
                if (idx == -1) break block1;
                str = str.substring(0, idx) + "\\" + str.substring(idx);
                from_idx = idx + 2;
            } while (str.length() > from_idx);
            return str;
        }
        return str;
    }

    public GSSUPExportName(byte[] gssExportedName) throws Exception {
        int at_idx;
        this.gssExportedName = gssExportedName;
        if (gssExportedName[0] != 4 || gssExportedName[1] != 1) {
            throw new CSIException(JeusMessage_EJB11._7098);
        }
        int mechoidlen = (gssExportedName[2] << 8) + gssExportedName[3];
        if (gssExportedName.length < 4 + mechoidlen + 4) {
            throw new CSIException(JeusMessage_EJB11._7098);
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(gssExportedName, 4, deroid, 0, mechoidlen);
        DerInputStream dis = new DerInputStream(deroid);
        ObjectIdentifier oid = dis.getOID();
        if (!oid.equals(GSSUP_MECH_OID)) {
            throw new CSIException(JeusMessage_EJB11._7098);
        }
        int pos = 4 + mechoidlen;
        int namelen = (gssExportedName[pos] << 24) + (gssExportedName[pos + 1] << 16) + (gssExportedName[pos + 2] << 8) + gssExportedName[pos + 3];
        pos += 4;
        if (gssExportedName.length != 4 + mechoidlen + 4 + namelen) {
            throw new CSIException(JeusMessage_EJB11._7098);
        }
        byte[] exportedname = new byte[gssExportedName.length - pos];
        System.arraycopy(gssExportedName, pos, exportedname, 0, gssExportedName.length - pos);
        String expname = new String(exportedname, "UTF8");
        int from_idx = 0;
        while ((at_idx = expname.indexOf(64)) != -1) {
            if (at_idx == 0) {
                this.scope = expname.substring(1);
                break;
            }
            if (expname.charAt(at_idx - 1) != '\\') {
                this.username = expname.substring(0, at_idx);
                this.scope = expname.substring(at_idx + 1);
                break;
            }
            from_idx = at_idx + 1;
        }
        if (this.username.equals("") && this.scope.equals("")) {
            this.username = expname;
        }
        this.username = GSSUPExportName.removeExcape(this.username);
        this.scope = GSSUPExportName.removeExcape(this.scope);
    }

    public static String removeExcape(String str) {
        int idx = 0;
        int from_idx = 0;
        while ((idx = str.indexOf(92, from_idx)) != -1 && idx + 1 < (str = str.substring(0, idx) + str.substring(idx + 1)).length()) {
            from_idx = idx + 1;
        }
        return str;
    }

    public byte[] getExportedName() {
        return this.gssExportedName;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsername() {
        return this.username;
    }

    public String getScopedUsername() {
        if (this.scope.equals("")) {
            return this.username;
        }
        return this.username + "@" + this.scope;
    }

    public String getName() {
        return this.getUsername();
    }

    public boolean equals(Object o) {
        return o instanceof GSSUPExportName && ((GSSUPExportName)o).getUsername().equals(this.username) && ((GSSUPExportName)o).getScope().equals(this.scope);
    }

    public int hashCode() {
        return this.username.hashCode() + this.scope.hashCode();
    }

    static {
        try {
            GSSUP_MECH_OID = new ObjectIdentifier("oid:2.23.130.1.1.1".substring("oid:2.23.130.1.1.1".indexOf(58) + 1));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

