/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.transaction;

import jeus.ejb.container.OTSPolicyImpl;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.ORBUtil;
import jeus.transaction.GTID;
import jeus.transaction.ThreadContexts;
import jeus.transaction.ots.TSIdentificationImpl;
import jeus.util.ArrayListStack;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_EJB12;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CORBA.TSIdentification;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.OTSPolicy;
import org.omg.CosTransactions.OTSPolicyValueHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public abstract class InterceptorImpl
extends LocalObject
implements ClientRequestInterceptor,
ServerRequestInterceptor,
ORBReceiver {
    private static final String name = "com.sun.jts.pi.Interceptor";
    private static final int TransactionServiceId = 0;
    private static final SystemException SYS_EXC = new SystemException("", 0, CompletionStatus.COMPLETED_MAYBE){};
    public static final int NO_REPLY_SLOT = 0;
    public static final int NULL_CTX_SLOT = 1;
    public static final Integer PROPER_CTX = new Integer(0);
    public static final Integer NULL_CTX = new Integer(1);
    public static final Integer REPLY = new Integer(0);
    public static final Integer NO_REPLY = new Integer(1);
    public static final String CLIENT_POLICY_CHECKING = "jeus.ots.check_client_policy";
    public static final String INTEROP_MODE = "jeus.ots.enable";
    public static ThreadLocal otsThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            Object[] threadLocalState = new Object[]{new ArrayListStack(), new ArrayListStack()};
            return threadLocalState;
        }
    };
    public static ORB txOrb = null;
    Current pic = null;
    Codec codec = null;
    int[] slotIds = null;
    TSIdentification tsi = null;
    TSIdentificationImpl tsiImpl = null;
    Sender sender = null;
    Receiver receiver = null;
    private boolean checkPolicy = true;
    private boolean interopMode = true;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");

    public InterceptorImpl(Current pic, Codec codec, int[] slotIds, TSIdentification tsi) {
        this.pic = pic;
        this.codec = codec;
        this.slotIds = slotIds;
        this.tsi = tsi;
        this.tsiImpl = (TSIdentificationImpl)tsi;
        if (this.tsiImpl != null) {
            this.sender = this.tsiImpl.getSender();
            this.receiver = this.tsiImpl.getReceiver();
        }
        String prop = System.getProperty(CLIENT_POLICY_CHECKING, "true");
        this.checkPolicy = prop.equals("true");
        prop = System.getProperty(INTEROP_MODE, "true");
        this.interopMode = prop.equals("true");
    }

    public void setTSIdentification(TSIdentification tsi) {
        if (tsi == null) {
            return;
        }
        this.tsi = tsi;
        this.tsiImpl = (TSIdentificationImpl)tsi;
        this.sender = this.tsiImpl.getSender();
        this.receiver = this.tsiImpl.getReceiver();
    }

    public String name() {
        return name;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        try {
            TaggedComponent otsComp = null;
            try {
                otsComp = ri.get_effective_component(31);
            }
            catch (BAD_PARAM e) {
                // empty catch block
            }
            int otsPolicyValue = -1;
            if (logger.isLoggable(JeusMessage_EJB12._9068_LEVEL)) {
                logger.log(JeusMessage_EJB12._9068_LEVEL, JeusMessage_EJB12._9068, (Object)otsComp);
                Thread.dumpStack();
            }
            if (otsComp == null) {
                otsPolicyValue = OTSPolicyImpl._ADAPTS.value();
            } else {
                TypeCode typeCode = ORB.init().get_primitive_tc(TCKind.tk_short);
                Any any = null;
                try {
                    any = this.codec.decode_value(otsComp.component_data, typeCode);
                }
                catch (TypeMismatch e) {
                    e.printStackTrace();
                    throw new INTERNAL();
                }
                catch (FormatMismatch e) {
                    e.printStackTrace();
                    throw new INTERNAL();
                }
                otsPolicyValue = OTSPolicyValueHelper.extract(any);
            }
            if (this.tsiImpl == null || this.sender == null) {
                if (otsPolicyValue == 1 && this.checkPolicy) {
                    throw new TRANSACTION_UNAVAILABLE();
                }
                if (logger.isLoggable(JeusMessage_EJB12._9069_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9069_LEVEL, JeusMessage_EJB12._9069);
                }
                return;
            }
            if (otsPolicyValue == 100) {
                if (logger.isLoggable(JeusMessage_EJB12._9070_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9070_LEVEL, JeusMessage_EJB12._9070);
                }
                return;
            }
            boolean isTxAssociated = this.tsiImpl.isTxAssociated();
            if (!isTxAssociated) {
                if (otsPolicyValue == 1 && this.checkPolicy) {
                    throw new TRANSACTION_REQUIRED();
                }
                if (logger.isLoggable(JeusMessage_EJB12._9071_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9071_LEVEL, JeusMessage_EJB12._9071);
                }
                return;
            }
            if (otsPolicyValue == 2 && this.checkPolicy) {
                throw new INVALID_TRANSACTION();
            }
            PropagationContextHolder hctx = new PropagationContextHolder();
            ObjectImpl target = (ObjectImpl)ri.effective_target();
            if (target._is_local()) {
                if (logger.isLoggable(JeusMessage_EJB12._9072_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9072_LEVEL, JeusMessage_EJB12._9072, new Object[]{Thread.currentThread(), ThreadContexts.getAssociatedTransactionID()});
                }
                hctx.value = ORBUtil.dummyContext;
            } else if (!this.interopMode) {
                if (logger.isLoggable(JeusMessage_EJB12._9073_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9073_LEVEL, JeusMessage_EJB12._9073);
                }
                hctx.value = ORBUtil.nullContext;
            } else {
                this.sender.sending_request(ri.request_id(), hctx);
            }
            Any any = txOrb.create_any();
            PropagationContextHelper.insert(any, hctx.value);
            byte[] ctxData = null;
            try {
                ctxData = this.codec.encode_value(any);
            }
            catch (InvalidTypeForEncoding e) {
                throw new INTERNAL();
            }
            if (logger.isLoggable(JeusMessage_EJB12._9074_LEVEL)) {
                logger.log(JeusMessage_EJB12._9074_LEVEL, JeusMessage_EJB12._9074);
            }
            ServiceContext svc = new ServiceContext(0, ctxData);
            ri.add_request_service_context(svc, false);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        try {
            if (logger.isLoggable(JeusMessage_EJB12._9075_LEVEL)) {
                logger.log(JeusMessage_EJB12._9075_LEVEL, JeusMessage_EJB12._9075);
            }
            ServiceContext svc = null;
            try {
                svc = ri.get_reply_service_context(0);
            }
            catch (BAD_PARAM e) {
                return;
            }
            if (this.tsiImpl == null || this.sender == null) {
                throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
            }
            Any any = null;
            try {
                TypeCode typeCode = PropagationContextHelper.type();
                any = this.codec.decode_value(svc.context_data, typeCode);
            }
            catch (TypeMismatch e) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            catch (FormatMismatch e) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            PropagationContext ctx = PropagationContextHelper.extract(any);
            Environment env = this.createEnvironment();
            try {
                this.sender.received_reply(ri.request_id(), ctx, env);
            }
            catch (WrongTransaction ex) {
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_YES);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract Environment createEnvironment();

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        try {
            ServiceContext svc = null;
            try {
                svc = ri.get_reply_service_context(0);
            }
            catch (BAD_PARAM e) {
                try {
                    svc = ri.get_request_service_context(0);
                }
                catch (Exception ex) {}
            }
            catch (Exception e) {
                try {
                    svc = ri.get_request_service_context(0);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (svc == null) {
                return;
            }
            Environment env = this.createEnvironment();
            SystemException exception = null;
            Any any = ri.received_exception();
            InputStream strm = any.create_input_stream();
            String repId = ri.received_exception_id();
            strm.read_string();
            int minorCode = strm.read_long();
            CompletionStatus completionStatus = CompletionStatus.from_int((int)strm.read_long());
            if (repId.indexOf("UNKNOWN") != -1) {
                if (minorCode != 1) {
                    exception = SYS_EXC;
                }
            } else {
                exception = SYS_EXC;
            }
            env.exception((Exception)exception);
            if (this.tsiImpl == null || this.sender == null) {
                throw new TRANSACTION_ROLLEDBACK(0, completionStatus);
            }
            try {
                TypeCode typeCode = PropagationContextHelper.type();
                any = this.codec.decode_value(svc.context_data, typeCode);
            }
            catch (TypeMismatch e) {
                throw new INTERNAL(0, completionStatus);
            }
            catch (FormatMismatch e) {
                throw new INTERNAL(0, completionStatus);
            }
            PropagationContext ctx = PropagationContextHelper.extract(any);
            try {
                this.sender.received_reply(ri.request_id(), ctx, env);
            }
            catch (WrongTransaction ex) {
                throw new INVALID_TRANSACTION(0, completionStatus);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        if (logger.isLoggable(JeusMessage_EJB12._9076_LEVEL)) {
            logger.log(JeusMessage_EJB12._9076_LEVEL, JeusMessage_EJB12._9076);
        }
        try {
            ServiceContext svc = null;
            try {
                svc = ri.get_reply_service_context(0);
            }
            catch (BAD_PARAM e) {
                return;
            }
            if (this.tsiImpl == null || this.sender == null) {
                throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            }
            Any any = null;
            try {
                TypeCode typeCode = PropagationContextHelper.type();
                any = this.codec.decode_value(svc.context_data, typeCode);
            }
            catch (TypeMismatch e) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            catch (FormatMismatch e) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            PropagationContext ctx = PropagationContextHelper.extract(any);
            Environment env = this.createEnvironment();
            try {
                this.sender.received_reply(ri.request_id(), ctx, env);
            }
            catch (WrongTransaction ex) {
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        try {
            OTSPolicy otsPolicy = null;
            try {
                otsPolicy = (OTSPolicy)ri.get_server_policy(56);
            }
            catch (INV_POLICY e) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_EJB12._9077_LEVEL)) {
                logger.log(JeusMessage_EJB12._9077_LEVEL, JeusMessage_EJB12._9077, (Object)otsPolicy);
                Thread.dumpStack();
            }
            int otsPolicyValue = -1;
            otsPolicyValue = otsPolicy == null ? (int)OTSPolicyImpl._ADAPTS.value() : (int)otsPolicy.value();
            ServiceContext svc = null;
            try {
                svc = ri.get_request_service_context(0);
            }
            catch (BAD_PARAM e) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_EJB12._9078_LEVEL)) {
                logger.log(JeusMessage_EJB12._9078_LEVEL, JeusMessage_EJB12._9078, (Object)svc);
            }
            if (svc == null) {
                InterceptorImpl.setThreadLocalData(0, NO_REPLY);
            } else {
                InterceptorImpl.setThreadLocalData(0, REPLY);
            }
            InterceptorImpl.setThreadLocalData(1, PROPER_CTX);
            try {
                if (this.tsiImpl == null || this.receiver == null) {
                    if (svc != null || otsPolicyValue == 1) {
                        throw new TRANSACTION_UNAVAILABLE();
                    }
                    if (logger.isLoggable(JeusMessage_EJB12._9079_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9079_LEVEL, JeusMessage_EJB12._9079);
                    }
                    return;
                }
                if (svc == null) {
                    if (otsPolicyValue == 1) {
                        throw new TRANSACTION_REQUIRED();
                    }
                    if (logger.isLoggable(JeusMessage_EJB12._9080_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9080_LEVEL, JeusMessage_EJB12._9080);
                    }
                    return;
                }
                if (otsPolicyValue == 2) {
                    throw new INVALID_TRANSACTION();
                }
                if (svc.context_id != 0) {
                    throw new INVALID_TRANSACTION();
                }
                Any any = null;
                try {
                    TypeCode typeCode = PropagationContextHelper.type();
                    any = this.codec.decode_value(svc.context_data, typeCode);
                }
                catch (TypeMismatch e) {
                    throw new INTERNAL();
                }
                catch (FormatMismatch e) {
                    throw new INTERNAL();
                }
                PropagationContext ctx = PropagationContextHelper.extract(any);
                if (InterceptorImpl.isDummyContext(ctx)) {
                    GTID gtid = ThreadContexts.getAssociatedTransactionID();
                    if (logger.isLoggable(JeusMessage_EJB12._9081_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9081_LEVEL, JeusMessage_EJB12._9081, new Object[]{Thread.currentThread(), gtid, Utility.getDump((byte[])gtid.toBytes())});
                    }
                    InterceptorImpl.getThreadLocalData(0);
                    InterceptorImpl.setThreadLocalData(0, NO_REPLY);
                    return;
                }
                if (InterceptorImpl.isNullContext(ctx)) {
                    if (logger.isLoggable(JeusMessage_EJB12._9082_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9082_LEVEL, JeusMessage_EJB12._9082);
                    }
                    InterceptorImpl.getThreadLocalData(1);
                    InterceptorImpl.setThreadLocalData(1, NULL_CTX);
                    InterceptorImpl.getThreadLocalData(0);
                    InterceptorImpl.setThreadLocalData(0, NO_REPLY);
                    return;
                }
                if (!this.interopMode) {
                    if (logger.isLoggable(JeusMessage_EJB12._9083_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9083_LEVEL, JeusMessage_EJB12._9083);
                    }
                    InterceptorImpl.getThreadLocalData(1);
                    InterceptorImpl.setThreadLocalData(1, NULL_CTX);
                }
                this.receiver.received_request(ri.request_id(), ctx);
                if (logger.isLoggable(JeusMessage_EJB12._9084_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9084_LEVEL, JeusMessage_EJB12._9084);
                }
            }
            catch (RuntimeException r) {
                InterceptorImpl.getThreadLocalData(0);
                InterceptorImpl.getThreadLocalData(1);
                throw r;
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    private void processServerSendPoint(ServerRequestInfo ri, CompletionStatus completionStatus) {
        InterceptorImpl.getThreadLocalData(1);
        Integer no_reply = InterceptorImpl.getThreadLocalData(0);
        if (no_reply == NO_REPLY) {
            if (logger.isLoggable(JeusMessage_EJB12._9085_LEVEL)) {
                logger.log(JeusMessage_EJB12._9085_LEVEL, JeusMessage_EJB12._9085);
            }
            return;
        }
        if (this.tsiImpl == null || this.receiver == null) {
            if (no_reply == REPLY) {
                throw new TRANSACTION_ROLLEDBACK(0, completionStatus);
            }
            if (logger.isLoggable(JeusMessage_EJB12._9086_LEVEL)) {
                logger.log(JeusMessage_EJB12._9086_LEVEL, JeusMessage_EJB12._9086);
            }
            return;
        }
        PropagationContextHolder ctxh = new PropagationContextHolder();
        this.receiver.sending_reply(ri.request_id(), ctxh);
        if (ctxh.value == null) {
            throw new TRANSACTION_ROLLEDBACK(0, completionStatus);
        }
        Any any = txOrb.create_any();
        PropagationContextHelper.insert(any, ctxh.value);
        byte[] ctxData = null;
        try {
            ctxData = this.codec.encode_value(any);
        }
        catch (InvalidTypeForEncoding e) {
            throw new INTERNAL(0, completionStatus);
        }
        ServiceContext svc = new ServiceContext(0, ctxData);
        if (logger.isLoggable(JeusMessage_EJB12._9087_LEVEL)) {
            logger.log(JeusMessage_EJB12._9087_LEVEL, JeusMessage_EJB12._9087);
        }
        ri.add_reply_service_context(svc, false);
    }

    public void send_reply(ServerRequestInfo ri) {
        if (logger.isLoggable(JeusMessage_EJB12._9088_LEVEL)) {
            logger.log(JeusMessage_EJB12._9088_LEVEL, JeusMessage_EJB12._9088);
        }
        try {
            this.processServerSendPoint(ri, CompletionStatus.COMPLETED_YES);
            if (logger.isLoggable(JeusMessage_EJB12._9089_LEVEL)) {
                logger.log(JeusMessage_EJB12._9089_LEVEL, JeusMessage_EJB12._9089);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        if (logger.isLoggable(JeusMessage_EJB12._9090_LEVEL)) {
            logger.log(JeusMessage_EJB12._9090_LEVEL, JeusMessage_EJB12._9090);
        }
        try {
            Any any = ri.sending_exception();
            InputStream strm = any.create_input_stream();
            strm.read_string();
            strm.read_long();
            CompletionStatus completionStatus = CompletionStatus.from_int((int)strm.read_long());
            this.processServerSendPoint(ri, completionStatus);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        if (logger.isLoggable(JeusMessage_EJB12._9091_LEVEL)) {
            logger.log(JeusMessage_EJB12._9091_LEVEL, JeusMessage_EJB12._9091);
        }
        try {
            this.processServerSendPoint(ri, CompletionStatus.COMPLETED_NO);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isTxCtxtNull() {
        Object[] threadLocalState = (Object[])otsThreadLocal.get();
        ArrayListStack stack = (ArrayListStack)threadLocalState[1];
        return (Integer)stack.peek() == NULL_CTX;
    }

    public static boolean isNullContext(PropagationContext ctx) {
        return ctx.current.coord == null && ctx.current.term == null;
    }

    public static boolean isDummyContext(PropagationContext ctx) {
        boolean proceed = false;
        try {
            proceed = ctx.implementation_specific_data.extract_long() == 9736;
        }
        catch (BAD_OPERATION e) {
            return false;
        }
        return proceed && InterceptorImpl.isNullContext(ctx) && ctx.timeout == -1;
    }

    public static void setThreadLocalData(int slot, Integer data) {
        Object[] threadLocalState = (Object[])otsThreadLocal.get();
        ((ArrayListStack)threadLocalState[slot]).push((Object)data);
    }

    public static Integer getThreadLocalData(int slot) {
        Object[] threadLocalState = (Object[])otsThreadLocal.get();
        return (Integer)((ArrayListStack)threadLocalState[slot]).pop();
    }

    public void setORB(ORB orb) {
        txOrb = orb;
    }
}

