/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableWrapper
implements Serializable {
    private Class cls;
    private transient Object target;

    public SerializableWrapper(Object target) {
        this.target = target;
        if (target != null) {
            this.cls = target.getClass();
        }
    }

    public Object getObject() {
        return this.target;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.cls == null) {
            return;
        }
        if (Serializable.class.isAssignableFrom(this.cls)) {
            stream.writeObject(this.target);
        } else {
            Collection<Field> fields = SerializableWrapper.getSerializationTargetFields(this.cls);
            for (final Field f : fields) {
                try {
                    Object value = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (!f.isAccessible()) {
                                f.setAccessible(true);
                            }
                            return f.get(SerializableWrapper.this.target);
                        }
                    });
                    stream.writeObject(value);
                }
                catch (Throwable t) {
                    IOException ex = new IOException();
                    ex.initCause(t);
                    throw ex;
                }
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.cls == null) {
            return;
        }
        if (Serializable.class.isAssignableFrom(this.cls)) {
            this.target = stream.readObject();
        } else {
            Collection<Field> fields = SerializableWrapper.getSerializationTargetFields(this.cls);
            try {
                this.target = this.cls.newInstance();
            }
            catch (Throwable t) {
                IOException ex = new IOException();
                ex.initCause(t);
                throw ex;
            }
            for (final Field f : fields) {
                final Object value = stream.readObject();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (!f.isAccessible()) {
                                f.setAccessible(true);
                            }
                            f.set(SerializableWrapper.this.target, value);
                            return null;
                        }
                    });
                }
                catch (Throwable t) {
                    IOException ex = new IOException();
                    ex.initCause(t);
                    throw ex;
                }
            }
        }
    }

    private static Collection<Field> getSerializationTargetFields(Class cls) {
        TreeMap<String, Field> fieldsMap = new TreeMap<String, Field>();
        for (Field f : cls.getDeclaredFields()) {
            int mods = f.getModifiers();
            if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
            fieldsMap.put(f.getName(), f);
        }
        return fieldsMap.values();
    }
}

