/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBException;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.security.SecurityAnnotationInfo;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EnterpriseBeanType;
import jeus.ejb.ReplicationMode;
import jeus.ejb.metadata.InterceptorBindingInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.TxAttrTable;
import jeus.ejb.util.MethodConvertor;
import jeus.ejb.util.MethodTable;
import jeus.util.StringUtil;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.ejbHelper.FindMethodPair;
import jeus.xml.binding.j2ee.SecurityRoleRefType;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;
import jeus.xml.binding.jeusDD.ExportIiopType;
import jeus.xml.binding.jeusDD.InvokeHttpType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ObjectManagementType;
import jeus.xml.binding.jeusDD.RunAsIdentityType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import jeus.xml.binding.jeusDD.ServiceClientType;
import jeus.xml.binding.webservicesHelper.WebservicesPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanInfo {
    protected EnterpriseBeanType ejbType;
    protected String beanName;
    private Class beanClass;
    protected ModuleInfo moduleInfo;
    protected JeusBeanType jeusBean;
    protected ObjectManagementType objectManagementType;
    protected String home;
    protected String localHome;
    protected String remote;
    protected String local;
    protected String mappedJndiName;
    protected String remoteEjbHomeJndiName;
    protected String localEjbHomeJndiName;
    protected String homeImpl;
    protected String localHomeImpl;
    protected String objectImpl;
    protected String localObjectImpl;
    protected String iiopEjbHomeImplClassName;
    protected String iiopEjbObjectImplClassName;
    protected Method timeoutMethod;
    protected boolean beanManagedTx;
    protected TxAttrTable txAttrTable;
    private TransactionAttributeType unspecifiedTransactionType;
    protected List<ServiceRefType> serviceRefs;
    protected NamingEnvironment beanNamingEnv;
    protected List serviceRefPairs;
    protected List<SecurityRoleRefType> securityRoleRefs;
    protected String runAsRole;
    protected InterceptorBindingInfo classInterceptorBinding;
    protected InterceptorInfo beanClassInterceptorInfo;
    protected Map<Method, InterceptorBindingInfo> methodInterceptorBindingMap = new HashMap<Method, InterceptorBindingInfo>();
    private SecurityAnnotationInfo securityAnnotationInfo;
    protected MethodTable remoteIdempotentMethods;
    protected MethodTable homeIdempotentMethods;
    protected MethodTable replicationModeOfMethods;
    protected ReplicationMode replicationModeOfBean = ReplicationMode.SYNC;
    protected boolean isClustered = false;

    protected BeanInfo(String beanName, Class beanClass, EnterpriseBeanType ejbType) {
        this.beanName = beanName;
        this.ejbType = ejbType;
        this.beanClass = beanClass;
    }

    public void setReplicationModeOfBean(ReplicationMode replicationModeOfBean) {
        this.replicationModeOfBean = replicationModeOfBean;
    }

    public ReplicationMode getReplicationModeOfBean() {
        return this.replicationModeOfBean;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public EnterpriseBeanType getEJBType() {
        return this.ejbType;
    }

    void setBeanClass(Class cls) {
        this.beanClass = cls;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getBeanClassFullName() {
        return this.beanClass.getName();
    }

    public String getBeanClassSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public String getEJBHomeClassName() {
        return this.home;
    }

    public void setEJBHomeClassName(String className) {
        this.home = className;
    }

    public String getEJBObjectClassName() {
        return this.remote;
    }

    public void setEJBObjectClassName(String className) {
        this.remote = className;
    }

    public String getEJBLocalHomeClassName() {
        return this.localHome;
    }

    public void setEJBLocalHomeClassName(String defaultlocalhomeclassname) {
        this.localHome = defaultlocalhomeclassname;
    }

    public String getEJBLocalObjectClassName() {
        return this.local;
    }

    public void setEJBLocalObjectClassName(String defaultlocalobjectclassname) {
        this.local = defaultlocalobjectclassname;
    }

    public void setEJBHomeImplClassName(String homeImpl) {
        this.homeImpl = homeImpl;
    }

    public void setEJBObjectImplClassName(String objectImpl) {
        this.objectImpl = objectImpl;
    }

    public void setEJBLocalHomeImplClassName(String localHomeImpl) {
        this.localHomeImpl = localHomeImpl;
    }

    public void setEJBLocalObjectImplClassName(String localObjectImpl) {
        this.localObjectImpl = localObjectImpl;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public void setModuleInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(Method timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public boolean isContainerManagedTx() {
        return !this.beanManagedTx;
    }

    public boolean isBeanManagedTx() {
        return this.beanManagedTx;
    }

    public void setBeanManagedTx(boolean isBeanManagedTx) {
        this.beanManagedTx = isBeanManagedTx;
    }

    public TxAttrTable getTxAttrTable() {
        if (this.txAttrTable == null) {
            this.txAttrTable = new TxAttrTable(this.getUnspecifiedTransactionType());
        }
        return this.txAttrTable;
    }

    public List<ServiceRefType> getServiceRefs() {
        return this.serviceRefs;
    }

    public void setServiceRefs(List<ServiceRefType> serviceRefs) {
        this.serviceRefs = serviceRefs;
    }

    public List<SecurityRoleRefType> getRoleLinkList() {
        return this.securityRoleRefs;
    }

    public void setRoleLinkList(List<SecurityRoleRefType> securityRoleRefs) {
        this.securityRoleRefs = securityRoleRefs;
    }

    public NamingEnvironment getBeanNamingEnvironment() {
        if (this.beanNamingEnv == null) {
            this.beanNamingEnv = new NamingEnvironment();
        }
        return this.beanNamingEnv;
    }

    public void setBeanNamingEnvironment(NamingEnvironment beanClassNamingEnv) {
        this.beanNamingEnv = beanClassNamingEnv;
    }

    public JeusBeanType getJeusBeanType() {
        return this.jeusBean;
    }

    public void setJeusBean(JeusBeanType jeusBean) throws EJBDeploymentException {
        this.jeusBean = jeusBean;
        this.objectManagementType = jeusBean != null ? jeusBean.getObjectManagement() : null;
    }

    public InterceptorBindingInfo getClassInterceptorBinding() {
        return this.classInterceptorBinding;
    }

    public void setClassInterceptorBinding(InterceptorBindingInfo bindingInfo) {
        this.classInterceptorBinding = bindingInfo;
    }

    public InterceptorInfo getBeanClassInterceptorInfo() {
        if (this.beanClassInterceptorInfo == null) {
            assert (this.beanClass != null);
            this.beanClassInterceptorInfo = new InterceptorInfo(this.beanClass);
        }
        return this.beanClassInterceptorInfo;
    }

    public void setMethodInterceptorBinding(Method m, InterceptorBindingInfo bindingInfo) {
        this.methodInterceptorBindingMap.put(m, bindingInfo);
    }

    public InterceptorBindingInfo getMethodInterceptorBinding(Method m) {
        return this.methodInterceptorBindingMap.get(m);
    }

    public Map<Method, InterceptorBindingInfo> getMethodInterceptorBindingMap() {
        return this.methodInterceptorBindingMap;
    }

    public boolean isEntityBean() {
        return this.ejbType == EnterpriseBeanType.ENTITY;
    }

    public abstract boolean isConManagedEntityBean();

    public abstract boolean isAutoKeyGenerator();

    public boolean isInvocationWithHttp() {
        return this.jeusBean.getInvokeHttp() != null;
    }

    public void setInvocationWithHttp(String httpURL, int httpPort) throws JAXBException {
        ObjectFactory objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
        InvokeHttpType invokeHttpType = objectFactory.createInvokeHttpType();
        invokeHttpType.setUrl(httpURL);
        invokeHttpType.setHttpPort(Integer.valueOf(httpPort));
        this.jeusBean.setInvokeHttp(invokeHttpType);
    }

    public boolean getExportIIOP() {
        return this.jeusBean.getExportIiop() != null;
    }

    public ExportIiopType getExportIiopType() {
        return this.jeusBean.getExportIiop();
    }

    public ClusteringType getClusterDesc() {
        return this.jeusBean.getClustering();
    }

    public static boolean matchMethod(FindMethodPair methodPair, Method m) {
        String methodName = methodPair.getMethodName();
        ArrayList paramList = methodPair.getMethodParams();
        if (!methodName.equals(m.getName())) {
            return false;
        }
        Class<?>[] paramClasses = m.getParameterTypes();
        if (paramClasses.length != paramList.size()) {
            return false;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            String paramValueType = (String)paramList.get(i);
            if (paramValueType.equals(MethodConvertor.translateToParamType(paramClasses[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchMethod(MethodParamType methodParamType, Method m) {
        MethodParamsType methodParamsType;
        List paramList;
        String methodName = methodParamType.getMethodName();
        if (!methodName.equals(m.getName())) {
            return false;
        }
        Class<?>[] paramClasses = m.getParameterTypes();
        if (paramClasses.length != (paramList = (methodParamsType = methodParamType.getMethodParams()) != null ? methodParamsType.getMethodParam() : Collections.EMPTY_LIST).size()) {
            return false;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            String paramValueType = (String)paramList.get(i);
            if (paramValueType.equals(MethodConvertor.translateToParamType(paramClasses[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchMethodInList(List ejbHomeIdempotentMethods, Method method) {
        for (int i = 0; i < ejbHomeIdempotentMethods.size(); ++i) {
            MethodParamType methodParamType = (MethodParamType)ejbHomeIdempotentMethods.get(i);
            if (!BeanInfo.matchMethod(methodParamType, method)) continue;
            return true;
        }
        return false;
    }

    public SecurityInteropType getEJBCSIDescriptor() {
        return this.jeusBean.getSecurityInterop();
    }

    public String getEJBObjectImplClassName() {
        return this.objectImpl;
    }

    public String getEJBHomeImplClassName() {
        return this.homeImpl;
    }

    public int getExportPort() {
        if (this.jeusBean.getExportPort() > 0) {
            return this.jeusBean.getExportPort();
        }
        if (this.isInvocationWithHttp()) {
            return 0;
        }
        if (this.useJeusRmi()) {
            return JeusEJBProperties.EJB_DEFAULT_EXPORT_PORT_FOR_JEUSRMI;
        }
        return JeusEJBProperties.EJB_DEFAULT_EXPORT_PORT;
    }

    public String getMappedJndiName() {
        return this.mappedJndiName;
    }

    public void setMappedJndiName(String mappedJndiName) {
        assert (!StringUtil.isNullOrEmpty((String)mappedJndiName));
        this.mappedJndiName = mappedJndiName;
    }

    public String getRemoteEjbHomeJndiName() {
        return this.remoteEjbHomeJndiName;
    }

    public void setRemoteEjbHomeJndiName(String remoteEjbHomeJndiName) {
        this.remoteEjbHomeJndiName = remoteEjbHomeJndiName;
    }

    public String getLocalEjbHomeJndiName() {
        return this.localEjbHomeJndiName;
    }

    public void setLocalEjbHomeJndiName(String localEjbHomeJndiName) {
        this.localEjbHomeJndiName = localEjbHomeJndiName;
    }

    public String getJndiName(String interfaze, Boolean isRemote) {
        assert (interfaze != null || isRemote != null);
        if (this.hasRemoteEjbHome()) {
            if (interfaze != null && interfaze.equals(this.getEJBHomeClassName())) {
                return this.getRemoteEjbHomeJndiName();
            }
            if (interfaze == null && isRemote.booleanValue()) {
                return this.getRemoteEjbHomeJndiName();
            }
        }
        if (this.hasLocalEjbHome()) {
            if (interfaze != null && interfaze.equals(this.getEJBLocalHomeClassName())) {
                return this.getLocalEjbHomeJndiName();
            }
            if (interfaze == null && !isRemote.booleanValue()) {
                return this.getLocalEjbHomeJndiName();
            }
        }
        return null;
    }

    public String getExportName() {
        return this.jeusBean.getExportName();
    }

    public boolean hasRemoteEjbHome() {
        return this.home != null;
    }

    public boolean hasLocalEjbHome() {
        return this.localHome != null;
    }

    public boolean hasRemoteView() {
        return this.hasRemoteEjbHome();
    }

    public boolean hasLocalView() {
        return this.hasLocalEjbHome();
    }

    public boolean isLocalInvocationOptimized() {
        return this.jeusBean.isLocalInvokeOptimize();
    }

    public String getLocalExportName() {
        return this.jeusBean.getLocalExportName();
    }

    public String getEJBLocalObjectImplClassName() {
        return this.localObjectImpl;
    }

    public String getEJBLocalHomeImplClassName() {
        return this.localHomeImpl;
    }

    public Long getPassivationTimeout() {
        return this.objectManagementType.getPassivationTimeout();
    }

    public boolean isSingleVMOnly() {
        return this.jeusBean.isSingleVmOnly();
    }

    public Long getDisconnectTimeout() {
        return this.objectManagementType.getDisconnectTimeout();
    }

    public String getModuleName() {
        return this.moduleInfo.getModuleName();
    }

    public String getHttpURL() {
        return this.jeusBean.getInvokeHttp().getUrl();
    }

    public int getHttpPort() {
        return this.jeusBean.getInvokeHttp().getHttpPort();
    }

    public int getThreadPoolMax() {
        return this.jeusBean.getThreadMax();
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public void setRunAsRole(String runAsRole) {
        this.runAsRole = runAsRole;
    }

    public SecurityAnnotationInfo getSecurityAnnotationInfo() {
        return this.securityAnnotationInfo;
    }

    public void setSecurityAnnotationInfo(SecurityAnnotationInfo annotationInfo) {
        this.securityAnnotationInfo = annotationInfo;
        this.runAsRole = this.securityAnnotationInfo.getRunAsRole();
    }

    public String getJeusDDRunAsName() {
        RunAsIdentityType type = this.jeusBean.getRunAsIdentity();
        if (type != null) {
            return type.getPrincipalName();
        }
        return null;
    }

    public int getCapacity() {
        return this.objectManagementType.getCapacity();
    }

    public int getEJBBeanPoolSize() {
        return this.objectManagementType.getBeanPool().getPoolMin();
    }

    public int getEJBBeanPoolMax() {
        return this.objectManagementType.getBeanPool().getPoolMax();
    }

    public int getConnectPoolSize() {
        return this.objectManagementType.getConnectPool().getPoolMin();
    }

    public int getConnectPoolMax() {
        return this.objectManagementType.getConnectPool().getPoolMax();
    }

    public long getConnectPoolResizingPeriod() {
        return this.objectManagementType.getConnectPool().getResizingPeriod();
    }

    public boolean isUseAccessControl() {
        return this.jeusBean.isUseAccessControl();
    }

    public String getSecurityPolicyID() {
        return this.moduleInfo.getModuleName();
    }

    public DurableTimerServiceType getDurableTimerSetting() {
        return this.jeusBean.getDurableTimerService();
    }

    public TransactionAttributeType getUnspecifiedTransactionType() {
        if (this.unspecifiedTransactionType == null) {
            String property;
            this.unspecifiedTransactionType = this.moduleInfo.getUnspecifiedTransactionType();
            if (this.unspecifiedTransactionType == null && (property = JeusEJBProperties.DEFAULT_EJB_TX_ATTRIBUTE) != null) {
                this.unspecifiedTransactionType = this.getTransactionAttribute(property);
            }
            if (this.unspecifiedTransactionType == null) {
                this.unspecifiedTransactionType = this.moduleInfo.ejbVersion >= 3.0 ? TransactionAttributeType.REQUIRED : (this.ejbType == EnterpriseBeanType.MESSAGE_DRIVEN ? TransactionAttributeType.NOT_SUPPORTED : TransactionAttributeType.SUPPORTS);
            }
        }
        return this.unspecifiedTransactionType;
    }

    protected TransactionAttributeType getTransactionAttribute(String transAttr) {
        if (transAttr != null) {
            if (transAttr.equals("NotSupported")) {
                return TransactionAttributeType.NOT_SUPPORTED;
            }
            if (transAttr.equals("Supports")) {
                return TransactionAttributeType.SUPPORTS;
            }
            if (transAttr.equals("Required")) {
                return TransactionAttributeType.REQUIRED;
            }
            if (transAttr.equals("RequiresNew")) {
                return TransactionAttributeType.REQUIRES_NEW;
            }
            if (transAttr.equals("Mandatory")) {
                return TransactionAttributeType.MANDATORY;
            }
            if (transAttr.equals("Never")) {
                return TransactionAttributeType.NEVER;
            }
        }
        return null;
    }

    public WebservicesPair getWebservicesPair() {
        return this.moduleInfo.getWebservicesPair();
    }

    public long getEJBBeanResizingPeriod() {
        return this.objectManagementType.getBeanPool().getResizingPeriod();
    }

    public String getIIOPEJBHomeImplClassName() {
        return this.iiopEjbHomeImplClassName;
    }

    public String getIIOPEJBObjectImplClassName() {
        return this.iiopEjbObjectImplClassName;
    }

    public void setIIOPEJBHomeImplClassName(String s) {
        this.iiopEjbHomeImplClassName = s;
    }

    public void setIIOPEJBObjectImplClassName(String s) {
        this.iiopEjbObjectImplClassName = s;
    }

    public List getServiceRefPairs() {
        return this.serviceRefPairs;
    }

    public void setServiceRefPairs(List serviceRefPairs) {
        this.serviceRefPairs = serviceRefPairs;
    }

    public ServiceClientType getWebservicesClientDD(ServiceRefType serviceRef) throws EJBDescriptorValidationException {
        String refName = serviceRef.getServiceRefName().getValue();
        JeusWebservicesClientDdType wsclientDD = this.jeusBean.getServiceRef();
        if (wsclientDD != null) {
            List list = wsclientDD.getServiceClient();
            for (int i = 0; i < list.size(); ++i) {
                ServiceClientType serviceClient = (ServiceClientType)list.get(i);
                if (!refName.equals(serviceClient.getServiceRefName())) continue;
                return serviceClient;
            }
        }
        return null;
    }

    public String getEJBRefJndiNameFromDD(String refName) {
        JndiRefType jndiRef = this.jeusBean.getEjbRef();
        if (jndiRef != null) {
            List jndiInfoList = jndiRef.getJndiInfo();
            for (JndiInfoType jndiInfo : jndiInfoList) {
                if (!refName.equals(jndiInfo.getRefName())) continue;
                return jndiInfo.getExportName();
            }
        }
        return null;
    }

    public String[] getHomeImplStubInterfaces() {
        return new String[]{this.home};
    }

    public MethodTable getRemoteIdempotentMethods() {
        if (this.remoteIdempotentMethods == null) {
            this.remoteIdempotentMethods = new MethodTable();
        }
        return this.remoteIdempotentMethods;
    }

    public void setRemoteIdempotentMethods(MethodTable remoteIdempotentMethods) {
        this.remoteIdempotentMethods = remoteIdempotentMethods;
    }

    public MethodTable getHomeIdempotentMethods() {
        if (this.homeIdempotentMethods == null) {
            this.homeIdempotentMethods = new MethodTable();
        }
        return this.homeIdempotentMethods;
    }

    public void setHomeIdempotentMethods(MethodTable homeIdempotentMethods) {
        this.homeIdempotentMethods = homeIdempotentMethods;
    }

    public MethodTable getReplicationModeOfMethods() {
        if (this.replicationModeOfMethods == null) {
            this.replicationModeOfMethods = new MethodTable();
        }
        return this.replicationModeOfMethods;
    }

    public void setReplicationModeOfMethods(MethodTable table) {
        this.replicationModeOfMethods = table;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public boolean useJeusRmi() {
        if (this.jeusBean.isSetJeusRmi()) {
            return this.jeusBean.isJeusRmi();
        }
        return JeusEJBProperties.JEUS_RMI;
    }
}

