/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.MessageListener;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EnterpriseBeanType;
import jeus.ejb.metadata.BeanInfo;
import jeus.jndi.JNSContextFactory;
import jeus.xml.binding.jeusDD.ActivationConfigPropertyType;
import jeus.xml.binding.jeusDD.ActivationConfigType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JndiSpiType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDrivenBeanInfo
extends BeanInfo {
    public static final Class DEFAULT_MESSAGE_LISTENER_INTERFACE = MessageListener.class;
    protected Class listenerInterface;
    protected Map<String, String> activationConfigProperties = new HashMap<String, String>();
    protected String destinationType;
    protected String destinationLink;
    protected String ackMode;
    protected String messageSelector;
    protected String destination;
    protected String durability;
    protected String connectionFactoryName;
    protected String clientId;
    protected String subscriptionName;

    MessageDrivenBeanInfo(String beanName, Class beanClass) {
        super(beanName, beanClass, EnterpriseBeanType.MESSAGE_DRIVEN);
    }

    public void addActivationConfigProperty(String name, String value) {
        this.activationConfigProperties.put(name, value);
    }

    public String getActivationConfigProperty(String name) {
        return this.activationConfigProperties.get(name);
    }

    public Set<String> getActivationConfigPropertyKeys() {
        return this.activationConfigProperties.keySet();
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationLink() {
        return this.destinationLink;
    }

    public void setDestinationLink(String destinationLink) {
        this.destinationLink = destinationLink;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @Override
    public void setJeusBean(JeusBeanType jeusBean) throws EJBDeploymentException {
        super.setJeusBean(jeusBean);
        if (jeusBean != null) {
            this.initActivationConfig();
        }
    }

    private void initActivationConfig() throws EJBDeploymentException {
        ActivationConfigType activationConfig = this.jeusBean.getActivationConfig();
        if (activationConfig != null) {
            for (ActivationConfigPropertyType property : activationConfig.getActivationConfigProperty()) {
                String name = property.getActivationConfigPropertyName();
                String value = property.getActivationConfigPropertyValue();
                this.addActivationConfigProperty(name, value);
            }
        }
        if (this.destinationType == null) {
            this.destinationType = this.activationConfigProperties.get("destinationType");
        }
        if (this.jeusBean.isSetDestination()) {
            this.destination = this.jeusBean.getDestination();
        } else if (this.mappedJndiName != null) {
            this.destination = this.mappedJndiName;
        } else if (this.destinationLink != null) {
            this.destination = this.moduleInfo.getMessageDestinationJndiName(this.destinationLink);
        }
        if (this.jeusBean.getMdbResourceAdapterName() == null && this.destination == null) {
            throw new EJBDeploymentException("There is no destination or endpoint: the destination or resource adapter should be specified", "", this.beanName);
        }
        this.ackMode = this.jeusBean.isSetAckMode() ? this.jeusBean.getAckMode().value() : this.activationConfigProperties.get("acknowledgeMode");
        if (this.ackMode == null) {
            this.ackMode = "Auto-acknowledge";
        }
        this.messageSelector = this.jeusBean.isSetMsgSelector() ? this.jeusBean.getMsgSelector() : this.activationConfigProperties.get("messageSelector");
        this.durability = this.jeusBean.isSetDurable() ? this.jeusBean.getDurable().value() : this.activationConfigProperties.get("subscriptionDurability");
        if (this.durability == null) {
            this.durability = "NonDurable";
        }
        if (this.jeusBean.isSetConnectionFactoryName()) {
            this.connectionFactoryName = this.jeusBean.getConnectionFactoryName();
        } else if (this.connectionFactoryName == null) {
            this.connectionFactoryName = this.activationConfigProperties.get("jeus.connectionFactoryName");
        }
        this.clientId = this.activationConfigProperties.get("jeus.cliendId");
        if (this.clientId == null) {
            this.clientId = this.getModuleName() + "/" + this.getBeanName();
        }
        this.subscriptionName = this.activationConfigProperties.get("jeus.subscriptionName");
        if (this.subscriptionName == null) {
            this.subscriptionName = this.getModuleName() + "/" + this.getBeanName();
        }
    }

    @Override
    public boolean isConManagedEntityBean() {
        return false;
    }

    @Override
    public boolean isAutoKeyGenerator() {
        return false;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isDurable() {
        return this.durability.equals("Durable");
    }

    public int getMaxMessage() {
        return this.jeusBean.getMaxMessage();
    }

    public int getAckMode() {
        if (this.ackMode.equals("Dups-ok-acknowledge")) {
            return 3;
        }
        return 1;
    }

    public Class getListenerInterface() {
        return this.listenerInterface != null ? this.listenerInterface : DEFAULT_MESSAGE_LISTENER_INTERFACE;
    }

    public void setListenerInterface(Class listenerInterface) {
        this.listenerInterface = listenerInterface;
    }

    public String getInitialContextFactory() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getInitialContextFactory();
        }
        return JNSContextFactory.class.getName();
    }

    public String getProviderURL() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getProviderUrl();
        }
        return null;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public String getVendor() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getMqVendor().value();
        }
        return null;
    }

    public String getCorrespondResourceAdapter() {
        return this.jeusBean.getMdbResourceAdapterName();
    }

    public boolean useResourceAdapter() {
        return this.jeusBean.getMdbResourceAdapterName() != null;
    }
}

