/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.descriptor;

import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.InvalidDescriptorException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.descriptor.EJBDescProcessor;
import jeus.xml.binding.j2ee.AcknowledgeModeType;
import jeus.xml.binding.j2ee.ActivationConfigPropertyType;
import jeus.xml.binding.j2ee.ActivationConfigType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.MessageDestinationLinkType;
import jeus.xml.binding.j2ee.MessageDestinationTypeType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.MessageDrivenDestinationType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.RunAsType;
import jeus.xml.binding.j2ee.SecurityIdentityType;
import jeus.xml.binding.j2ee.SubscriptionDurabilityType;

public class MDBDescProcessor
extends EJBDescProcessor {
    public MDBDescProcessor(ModuleInfo moduleInfo) {
        super(moduleInfo);
    }

    public void process(MessageDrivenBeanType bean, MessageDrivenBeanInfo beanInfo) throws InvalidDescriptorException {
        RoleNameType roleNameType;
        RunAsType runAsType;
        MessageDrivenDestinationType desType;
        AcknowledgeModeType ackMode;
        String selector;
        ActivationConfigType activationConfig;
        MessageDestinationLinkType destinationLink;
        FullyQualifiedClassType messagingType;
        assert (beanInfo != null);
        Class ejbClass = beanInfo.getBeanClass();
        if (ejbClass == null) {
            throw new InvalidDescriptorException("<ejb-class> is not defined");
        }
        if (bean.isSetMappedName()) {
            beanInfo.setMappedJndiName(bean.getMappedName().getValue().trim());
        }
        if ((messagingType = bean.getMessagingType()) != null) {
            Class<?> listenerClass;
            String clsName = messagingType.getValue().trim();
            try {
                listenerClass = this.loader.loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException("there is no " + clsName + " class");
            }
            beanInfo.setListenerInterface(listenerClass);
        }
        this.processTimeoutMethod(bean.getTimeoutMethod(), ejbClass, beanInfo);
        this.processTransactionType(bean.getTransactionType(), beanInfo);
        MessageDestinationTypeType destinationType = bean.getMessageDestinationType();
        if (destinationType != null) {
            beanInfo.setDestinationType(destinationType.getValue());
        }
        if ((destinationLink = bean.getMessageDestinationLink()) != null) {
            beanInfo.setDestinationLink(destinationLink.getValue());
        }
        if ((activationConfig = bean.getActivationConfig()) != null) {
            for (ActivationConfigPropertyType property : activationConfig.getActivationConfigProperty()) {
                beanInfo.addActivationConfigProperty(property.getActivationConfigPropertyName().getValue(), property.getActivationConfigPropertyValue().getValue());
            }
        }
        if ((selector = bean.getMessageSelector()) != null && beanInfo.getActivationConfigProperty("messageSelector") == null) {
            beanInfo.addActivationConfigProperty("messageSelector", selector);
        }
        if ((ackMode = bean.getAcknowledgeMode()) != null && beanInfo.getActivationConfigProperty("acknowledgeMode") == null) {
            beanInfo.addActivationConfigProperty("acknowledgeMode", ackMode.value());
        }
        if ((desType = bean.getMessageDrivenDestination()) != null) {
            SubscriptionDurabilityType durabilityType;
            if (beanInfo.getActivationConfigProperty("destinationType") == null) {
                beanInfo.addActivationConfigProperty("destinationType", desType.getDestinationType().value());
            }
            if ((durabilityType = desType.getSubscriptionDurability()) != null && beanInfo.getActivationConfigProperty("subscriptionDurability") == null) {
                beanInfo.addActivationConfigProperty("subscriptionDurability", durabilityType.value());
            }
        }
        InterceptorInfo beanClsInterceptorInfo = beanInfo.getBeanClassInterceptorInfo();
        if (bean.isSetAroundInvoke()) {
            this.processAroundInvokeMethod(bean.getAroundInvoke(), ejbClass, beanClsInterceptorInfo);
        }
        if (bean.isSetPostConstruct()) {
            this.processLifecycleCallbackMethod(CallbackType.POST_CONSTRUCT, bean.getPostConstruct(), null, ejbClass, beanClsInterceptorInfo);
        }
        if (bean.isSetPreDestroy()) {
            this.processLifecycleCallbackMethod(CallbackType.PRE_DESTROY, bean.getPreDestroy(), null, ejbClass, beanClsInterceptorInfo);
        }
        NamingEnvironment env = beanInfo.getBeanNamingEnvironment();
        JndiEnvironmentRefsGroup envRefs = new JndiEnvironmentRefsGroup();
        envRefs.simpleEnvEntryList = bean.getEnvEntry();
        envRefs.ejbRefList = bean.getEjbRef();
        envRefs.ejbLocalRefList = bean.getEjbLocalRef();
        if (beanInfo.getModuleInfo().getEjbVersion() > 2.1) {
            envRefs.serviceRefList = bean.getServiceRef();
        }
        envRefs.resourceRefList = bean.getResourceRef();
        envRefs.resourceEnvRefList = bean.getResourceEnvRef();
        envRefs.messageDestinationRefList = bean.getMessageDestinationRef();
        envRefs.persistenceContextRefList = bean.getPersistenceContextRef();
        envRefs.persistenceUnitRefList = bean.getPersistenceUnitRef();
        EnvironmentDescriptorProcessor envProcessor = new EnvironmentDescriptorProcessor(env, this.loader);
        envProcessor.process(envRefs);
        beanInfo.setBeanNamingEnvironment(envProcessor.getNamingEnvironment());
        beanInfo.setServiceRefs(envRefs.serviceRefList);
        SecurityIdentityType identityType = bean.getSecurityIdentity();
        if (identityType != null && (runAsType = identityType.getRunAs()) != null && (roleNameType = runAsType.getRoleName()) != null) {
            beanInfo.setRunAsRole(roleNameType.getValue());
        }
    }
}

