/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jeus.ejb.bean.objectbase.FieldAccessor;
import jeus.ejb.container.ContainerException;
import jeus.util.Serializer;
import jeus.util.message.JeusMessage_EJB11;

public class DBUtil {
    public static int fetchSize = 10;

    public static void setObjectToDBStatement(Object obj, PreparedStatement stat, int idx, int type) throws ContainerException {
        try {
            switch (type) {
                case 1: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setString(idx, obj.toString());
                    break;
                }
                case -7: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case -6: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setByte(idx, (Byte)obj);
                    break;
                }
                case -4: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    byte[] contents = (byte[])obj;
                    ByteArrayInputStream in = new ByteArrayInputStream(contents);
                    stat.setBinaryStream(idx, (InputStream)in, contents.length);
                    break;
                }
                case -1: 
                case 12: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setString(idx, (String)obj);
                    break;
                }
                case 2: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setBigDecimal(idx, (BigDecimal)obj);
                    break;
                }
                case 91: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setDate(idx, (Date)obj);
                    break;
                }
                case 92: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setTime(idx, (Time)obj);
                    break;
                }
                case 93: {
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    if (obj instanceof Timestamp) {
                        stat.setTimestamp(idx, (Timestamp)obj);
                        break;
                    }
                    stat.setTimestamp(idx, new Timestamp(((java.util.Date)obj).getTime()));
                    break;
                }
                case 2000: {
                    if (obj == null) {
                        stat.setNull(idx, -4);
                        break;
                    }
                    byte[] buf = ((Serializer)Serializer.serializers.get()).serialize(obj);
                    ByteArrayInputStream in = new ByteArrayInputStream(buf);
                    stat.setBinaryStream(idx, (InputStream)in, buf.length);
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB11._7114, Integer.toString(type));
                }
            }
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB11._7115, (Throwable)ex);
        }
    }

    public static Object readObjectFromDBStatement(ResultSet result, int idx, int type) throws ContainerException {
        Object obj;
        try {
            switch (type) {
                case 4: {
                    obj = new Integer(result.getInt(idx));
                    break;
                }
                case -7: {
                    obj = new Boolean(result.getBoolean(idx));
                    break;
                }
                case -6: {
                    obj = new Byte(result.getByte(idx));
                    break;
                }
                case 1: {
                    obj = new Character(result.getString(idx).charAt(0));
                    break;
                }
                case 5: {
                    obj = new Short(result.getShort(idx));
                    break;
                }
                case -5: {
                    obj = new Long(result.getLong(idx));
                    break;
                }
                case 7: {
                    obj = new Float(result.getFloat(idx));
                    break;
                }
                case 8: {
                    obj = new Double(result.getDouble(idx));
                    break;
                }
                case -4: {
                    obj = result.getBytes(idx);
                    break;
                }
                case 12: {
                    obj = result.getString(idx);
                    break;
                }
                case 2: {
                    obj = result.getBigDecimal(idx);
                    break;
                }
                case 91: {
                    obj = result.getDate(idx);
                    break;
                }
                case 92: {
                    obj = result.getTime(idx);
                    break;
                }
                case 93: {
                    obj = result.getTimestamp(idx);
                    break;
                }
                case 2000: {
                    try {
                        obj = ((Serializer)Serializer.serializers.get()).deserialize(result.getBytes(idx));
                        break;
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB11._7114, Integer.toString(type));
                }
            }
            if (result.wasNull()) {
                obj = null;
            }
        }
        catch (SQLException ex) {
            throw new ContainerException(JeusMessage_EJB11._7117, (Throwable)ex);
        }
        return obj;
    }

    public static void setFieldToDBStatement(Object obj, Field field, PreparedStatement stat, int idx, int type) throws ContainerException {
        Object object;
        try {
            object = field.get(obj);
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB11._7115, (Throwable)ex);
        }
        DBUtil.setObjectToDBStatement(object, stat, idx, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean readFieldFromDBStatement(ResultSet result, int idx, Object obj, Field field, int type) throws ContainerException {
        try {
            switch (type) {
                case 4: {
                    if (field.getType().isPrimitive()) {
                        field.setInt(obj, result.getInt(idx));
                        break;
                    }
                    i = result.getInt(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Integer(i));
                    break;
                }
                case -7: {
                    if (field.getType().isPrimitive()) {
                        field.setBoolean(obj, result.getBoolean(idx));
                        break;
                    }
                    b = result.getBoolean(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Boolean(b));
                    break;
                }
                case -6: {
                    if (field.getType().isPrimitive()) {
                        field.setByte(obj, result.getByte(idx));
                        break;
                    }
                    b = result.getByte(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Byte(b));
                    break;
                }
                case 1: {
                    if (field.getType().isPrimitive()) {
                        field.setChar(obj, result.getString(idx).charAt(0));
                        break;
                    }
                    s = result.getString(idx);
                    if (s == null) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Character(s.charAt(0)));
                    break;
                }
                case 5: {
                    if (field.getType().isPrimitive()) {
                        field.setShort(obj, result.getShort(idx));
                        break;
                    }
                    s = result.getShort(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Short(s));
                    break;
                }
                case -5: {
                    if (field.getType().isPrimitive()) {
                        field.setLong(obj, result.getLong(idx));
                        break;
                    }
                    l = result.getLong(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Long(l));
                    break;
                }
                case 7: {
                    if (field.getType().isPrimitive()) {
                        field.setFloat(obj, result.getFloat(idx));
                        break;
                    }
                    f = result.getFloat(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Float(f));
                    break;
                }
                case 8: {
                    if (field.getType().isPrimitive()) {
                        field.setDouble(obj, result.getDouble(idx));
                        break;
                    }
                    d = result.getDouble(idx);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Double(d));
                    break;
                }
                case -4: {
                    field.set(obj, result.getBytes(idx));
                    break;
                }
                case -1: 
                case 12: {
                    field.set(obj, result.getString(idx));
                    break;
                }
                case 2: {
                    field.set(obj, result.getBigDecimal(idx));
                    break;
                }
                case 91: {
                    field.set(obj, result.getDate(idx));
                    break;
                }
                case 92: {
                    field.set(obj, result.getTime(idx));
                    break;
                }
                case 93: {
                    if (Timestamp.class.isAssignableFrom(field.getType())) {
                        field.set(obj, result.getTimestamp(idx));
                        break;
                    }
                    field.set(obj, new java.util.Date(result.getTimestamp(idx).getTime()));
                    break;
                }
                case 2000: {
                    value = ((Serializer)Serializer.serializers.get()).deserialize(result.getBytes(idx));
                    field.set(obj, value);
                    break;
                }
                case 2005: {
                    try {
                        clob = result.getClob(idx);
                        len = (int)clob.length();
                        if (len == 0) {
                            clob_value = new String("");
                        } else {
                            contents = new char[len];
                            reader = clob.getCharacterStream();
                            reader.read(contents, 0, len);
                            reader.close();
                            clob_value = new String(contents);
                        }
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
                    field.set(obj, clob_value);
                    break;
                }
                case 2004: {
                    try {
                        blob = result.getBlob(idx);
                        len = (int)blob.length();
                        if (len != 0) ** GOTO lbl133
                        blob_value = null;
                        ** GOTO lbl150
lbl133:
                        // 1 sources

                        contents = new byte[len];
                        is = blob.getBinaryStream();
                        try {
                            is.read(contents);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (Throwable t) {}
                        }
                        serial = new Serializer();
                        blob_value = serial.deserialize(contents);
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
lbl150:
                    // 2 sources

                    field.set(obj, blob_value);
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB11._7114, Integer.toString(type));
                }
            }
            if (result.wasNull()) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB11._7117, (Throwable)ex);
        }
        return false;
    }

    public static void setCMPFieldToDBStatement(FieldAccessor ejbBean, int fieldIdx, int type, boolean isPrimitive, PreparedStatement stat, int idx) throws ContainerException {
        try {
            switch (type) {
                case 1: {
                    if (isPrimitive) {
                        stat.setString(idx, new String(new char[]{ejbBean._getCharactor(fieldIdx, true)}));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setString(idx, obj.toString());
                    break;
                }
                case 4: {
                    if (isPrimitive) {
                        stat.setInt(idx, ejbBean._getInt(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case -7: {
                    if (isPrimitive) {
                        stat.setBoolean(idx, ejbBean._getBoolean(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case 5: {
                    if (isPrimitive) {
                        stat.setShort(idx, ejbBean._getShort(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case -5: {
                    if (isPrimitive) {
                        stat.setLong(idx, ejbBean._getLong(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case 7: {
                    if (isPrimitive) {
                        stat.setFloat(idx, ejbBean._getFloat(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case 8: {
                    if (isPrimitive) {
                        stat.setDouble(idx, ejbBean._getDouble(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setObject(idx, obj);
                    break;
                }
                case -6: {
                    if (isPrimitive) {
                        stat.setByte(idx, ejbBean._getByte(fieldIdx, true));
                        break;
                    }
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setByte(idx, (Byte)obj);
                    break;
                }
                case -4: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    byte[] contents = (byte[])obj;
                    ByteArrayInputStream in = new ByteArrayInputStream(contents);
                    stat.setBinaryStream(idx, (InputStream)in, contents.length);
                    break;
                }
                case -1: 
                case 12: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setString(idx, (String)obj);
                    break;
                }
                case 2: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setBigDecimal(idx, (BigDecimal)obj);
                    break;
                }
                case 91: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setDate(idx, (Date)obj);
                    break;
                }
                case 92: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    stat.setTime(idx, (Time)obj);
                    break;
                }
                case 93: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, type);
                        break;
                    }
                    if (obj instanceof java.util.Date) {
                        obj = new Timestamp(((java.util.Date)obj).getTime());
                    }
                    stat.setTimestamp(idx, (Timestamp)obj);
                    break;
                }
                case 2000: 
                case 2004: 
                case 2005: {
                    Object obj = ejbBean._get(fieldIdx, true);
                    if (obj == null) {
                        stat.setNull(idx, -4);
                        break;
                    }
                    byte[] buf = ((Serializer)Serializer.serializers.get()).serialize(obj);
                    ByteArrayInputStream in = new ByteArrayInputStream(buf);
                    stat.setBinaryStream(idx, (InputStream)in, buf.length);
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB11._7114, Integer.toString(type));
                }
            }
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB11._7115, (Throwable)ex);
        }
    }

    public static void readCMPFieldFromDBStatement(ResultSet result, int idx, FieldAccessor ejbBean, int fieldIdx, int type, boolean isPrimitive) throws ContainerException {
        try {
            switch (type) {
                case 4: {
                    if (isPrimitive) {
                        ejbBean._setInt(fieldIdx, result.getInt(idx), true);
                        break;
                    }
                    int i = result.getInt(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Integer(i), true);
                    break;
                }
                case -7: {
                    if (isPrimitive) {
                        ejbBean._setBoolean(fieldIdx, result.getBoolean(idx), true);
                        break;
                    }
                    boolean b = result.getBoolean(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Boolean(b), true);
                    break;
                }
                case -6: {
                    if (isPrimitive) {
                        ejbBean._setByte(fieldIdx, result.getByte(idx), true);
                        break;
                    }
                    byte b = result.getByte(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Byte(b), true);
                    break;
                }
                case 1: {
                    if (isPrimitive) {
                        ejbBean._setCharactor(fieldIdx, result.getString(idx).charAt(0), true);
                        break;
                    }
                    String s = result.getString(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Character(s.charAt(0)), true);
                    break;
                }
                case 5: {
                    if (isPrimitive) {
                        ejbBean._setShort(fieldIdx, result.getShort(idx), true);
                        break;
                    }
                    short s = result.getShort(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Short(s), true);
                    break;
                }
                case -5: {
                    if (isPrimitive) {
                        ejbBean._setLong(fieldIdx, result.getLong(idx), true);
                        break;
                    }
                    long l = result.getLong(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Long(l), true);
                    break;
                }
                case 7: {
                    if (isPrimitive) {
                        ejbBean._setFloat(fieldIdx, result.getFloat(idx), true);
                        break;
                    }
                    float f = result.getFloat(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Float(f), true);
                    break;
                }
                case 8: {
                    if (isPrimitive) {
                        ejbBean._setDouble(fieldIdx, result.getDouble(idx), true);
                        break;
                    }
                    double d = result.getDouble(idx);
                    if (result.wasNull()) {
                        ejbBean._set(fieldIdx, null, true);
                        break;
                    }
                    ejbBean._set(fieldIdx, new Double(d), true);
                    break;
                }
                case -4: {
                    ejbBean._set(fieldIdx, result.getBytes(idx), true);
                    break;
                }
                case -1: 
                case 12: {
                    ejbBean._set(fieldIdx, result.getString(idx), true);
                    break;
                }
                case 2: {
                    ejbBean._set(fieldIdx, result.getBigDecimal(idx), true);
                    break;
                }
                case 91: {
                    ejbBean._set(fieldIdx, result.getDate(idx), true);
                    break;
                }
                case 92: {
                    ejbBean._set(fieldIdx, result.getTime(idx), true);
                    break;
                }
                case 93: {
                    ejbBean._set(fieldIdx, result.getTimestamp(idx), true);
                    break;
                }
                case 2000: {
                    Object value;
                    try {
                        value = ((Serializer)Serializer.serializers.get()).deserialize(result.getBytes(idx));
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
                    ejbBean._set(fieldIdx, value, true);
                    break;
                }
                case 2005: {
                    String clob_value;
                    try {
                        Clob clob = result.getClob(idx);
                        int len = (int)clob.length();
                        if (len == 0) {
                            clob_value = new String("");
                        } else {
                            char[] contents = new char[len];
                            Reader reader = clob.getCharacterStream();
                            reader.read(contents);
                            reader.close();
                            clob_value = new String(contents);
                        }
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
                    ejbBean._set(fieldIdx, clob_value, true);
                    break;
                }
                case 2004: {
                    Object blob_value;
                    try {
                        Blob blob = result.getBlob(idx);
                        int len = (int)blob.length();
                        if (len == 0) {
                            blob_value = null;
                        } else {
                            byte[] contents = new byte[len];
                            InputStream is = blob.getBinaryStream();
                            is.read(contents);
                            is.close();
                            Serializer serial = new Serializer();
                            blob_value = serial.deserialize(contents);
                        }
                    }
                    catch (Exception ex) {
                        throw new ContainerException(JeusMessage_EJB11._7116, (Throwable)ex);
                    }
                    ejbBean._set(fieldIdx, blob_value, true);
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB11._7114, Integer.toString(type));
                }
            }
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB11._7117, (Throwable)ex);
        }
    }
}

