/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBCacher;
import jeus.ejb.schema.EJBCreator;
import jeus.ejb.schema.EJBFinder;
import jeus.ejb.schema.EJBLoader;
import jeus.ejb.schema.EJBRemover;
import jeus.ejb.schema.EJBStorer;
import jeus.ejb.schema.EJBTableChecker;
import jeus.ejb.schema.EJBTableCreator;
import jeus.ejb.schema.EJBTableRemover;
import jeus.ejb.schema.cmp11.SchemaHandlerFactoryForCMP11;
import jeus.ejb.schema.cmp20.SchemaHandlerFactoryForCMP20;

public abstract class AbstractSchemaHandlerFactory {
    private static final AbstractSchemaHandlerFactory cmp20Factory = new SchemaHandlerFactoryForCMP20();
    private static final AbstractSchemaHandlerFactory cmp11Factory = new SchemaHandlerFactoryForCMP11();

    public abstract EJBCreator createEJBCreator();

    public abstract CMPFieldRW createCMPFieldRW();

    public static AbstractSchemaHandlerFactory createSchemaHandlerFactory(int cmpVersion) {
        if (cmpVersion > 1) {
            return cmp20Factory;
        }
        return cmp11Factory;
    }

    public abstract EJBLoader createEJBLoader();

    public abstract EJBStorer createEJBStorer();

    public abstract EJBTableCreator createEJBTableCreator();

    public abstract EJBTableRemover createEJBTableRemover();

    public abstract EJBRemover createEJBRemover();

    public abstract EJBFinder createEJBFinder();

    public abstract EJBCacher createEJBCacher();

    public abstract EJBTableChecker createEJBTableChecker();
}

