/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.ModuleSchema;
import jeus.ejb.util.EJBCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB8;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class BeanSchema {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.BeanSchema");
    public static final String cmrFieldNamePrefix = "_cmrField";
    public ArrayList cmFieldRWs;
    public Vector relations = new Vector();
    public EJBSQLGenerator sqlGen;
    public EJBSourceGenerator sourceGen;
    public CMEntityBeanPair beanPair;

    public BeanSchema(CMEntityBeanPair desc, ModuleSchema mSchema, FileArchive jarArchive, FileArchive tempArchive, String moduleName, ArchiveArrayClassLoader loader, EJBCompiler compiler) throws EJBSourceGeneratorException {
        this.beanPair = desc;
        this.sqlGen = new EJBSQLGenerator(desc, mSchema);
        this.sourceGen = new EJBSourceGenerator(this, this.sqlGen, jarArchive, tempArchive, moduleName, loader, compiler);
    }

    public void sortRelations() {
        int size;
        if (logger.isLoggable(JeusMessage_EJB8._5301_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5301_LEVEL, "BeanSchema", "sortRelations", JeusMessage_EJB8._5301);
        }
        if ((size = this.relations.size()) < 2) {
            return;
        }
        Object[] descs = this.relations.toArray(RelationshipRolePair.dummyArray);
        Arrays.sort(descs);
        this.relations = new Vector(descs.length);
        for (int i = 0; i < descs.length; ++i) {
            this.relations.add(descs[i]);
        }
    }

    public void setCMRFieldName() throws JAXBException {
        int idx = 0;
        Enumeration e = this.relations.elements();
        while (e.hasMoreElements()) {
            RelationshipRolePair rdesc = (RelationshipRolePair)e.nextElement();
            if (rdesc.getCMRFieldName() != null) continue;
            String cmrName = cmrFieldNamePrefix + idx;
            if (logger.isLoggable(JeusMessage_EJB8._5302_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5302_LEVEL, "BeanSchema", "setCMRFieldName", JeusMessage_EJB8._5302, (Object)cmrName);
            }
            rdesc.setCMRFieldName(cmrName);
            ++idx;
        }
    }

    public static boolean isContainerDefinedCMRField(String fieldName) {
        return fieldName.startsWith(cmrFieldNamePrefix);
    }

    public String getBeanName() {
        return this.beanPair.getBeanName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BeanSchema) {
            return this.beanPair.getSchemaName().equals(((BeanSchema)obj).beanPair.getSchemaName());
        }
        return false;
    }
}

