/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.io.OutputStream;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import javax.ejb.EntityBean;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.util.Serializer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB8;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public abstract class EJBCreator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.creator");
    public CMPFieldRW[] cmNormalFieldRWs;
    public CMRFieldRW[] managableCMRFieldList;
    public CMPFieldRW[] cmNPkeyClobFieldRWs;
    public CMPFieldRW[] cmNPkeyBlobFieldRWs;
    public CMPFieldRW[] cmPkeyFieldRWs;
    public String ejbCreateSQL;
    public String BlobClobSelectSQL;

    public abstract void create(EntityBean var1, Connection var2) throws ContainerException;

    public void initCreator(EJBSQLGenerator generator) throws EJBSQLGeneratorException {
        try {
            this.makeInsertSQLForEntity(generator);
            if (this.cmNPkeyBlobFieldRWs.length > 0 || this.cmNPkeyClobFieldRWs.length > 0) {
                this.writeSelectBlobClobFieldsSQL(generator);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB8._5451_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5451_LEVEL, "EJBCreator", "initCreator", JeusMessage_EJB8._5451, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB8._5451, ex);
        }
    }

    protected void makeInsertSQLForEntity(EJBSQLGenerator generator) {
        SQLBuilder sqlBuilder = generator.sqlBuilder;
        sqlBuilder.initInsertSQL();
        sqlBuilder.setTableName(generator.tableName);
        sqlBuilder.beginColumnName();
        sqlBuilder.addColumnNameByFieldRW(this.cmNormalFieldRWs);
        sqlBuilder.addColumnNameByFieldRW(this.cmNPkeyClobFieldRWs);
        sqlBuilder.addColumnNameByFieldRW(this.cmNPkeyBlobFieldRWs);
        this.setColumnNamesForOtherFields(generator.bSchema.relations, sqlBuilder);
        sqlBuilder.finishColumnName();
        sqlBuilder.beginValues();
        sqlBuilder.addValueList(this.cmNormalFieldRWs.length, "? ");
        sqlBuilder.addValueList(this.cmNPkeyClobFieldRWs.length, "EMPTY_CLOB() ");
        sqlBuilder.addValueList(this.cmNPkeyBlobFieldRWs.length, "EMPTY_BLOB() ");
        this.setValueListForOtherFields(generator.bSchema.relations, sqlBuilder);
        sqlBuilder.finishValues();
        this.ejbCreateSQL = sqlBuilder.getSQL();
    }

    protected void setValueListForOtherFields(AbstractList relations, SQLBuilder sqlBuilder) {
    }

    protected void setColumnNamesForOtherFields(AbstractList relations, SQLBuilder sqlBuilder) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBLOBCLOB(EntityBean ejbBean, Connection con) throws ContainerException {
        Statement stat = null;
        try {
            boolean flag = false;
            try {
                if (con.getAutoCommit()) {
                    flag = true;
                    con.setAutoCommit(false);
                }
                stat = con.prepareStatement(this.BlobClobSelectSQL);
                for (int i = 0; i < this.cmPkeyFieldRWs.length; ++i) {
                    this.cmPkeyFieldRWs[i].setToDBStatement(ejbBean, (PreparedStatement)stat, i + 1);
                }
                ResultSet rs = stat.executeQuery();
                if (rs.next()) {
                    Object content;
                    int j;
                    for (j = 0; j < this.cmNPkeyBlobFieldRWs.length; ++j) {
                        content = this.cmNPkeyBlobFieldRWs[j].getFieldContent(ejbBean);
                        if (content == null) continue;
                        Blob blob = rs.getBlob(j + 1);
                        OutputStream os = ((BLOB)blob).getBinaryOutputStream();
                        try {
                            Serializer serial = new Serializer();
                            byte[] buf = serial.serialize(content);
                            os.write(buf);
                            os.flush();
                            continue;
                        }
                        finally {
                            os.close();
                        }
                    }
                    for (j = 0; j < this.cmNPkeyClobFieldRWs.length; ++j) {
                        content = (String)this.cmNPkeyClobFieldRWs[j].getFieldContent(ejbBean);
                        if (content == null) continue;
                        Clob clob = rs.getClob(this.cmNPkeyBlobFieldRWs.length + j + 1);
                        Writer writer = ((CLOB)clob).getCharacterOutputStream();
                        try {
                            writer.write(((String)content).toCharArray());
                            writer.flush();
                            continue;
                        }
                        finally {
                            writer.close();
                        }
                    }
                } else {
                    throw new SQLException(" Could not get java.sql.Blob to write");
                }
                if (flag) {
                    con.commit();
                    con.setAutoCommit(true);
                }
            }
            catch (Throwable t) {
                if (flag && stat != null) {
                    con.rollback();
                }
                throw t;
            }
            finally {
                if (stat != null) {
                    try {
                        stat.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB8._5452_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5452_LEVEL, "EJBCreator", "createBLOBCLOB", JeusMessage_EJB8._5452, ex);
            }
            throw new ContainerException(JeusMessage_EJB8._5452, ex);
        }
    }

    protected void writeSelectBlobClobFieldsSQL(EJBSQLGenerator generator) {
        SQLBuilder sqlBuilder = generator.sqlBuilder;
        sqlBuilder.initSelectSQL();
        if (this.cmNPkeyBlobFieldRWs != null) {
            sqlBuilder.addColumnNameByFieldRW(this.cmNPkeyBlobFieldRWs);
        }
        if (this.cmNPkeyBlobFieldRWs != null) {
            sqlBuilder.addColumnNameByFieldRW(this.cmNPkeyClobFieldRWs);
        }
        sqlBuilder.beginFromClause();
        sqlBuilder.setTableName(generator.tableName);
        sqlBuilder.finishFromClause();
        sqlBuilder.addCommonWhereClause();
        sqlBuilder.addForUpdate();
        this.BlobClobSelectSQL = sqlBuilder.getSQL();
    }

    protected int setFieldsToDBStatement(FieldRW[] fields, EntityBean ejbBean, PreparedStatement stat, int statIndex) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            statIndex += fields[i].setToDBStatement(ejbBean, stat, statIndex);
        }
        return statIndex;
    }

    public String toString() {
        return "ejbCreateSQL : " + this.ejbCreateSQL + "\n\tBlobClobSelectSQL : " + this.BlobClobSelectSQL;
    }
}

