/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import jeus.ejb.persistence.database.SQLTypeTable;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.transaction.TransactionManager;
import jeus.transaction.TxHelper;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB9;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;

public class EJBKeyGenerator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.keyGenerator");
    private String dbVendor;
    private String genKeyQuerySQL;
    private String genKeyUpdateSQL;
    private String generatorName;
    private String userSequenceCol;
    private int cacheSize = 1;
    private int currCacheSize;
    private int currValue;
    private boolean genKeyBeforeInsert;
    private String genKeyType;
    private String dataSourceName;
    private DataSource ds;

    public EJBKeyGenerator(CMEntityBeanPair dbInfo) {
        this.dbVendor = dbInfo.getDBVendor();
        this.dataSourceName = dbInfo.getDataSourceName();
        this.genKeyType = dbInfo.getGenKeyType();
        this.generatorName = dbInfo.getKeyGeneratorName();
        if (this.generatorName == null) {
            this.generatorName = "KT_" + dbInfo.getBeanName() + dbInfo.getModuleName();
            if (this.generatorName.length() > 15) {
                // empty if block
            }
            this.generatorName = "KT_" + (this.generatorName.hashCode() & Integer.MAX_VALUE);
        }
        this.cacheSize = dbInfo.getCacheSize();
        if (this.genKeyType.equals("USER_KEY_TABLE")) {
            this.userSequenceCol = dbInfo.getSequenceColumn();
            if (this.userSequenceCol == null) {
                this.userSequenceCol = "key";
            }
        }
        if (logger.isLoggable(JeusMessage_EJB9._5551_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5551_LEVEL, "EJBKeyGenerator", "<init>", JeusMessage_EJB9._5551, (Object)this.genKeyType);
        }
    }

    public boolean isGenKeyBeforeInsert() {
        return this.genKeyBeforeInsert;
    }

    public void initKeyGenerator() throws SQLException {
        if (logger.isLoggable(JeusMessage_EJB9._5552_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5552_LEVEL, "EJBKeyGenerator", "initKeyGenerator", JeusMessage_EJB9._5552);
        }
        if (this.genKeyType.equals("ORACLE")) {
            this.genKeyBeforeInsert = true;
            this.genKeyQuerySQL = "SELECT " + this.generatorName + ".nextval FROM DUAL";
            if (logger.isLoggable(JeusMessage_EJB9._5553_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5553_LEVEL, "EJBKeyGenerator", "initKeyGenerator", JeusMessage_EJB9._5553, (Object)this.genKeyQuerySQL);
            }
        } else if (this.genKeyType.equals("MSSQL")) {
            this.genKeyQuerySQL = "SELECT @@IDENTITY";
            if (logger.isLoggable(JeusMessage_EJB9._5554_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5554_LEVEL, "EJBKeyGenerator", "initKeyGenerator", JeusMessage_EJB9._5554, (Object)this.genKeyQuerySQL);
            }
        } else if (this.genKeyType.equals("USER_KEY_TABLE")) {
            this.genKeyBeforeInsert = true;
            if (this.cacheSize <= 0) {
                this.cacheSize = 10;
            }
            this.genKeyQuerySQL = "SELECT " + this.userSequenceCol + " FROM " + this.generatorName;
            this.genKeyUpdateSQL = "UPDATE " + this.generatorName + " SET " + this.userSequenceCol + " = " + this.userSequenceCol + " + " + this.cacheSize;
            if (!this.checkExistSequenceTable()) {
                this.createDefaultSequenceTable();
            }
            if (logger.isLoggable(JeusMessage_EJB9._5555_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5555_LEVEL, "EJBKeyGenerator", "initKeyGenerator", JeusMessage_EJB9._5555, (Object)this.genKeyQuerySQL);
            }
        } else {
            throw new JeusSQLException("Only support follwing Generator Key Type : ORACLE , MSSQL , USER_KEY_TABLE");
        }
    }

    public Object getNextKey() throws SQLException {
        if (this.genKeyType.equals("ORACLE")) {
            return this.getOracleNextKey();
        }
        if (this.genKeyType.equals("MSSQL")) {
            return this.getKeyQuery();
        }
        return this.getUserSequenceNextKey();
    }

    public synchronized Object getOracleNextKey() throws SQLException {
        if (this.currCacheSize <= 0) {
            this.currValue = (Integer)this.getKeyQuery();
            this.currCacheSize = this.cacheSize;
        }
        --this.currCacheSize;
        if (logger.isLoggable(JeusMessage_EJB9._5556_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5556_LEVEL, "EJBKeyGenerator", "getOracleNextKey", JeusMessage_EJB9._5556, (Object)String.valueOf(this.currValue));
        }
        return new Integer(this.currValue++);
    }

    public synchronized Object getUserSequenceNextKey() throws SQLException {
        if (this.currCacheSize <= 0) {
            this.currValue = (Integer)this.getKeyUpdateAndQuery();
            this.currCacheSize = this.cacheSize;
        }
        --this.currCacheSize;
        if (logger.isLoggable(JeusMessage_EJB9._5557_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5557_LEVEL, "EJBKeyGenerator", "getUserSequenceNextKey", JeusMessage_EJB9._5557, (Object)String.valueOf(this.currValue));
        }
        return new Integer(this.currValue++);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getKeyUpdateAndQuery() throws SQLException {
        Integer n;
        ResultSet rs;
        Statement st;
        Connection con;
        block27: {
            con = null;
            st = null;
            rs = null;
            TransactionManager txManager = TxHelper.getTransactionManager();
            Transaction callerTx = null;
            Transaction tx = null;
            try {
                try {
                    block26: {
                        if (logger.isLoggable(JeusMessage_EJB9._5558_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5558_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5558);
                        }
                        if ((callerTx = txManager.getTransaction()) != null) {
                            if (logger.isLoggable(JeusMessage_EJB9._5559_LEVEL)) {
                                logger.logp(JeusMessage_EJB9._5559_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5559);
                            }
                            txManager.suspend();
                        }
                        txManager.begin();
                        tx = txManager.getTransaction();
                        con = this.getConnection();
                        try {
                            con.setTransactionIsolation(8);
                        }
                        catch (SQLException ex) {
                            if (!logger.isLoggable(JeusMessage_EJB9._5585_LEVEL)) break block26;
                            logger.log(JeusMessage_EJB9._5585_LEVEL, JeusMessage_EJB9._5585, (Throwable)ex);
                        }
                    }
                    st = con.createStatement();
                    int list = st.executeUpdate(this.genKeyUpdateSQL);
                    if (list < 1) {
                        if (!logger.isLoggable(JeusMessage_EJB9._5560_LEVEL)) throw new JeusSQLException("fail to update auto key table : " + this.genKeyUpdateSQL);
                        logger.logp(JeusMessage_EJB9._5560_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5560, (Object)this.genKeyUpdateSQL);
                        throw new JeusSQLException("fail to update auto key table : " + this.genKeyUpdateSQL);
                    }
                    rs = st.executeQuery(this.genKeyQuerySQL);
                    if (!rs.next()) {
                        if (!logger.isLoggable(JeusMessage_EJB9._5561_LEVEL)) throw new JeusSQLException("fail to get key value from auto key table : " + this.genKeyQuerySQL);
                        logger.logp(JeusMessage_EJB9._5561_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5561, (Object)this.genKeyQuerySQL);
                        throw new JeusSQLException("fail to get key value from auto key table : " + this.genKeyQuerySQL);
                    }
                    int keyValue = rs.getInt(1);
                    txManager.commit();
                    if (logger.isLoggable(JeusMessage_EJB9._5562_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5562_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5562, (Object)String.valueOf(keyValue));
                    }
                    n = new Integer(keyValue);
                    Object var11_15 = null;
                    if (callerTx == null || tx == null) break block27;
                }
                catch (SQLException sqle) {
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!logger.isLoggable(JeusMessage_EJB9._5563_LEVEL)) throw sqle;
                    logger.logp(JeusMessage_EJB9._5563_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5563, (Throwable)sqle);
                    throw sqle;
                }
                catch (Throwable t) {
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (Throwable t1) {
                            // empty catch block
                        }
                    }
                    if (!logger.isLoggable(JeusMessage_EJB9._5564_LEVEL)) throw new JeusSQLException("fail to update and query in user defined squence table");
                    logger.logp(JeusMessage_EJB9._5564_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5564, t);
                    throw new JeusSQLException("fail to update and query in user defined squence table");
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (callerTx != null && tx != null) {
                    try {
                        if (logger.isLoggable(JeusMessage_EJB9._5565_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5565_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5565);
                        }
                        txManager.resume(callerTx);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_EJB9._5566_LEVEL)) throw new JeusSQLException("fail to resume transaction", t);
                        logger.logp(JeusMessage_EJB9._5566_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5566, t);
                        throw new JeusSQLException("fail to resume transaction", t);
                    }
                }
                this.releaseResource(con, st, rs);
                throw throwable;
            }
            try {}
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB9._5566_LEVEL)) throw new JeusSQLException("fail to resume transaction", t);
                logger.logp(JeusMessage_EJB9._5566_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5566, t);
                throw new JeusSQLException("fail to resume transaction", t);
            }
            if (logger.isLoggable(JeusMessage_EJB9._5565_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5565_LEVEL, "EJBKeyGenerator", "getKeyUpdateAndQuery", JeusMessage_EJB9._5565);
            }
            txManager.resume(callerTx);
        }
        this.releaseResource(con, st, rs);
        return n;
    }

    public Object getKeyQuery() throws SQLException {
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(this.genKeyQuerySQL);
            if (!rs.next()) {
                throw new JeusSQLException("fail to generate key : " + this.genKeyQuerySQL);
            }
            int keyValue = rs.getInt(1);
            if (logger.isLoggable(JeusMessage_EJB9._5567_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5567_LEVEL, "EJBKeyGenerator", "getKeyQuery", JeusMessage_EJB9._5567, (Object)String.valueOf(keyValue));
            }
            Integer n = new Integer(keyValue);
            this.releaseResource(con, stat, rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                this.releaseResource(con, stat, rs);
                throw throwable;
            }
        }
    }

    public Object getKeyQuery(Connection con) throws SQLException {
        if (logger.isLoggable(JeusMessage_EJB9._5568_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5568_LEVEL, "EJBKeyGenerator", "getKeyQuery", JeusMessage_EJB9._5568);
        }
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = con.createStatement();
            rs = stat.executeQuery(this.genKeyQuerySQL);
            if (!rs.next()) {
                if (logger.isLoggable(JeusMessage_EJB9._5569_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5569_LEVEL, "EJBKeyGenerator", "getKeyQuery", JeusMessage_EJB9._5569);
                }
                throw new JeusSQLException("fail to generate key : " + this.genKeyQuerySQL);
            }
            int keyValue = rs.getInt(1);
            if (logger.isLoggable(JeusMessage_EJB9._5570_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5570_LEVEL, "EJBKeyGenerator", "getKeyQuery", JeusMessage_EJB9._5570, (Object)String.valueOf(keyValue));
            }
            Integer n = new Integer(keyValue);
            this.releaseResource(null, stat, rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5571_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5571_LEVEL, "EJBKeyGenerator", "getKeyQuery", JeusMessage_EJB9._5571, (Throwable)sqle);
                }
                throw sqle;
            }
            catch (Throwable throwable) {
                this.releaseResource(null, stat, rs);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createDefaultSequenceTable() throws SQLException {
        if (logger.isLoggable(JeusMessage_EJB9._5572_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5572_LEVEL, "EJBKeyGenerator", "createDefaultSequenceTable", JeusMessage_EJB9._5572);
        }
        Connection con = null;
        Statement stat = null;
        StringBuffer createSQL = new StringBuffer("CREATE TABLE ").append(this.generatorName).append("(");
        try {
            createSQL.append(this.userSequenceCol + " ").append(SQLTypeTable.convert(Integer.class, this.dbVendor)).append(")");
            String s = createSQL.toString();
            if (logger.isLoggable(JeusMessage_EJB9._5573_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5573_LEVEL, "EJBKeyGenerator", "createDefaultSequenceTable", JeusMessage_EJB9._5573, (Object)s);
            }
            con = this.getConnection();
            stat = con.createStatement();
            stat.executeUpdate(s);
            stat.executeUpdate("INSERT INTO " + this.generatorName + " VALUES(0)");
            if (!con.getAutoCommit()) {
                con.commit();
            }
            if (logger.isLoggable(JeusMessage_EJB9._5574_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5574_LEVEL, "EJBKeyGenerator", "createDefaultSequenceTable", JeusMessage_EJB9._5574);
            }
            boolean bl = true;
            this.releaseResource(con, stat, null);
            return bl;
        }
        catch (SQLException t) {
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5575_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5575_LEVEL, "EJBKeyGenerator", "createDefaultSequenceTable", JeusMessage_EJB9._5575, (Object)createSQL.toString(), (Throwable)t);
                }
                throw t;
                catch (Throwable t2) {
                    if (logger.isLoggable(JeusMessage_EJB9._5576_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5576_LEVEL, "EJBKeyGenerator", "createDefaultSequenceTable", JeusMessage_EJB9._5576, t2);
                    }
                    throw new JeusSQLException("fail to create Default Sequence Table : " + createSQL.toString());
                }
            }
            catch (Throwable throwable) {
                this.releaseResource(con, stat, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExistSequenceTable() {
        if (logger.isLoggable(JeusMessage_EJB9._5577_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5577_LEVEL, "EJBKeyGenerator", "checkExistSequenceTable", JeusMessage_EJB9._5577);
        }
        Connection con = null;
        PreparedStatement ps = null;
        String checkSQL = new String("SELECT " + this.userSequenceCol + " FROM " + this.generatorName + " WHERE 1 = 0");
        try {
            con = this.getConnection();
            ps = con.prepareStatement(checkSQL);
            ps.executeQuery();
            if (logger.isLoggable(JeusMessage_EJB9._5578_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5578_LEVEL, "EJBKeyGenerator", "checkExistSequenceTable", JeusMessage_EJB9._5578);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            if (logger.isLoggable(JeusMessage_EJB9._5579_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5579_LEVEL, "EJBKeyGenerator", "checkExistSequenceTable", JeusMessage_EJB9._5579);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseResource(con, ps, null);
        }
    }

    private Connection getConnection() throws SQLException {
        if (logger.isLoggable(JeusMessage_EJB9._5580_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5580_LEVEL, "EJBKeyGenerator", "getConnection", JeusMessage_EJB9._5580, (Object)this.dataSourceName);
        }
        try {
            if (this.ds == null) {
                InitialContext ctx = new InitialContext();
                this.ds = (DataSource)ctx.lookup(this.dataSourceName);
            }
            Connection con = this.ds.getConnection();
            if (logger.isLoggable(JeusMessage_EJB9._5581_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5581_LEVEL, "EJBKeyGenerator", "getConnection", JeusMessage_EJB9._5581);
            }
            return con;
        }
        catch (SQLException t) {
            if (logger.isLoggable(JeusMessage_EJB9._5582_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5582_LEVEL, "EJBKeyGenerator", "getConnection", JeusMessage_EJB9._5582, (Object)this.dataSourceName, (Throwable)t);
            }
            throw t;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB9._5583_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5583_LEVEL, "EJBKeyGenerator", "getConnection", JeusMessage_EJB9._5583, (Object)this.dataSourceName, t);
            }
            throw new JeusSQLException("fail to getConnection");
        }
    }

    private void releaseResource(Connection con, Statement st, ResultSet rs) {
        if (logger.isLoggable(JeusMessage_EJB9._5584_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5584_LEVEL, "EJBKeyGenerator", "releaseResource", JeusMessage_EJB9._5584);
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable t3) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("genKeyType : ").append(this.genKeyType).append(StringUtil.lineSeparator);
        buffer.append("db vendor : ").append(this.dbVendor).append(StringUtil.lineSeparator);
        buffer.append("genKeyQuerySQL : ").append(this.genKeyQuerySQL).append(StringUtil.lineSeparator);
        buffer.append("genKeyUpdateSQL : ").append(this.genKeyUpdateSQL).append(StringUtil.lineSeparator);
        buffer.append("generatorName : ").append(this.generatorName).append(StringUtil.lineSeparator);
        buffer.append("userSequenceCol : ").append(this.userSequenceCol).append(StringUtil.lineSeparator);
        buffer.append("cacheSize : ").append(this.cacheSize).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

