/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.ObjectNotFoundException;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.schema.EJBFinder;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.cmp20.EJBQLHandler;
import jeus.ejb.schema.cmp20.EJBSelector;
import jeus.ejb.util.MethodConvertor;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;

public class EJBFinderForCMP20
extends EJBFinder {
    private ArrayList ejbSelectors = new ArrayList();
    private ArrayList findMethodNames = new ArrayList();
    private ArrayList ejbQLs = new ArrayList();

    public Object find(Connection con, String methodName, Object[] args, boolean isLocal, boolean isLocalIntf, int fetchSize) throws Exception {
        if (methodName.startsWith("findByPrimaryKey")) {
            if (this.checkForPrimaryKeyExistence(args[0], con)) {
                return this.container.getEJBObjectOfInternal(args[0], isLocalIntf, isLocal);
            }
            throw new ObjectNotFoundException();
        }
        int idx = this.findMethodNames.indexOf(methodName);
        EJBSelector selector = (EJBSelector)this.ejbSelectors.get(idx);
        return selector.select(con, args, isLocal, isLocalIntf, fetchSize);
    }

    public void initFinder(EJBSQLGenerator generator) throws EJBSQLGeneratorException, EJBDescriptorValidationException {
        this.writePreparedSelectSQL(generator);
        generator.sqlBuilder.addCommonWhereClause();
        if (generator.beanPair.isWriteLockingFindNeeded()) {
            generator.sqlBuilder.addForUpdate();
        }
        this.findByPrimaryKeySQL = generator.sqlBuilder.getSQL();
        for (int i = 0; i < generator.findMethods.size(); ++i) {
            EJBQLHandler handler = new EJBQLHandler();
            Method m = this.findMethods[i];
            this.ejbQLs.add(generator.beanPair.getFindSQL(m));
            boolean returnType = generator.beanPair.isEJBQLReturnTypeRemote(m);
            this.checkQLReturnType(generator, m);
            handler.generate(generator.mSchema, generator.beanPair.getBeanName(), m, (String)this.ejbQLs.get(i), returnType, generator.dbVendor);
            this.ejbSelectors.add(handler.ejbSelector);
            this.findMethodNames.add(MethodConvertor.getMethodDeclaration(m));
        }
    }

    public void setContainer(CMEntityContainer con) {
        for (int j = 0; j < this.ejbSelectors.size(); ++j) {
            ((EJBSelector)this.ejbSelectors.get(j)).setContainer(con);
        }
        this.container = con;
    }

    private void checkQLReturnType(EJBSQLGenerator generator, Method m) throws EJBSQLGeneratorException {
        Class<?> returnClass = m.getReturnType();
        if (!Collection.class.isAssignableFrom(returnClass) && m.getName().startsWith("find")) {
            if (EJBLocalObject.class.isAssignableFrom(returnClass)) {
                if (!returnClass.getName().equals(generator.beanPair.getEJBLocalObjectClassName())) {
                    throw new EJBSQLGeneratorException(JeusMessage_EJB11._7151);
                }
            } else if (EJBObject.class.isAssignableFrom(returnClass)) {
                if (!returnClass.getName().equals(generator.beanPair.getEJBObjectClassName())) {
                    throw new EJBSQLGeneratorException(JeusMessage_EJB11._7151);
                }
            } else {
                throw new EJBSQLGeneratorException(JeusMessage_EJB11._7152);
            }
        }
    }

    public String toString() {
        StringBuffer temp = new StringBuffer("findByPrimaryKey : ").append(this.findByPrimaryKeySQL);
        for (int i = 0; i < this.ejbSelectors.size(); ++i) {
            temp.append("\n\tMethod[" + i + "] : ").append(this.findMethodNames.get(i));
            temp.append("\n\tEJBQL[" + i + "] : ").append(((String)this.ejbQLs.get(i)).trim());
            temp.append("\n\tejbSelector[" + i + "] : ").append(this.ejbSelectors.get(i)).append("\n\n");
        }
        return temp.toString();
    }
}

