/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.ejb.EntityBean;
import jeus.ejb.bean.objectbase.FieldAccessor;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.EJBLoader;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class EJBLoaderForCMP20
extends EJBLoader {
    private String[] relationTableSelectSQLs;
    private CMRFieldRW[] relationFieldRWs;

    public void load(EntityBean bean, Connection con, int numLoader) throws ContainerException {
        ((FieldAccessor)bean)._clearLoadInfo();
        ((FieldAccessor)bean)._clearModifiedInfo();
    }

    public void postLoad(EntityBean bean, Connection con, int numLoader) throws ContainerException {
        boolean isBeanTableLoader;
        String selectSQL;
        if (numLoader == 0) {
            selectSQL = this.beanTableSelectSQL;
            isBeanTableLoader = true;
        } else {
            selectSQL = this.relationTableSelectSQLs[numLoader - 1];
            isBeanTableLoader = false;
        }
        FieldAccessor ejbBean = (FieldAccessor)bean;
        try {
            PreparedStatement stat = con.prepareStatement(selectSQL);
            for (int i = 0; i < this.cmPkeyFieldRWs.length; ++i) {
                this.cmPkeyFieldRWs[i].setToDBStatement(bean, stat, i + 1);
            }
            ResultSet result = stat.executeQuery();
            boolean isNotRelatedFromOtherBeans = false;
            if (!result.next()) {
                if (isBeanTableLoader) {
                    throw new ContainerException(JeusMessage_EJB11._7153);
                }
                isNotRelatedFromOtherBeans = true;
            }
            boolean[] modified = ejbBean._getModifiedInfo();
            int statIndex = 1;
            if (isBeanTableLoader) {
                for (int i = 0; i < this.cmNPkeyFieldRWs.length; ++i) {
                    if (!modified[this.cmNPkeyFieldRWs[i].getIndex()]) {
                        statIndex += this.cmNPkeyFieldRWs[i].restoreFromDBField(bean, isNotRelatedFromOtherBeans ? null : result, statIndex);
                        continue;
                    }
                    statIndex += this.cmNPkeyFieldRWs[i].getNumColumn();
                }
            } else {
                this.relationFieldRWs[numLoader - 1].restoreFromDBField(bean, isNotRelatedFromOtherBeans ? null : result, statIndex);
            }
            result.close();
            stat.close();
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB11._7154, ex);
        }
    }

    public void initLoader(EJBSQLGenerator generator) throws EJBSQLGeneratorException {
        try {
            this.beanTableSelectSQL = this.writeBeanTableLoader(generator);
            SQLBuilder sqlBuilder = generator.sqlBuilder;
            ArrayList<String> relationTableSQLList = new ArrayList<String>();
            ArrayList<CMRFieldRW> relationFieldRWList = new ArrayList<CMRFieldRW>();
            for (int i = 0; i < generator.bSchema.relations.size(); ++i) {
                sqlBuilder.initSelectSQL();
                RelationshipRolePair relation = (RelationshipRolePair)generator.bSchema.relations.elementAt(i);
                if (relation.isDelegatedRelation()) {
                    RelationshipRolePair pair = relation.getPair();
                    if (relation.isManyToManyRelation()) {
                        sqlBuilder.addColumnName(pair.getMyfkeyColNames());
                    } else {
                        EJBSQLGenerator pairDBInfo = generator.mSchema.getTargetBeanDBInfo(relation);
                        for (int j = 0; j < pairDBInfo.cmPkeyFieldRWs.size(); ++j) {
                            sqlBuilder.addColumnName(((CMPFieldRW)pairDBInfo.cmPkeyFieldRWs.get(j)).getColName());
                        }
                    }
                    sqlBuilder.beginFromClause();
                    sqlBuilder.setTableName(pair.getRelationTableName());
                    sqlBuilder.finishFromClause();
                    sqlBuilder.beginWhereClause();
                    sqlBuilder.addWhereQuestion(pair.getFkeyColNames());
                } else {
                    if (!relation.isManagedJoinRelation()) continue;
                    sqlBuilder.addColumnName(relation.getFkeyColNames());
                    sqlBuilder.beginFromClause();
                    sqlBuilder.setTableName(relation.getRelationTableName());
                    sqlBuilder.finishFromClause();
                    sqlBuilder.beginWhereClause();
                    sqlBuilder.addWhereQuestion(relation.getMyfkeyColNames());
                }
                sqlBuilder.finishWhereClause();
                if (generator.bSchema.beanPair.isWriteLockingNeeded() || generator.beanPair.isWriteLockingFindNeeded()) {
                    sqlBuilder.addForUpdate();
                }
                relationTableSQLList.add(sqlBuilder.getSQL());
                relationFieldRWList.add(relation.getFieldRW());
            }
            this.relationTableSelectSQLs = relationTableSQLList.toArray(new String[0]);
            this.relationFieldRWs = relationFieldRWList.toArray(CMRFieldRW.dummyArray);
        }
        catch (Throwable ex) {
            throw new EJBSQLGeneratorException(JeusMessage_EJB11._7155, ex);
        }
    }

    public void load(EntityBean bean, Connection con) throws ContainerException {
        for (int i = 0; i <= this.relationTableSelectSQLs.length; ++i) {
            this.load(bean, con, i);
        }
    }

    protected void addNonSharedCMRFieldColumns(BeanSchema bSchema, SQLBuilder sqlBuilder) {
        Hashtable<String, Integer> columnInfo = new Hashtable<String, Integer>();
        ArrayList<FieldRW> fieldRWs = new ArrayList<FieldRW>();
        for (int i = 0; i < this.cmNPkeyFieldRWs.length; ++i) {
            columnInfo.put(((CMPFieldRW)this.cmNPkeyFieldRWs[i]).getColName(), new Integer(i + 1));
            fieldRWs.add(this.cmNPkeyFieldRWs[i]);
        }
        int columnIdx = this.cmNPkeyFieldRWs.length;
        for (int i = 0; i < bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)bSchema.relations.elementAt(i);
            if (!relation.isManagedRelationType()) continue;
            CMRFieldRW frw = relation.getFieldRW();
            String[] fkeyColNames = relation.getFkeyColNames();
            if (!relation.isSharedWithCMPFields()) {
                sqlBuilder.addColumnName(relation.getFkeyColNames());
            } else {
                int[] colIDForLoad = new int[fkeyColNames.length];
                for (int j = 0; j < fkeyColNames.length; ++j) {
                    Integer colIdx = (Integer)columnInfo.get(fkeyColNames[j]);
                    if (colIdx == null) {
                        String fkeyColName = fkeyColNames[j];
                        sqlBuilder.addColumnName(fkeyColName);
                        columnInfo.put(fkeyColName, new Integer(columnIdx));
                        colIDForLoad[j] = columnIdx++;
                        continue;
                    }
                    colIDForLoad[j] = colIdx;
                }
                frw.colIDForLoad = colIDForLoad;
            }
            fieldRWs.add(frw);
        }
        this.cmNPkeyFieldRWs = fieldRWs.toArray(FieldRW.dummyArray);
    }

    public String toString() {
        String temp = "EJBLoader : \tbeanTableSelectSQL : " + this.beanTableSelectSQL;
        if (this.relationTableSelectSQLs != null) {
            for (int i = 0; i < this.relationTableSelectSQLs.length; ++i) {
                temp = temp + "\n\trelationTableSelectSQL[" + i + "] : " + this.relationTableSelectSQLs[i];
            }
        }
        return temp;
    }
}

