/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.ejbql;

import java.util.Iterator;
import jeus.ejb.persistence.database.ExtendedSQLBuilder;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.cmp20.EJBQLHandler;
import jeus.ejb.schema.ejbql.EJBQLValidationException;
import jeus.ejb.schema.ejbql.NavigationInfo;
import jeus.ejb.schema.ejbql.ValidationVisitor;
import jeus.ejb.schema.ejbql.VariableInfo;
import jeus.ejb.schema.ejbql.Visitor;
import jeus.ejb.schema.ejbql.element.AbstractSchemaName;
import jeus.ejb.schema.ejbql.element.AggregationFuncExpr;
import jeus.ejb.schema.ejbql.element.BetweenExpr;
import jeus.ejb.schema.ejbql.element.BinaryOperation;
import jeus.ejb.schema.ejbql.element.BinaryOperationExpr;
import jeus.ejb.schema.ejbql.element.BooleanLiteral;
import jeus.ejb.schema.ejbql.element.CMPField;
import jeus.ejb.schema.ejbql.element.CMRField;
import jeus.ejb.schema.ejbql.element.CollectionMemberDecl;
import jeus.ejb.schema.ejbql.element.CollectionMemberExpr;
import jeus.ejb.schema.ejbql.element.CollectionValuedCMRField;
import jeus.ejb.schema.ejbql.element.CollectionValuedPathExpr;
import jeus.ejb.schema.ejbql.element.ComparisonExpr;
import jeus.ejb.schema.ejbql.element.ConcatFunc;
import jeus.ejb.schema.ejbql.element.ConditionalExprsWithLogicalOperator;
import jeus.ejb.schema.ejbql.element.CountFuncExpr;
import jeus.ejb.schema.ejbql.element.DoubleNumericLiteral;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.ejb.schema.ejbql.element.EJBQLQuery;
import jeus.ejb.schema.ejbql.element.EJBQLSubQuery;
import jeus.ejb.schema.ejbql.element.EmptyCollectionComparisonExpr;
import jeus.ejb.schema.ejbql.element.ExistsExpr;
import jeus.ejb.schema.ejbql.element.Expression;
import jeus.ejb.schema.ejbql.element.Field;
import jeus.ejb.schema.ejbql.element.FloatNumericLiteral;
import jeus.ejb.schema.ejbql.element.FromClause;
import jeus.ejb.schema.ejbql.element.GroupByClause;
import jeus.ejb.schema.ejbql.element.HavingClause;
import jeus.ejb.schema.ejbql.element.IdentificationVar;
import jeus.ejb.schema.ejbql.element.IdentificationVarDecl;
import jeus.ejb.schema.ejbql.element.InExpr;
import jeus.ejb.schema.ejbql.element.InputParam;
import jeus.ejb.schema.ejbql.element.IntegerNumericLiteral;
import jeus.ejb.schema.ejbql.element.LikeExpr;
import jeus.ejb.schema.ejbql.element.LocateFunc;
import jeus.ejb.schema.ejbql.element.LongNumericLiteral;
import jeus.ejb.schema.ejbql.element.ModFunc;
import jeus.ejb.schema.ejbql.element.NewIdentificationVar;
import jeus.ejb.schema.ejbql.element.NullComparisonExpr;
import jeus.ejb.schema.ejbql.element.OrderByClause;
import jeus.ejb.schema.ejbql.element.OrderByItem;
import jeus.ejb.schema.ejbql.element.PathExpression;
import jeus.ejb.schema.ejbql.element.RangeVarDecl;
import jeus.ejb.schema.ejbql.element.SelectClause;
import jeus.ejb.schema.ejbql.element.SelectClauseForSubQuery;
import jeus.ejb.schema.ejbql.element.SelectHint;
import jeus.ejb.schema.ejbql.element.SingleValuedCMRField;
import jeus.ejb.schema.ejbql.element.SingleValuedCMRPathExpr;
import jeus.ejb.schema.ejbql.element.SingleValuedField;
import jeus.ejb.schema.ejbql.element.SingleValuedPathExpr;
import jeus.ejb.schema.ejbql.element.StringLiteral;
import jeus.ejb.schema.ejbql.element.SubstringFunc;
import jeus.ejb.schema.ejbql.element.UnaryArithmeticFunc;
import jeus.ejb.schema.ejbql.element.UnaryExpr;
import jeus.ejb.schema.ejbql.element.UniqueExpr;
import jeus.ejb.schema.ejbql.element.WhereClause;
import jeus.ejb.schema.ejbql.parser.EJBQLParser;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class SQLBuilderVisitor
extends Visitor {
    private EJBQLQuery query;
    private SQLBuilder fromBuilder;
    private SQLBuilder selectBuilder;
    private SQLBuilder orderByBuilder;
    private SQLBuilder groupByBuilder;
    private SQLBuilder exprBuilder;
    private SQLBuilder conditionBuilder;
    static final String SUBQUERY_VAR_INFIX = "SubVar";
    static final String SUBQUERY_FROM_TABLE = "SubTRef";
    private EJBQLHandler handler;
    private int subqueryIndex;
    private String dbVendor;
    private boolean isCountSelect;

    public SQLBuilderVisitor(EJBQLQuery sentence, EJBQLHandler handler, String dbVendor) throws EJBSQLGeneratorException {
        this.query = sentence;
        this.dbVendor = dbVendor;
        this.handler = handler;
        this.fromBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.selectBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.exprBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.conditionBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.orderByBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.groupByBuilder = SQLBuilder.createSQLBuilder(dbVendor);
        this.conditionBuilder.initEmpty();
    }

    public EJBQLQuery generateSQL() throws EJBQLParseException {
        this.query.accept(this);
        this.selectBuilder.merge(this.fromBuilder);
        if (this.query.where != null) {
            this.selectBuilder.merge(this.conditionBuilder);
        } else if (this.conditionBuilder.getCurrentElement() > 0) {
            this.selectBuilder.beginWhereClause();
            this.selectBuilder.merge(this.conditionBuilder);
            this.selectBuilder.finishWhereClause();
        }
        if (this.query.groupBy != null) {
            this.selectBuilder.merge(this.groupByBuilder);
        }
        if (this.query.orderBy != null) {
            this.selectBuilder.merge(this.orderByBuilder);
        }
        this.query.setSQL(this.selectBuilder.getSQL());
        return this.query;
    }

    public void visitEJBQLQuery(EJBQLQuery query) throws EJBQLParseException {
        query.from.accept(this);
        if (query.selectHint != null) {
            query.selectHint.accept(this);
        }
        query.select.accept(this);
        if (!this.isCountSelect) {
            if (query.orderBy != null) {
                query.orderBy.accept(this);
            }
            if (query.groupBy != null) {
                query.groupBy.accept(this);
            }
            if (query.where != null) {
                query.where.accept(this);
            }
        }
    }

    public void visitFromClause(FromClause from) throws EJBQLParseException {
        this.fromBuilder.initEmpty();
        this.fromBuilder.beginFromClause();
        IdentificationVarDecl[] varDecls = from.getVarDecls();
        for (int i = 0; i < varDecls.length; ++i) {
            varDecls[i].accept(this);
        }
        this.fromBuilder.finishFromClause();
    }

    public void visitRangeVarDecl(RangeVarDecl varDecl) throws EJBQLParseException {
        varDecl.var.accept(this);
    }

    public void visitAbstractSchemaName(AbstractSchemaName abstractSchemaName) throws EJBQLValidationException {
    }

    public void visitNewIdentificationVar(NewIdentificationVar newVar) throws EJBQLValidationException {
        String tableRef;
        NavigationInfo info;
        VariableInfo variableInfo = newVar.getVariableInfo();
        Iterator iter = variableInfo.getBranchTableNameIterator();
        while (iter.hasNext()) {
            info = (NavigationInfo)iter.next();
            tableRef = variableInfo.getTableReference(info);
            this.fromBuilder.addTableName(info.getTargetTableName(), tableRef);
        }
        iter = variableInfo.getBranchJoinTableNameIterator();
        while (iter.hasNext()) {
            info = (NavigationInfo)iter.next();
            tableRef = variableInfo.getJoinTableReference(info);
            this.fromBuilder.addTableName(info.getTargetJoinTableName(), tableRef);
        }
    }

    public void visitCollectionMemberDecl(CollectionMemberDecl varDecl) throws EJBQLParseException {
        varDecl.expr.accept(this);
        varDecl.var.accept(this);
    }

    public void visitPathExpression(PathExpression path) throws EJBQLParseException {
        String ownerTableReference = path.var.getTableReference();
        for (int i = 0; i < path.fields.length; ++i) {
            SingleValuedCMRField field = path.fields[i];
            field.setFieldOwnerTableReference(ownerTableReference);
            String targetTableReference = field.getTargetTableReference();
            this.getJoinExpression(field, ownerTableReference);
            ownerTableReference = targetTableReference;
        }
        path.field.setFieldOwnerTableReference(ownerTableReference);
        path.field.accept(this);
    }

    public void getJoinExpression(CMRField field, String fieldOwnerTableReference) throws EJBQLParseException {
        RelationshipRolePair rDesc = field.getRelationshipDescriptor();
        switch (rDesc.getRelationType()) {
            case 0: 
            case 3: {
                rDesc = rDesc.getPair();
                String myTableRefName = field.getTargetTableReference();
                String pairTableRefName = fieldOwnerTableReference;
                EJBSQLGenerator pairDBInfo = field.getFieldOwnerBeanSchema().sqlGen;
                this.writeTableRelation(rDesc, myTableRefName, pairTableRefName, pairDBInfo);
                break;
            }
            case 1: 
            case 2: {
                String myTableRefName = fieldOwnerTableReference;
                String pairTableRefName = field.getTargetTableReference();
                EJBSQLGenerator pairDBInfo = field.getTargetBeanSchema().sqlGen;
                this.writeTableRelation(rDesc, myTableRefName, pairTableRefName, pairDBInfo);
                break;
            }
            case 5: {
                rDesc = rDesc.getPair();
                EJBSQLGenerator pairDBInfo = field.getFieldOwnerBeanSchema().sqlGen;
                EJBSQLGenerator myDBInfo = field.getTargetBeanSchema().sqlGen;
                String pairTableRefName = fieldOwnerTableReference;
                String myTableRefName = field.getTargetTableReference();
                String mmTableRefName = ((CollectionValuedCMRField)field).getJoinTableReference();
                this.writeJoinTableRelation(rDesc, myTableRefName, myDBInfo, mmTableRefName, pairTableRefName, pairDBInfo);
                break;
            }
            case 4: {
                EJBSQLGenerator myDBInfo = field.getFieldOwnerBeanSchema().sqlGen;
                EJBSQLGenerator pairDBInfo = field.getTargetBeanSchema().sqlGen;
                String myTableRefName = fieldOwnerTableReference;
                String pairTableRefName = field.getTargetTableReference();
                String mmTableRefName = ((CollectionValuedCMRField)field).getJoinTableReference();
                this.writeJoinTableRelation(rDesc, myTableRefName, myDBInfo, mmTableRefName, pairTableRefName, pairDBInfo);
                break;
            }
        }
    }

    private void writeJoinTableRelation(RelationshipRolePair rDesc, String myTableRefName, EJBSQLGenerator myDBInfo, String mmTableRefName, String pairTableRefName, EJBSQLGenerator pairDBInfo) {
        this.conditionBuilder.beginANDCondition();
        String[] myfkeyColNames = rDesc.getMyfkeyColNames();
        for (int i = 0; i < myfkeyColNames.length; ++i) {
            this.conditionBuilder.addANDEqualCondition(myTableRefName, ((CMPFieldRW)myDBInfo.cmPkeyFieldRWs.get(i)).getColName(), mmTableRefName, myfkeyColNames[i]);
        }
        String[] fkeyColNames = rDesc.getFkeyColNames();
        for (int i = 0; i < fkeyColNames.length; ++i) {
            this.conditionBuilder.addANDEqualCondition(mmTableRefName, fkeyColNames[i], pairTableRefName, ((CMPFieldRW)pairDBInfo.cmPkeyFieldRWs.get(i)).getColName());
        }
        this.conditionBuilder.finishANDCondition();
    }

    private void writeTableRelation(RelationshipRolePair rDesc, String myTableRefName, String pairTableRefName, EJBSQLGenerator pairDBInfo) {
        this.conditionBuilder.beginANDCondition();
        String[] fkeyColNames = rDesc.getFkeyColNames();
        for (int i = 0; i < fkeyColNames.length; ++i) {
            this.conditionBuilder.addANDEqualCondition(myTableRefName, fkeyColNames[i], pairTableRefName, ((CMPFieldRW)pairDBInfo.cmPkeyFieldRWs.get(i)).getColName());
        }
        this.conditionBuilder.finishANDCondition();
    }

    public void visitIdentificationVar(IdentificationVar var) throws EJBQLValidationException {
        this.exprBuilder.setTableReferenceForColumns(var.getTableReference());
        EJBSQLGenerator generator = var.getEJBSQLGenerator();
        for (int i = 0; i < generator.cmPkeyFieldRWs.size(); ++i) {
            this.exprBuilder.addColumnNameFollowingTableRef(((CMPFieldRW)generator.cmPkeyFieldRWs.get(i)).getColName());
        }
    }

    public void visitCMRField(CMRField field) throws EJBQLParseException {
    }

    public void visitSingleValuedCMRField(SingleValuedCMRField field) throws EJBQLParseException {
        RelationshipRolePair rd = field.getRelationshipDescriptor();
        if (rd.isDelegatedRelation()) {
            this.getJoinExpression(field, field.getFieldOwnerTableReference());
            this.exprBuilder.setTableReferenceForColumns(field.getTargetTableReference());
            EJBSQLGenerator pairDBInfo = field.getTargetEJBSQLGenerator();
            for (int i = 0; i < pairDBInfo.cmPkeyFieldRWs.size(); ++i) {
                this.exprBuilder.addColumnNameFollowingTableRef(((CMPFieldRW)pairDBInfo.cmPkeyFieldRWs.get(i)).getColName());
            }
        } else {
            this.exprBuilder.setTableReferenceForColumns(field.getFieldOwnerTableReference());
            String[] fkeyColNames = rd.getFkeyColNames();
            for (int i = 0; i < fkeyColNames.length; ++i) {
                this.exprBuilder.addColumnNameFollowingTableRef(fkeyColNames[i]);
            }
        }
    }

    public void visitSingleValuedField(SingleValuedField field) throws EJBQLParseException {
        field.getWrappedField().accept(this);
    }

    public void visitCollectionValuedCMRField(CollectionValuedCMRField field) throws EJBQLParseException {
        this.getJoinExpression(field, field.getFieldOwnerTableReference());
    }

    public void visitSelectClause(SelectClause selectClause) throws EJBQLParseException {
        if (!this.selectBuilder.isInitialized()) {
            this.selectBuilder.initSelectSQL();
        }
        if (selectClause.isDistinct) {
            this.selectBuilder.addDistinct();
        }
        Expression[] exprs = selectClause.selectColumn;
        for (int i = 0; i < exprs.length; ++i) {
            this.exprBuilder.initEmpty();
            exprs[i].accept(this);
            this.selectBuilder.addColumnName(this.exprBuilder.getSQL());
        }
    }

    public void visitCMPField(CMPField field) throws EJBQLParseException {
        CMPFieldRW fieldRW = field.getCMPFieldRW();
        this.exprBuilder.setTableReferenceForColumns(field.getFieldOwnerTableReference());
        this.exprBuilder.addColumnNameFollowingTableRef(fieldRW.getColName());
    }

    public void visitAggregationFuncExpr(AggregationFuncExpr expr) throws EJBQLParseException {
        this.exprBuilder.beginAggregationFuncation(expr.funcName);
        if (expr.isDistinct) {
            this.exprBuilder.addDistinct();
        }
        expr.paramExpr.accept(this);
        this.exprBuilder.finishAggregationFuncation();
    }

    public void visitWhereClause(WhereClause whereClause) throws EJBQLParseException {
        String relationCondition = null;
        if (this.conditionBuilder.getCurrentElement() > 0) {
            relationCondition = this.conditionBuilder.getSQL();
        }
        this.conditionBuilder.initEmpty();
        this.conditionBuilder.beginWhereClause();
        if (relationCondition != null) {
            this.conditionBuilder.beginANDCondition();
        }
        whereClause.whereConditionExpr.accept(this);
        if (relationCondition != null) {
            this.conditionBuilder.finishANDCondition();
        }
        if (relationCondition != null) {
            this.conditionBuilder.beginANDCondition();
            this.conditionBuilder.addCondition(relationCondition);
            this.conditionBuilder.finishANDCondition();
        }
        this.conditionBuilder.finishWhereClause();
    }

    public void visitComparisonExpr(ComparisonExpr expr) throws EJBQLParseException {
        String exprString;
        if (expr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        SQLBuilder prevConditionBuilder = (SQLBuilder)this.conditionBuilder.clone();
        this.conditionBuilder.initEmpty();
        String valueString = null;
        boolean isBeanComparison = expr.value.isBeanType();
        if (isBeanComparison) {
            SQLBuilder builder = this.exprBuilder;
            try {
                this.exprBuilder = ExtendedSQLBuilder.createSQLBuilder(this.dbVendor);
            }
            catch (EJBSQLGeneratorException ex) {
                throw new EJBQLParseException("The database vendor " + this.dbVendor + " is not supported");
            }
            this.exprBuilder.initEmpty();
            expr.value.accept(this);
            ((ExtendedSQLBuilder)this.exprBuilder).setRight();
            expr.expr.accept(this);
            ((ExtendedSQLBuilder)this.exprBuilder).setOperator(expr.oper.typeString);
            exprString = this.exprBuilder.getSQL();
            this.exprBuilder = builder;
        } else {
            this.exprBuilder.initEmpty();
            expr.value.accept(this);
            valueString = this.exprBuilder.getSQL();
            this.exprBuilder.initEmpty();
            expr.expr.accept(this);
            exprString = this.exprBuilder.getSQL();
        }
        if (this.conditionBuilder.getCurrentElement() > 0) {
            prevConditionBuilder.beginANDCondition();
            if (expr.isNot) {
                prevConditionBuilder.beginNotCondition();
            }
            if (isBeanComparison) {
                prevConditionBuilder.addString(exprString);
            } else {
                prevConditionBuilder.addComparisonCondition(valueString, expr.oper.typeString, exprString);
            }
            if (expr.isNot) {
                prevConditionBuilder.finishNotCondition();
            }
            prevConditionBuilder.finishANDCondition();
            prevConditionBuilder.beginANDCondition();
            prevConditionBuilder.addCondition(this.conditionBuilder.getSQL());
            prevConditionBuilder.finishANDCondition();
        } else {
            if (expr.isNot) {
                prevConditionBuilder.beginNotCondition();
            }
            if (isBeanComparison) {
                prevConditionBuilder.addString(exprString);
            } else {
                prevConditionBuilder.addComparisonCondition(valueString, expr.oper.typeString, exprString);
            }
            if (expr.isNot) {
                prevConditionBuilder.finishNotCondition();
            }
        }
        this.conditionBuilder = prevConditionBuilder;
        if (expr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    public void visitSubstringFunc(SubstringFunc expr) throws EJBQLParseException {
        if (expr.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.beginSubstringFunc();
        expr.expr1.accept(this);
        this.exprBuilder.afterSubstringFuncParam1();
        expr.expr2.accept(this);
        this.exprBuilder.afterSubstringFuncParam2();
        expr.expr3.accept(this);
        this.exprBuilder.finishSubstringFunc();
        if (expr.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitLocateFunc(LocateFunc locateFunc) throws EJBQLParseException {
        if (locateFunc.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.beginLocateFunc();
        locateFunc.expr1.accept(this);
        this.exprBuilder.afterLocateFuncParam1();
        locateFunc.expr2.accept(this);
        if (locateFunc.expr3 != null) {
            this.exprBuilder.afterLocateFuncParam2();
            locateFunc.expr3.accept(this);
        }
        this.exprBuilder.finishLocateFunc();
        if (locateFunc.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitUnaryArithmeticFunc(UnaryArithmeticFunc unaryArithmeticFunc) throws EJBQLParseException {
        if (unaryArithmeticFunc.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.beginFunc(unaryArithmeticFunc.oper.typeString);
        if (unaryArithmeticFunc.oper.typeString.equals("ABS") && unaryArithmeticFunc.expr instanceof InputParam) {
            Class inputClass = ((InputParam)unaryArithmeticFunc.expr).getCorrespondingParamClass();
            if (Integer.class.isAssignableFrom(inputClass) || Long.class.isAssignableFrom(inputClass) || Short.class.isAssignableFrom(inputClass)) {
                this.exprBuilder.addInputParam(true);
            } else {
                this.exprBuilder.addInputParam(false);
            }
        } else {
            unaryArithmeticFunc.expr.accept(this);
        }
        this.exprBuilder.finishFunc();
        if (unaryArithmeticFunc.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitModFunc(ModFunc modFunc) throws EJBQLParseException {
        if (modFunc.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.beginModFunc();
        modFunc.target.accept(this);
        this.exprBuilder.afterModFuncParam();
        modFunc.modSize.accept(this);
        this.exprBuilder.finishModFunc();
        if (modFunc.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitConcatFunc(ConcatFunc concatFunc) throws EJBQLParseException {
        if (concatFunc.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.beginConcatFunc();
        concatFunc.expr1.accept(this);
        this.exprBuilder.afterConcatFuncParam();
        concatFunc.expr2.accept(this);
        this.exprBuilder.finishConcatFunc();
        if (concatFunc.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitUnaryExpr(UnaryExpr unaryExpr) throws EJBQLParseException {
        if (unaryExpr.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        this.exprBuilder.addString(unaryExpr.oper.typeString);
        unaryExpr.expr.accept(this);
        if (unaryExpr.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitBinaryOperationExpr(BinaryOperationExpr binaryOperationExpr) throws EJBQLParseException {
        if (binaryOperationExpr.isEnclosed()) {
            this.exprBuilder.beginParenthesis();
        }
        binaryOperationExpr.expr1.accept(this);
        if (binaryOperationExpr.binaryOperations != null) {
            for (int i = 0; i < binaryOperationExpr.binaryOperations.length; ++i) {
                this.exprBuilder.addString(binaryOperationExpr.binaryOperations[i].oper.typeString);
                binaryOperationExpr.binaryOperations[i].expr2.accept(this);
            }
        }
        if (binaryOperationExpr.isEnclosed()) {
            this.exprBuilder.finishParenthesis();
        }
    }

    public void visitBinaryOperation(BinaryOperation binaryOperation) throws EJBQLParseException {
    }

    public void visitCountFuncExpr(CountFuncExpr expr) throws EJBQLParseException {
        this.exprBuilder.beginCountFunc();
        if (expr.countExpr == null) {
            this.exprBuilder.addAsteriskToListIfNeeded();
            this.exprBuilder.finishCountFunc();
            return;
        }
        if (expr.isDistinct && expr.countExpr.isCompoundPrimaryKey()) {
            StringBuffer subQuery;
            IdentificationVar var;
            this.exprBuilder.addAsteriskToListIfNeeded();
            this.exprBuilder.finishCountFunc();
            SingleValuedPathExpr pathExpr = null;
            if (expr.countExpr instanceof IdentificationVar) {
                var = (IdentificationVar)expr.countExpr;
            } else {
                pathExpr = (SingleValuedPathExpr)expr.countExpr;
                var = pathExpr.var;
            }
            String subQuerySelectVarName = var.varName;
            if (pathExpr == null) {
                subQuery = new StringBuffer("SELECT DISTINCT OBJECT(").append(subQuerySelectVarName).append(") FROM ");
            } else {
                subQuery = new StringBuffer("SELECT DISTINCT ").append(subQuerySelectVarName);
                if (pathExpr.fields.length > 0) {
                    for (int i = 0; i < pathExpr.fields.length; ++i) {
                        subQuery.append(".").append(pathExpr.fields[i].fieldName);
                    }
                }
                subQuery.append(".").append(pathExpr.field.fieldName).append(" FROM ");
            }
            String[] ql = this.handler.ejbQL.split("[Ff][Rr][Oo][Mm]", 2);
            subQuery.append(ql[1]);
            EJBQLQuery query = EJBQLParser.parse(subQuery.toString());
            try {
                ValidationVisitor validationVisitor = new ValidationVisitor(query, this.handler);
                validationVisitor.validate(false);
                SQLBuilderVisitor visitor = new SQLBuilderVisitor(query, this.handler, this.dbVendor);
                visitor.generateSQL();
            }
            catch (EJBSQLGeneratorException ex) {
                throw new EJBQLParseException("The database vendor " + this.dbVendor + " is not supported");
            }
            this.fromBuilder.initEmpty();
            this.fromBuilder.beginFromClause();
            this.fromBuilder.addTableName("( " + query.getSQL() + " )", subQuerySelectVarName + SUBQUERY_FROM_TABLE + this.subqueryIndex++);
            this.isCountSelect = true;
        } else {
            if (expr.isDistinct) {
                this.exprBuilder.addDistinct();
            }
            expr.countExpr.accept(this);
            this.exprBuilder.finishCountFunc();
        }
    }

    public void visitBooleanLiteral(BooleanLiteral booleanLiteral) throws EJBQLParseException {
        this.exprBuilder.addBoolean(booleanLiteral.value);
    }

    public void visitLongNumericLiteral(LongNumericLiteral longNumericLiteral) throws EJBQLParseException {
        this.exprBuilder.addString(Long.toString(longNumericLiteral.value));
    }

    public void visitIntegerNumericLiteral(IntegerNumericLiteral integerNumericLiteral) throws EJBQLParseException {
        this.exprBuilder.addString(Integer.toString(integerNumericLiteral.value));
    }

    public void visitFloatNumericLiteral(FloatNumericLiteral floatNumericLiteral) throws EJBQLParseException {
        this.exprBuilder.addString(Float.toString(floatNumericLiteral.value));
    }

    public void visitDoubleNumericLiteral(DoubleNumericLiteral doubleNumericLiteral) throws EJBQLParseException {
        this.exprBuilder.addString(Double.toString(doubleNumericLiteral.value));
    }

    public void visitStringLiteral(StringLiteral stringLiteral) throws EJBQLParseException {
        this.exprBuilder.addLiteral(stringLiteral.value);
    }

    public void visitInputParam(InputParam inputParam) throws EJBQLParseException {
        if (inputParam.isBeanType()) {
            ((ExtendedSQLBuilder)this.exprBuilder).addQuestionsToRight();
        } else {
            this.exprBuilder.addInputParam();
        }
    }

    public void visitCollectionMemberExpr(CollectionMemberExpr expr) throws EJBQLParseException {
        int i;
        if (expr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        this.conditionBuilder.beginExistsCondition(expr.isNot);
        IdentificationVarDecl targetVarDecl = null;
        SingleValuedCMRPathExpr targetPathExpr = null;
        String subQueryTargetVarName = null;
        if (expr.target instanceof SingleValuedCMRPathExpr) {
            targetPathExpr = (SingleValuedCMRPathExpr)expr.target;
            targetVarDecl = targetPathExpr.var.getVariableInfo().getVariableDecl();
            subQueryTargetVarName = targetVarDecl.var.newVarName;
        } else if (expr.target instanceof IdentificationVar) {
            targetVarDecl = ((IdentificationVar)expr.target).getVariableInfo().getVariableDecl();
            subQueryTargetVarName = targetVarDecl.var.newVarName;
        }
        IdentificationVarDecl expVarDecl = expr.collection.var.getVariableInfo().getVariableDecl();
        boolean isNeedTargetVariableDeclaration = targetVarDecl != null && !targetVarDecl.var.newVarName.equals(expVarDecl.var.newVarName);
        String subQueryVarNamePrefix = expr.collection.var.varName + SUBQUERY_VAR_INFIX;
        String subQuerySelectVarName = subQueryVarNamePrefix + this.subqueryIndex++;
        String subQueryExpVarName = expVarDecl.var.newVarName;
        String subQuery = "SELECT OBJECT(" + subQuerySelectVarName + ") FROM " + this.makeVarDeclPhrase(expVarDecl, subQueryExpVarName);
        subQuery = subQuery + ", IN (" + subQueryExpVarName;
        for (i = 0; i < expr.collection.fields.length; ++i) {
            subQuery = subQuery + "." + expr.collection.fields[i].fieldName;
        }
        subQuery = subQuery + "." + expr.collection.field.fieldName + ") " + subQuerySelectVarName;
        if (isNeedTargetVariableDeclaration) {
            subQuery = subQuery + ", " + this.makeVarDeclPhrase(targetVarDecl, subQueryTargetVarName);
        }
        subQuery = subQuery + " WHERE " + subQuerySelectVarName + " = ";
        if (targetVarDecl == null) {
            subQuery = subQuery + "?" + ((InputParam)expr.target).index;
        } else {
            subQuery = subQuery + subQueryTargetVarName;
            if (targetPathExpr != null) {
                for (i = 0; i < targetPathExpr.fields.length; ++i) {
                    subQuery = subQuery + "." + targetPathExpr.fields[i].fieldName;
                }
                subQuery = subQuery + "." + targetPathExpr.field.fieldName;
            }
        }
        EJBQLQuery query = EJBQLParser.parse(subQuery);
        try {
            ValidationVisitor validationVisitor = new ValidationVisitor(query, this.handler);
            validationVisitor.validate();
            this.convertToOuterReference(query, 0);
            if (isNeedTargetVariableDeclaration) {
                this.convertToOuterReference(query, 2);
            }
            SQLBuilderVisitor visitor = new SQLBuilderVisitor(query, this.handler, this.dbVendor);
            visitor.generateSQL();
        }
        catch (EJBSQLGeneratorException ex) {
            throw new EJBQLParseException("The database vendor " + this.dbVendor + " is not supported");
        }
        this.conditionBuilder.addSubSelectQuery(this.convertSubQL(query.getSQL()));
        this.conditionBuilder.finishExistsCondition();
        if (expr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    private void convertToOuterReference(EJBQLQuery query, int varDeclIndex) {
        VariableInfo info = query.from.getVarDecls((int)varDeclIndex).var.getVariableInfo();
        info.removeBranchRelation(info.getNavigationInfo());
        info.attachTableReferenceInfix("_SUB_");
    }

    public void visitEmptyCollectionComparisonExpr(EmptyCollectionComparisonExpr expr) throws EJBQLParseException {
        if (expr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        this.conditionBuilder.beginExistsCondition(!expr.isNot);
        IdentificationVarDecl varDecl = expr.expr.var.getVariableInfo().getVariableDecl();
        String subQueryVarNamePrefix = expr.expr.var.varName + SUBQUERY_VAR_INFIX;
        String subQuerySelectVarName = subQueryVarNamePrefix + this.subqueryIndex++;
        String subQueryRootVarName = expr.expr.var.varName;
        String subQuery = "SELECT OBJECT(" + subQuerySelectVarName + ") FROM " + this.makeVarDeclPhrase(varDecl, subQueryRootVarName) + ", IN (" + subQueryRootVarName;
        for (int i = 0; i < expr.expr.fields.length; ++i) {
            subQuery = subQuery + "." + expr.expr.fields[i].fieldName;
        }
        subQuery = subQuery + "." + expr.expr.field.fieldName + ") " + subQuerySelectVarName;
        EJBQLQuery query = EJBQLParser.parse(subQuery);
        try {
            ValidationVisitor validationVisitor = new ValidationVisitor(query, this.handler);
            validationVisitor.validate();
            this.convertToOuterReference(query, 0);
            SQLBuilderVisitor visitor = new SQLBuilderVisitor(query, this.handler, this.dbVendor);
            visitor.generateSQL();
        }
        catch (EJBSQLGeneratorException ex) {
            throw new EJBQLParseException("The database vendor " + this.dbVendor + " is not supported");
        }
        this.conditionBuilder.addSubSelectQuery(this.convertSubQL(query.getSQL()));
        this.conditionBuilder.finishExistsCondition();
        if (expr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    public void visitNullComparisonExpr(NullComparisonExpr expr) throws EJBQLParseException {
        if (expr.expr instanceof SingleValuedPathExpr) {
            boolean isFKeyInBeanTable;
            boolean isNeedExists = true;
            SingleValuedPathExpr pathExpr = (SingleValuedPathExpr)expr.expr;
            Field field = ((SingleValuedField)pathExpr.field).getWrappedField();
            boolean bl = isFKeyInBeanTable = field instanceof CMPField || ((CMRField)field).getRelationshipDescriptor().isManagedOneToOneType();
            if (isFKeyInBeanTable) {
                if (expr.isEnclosed()) {
                    this.conditionBuilder.beginParenthesis();
                }
                if (pathExpr.fields.length == 0) {
                    isNeedExists = false;
                }
                if (isNeedExists && !expr.isEnclosed() && !expr.isNot) {
                    this.conditionBuilder.beginParenthesis();
                }
                if (isNeedExists) {
                    this.conditionBuilder.beginORConditionByUser();
                }
                this.exprBuilder.initEmpty();
                pathExpr.accept(this);
                this.conditionBuilder.beginANDCondition();
                if (expr.isNot) {
                    this.conditionBuilder.beginNotCondition();
                }
                this.conditionBuilder.addIsNullCondition(this.exprBuilder.getSQL());
                this.conditionBuilder.finishANDCondition();
                if (isNeedExists) {
                    this.conditionBuilder.finishORConditionByUser();
                    this.conditionBuilder.beginORConditionByUser();
                }
            } else if (expr.isNot) {
                this.conditionBuilder.beginNotCondition();
            } else if (expr.isEnclosed()) {
                this.conditionBuilder.beginParenthesis();
            }
            if (isNeedExists) {
                this.conditionBuilder.beginNotExistsCondition();
                IdentificationVarDecl varDecl = pathExpr.var.getVariableInfo().getVariableDecl();
                String subQuerySelectVarName = pathExpr.var.varName;
                String subQuery = "SELECT " + subQuerySelectVarName;
                for (int i = 0; i < pathExpr.fields.length; ++i) {
                    subQuery = subQuery + "." + pathExpr.fields[i].fieldName;
                }
                subQuery = subQuery + "." + pathExpr.field.fieldName + " FROM " + this.makeVarDeclPhrase(varDecl, subQuerySelectVarName);
                EJBQLQuery query = EJBQLParser.parse(subQuery);
                try {
                    ValidationVisitor validationVisitor = new ValidationVisitor(query, this.handler);
                    validationVisitor.validate();
                    this.convertToOuterReference(query, 0);
                    SQLBuilderVisitor visitor = new SQLBuilderVisitor(query, this.handler, this.dbVendor);
                    visitor.generateSQL();
                }
                catch (EJBSQLGeneratorException ex) {
                    throw new EJBQLParseException("The database vendor " + this.dbVendor + " is not supported");
                }
                this.conditionBuilder.addSubSelectQuery(this.convertSubQL(query.getSQL()));
                this.conditionBuilder.finishNotExistsCondition();
                if (isFKeyInBeanTable) {
                    this.conditionBuilder.finishORConditionByUser();
                    if (!expr.isEnclosed() && !expr.isNot) {
                        this.conditionBuilder.finishParenthesis();
                    }
                }
            }
        } else {
            if (expr.isNot) {
                this.conditionBuilder.beginNotCondition();
            } else if (expr.isEnclosed()) {
                this.conditionBuilder.beginParenthesis();
            }
            expr.expr.accept(this);
            this.conditionBuilder.addIsNullCondition("?");
        }
        if (expr.isNot) {
            this.conditionBuilder.finishNotCondition();
        } else if (expr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    private String makeVarDeclPhrase(IdentificationVarDecl varDecl, String tRefName) {
        if (varDecl instanceof RangeVarDecl) {
            return ((RangeVarDecl)varDecl).schemaName.schemaName + " " + tRefName;
        }
        CollectionMemberDecl decl = (CollectionMemberDecl)varDecl;
        CollectionValuedPathExpr pathExpr = decl.expr;
        return ((CollectionValuedCMRField)pathExpr.field).getTargetBeanSchema().beanPair.getSchemaName() + " " + tRefName;
    }

    private String convertSubQL(String sql) {
        int fromIndex = sql.indexOf("FROM");
        StringBuffer buffer = new StringBuffer("SELECT * ").append(sql.substring(fromIndex));
        return buffer.toString();
    }

    public void visitBetweenExpr(BetweenExpr betweenExpr) throws EJBQLParseException {
        this.conditionBuilder.beginParenthesis();
        SQLBuilder prevConditionBuilder = (SQLBuilder)this.conditionBuilder.clone();
        this.conditionBuilder.initEmpty();
        this.exprBuilder.initEmpty();
        betweenExpr.target.accept(this);
        String s1 = this.exprBuilder.getSQL();
        this.exprBuilder.initEmpty();
        betweenExpr.fromRange.accept(this);
        String s2 = this.exprBuilder.getSQL();
        this.exprBuilder.initEmpty();
        betweenExpr.toRange.accept(this);
        String s3 = this.exprBuilder.getSQL();
        if (this.conditionBuilder.getCurrentElement() > 0) {
            prevConditionBuilder.beginANDCondition();
            prevConditionBuilder.addBetweenExpr(s1, s2, s3, betweenExpr.isNot);
            prevConditionBuilder.finishANDCondition();
            prevConditionBuilder.beginANDCondition();
            prevConditionBuilder.addCondition(this.conditionBuilder.getSQL());
            prevConditionBuilder.finishANDCondition();
        } else {
            prevConditionBuilder.addBetweenExpr(s1, s2, s3, betweenExpr.isNot);
        }
        this.conditionBuilder = prevConditionBuilder;
        this.conditionBuilder.finishParenthesis();
    }

    public void visitInExpr(InExpr inExpr) throws EJBQLParseException {
        this.conditionBuilder.beginParenthesis();
        this.exprBuilder.initEmpty();
        inExpr.target.accept(this);
        this.conditionBuilder.beginANDCondition();
        this.conditionBuilder.beginInCondition(this.exprBuilder.getSQL(), inExpr.isNot);
        for (int i = 0; i < inExpr.elementsInSet.length; ++i) {
            this.exprBuilder.initEmpty();
            inExpr.elementsInSet[i].accept(this);
            this.conditionBuilder.addInParameter(this.exprBuilder.getSQL());
        }
        this.conditionBuilder.finishInCondition();
        this.conditionBuilder.finishANDCondition();
        this.conditionBuilder.finishParenthesis();
    }

    public void visitLikeExpr(LikeExpr likeExpr) throws EJBQLParseException {
        if (likeExpr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        this.exprBuilder.initEmpty();
        likeExpr.target.accept(this);
        this.conditionBuilder.beginANDCondition();
        this.conditionBuilder.beginLikeCondition(this.exprBuilder.getSQL(), likeExpr.isNot);
        this.exprBuilder.initEmpty();
        likeExpr.pattern.accept(this);
        this.conditionBuilder.addLikePattern(this.exprBuilder.getSQL());
        if (likeExpr.escapeLiteral != null) {
            this.exprBuilder.initEmpty();
            likeExpr.escapeLiteral.accept(this);
            this.conditionBuilder.addLikeEscape(this.exprBuilder.getSQL());
        }
        this.conditionBuilder.finishLikeCondition();
        this.conditionBuilder.finishANDCondition();
        if (likeExpr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    public void visitOrderByClause(OrderByClause orderByClause) throws EJBQLParseException {
        this.orderByBuilder.initEmpty();
        this.orderByBuilder.beginOrderByClause();
        for (int i = 0; i < orderByClause.orderByItems.length; ++i) {
            orderByClause.orderByItems[i].accept(this);
        }
        this.orderByBuilder.finishOrderByClause();
    }

    public void visitOrderByItem(OrderByItem orderByItem) throws EJBQLParseException {
        this.exprBuilder.initEmpty();
        orderByItem.expr.accept(this);
        this.orderByBuilder.addOrderByItem(this.exprBuilder.getSQL(), orderByItem.isDesc);
        if (!orderByItem.isAppearsInSelectClause()) {
            this.selectBuilder.addColumnName(this.exprBuilder.getSQL());
        }
    }

    public void visitEJBQLSubQuery(EJBQLSubQuery ejbqlSubQuery) throws EJBQLParseException {
        try {
            ejbqlSubQuery.setMainQuery();
            SQLBuilderVisitor visitor = new SQLBuilderVisitor(ejbqlSubQuery, this.handler, this.dbVendor);
            visitor.generateSQL();
            this.exprBuilder.addString(ejbqlSubQuery.getSQL());
        }
        catch (EJBSQLGeneratorException ex) {
            throw new EJBQLParseException("internal exception during initialize SQLBuilderVisitor : ", (Throwable)((Object)ex));
        }
    }

    public void visitSelectClauseForSubQuery(SelectClauseForSubQuery selectClauseForSubQuery) throws EJBQLParseException {
        this.visitSelectClause(selectClauseForSubQuery);
    }

    public void visitExistsExpr(ExistsExpr existsExpr) throws EJBQLParseException {
        if (existsExpr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        this.conditionBuilder.beginExistsCondition(existsExpr.isNot);
        existsExpr.subQuery.accept(this);
        this.conditionBuilder.addString(existsExpr.subQuery.getSQL());
        this.conditionBuilder.finishExistsCondition();
        if (existsExpr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    public void visitGroupByClause(GroupByClause groupByClause) throws EJBQLParseException {
        this.groupByBuilder.initEmpty();
        this.groupByBuilder.beginGroupByClause();
        for (int i = 0; i < groupByClause.pathExprs.length; ++i) {
            this.exprBuilder.initEmpty();
            groupByClause.pathExprs[i].accept(this);
            this.groupByBuilder.addGroupByItem(this.exprBuilder.getSQL());
        }
        if (groupByClause.havingClause != null) {
            groupByClause.havingClause.accept(this);
        }
        this.groupByBuilder.finishGroupByClause();
    }

    public void visitHavingClause(HavingClause havingClause) throws EJBQLParseException {
        this.groupByBuilder.beginHavingClause();
        SQLBuilder prevConditionalBuilder = (SQLBuilder)this.conditionBuilder.clone();
        this.conditionBuilder.initEmpty();
        havingClause.expr.accept(this);
        this.groupByBuilder.addString(this.conditionBuilder.getSQL());
        this.conditionBuilder = prevConditionalBuilder;
        this.groupByBuilder.finishHavingClause();
    }

    public void visitUniqueExpr(UniqueExpr uniqueExpr) throws EJBQLParseException {
        if (uniqueExpr.isEnclosed()) {
            this.conditionBuilder.beginParenthesis();
        }
        this.conditionBuilder.beginUniqueCondition(uniqueExpr.isNot);
        uniqueExpr.subQuery.accept(this);
        this.conditionBuilder.addString(uniqueExpr.subQuery.getSQL());
        this.conditionBuilder.finishUniqueCondition();
        if (uniqueExpr.isEnclosed()) {
            this.conditionBuilder.finishParenthesis();
        }
    }

    public void visitSelectHint(SelectHint selectHint) throws EJBQLParseException {
        this.selectBuilder.initSelectSQL();
        String hint = selectHint.hint.value;
        this.selectBuilder.addSelectHint(hint.substring(1, hint.length() - 1));
    }

    public void visitConditionalExprWithLogicalOperator(ConditionalExprsWithLogicalOperator expr) throws EJBQLParseException {
        if (expr.conditionalExprs.length == 1) {
            if (expr.isNot) {
                expr.negate();
            }
            if (expr.isEnclosed()) {
                this.conditionBuilder.beginParenthesis();
            }
            expr.conditionalExprs[0].accept(this);
            if (expr.isEnclosed()) {
                this.conditionBuilder.finishParenthesis();
            }
        } else {
            if (expr.isNot) {
                expr.negate();
            }
            if (expr.isEnclosed()) {
                this.conditionBuilder.beginParenthesis();
            }
            for (int i = 0; i < expr.conditionalExprs.length; ++i) {
                if (expr.isOR()) {
                    this.conditionBuilder.beginORConditionByUser();
                } else {
                    this.conditionBuilder.beginANDConditionByUser();
                }
                expr.conditionalExprs[i].accept(this);
                if (expr.isOR()) {
                    this.conditionBuilder.finishORConditionByUser();
                    continue;
                }
                this.conditionBuilder.finishANDConditionByUser();
            }
            if (expr.isEnclosed()) {
                this.conditionBuilder.finishParenthesis();
            }
        }
    }
}

