/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.ejbql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.ejbql.NavigationInfo;
import jeus.ejb.schema.ejbql.element.CMRField;
import jeus.ejb.schema.ejbql.element.CollectionValuedCMRField;
import jeus.ejb.schema.ejbql.element.IdentificationVarDecl;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class VariableInfo
implements Cloneable {
    private BeanSchema beanSchema;
    public HashMap branchRalations = new HashMap();
    private String tableReference;
    private static final String defaultTableReferenceInfix = "TRef";
    private String tableReferenceInfix = "TRef";
    public static final String joinTableRefPostfix = "JTRef";
    private IdentificationVarDecl varDecl;
    private HashMap branchJoinRalations = new HashMap();
    private HashMap tableRefTable = new HashMap();
    private int tableRefIndex;
    private NavigationInfo variableNavigationInfo;

    public void setBeanSchema(BeanSchema beanSchema) {
        this.beanSchema = beanSchema;
    }

    public BeanSchema getBeanSchema() {
        return this.beanSchema;
    }

    public void addBranchField(CMRField field) {
        NavigationInfo info = field.getNavigationInfo();
        this.putFieldWithTableName(this.branchRalations, info, field);
        RelationshipRolePair rd = field.getRelationshipDescriptor();
        if (rd.isManyToManyRelation()) {
            if (rd.isManagedJoinRelation()) {
                info.setTargetJoinTableName(rd.getRelationTableName());
            } else {
                info.setTargetJoinTableName(rd.getPair().getRelationTableName());
            }
            this.putFieldWithTableName(this.branchJoinRalations, info, field);
        }
    }

    private void putFieldWithTableName(HashMap relationTable, NavigationInfo info, CMRField field) {
        ArrayList<CMRField> fieldListByBeanSchema = (ArrayList<CMRField>)relationTable.get(info);
        if (fieldListByBeanSchema == null) {
            fieldListByBeanSchema = new ArrayList<CMRField>();
            relationTable.put(info, fieldListByBeanSchema);
        }
        fieldListByBeanSchema.add(field);
    }

    public Iterator getBranchTableNameIterator() {
        return this.branchRalations.keySet().iterator();
    }

    public Iterator getBranchJoinTableNameIterator() {
        return this.branchJoinRalations.keySet().iterator();
    }

    public String getTableReference(NavigationInfo info) {
        String predefinedTableRef = (String)this.tableRefTable.get(info);
        String tableRef = predefinedTableRef != null ? predefinedTableRef : this.tableReference + this.tableReferenceInfix + this.tableRefIndex++;
        ArrayList fieldList = (ArrayList)this.branchRalations.get(info);
        for (int i = 0; i < fieldList.size(); ++i) {
            CMRField fieldWithSameNavigationInfo = (CMRField)fieldList.get(i);
            fieldWithSameNavigationInfo.setTargetTableReference(tableRef);
        }
        return tableRef;
    }

    public String getJoinTableReference(NavigationInfo info) {
        ArrayList fieldList = (ArrayList)this.branchJoinRalations.get(info);
        String tableRef = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            CollectionValuedCMRField field = (CollectionValuedCMRField)fieldList.get(i);
            tableRef = field.getTargetTableReference() + joinTableRefPostfix;
            field.setJoinTableReference(tableRef);
        }
        return tableRef;
    }

    public String getTableReference() {
        return this.tableReference;
    }

    public void setTableReference(String targetTableReference) {
        this.tableReference = targetTableReference;
    }

    public void setVariableDecl(IdentificationVarDecl varDecl) {
        this.varDecl = varDecl;
    }

    public IdentificationVarDecl getVariableDecl() {
        return this.varDecl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void setTableReferenceForVariable(NavigationInfo info, String newVarName) {
        if (info == null) {
            info = new NavigationInfo(this.varDecl.var.newVarName, this.beanSchema.sqlGen.tableName);
            this.branchRalations.put(info, new ArrayList());
        }
        this.variableNavigationInfo = info;
        this.tableRefTable.put(info, newVarName);
    }

    public void removeBranchRelation(NavigationInfo info) {
        this.branchRalations.remove(info);
    }

    public void attachTableReferenceInfix(String postfix) {
        this.tableReferenceInfix = this.tableReferenceInfix + postfix;
    }

    public String getTableReferenceInfix() {
        return this.tableReferenceInfix;
    }

    public NavigationInfo getNavigationInfo() {
        return this.variableNavigationInfo;
    }
}

