/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.session;

import java.io.IOException;
import java.io.OutputStream;
import jeus.ejb.BeanState;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.io.IOUtils;
import jeus.ejb.session.EJBSessionConfig;
import jeus.sessionmanager.session.DistributableObjectSession;
import jeus.sessionmanager.util.SessionByteArrayInputStream;

public class EJBSession
extends DistributableObjectSession {
    private boolean exceptionalRemove = false;
    private long passivateTO = 0L;

    public EJBSession(EJBSessionConfig config) {
        super(config);
    }

    public boolean checkPassivation(long currentTime, long passivationTo) {
        if (!((SessionContextImpl)this.object).canBePassivated()) {
            return false;
        }
        if (this.passivateTO != 0L) {
            return super.checkPassivation(currentTime, this.passivateTO);
        }
        return super.checkPassivation(currentTime, passivationTo);
    }

    public void setPassivateTO(long passivateTO) {
        this.passivateTO = passivateTO;
    }

    public boolean isExceptionalRemove() {
        return this.exceptionalRemove;
    }

    public void setExceptionalRemove(boolean exceptionalRemove) {
        this.exceptionalRemove = exceptionalRemove;
    }

    protected int internalReadContent(SessionByteArrayInputStream sbais) throws Exception {
        int length = sbais.available();
        if (length < 0) {
            throw new Exception(" There is no session content to read");
        }
        byte[] serializedObj = new byte[length];
        int contextLength = sbais.read(serializedObj, 0, length);
        if (contextLength != length) {
            throw new Exception("Occured exception during reading an uncompleted session");
        }
        this.object = IOUtils.deserialize(Thread.currentThread().getContextClassLoader(), serializedObj);
        if (this.object != null && this.object instanceof SessionContextImpl) {
            ((SessionContextImpl)this.object).setStatus(BeanState.READY);
        }
        return contextLength;
    }

    protected void internalWriteContent(OutputStream outputStream) throws IOException {
        if (this.object == null) {
            return;
        }
        byte[] serializedObj = IOUtils.serialize(this.object);
        outputStream.write(serializedObj);
    }
}

