/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.timer.containers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.timer.containers.TimerPrimaryKey;
import jeus.util.Serializer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusManagerPropertyValues;

public abstract class TimerBean
implements EntityBean {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer.timerBean");
    private boolean blobLoaded_;
    private Object timedObjectPrimaryKey_;
    private transient Serializable info_;
    private transient Date creationTime_;
    private transient Date initialExpiration_;
    private transient Date lastExpiration_;

    public abstract Long getTimerId();

    public abstract void setTimerId(Long var1);

    public abstract String getOwnerId();

    public abstract void setOwnerId(String var1);

    public abstract long getCreationTimeRaw();

    public abstract void setCreationTimeRaw(long var1);

    public abstract long getInitialExpirationRaw();

    public abstract void setInitialExpirationRaw(long var1);

    public abstract long getLastExpirationRaw();

    public abstract void setLastExpirationRaw(long var1);

    public abstract long getIntervalDuration();

    public abstract void setIntervalDuration(long var1);

    public abstract String getContainerId();

    public abstract void setContainerId(String var1);

    public abstract Blob getBlob();

    public abstract void setBlob(Blob var1);

    public abstract Set ejbSelectTimerIdsByContainer(String var1, String var2) throws FinderException;

    public abstract Set ejbSelectAllTimerIds(String var1) throws FinderException;

    public abstract Set ejbSelectTimersByContainer(String var1, String var2) throws FinderException;

    public abstract Set ejbSelectAllTimers(String var1) throws FinderException;

    public TimerPrimaryKey ejbCreate(Long timerId, String containerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        this.setTimerId(timerId);
        this.setOwnerId(JeusManagerPropertyValues.containerName);
        return null;
    }

    public void ejbPostCreate(Long timerId, String containerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        Date creationTime = new Date();
        this.setCreationTimeRaw(creationTime.getTime());
        this.creationTime_ = creationTime;
        this.setInitialExpirationRaw(initialExpiration.getTime());
        this.initialExpiration_ = initialExpiration;
        this.setLastExpirationRaw(0L);
        this.lastExpiration_ = null;
        this.setIntervalDuration(intervalDuration);
        this.setContainerId(containerId);
        this.timedObjectPrimaryKey_ = timedObjectPrimaryKey;
        this.info_ = info;
        this.blobLoaded_ = true;
        try {
            Blob blob = new Blob(timedObjectPrimaryKey, info);
            this.setBlob(blob);
        }
        catch (IOException ioe) {
            CreateException ce = new CreateException();
            ce.initCause((Throwable)ioe);
            throw ce;
        }
        if (logger.isLoggable(JeusMessage_EJB11._7174_LEVEL)) {
            logger.log(JeusMessage_EJB11._7174_LEVEL, JeusMessage_EJB11._7174, (Object[])new String[]{this.getTimerId().toString(), this.getContainerId().toString(), this.getBlob().toString(), String.valueOf(this.getInitialExpirationRaw()), String.valueOf(this.getIntervalDuration()), String.valueOf(this.getCreationTimeRaw())});
        }
    }

    private void loadBlob() {
        TimerContainer timerContainer = TimerContainer.currentTimerContainer();
        ClassLoader cl = timerContainer.getTimerClassLoader(this.getTimerId());
        if (cl == null) {
            throw new EJBException("No timer classloader for " + this.getTimerId());
        }
        this.loadBlob(cl);
    }

    private void loadBlob(ClassLoader cl) {
        try {
            Blob blob = this.getBlob();
            this.timedObjectPrimaryKey_ = blob.getTimedObjectPrimaryKey(cl);
            this.info_ = blob.getInfo(cl);
            this.blobLoaded_ = true;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void setEntityContext(EntityContext context) {
    }

    public void unsetEntityContext() {
    }

    public void ejbRemove() {
    }

    public void ejbLoad() {
        long lastExpirationRaw = this.getLastExpirationRaw();
        this.lastExpiration_ = lastExpirationRaw <= 0L ? null : new Date(lastExpirationRaw);
        this.creationTime_ = new Date(this.getCreationTimeRaw());
        this.initialExpiration_ = new Date(this.getInitialExpirationRaw());
        this.timedObjectPrimaryKey_ = null;
        this.info_ = null;
        this.blobLoaded_ = false;
    }

    public void ejbStore() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public Serializable getInfo() {
        if (!this.blobLoaded_) {
            this.loadBlob();
        }
        return this.info_;
    }

    public Serializable getInfo(ClassLoader cl) {
        if (!this.blobLoaded_) {
            this.loadBlob(cl);
        }
        return this.info_;
    }

    public Object getTimedObjectPrimaryKey() {
        if (!this.blobLoaded_) {
            this.loadBlob();
        }
        return this.timedObjectPrimaryKey_;
    }

    public Object getTimedObjectPrimaryKey(ClassLoader cl) {
        if (!this.blobLoaded_) {
            this.loadBlob(cl);
        }
        return this.timedObjectPrimaryKey_;
    }

    public Date getCreationTime() {
        return this.creationTime_;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration_;
    }

    public Date getLastExpiration() {
        return this.lastExpiration_;
    }

    public void setLastExpiration(Date lastExpiration) {
        this.lastExpiration_ = lastExpiration;
        long lastExpirationRaw = lastExpiration == null ? 0L : lastExpiration.getTime();
        this.setLastExpirationRaw(lastExpirationRaw);
    }

    private Set toPKeys(Set ids) {
        HashSet pkeys = new HashSet();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            pkeys.add(iter.next());
        }
        return pkeys;
    }

    public Set ejbHomeSelectTimerIdsByContainer(String containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainer(containerId, JeusManagerPropertyValues.containerName));
    }

    public Set ejbHomeSelectAllTimerIds() throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIds(JeusManagerPropertyValues.containerName));
    }

    public Set ejbHomeSelectTimersByContainer(String containerId) throws FinderException {
        return this.ejbSelectTimersByContainer(containerId, JeusManagerPropertyValues.containerName);
    }

    public Set ejbHomeSelectAllTimersOwnedBy(String owner) throws FinderException {
        return this.ejbSelectAllTimers(owner);
    }

    public Set ejbHomeSelectAllTimers() throws FinderException {
        return this.ejbSelectAllTimers(JeusManagerPropertyValues.containerName);
    }

    public static class Blob
    implements Serializable {
        private byte[] primaryKeyBytes_ = null;
        private byte[] infoBytes_ = null;

        public Object getTimedObjectPrimaryKey(ClassLoader cl) throws Exception {
            Object pKey = null;
            if (this.primaryKeyBytes_ != null) {
                Serializer serializer2 = new Serializer();
                pKey = serializer2.deserialize(this.primaryKeyBytes_, cl);
            }
            return pKey;
        }

        public Serializable getInfo(ClassLoader loader) throws Exception {
            Serializable info = null;
            if (this.infoBytes_ != null) {
                Serializer serializer2 = new Serializer();
                info = (Serializable)serializer2.deserialize(this.infoBytes_, loader);
            }
            return info;
        }

        public Blob() {
        }

        public Blob(Object primaryKey, Serializable info) throws IOException {
            Serializer serializer2 = new Serializer();
            if (primaryKey != null) {
                this.primaryKeyBytes_ = serializer2.serialize(primaryKey);
            }
            if (info != null) {
                this.infoBytes_ = serializer2.serialize((Object)info);
            }
        }
    }
}

