/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.IOException;
import java.io.OutputStream;

public class CodeWriter {
    private OutputStream stream;
    private static String ls = System.getProperty("line.separator");
    private int TabCount = 0;
    private String Indent = "";
    private boolean concatenation = false;

    public CodeWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void write(String s) throws IOException {
        String str = this.concatenation ? s + ls : this.Indent + s + ls;
        this.stream.write(str.getBytes());
        this.concatenation = false;
    }

    public void cwrite(String s) throws IOException {
        String str = this.concatenation ? s : this.Indent + s;
        this.stream.write(str.getBytes());
        this.concatenation = true;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void TabIn() {
        this.Indent = "";
        ++this.TabCount;
        for (int i = 0; i < this.TabCount; ++i) {
            this.Indent = this.Indent + "\t";
        }
    }

    public void TabOut() {
        this.Indent = "";
        --this.TabCount;
        for (int i = 0; i < this.TabCount; ++i) {
            this.Indent = this.Indent + "\t";
        }
    }

    public void writeTry(String tryBlock, String[][] catchBlocks) throws IOException {
        this.write("try {");
        this.TabIn();
        this.write(tryBlock);
        this.TabOut();
        for (int i = 0; i < catchBlocks.length; ++i) {
            String[] catchBlock = catchBlocks[i];
            this.write("} catch (" + catchBlock[0] + " ex) {");
            this.TabIn();
            this.write(catchBlock[1]);
            this.TabOut();
        }
        this.write("}");
    }
}

