/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import jeus.ejb.util.StringUtil;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;
import sun.tools.javac.Main;

public final class JavaCompiler {
    private static final String PROP_COMPILER_MODE = "jeus.compiler.mode";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String fs;
    private static final JeusLogger logger;
    public static Method method141;
    public static Method method13;

    public static void compile(String[] compile_args) throws JeusException {
        try {
            String isJavacFork = System.getProperty(PROP_COMPILER_MODE);
            if (isJavacFork != null && isJavacFork.equalsIgnoreCase("fork")) {
                String jrePath = System.getProperty(PROP_JAVA_HOME);
                String command = jrePath.substring(0, jrePath.lastIndexOf(fs)) + fs + "bin" + fs + "javac";
                for (int i = 0; i < compile_args.length; ++i) {
                    command = command + " " + compile_args[i];
                }
                Runtime runtime = Runtime.getRuntime();
                Process javacProc = runtime.exec(command);
                String message = StringUtil.getStringFromInputStream(javacProc);
                if (logger.isLoggable(JeusMessage_EJB10._6205_LEVEL)) {
                    logger.log(JeusMessage_EJB10._6205_LEVEL, JeusMessage_EJB10._6205, (Object)message);
                }
            } else {
                if (logger.isLoggable(JeusMessage_EJB10._6203_LEVEL)) {
                    StringBuffer buffer = new StringBuffer("javac");
                    for (int i = 0; i < compile_args.length; ++i) {
                        String compile_arg = compile_args[i];
                        buffer.append(' ').append(compile_arg);
                    }
                    logger.logp(JeusMessage_EJB10._6203_LEVEL, "JavaCompiler", "compile", JeusMessage_EJB10._6203, (Object)buffer.toString());
                }
                if (method141 != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(bos);
                    Object result = method141.invoke(null, compile_args, pw);
                    pw.flush();
                    bos.flush();
                    int status = (Integer)result;
                    if (status != 0) {
                        throw new JeusException(JeusMessage_EJB10._6201, (Object)bos.toString());
                    }
                } else if (method13 != null) {
                    Object result = method13.invoke((Object)new com.sun.tools.javac.Main(), new Object[]{compile_args});
                    int status = (Integer)result;
                    if (status != 0) {
                        throw new JeusException(JeusMessage_EJB10._6201, (Object)"output message in the stdout");
                    }
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Main java_compiler = new Main((OutputStream)baos, "javac");
                    if (!java_compiler.compile(compile_args)) {
                        throw new JeusException(JeusMessage_EJB10._6201, (Object)baos.toString());
                    }
                }
            }
        }
        catch (JeusException ex1) {
            throw ex1;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6202_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6202_LEVEL, "JavaCompiler", "compile", JeusMessage_EJB10._6202, ex);
            }
            throw new JeusException(JeusMessage_EJB10._6202, ex);
        }
    }

    static {
        block6: {
            fs = System.getProperty("file.separator");
            logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.util.JavaCompiler");
            Class<com.sun.tools.javac.Main> clazz = com.sun.tools.javac.Main.class;
            try {
                method141 = clazz.getMethod("compile", String[].class, PrintWriter.class);
                if (logger.isLoggable(JeusMessage_EJB10._6204_LEVEL)) {
                    logger.log(JeusMessage_EJB10._6204_LEVEL, JeusMessage_EJB10._6204, (Object)"com.sun.tools.javac.Main - 1.4.1");
                }
            }
            catch (Throwable t) {
                try {
                    method13 = clazz.getMethod("compile", String[].class);
                    if (logger.isLoggable(JeusMessage_EJB10._6204_LEVEL)) {
                        logger.log(JeusMessage_EJB10._6204_LEVEL, JeusMessage_EJB10._6204, (Object)"com.sun.tools.javac.Main - 1.3");
                    }
                }
                catch (Throwable t1) {
                    if (!logger.isLoggable(JeusMessage_EJB10._6204_LEVEL)) break block6;
                    logger.log(JeusMessage_EJB10._6204_LEVEL, JeusMessage_EJB10._6204, (Object)"sun.tools.javac.Main - deprecated");
                }
            }
        }
    }
}

