/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeus.ejb.util.InstanceCache;
import jeus.ejb.util.InstanceDuplicateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInstanceCache<K, E>
implements InstanceCache<K, E> {
    protected ConcurrentMap<K, Entry<E>> table = new ConcurrentHashMap<K, Entry<E>>();

    @Override
    public void add(K key, E instance) throws InstanceDuplicateException, NullPointerException {
        if (instance == null) {
            throw new NullPointerException();
        }
        if (this.table.putIfAbsent(key, new Entry<E>(instance)) != null) {
            throw new InstanceDuplicateException();
        }
    }

    @Override
    public E get(K key) {
        E instance = null;
        Entry entry = (Entry)this.table.get(key);
        if (entry != null) {
            entry.updateLastAccessTime();
            instance = entry.element;
        }
        return instance;
    }

    @Override
    public boolean containsKey(K key) {
        return this.table.containsKey(key);
    }

    @Override
    public long getLastAccessTime(K key) {
        Entry entry = (Entry)this.table.get(key);
        if (entry != null) {
            return entry.lastAccessTime;
        }
        return 0L;
    }

    @Override
    public void updateLastAccessTime(K key) {
        Entry entry = (Entry)this.table.get(key);
        if (entry != null) {
            entry.updateLastAccessTime();
        }
    }

    @Override
    public E remove(K key) {
        E instance = null;
        Entry entry = (Entry)this.table.remove(key);
        if (entry != null) {
            instance = entry.element;
        }
        return instance;
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E> {
        E element;
        long lastAccessTime;

        public Entry(E element) {
            this.element = element;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry obj2 = (Entry)obj;
            return this.element.equals(obj2.element);
        }

        synchronized void updateLastAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }
}

