/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import jeus.ejb.util.InstanceCreateException;
import jeus.ejb.util.InstancePool;
import jeus.ejb.util.InstancePoolHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInstancePool<E>
implements InstancePool<E> {
    protected Class<E> type;
    protected Constructor<E> constructor;
    protected int initSize;
    protected int spare;
    protected int maxSpare;
    protected int maxSize;
    protected InstancePoolHandler<E> handler;
    protected final List<E> idlePool = new LinkedList();
    private static final Object PRESENT = new Object();
    protected final IdentityHashMap<E, Object> activePool = new IdentityHashMap();
    protected boolean initialized = false;
    protected boolean cleared;

    @Override
    public synchronized void initialize(Class<E> type, int initSize, int spare, int maxSpare, int maxSize, InstancePoolHandler<E> handler) throws IllegalStateException, InstanceCreateException, IllegalArgumentException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (type == null) {
            throw new NullPointerException();
        }
        try {
            this.constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (initSize < 0 || spare < 0 || maxSpare < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize should be positive");
        }
        if (spare > initSize || initSize > maxSpare || maxSpare > maxSize) {
            throw new IllegalArgumentException("not spare <= initSize <= maxSpare <= maxSize");
        }
        this.type = type;
        this.initSize = initSize;
        this.spare = spare;
        this.maxSpare = maxSpare;
        this.maxSize = maxSize;
        this.handler = handler;
        for (int i = 0; i < initSize; ++i) {
            this.idlePool.add(this.create());
        }
        this.initialized = true;
    }

    protected E create() throws InstanceCreateException {
        try {
            Object obj = null;
            if (this.handler != null) {
                obj = this.handler.createInstance();
            }
            if (obj == null) {
                if (this.constructor == null) {
                    throw new InstanceCreateException("there is no default constructor");
                }
                obj = this.constructor.newInstance(new Object[0]);
            }
            if (this.handler != null) {
                this.handler.afterCreateInstance(obj);
            }
            return obj;
        }
        catch (Throwable e) {
            throw new InstanceCreateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E fetch() throws InstanceCreateException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        E instance = null;
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.cleared) {
                return null;
            }
            if (this.available() == 0 && this.size() >= this.maxSize) {
                return null;
            }
            instance = this.available() > 0 ? (E)this.idlePool.remove(0) : (E)this.create();
            this.activePool.put(instance, PRESENT);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putback(E obj) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (obj == null) {
            throw new NullPointerException("the putbacked object is null");
        }
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.activePool.remove(obj) == PRESENT) {
                if (!this.cleared && this.available() < this.maxSpare) {
                    this.idlePool.add(obj);
                } else {
                    Object userData = this.beforeRemoveInstances();
                    this.remove(obj);
                    this.afterRemoveInstances(userData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shrink() throws InstanceCreateException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.available() > this.spare) {
                Object userData = this.beforeRemoveInstances();
                while (this.available() > this.spare) {
                    E instance = this.idlePool.remove(0);
                    this.remove(instance);
                }
                this.afterRemoveInstances(userData);
            } else if (this.available() < this.spare) {
                while (this.available() < this.spare) {
                    E instance = this.create();
                    this.idlePool.add(instance);
                }
            }
        }
    }

    protected Object beforeRemoveInstances() {
        if (this.handler != null) {
            try {
                return this.handler.beforeRemoveInstances();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected void remove(E obj) {
        if (this.handler != null) {
            try {
                this.handler.beforeRemoveInstance(obj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void afterRemoveInstances(Object userData) {
        if (this.handler != null) {
            try {
                this.handler.afterRemoveInstances(userData);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean force) {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            this.cleared = true;
            if (!force && this.idlePool.size() == 0) {
                return;
            }
            if (force && this.idlePool.size() == 0 && this.activePool.size() == 0) {
                return;
            }
            Object userData = this.beforeRemoveInstances();
            for (E element : this.idlePool) {
                this.remove(element);
            }
            this.idlePool.clear();
            if (force) {
                for (E element : this.activePool.keySet()) {
                    this.remove(element);
                }
                this.activePool.clear();
            }
            this.afterRemoveInstances(userData);
        }
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public int getInitSize() {
        return this.initSize;
    }

    @Override
    public int getSpare() {
        return this.spare;
    }

    @Override
    public int getMaxSpare() {
        return this.maxSpare;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized int size() {
        return this.idlePool.size() + this.activePool.size();
    }

    @Override
    public synchronized int available() {
        return this.idlePool.size();
    }

    @Override
    public synchronized int actives() {
        return this.activePool.size();
    }

    @Override
    public InstancePoolHandler<E> getHandler() {
        return this.handler;
    }
}

