/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jeus.ejb.util.CodeWriter;

public abstract class WrapperGenerator {
    private static final int CW_BUFFER = 4096;
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);
    private static String clsp = File.separator.equals("/") ? new String(":") : new String(";");
    protected String packageName;
    protected String ImplClassName;
    protected Class userInterface;
    private File sourceFile;
    private String sourceFilePath;
    private Method[] methods;
    private String outPath;
    private ClassLoader loader;
    protected String interfaceName;
    protected String generateClassName;

    public WrapperGenerator(String path, String packageName, String implClassName, String interfaceName, ClassLoader loader) {
        this.outPath = path;
        this.packageName = packageName;
        this.ImplClassName = implClassName;
        this.interfaceName = interfaceName;
        this.loader = loader;
    }

    public void generate() {
        try {
            this.loadingImplClass();
            this.generateClassName = this.generateClassName();
            this.getMethods();
            OutputStream out = this.makeSourceFile();
            this.generateWrapper(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadingImplClass() throws Exception {
        this.userInterface = this.loader.loadClass(this.packageName + "." + this.interfaceName);
    }

    private void getMethods() throws Exception {
        Method[] methodlist = this.userInterface.getMethods();
        block2: for (int i = 0; i < methodlist.length - 1; ++i) {
            Method method1 = methodlist[i];
            if (method1 == null) continue;
            Class<?>[] paramTypes1 = method1.getParameterTypes();
            Class[] exceptions1 = method1.getExceptionTypes();
            block3: for (int j = i + 1; j < methodlist.length; ++j) {
                Class<?>[] paramTypes2;
                Method method2 = methodlist[j];
                if (method2 == null || !method2.getName().equals(method1.getName()) || paramTypes1.length != (paramTypes2 = method2.getParameterTypes()).length) continue;
                for (int k = 0; k < paramTypes1.length; ++k) {
                    if (paramTypes1[k] != paramTypes2[k]) continue block3;
                }
                Class[] exceptions2 = method2.getExceptionTypes();
                if (this.isSubExceptions(exceptions1, exceptions2)) {
                    methodlist[j] = null;
                    continue;
                }
                if (!this.isSubExceptions(exceptions2, exceptions1)) continue;
                methodlist[i] = null;
                continue block2;
            }
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methodlist.length; ++i) {
            if (methodlist[i] == null) continue;
            list.add(methodlist[i]);
        }
        this.methods = list.toArray(new Method[0]);
    }

    private boolean isSubExceptions(Class[] exceptions1, Class[] exceptions2) {
        for (int k = 0; k < exceptions2.length; ++k) {
            int j;
            if (RuntimeException.class.isAssignableFrom(exceptions2[k])) continue;
            for (j = 0; j < exceptions1.length && !exceptions1[j].isAssignableFrom(exceptions2[k]); ++j) {
            }
            if (j != exceptions1.length) continue;
            return false;
        }
        return true;
    }

    private OutputStream makeSourceFile() throws Exception {
        this.sourceFilePath = this.outPath + fs + this.packageName.replace('.', fsc) + fs + this.generateClassName + ".java";
        this.sourceFile = new File(this.sourceFilePath);
        if (this.sourceFile.getParent() != null) {
            new File(this.sourceFile.getParent()).mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(this.sourceFile), 4096);
    }

    public void generateWrapper(OutputStream out) throws Exception {
        CodeWriter codewriter = new CodeWriter(out);
        codewriter.write("package " + this.packageName + ";");
        codewriter.write("");
        codewriter.write("");
        this.generateClassHeader(codewriter);
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("private " + this.ImplClassName + " delegate;");
        codewriter.write("");
        this.generateField(codewriter);
        codewriter.write("public " + this.generateClassName + "(" + this.ImplClassName + " delegate)");
        codewriter.write("{");
        codewriter.write("\tthis.delegate = delegate;");
        codewriter.write("}");
        codewriter.write("");
        for (int i = 0; i < this.methods.length; ++i) {
            this.generateWrapperMethod(codewriter, this.methods[i]);
            codewriter.write("");
        }
        codewriter.TabOut();
        this.generateAdditionalMethod(codewriter);
        codewriter.write("}");
        codewriter.close();
    }

    public void generateWrapperMethod(CodeWriter codewriter, Method m) throws IOException {
        int i;
        codewriter.cwrite("public " + this.getTypeString(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 != 0) {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(this.getTypeString(params[i2]) + " arg" + i2);
        }
        codewriter.cwrite(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        for (i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                codewriter.cwrite("throws ");
            } else {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(exceptions[i].getName());
        }
        codewriter.write("");
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("");
        this.generatePreInvoke(codewriter);
        codewriter.write("try {");
        codewriter.TabIn();
        if (!m.getReturnType().equals(Void.TYPE)) {
            codewriter.cwrite(this.getTypeString(m.getReturnType()) + " val = ");
        }
        codewriter.cwrite("delegate." + m.getName() + "(");
        for (i = 0; i < params.length; ++i) {
            if (i != 0) {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(" arg" + i);
        }
        codewriter.write("); ");
        if (!m.getReturnType().equals(Void.TYPE)) {
            codewriter.write("return val;");
        }
        codewriter.TabOut();
        codewriter.write("} finally {");
        codewriter.TabIn();
        this.generatePostInvoke(codewriter);
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.TabOut();
        codewriter.write("}");
    }

    private String getTypeString(Class cls) {
        String array = "";
        while (cls.isArray()) {
            cls = cls.getComponentType();
            array = array + "[]";
        }
        return cls.getName() + array;
    }

    protected abstract void generatePreInvoke(CodeWriter var1) throws IOException;

    protected abstract void generatePostInvoke(CodeWriter var1) throws IOException;

    public abstract String generateClassName();

    protected abstract void generateAdditionalMethod(CodeWriter var1) throws IOException;

    protected abstract void generateClassHeader(CodeWriter var1) throws IOException;

    protected abstract void generateField(CodeWriter var1) throws IOException;
}

