/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.webserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import jeus.ejb.webserver.RequestHandler;
import jeus.ejb.webserver.WebServerException;
import jeus.util.cnet.classftp.ClassFTPProtocol;
import jeus.util.message.JeusMessage_EJB10;

public class CustomRequestHandler
extends RequestHandler
implements ClassFTPProtocol {
    private DataInputStream in;
    private DataOutputStream out;

    public void setSocket(Socket soc) throws WebServerException {
        try {
            InputStream is = soc.getInputStream();
            this.in = new DataInputStream(new BufferedInputStream(is));
            OutputStream os = soc.getOutputStream();
            this.out = new DataOutputStream(new BufferedOutputStream(os));
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6351_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6351_LEVEL, "HttpRequestHandler", "setSocket", JeusMessage_EJB10._6351, (Throwable)ex);
            }
            throw new WebServerException(JeusMessage_EJB10._6351, (Throwable)ex);
        }
    }

    protected String readRequest() throws WebServerException {
        try {
            int opcode = this.in.readInt();
            if (opcode != 69402625) {
                throw new WebServerException("invalid opcode : 0x" + Integer.toHexString(opcode));
            }
            int length = this.in.readInt();
            if (length <= 0) {
                throw new WebServerException("invalid payload length : " + length);
            }
            byte[] buf = new byte[length];
            this.in.readFully(buf);
            String line = new String(buf);
            if (logger.isLoggable(JeusMessage_EJB10._6352_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6352_LEVEL, "HttpRequestHandler", "processRequest", JeusMessage_EJB10._6352, (Object)line);
            }
            return line;
        }
        catch (WebServerException we) {
            throw we;
        }
        catch (Throwable ex) {
            this.finish();
            if (logger.isLoggable(JeusMessage_EJB10._6353_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6353_LEVEL, "HttpRequestHandler", "processRequest", JeusMessage_EJB10._6353, ex);
            }
            throw new WebServerException("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(File file) throws WebServerException {
        FileInputStream fin = null;
        try {
            int read;
            this.out.writeInt(69402881);
            this.out.writeInt((int)file.length());
            fin = new FileInputStream(file);
            byte[] buf = new byte[4096];
            while ((read = fin.read(buf)) != -1) {
                this.out.write(buf, 0, read);
            }
            this.out.flush();
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6354_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6354_LEVEL, "HttpRequestHandler", "innerProcessRequest", JeusMessage_EJB10._6354, (Throwable)ex);
            }
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void finish() throws WebServerException {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

